/*
 * Decompiled with CFR 0.152.
 */
package JabpLite;

import JabpLite.Account;
import JabpLite.AccountStore;
import JabpLite.AccountView;
import JabpLite.Investment;
import JabpLite.InvestmentStore;
import JabpLite.JabpLite;
import JabpLite.Utilities;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;

public class NetWorth
extends Canvas
implements CommandListener,
Runnable {
    Display display;
    Form touchScreenMenu;
    ChoiceGroup cgtsm;
    Alert alert;
    Font font;
    JabpLite parent;
    boolean skipLine = false;
    int fs;
    int width;
    int height;
    int fontHeight;
    int fontWidth;
    int numberWidth;
    int nameWidth;
    int amountPosition;
    int currentX;
    int currentY;
    int totalAmount;
    long timePointerOnScreen;

    public NetWorth(JabpLite jabpLite, Display display) {
        this.parent = jabpLite;
        this.display = display;
        this.setFullScreenMode(this.parent.showFullCanvas);
        this.addCommand(this.parent.okCommand);
        this.addCommand(this.parent.exitCommand);
        this.setCommandListener(this);
        this.alert = new Alert("");
        this.alert.setType(AlertType.CONFIRMATION);
        this.alert.setTimeout(1500);
        this.width = this.getWidth();
        this.height = this.getHeight() - this.parent.heightAdjustment;
        this.setPositions();
        this.currentX = 0;
        this.currentY = this.fontHeight;
        if (this.parent.isAndroid) {
            this.display.callSerially((Runnable)this);
        }
    }

    void androidDelay() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.repaint();
        this.serviceRepaints();
    }

    public void run() {
        this.androidDelay();
    }

    public void paint(Graphics graphics) {
        if (this.width != this.getWidth() || this.height != this.getHeight() - this.parent.heightAdjustment) {
            this.width = this.getWidth();
            this.height = this.getHeight() - this.parent.heightAdjustment;
            this.setPositions();
        }
        graphics.setFont(this.font);
        this.showHeader(graphics);
        this.showPage(graphics);
        this.showFooter(graphics);
    }

    void showPage(Graphics graphics) {
        int n;
        this.currentY = this.fontHeight;
        graphics.setColor(this.parent.colorBackground);
        graphics.fillRect(0, this.fontHeight, this.width, this.height - this.fontHeight * 2);
        graphics.setColor(this.parent.colorFont);
        AccountStore accountStore = new AccountStore(this.parent);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = accountStore.getNumAccounts();
        for (int i = 0; i < n8; ++i) {
            Account account = accountStore.getAccountFromIndex(i);
            if (account.type.equals("\u0411\u0430\u043d\u043a")) {
                n2 += account.today;
            }
            if (account.type.equals("\u041a\u0440\u0435\u0434. \u043a\u0430\u0440\u0442\u0430")) {
                n3 += account.today;
            }
            if (account.type.equals("\u041d\u0430\u043b\u0438\u0447\u043d\u044b\u0435")) {
                n4 += account.today;
            }
            if (account.type.equals("\u0410\u043a\u0442\u0438\u0432\u044b")) {
                n5 += account.today;
            }
            if (!account.type.equals("\u041e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u043e")) continue;
            n6 += account.today;
        }
        accountStore.closeAccountStore();
        accountStore = null;
        InvestmentStore investmentStore = new InvestmentStore(this.parent);
        n8 = investmentStore.getNumInvestments();
        for (n = 0; n < n8; ++n) {
            Investment investment = investmentStore.getInvestmentFromIndex(n);
            n7 += investment.calcValue(investment);
        }
        investmentStore.closeInvestmentStore();
        investmentStore = null;
        this.totalAmount = n2 + n3 + n4 + n5 + n6 + n7;
        n = this.height / this.fontHeight;
        if (n >= 15) {
            this.skipLine = true;
        }
        this.buildLine(graphics, "\u0411\u0430\u043d\u043a\u0438", n2);
        this.buildLine(graphics, "\u041a\u0440\u0435\u0434. \u043a\u0430\u0440\u0442\u044b", n3);
        this.buildLine(graphics, "\u041d\u0430\u043b\u0438\u0447\u043d\u044b\u0435", n4);
        this.buildLine(graphics, "\u0410\u043a\u0442\u0438\u0432\u044b", n5);
        this.buildLine(graphics, "\u041e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430", n6);
        this.buildLine(graphics, "\u0418\u043d\u0432\u0435\u0441\u0442\u0438\u0446\u0438\u0438", n7);
    }

    void showHeader(Graphics graphics) {
        graphics.setColor(this.parent.colorHeading);
        graphics.fillRect(0, 0, this.width, this.fontHeight);
        graphics.setColor(this.parent.colorFont);
        graphics.drawString("\u0427\u0438\u0441\u0442\u044b\u0439 \u0434\u043e\u0445\u043e\u0434", this.parent.widthAdjustment, this.parent.fontAdjustment, 20);
        graphics.drawString("\u0421\u0443\u043c\u043c\u0430", this.amountPosition + this.numberWidth - this.font.stringWidth("\u0421\u0443\u043c\u043c\u0430"), this.parent.fontAdjustment, 20);
    }

    void showFooter(Graphics graphics) {
        graphics.setColor(this.parent.colorHeading);
        graphics.fillRect(0, this.height - this.fontHeight, this.width, this.fontHeight);
        graphics.setColor(this.parent.colorFont);
        graphics.drawString("\u0412\u0441\u0435\u0433\u043e", this.parent.widthAdjustment, this.height - this.fontHeight + this.parent.fontAdjustment, 20);
        String string = Utilities.numberToString(this.totalAmount, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
        graphics.drawString(string, this.amountPosition + this.numberWidth - this.font.stringWidth(string), this.height - this.fontHeight + this.parent.fontAdjustment, 20);
    }

    void buildLine(Graphics graphics, String string, int n) {
        if (this.skipLine) {
            this.currentY += this.fontHeight;
        }
        graphics.drawString(string, this.parent.widthAdjustment, this.currentY + this.parent.fontAdjustment, 20);
        String string2 = Utilities.numberToString(n, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
        graphics.drawString(string2, this.amountPosition + this.numberWidth - this.font.stringWidth(string2), this.currentY + this.parent.fontAdjustment, 20);
        this.currentY += this.fontHeight;
    }

    void setPositions() {
        this.fs = 8;
        if (this.parent.mediumSize) {
            this.fs = 0;
        }
        if (this.parent.largeSize) {
            this.fs = 16;
        }
        this.font = Font.getFont((int)0, (int)0, (int)this.fs);
        this.fontHeight = this.font.getHeight();
        this.numberWidth = this.parent.isGroupingUsed ? this.font.stringWidth("999,999.99") : this.font.stringWidth("999999.99");
        this.nameWidth = this.width - this.numberWidth - this.parent.widthAdjustment * 2 - 10;
        this.amountPosition = this.nameWidth + this.parent.widthAdjustment + 10;
    }

    protected void showNotify() {
        this.repaint();
    }

    protected void pointerPressed(int n, int n2) {
        this.timePointerOnScreen = System.currentTimeMillis();
    }

    protected void pointerReleased(int n, int n2) {
        this.displayTouchScreenMenu();
    }

    void displayTouchScreenMenu() {
        this.touchScreenMenu = new Form("\u0427\u0438\u0441\u0442\u044b\u0439 \u0434\u043e\u0445\u043e\u0434");
        this.cgtsm = new ChoiceGroup("\u0412\u044b\u0431\u0440\u0430\u0442\u044c \u043e\u043f\u0446\u0438\u044e", 1);
        this.cgtsm.append("\u0417\u0430\u043a\u0440\u044b\u0442\u044c", null);
        this.cgtsm.append("\u0412\u044b\u0445\u043e\u0434", null);
        this.touchScreenMenu.append((Item)this.cgtsm);
        this.touchScreenMenu.addCommand(this.parent.okCommand);
        this.touchScreenMenu.addCommand(this.parent.cancelCommand);
        this.touchScreenMenu.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)this.touchScreenMenu);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.parent.exitCommand) {
            this.parent.destroyApp(true);
            return;
        }
        if (displayable == this && command == this.parent.okCommand) {
            if (this.parent.av == null) {
                this.parent.av = new AccountView(this.parent, this.display);
            }
            this.display.setCurrent((Displayable)this.parent.av);
        }
        if (displayable == this.touchScreenMenu) {
            if (command == this.parent.okCommand) {
                int n = this.cgtsm.getSelectedIndex();
                if (n == 0) {
                    this.commandAction(this.parent.okCommand, (Displayable)this);
                }
                if (n == 2) {
                    this.parent.destroyApp(true);
                }
            } else {
                this.touchScreenMenu = null;
                this.alert.setString("\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
        }
    }
}

