/*
 * Decompiled with CFR 0.152.
 */
package JabpLite;

import JabpLite.Account;
import JabpLite.AccountStore;
import JabpLite.Category;
import JabpLite.CategoryStore;
import JabpLite.Currency;
import JabpLite.CurrencyStore;
import JabpLite.JabpLite;
import JabpLite.Split;
import JabpLite.SplitStore;
import JabpLite.Transaction;
import JabpLite.Utilities;
import java.util.Vector;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.DateField;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;

public class TransactionForm
extends Form
implements Runnable {
    boolean ready = false;
    Transaction t;
    Transaction t1;
    String s1;
    JabpLite parent;
    DateField df;
    TextField tfDescription;
    TextField tfReference;
    TextField tfAmount;
    ChoiceGroup cgDRCR;
    ChoiceGroup cgAccount;
    ChoiceGroup cgCategory;
    ChoiceGroup cgCurrency;
    ChoiceGroup cgReconciled;
    ChoiceGroup cgTransfer;

    public TransactionForm(JabpLite jabpLite) {
        super("\u041d\u043e\u0432\u0430\u044f \u0442\u0440\u0430\u043d\u0441\u0430\u043a\u0446\u0438\u044f");
        this.parent = jabpLite;
    }

    void build(boolean bl, String string, boolean bl2) {
        int n;
        int n2;
        Object object;
        if (!this.parent.isAndroid) {
            this.append("\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u043f\u043e\u0434\u043e\u0436\u0434\u0438\u0442\u0435...");
        }
        this.tfDescription = new TextField("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435", "", 64, 0);
        if (this.parent.end) {
            return;
        }
        this.append((Item)this.tfDescription);
        int n3 = 2;
        if (!this.parent.numericEntry) {
            n3 = 0;
        }
        this.tfAmount = new TextField("\u0421\u0443\u043c\u043c\u0430", "", 64, n3);
        if (this.parent.end) {
            return;
        }
        this.append((Item)this.tfAmount);
        int n4 = 4;
        if (this.parent.oldStyleChoice) {
            n4 = 1;
        }
        this.cgDRCR = new ChoiceGroup("DR/CR", n4);
        this.cgDRCR.append("\u0414\u0435\u0431\u0435\u0442", null);
        this.cgDRCR.append("\u041a\u0440\u0435\u0434\u0438\u0442", null);
        if (this.parent.end) {
            return;
        }
        this.append((Item)this.cgDRCR);
        this.tfReference = new TextField("Reference", "", 64, 0);
        if (this.parent.end) {
            return;
        }
        this.append((Item)this.tfReference);
        this.df = new DateField("\u0414\u0430\u0442\u0430", 1);
        this.df.setDate(this.parent.todayDate);
        if (this.parent.end) {
            return;
        }
        this.append((Item)this.df);
        this.cgReconciled = new ChoiceGroup("\u041f\u0440\u0438\u043c\u0438\u0440\u0435\u043d\u043d\u043e", n4);
        this.cgReconciled.append("\u041d\u0435\u0442", null);
        this.cgReconciled.append("\u0414\u0430", null);
        if (this.parent.end) {
            return;
        }
        this.append((Item)this.cgReconciled);
        this.cgTransfer = new ChoiceGroup("\u0422\u0440\u0430\u043d\u0441\u0444\u0435\u0440", n4);
        this.cgTransfer.append("\u041d\u0435\u0442", null);
        this.cgTransfer.append("\u0414\u0430", null);
        if (this.parent.end) {
            return;
        }
        this.append((Item)this.cgTransfer);
        if (bl) {
            this.cgAccount = new ChoiceGroup("\u0423\u0447. \u0437\u0430\u043f\u0438\u0441\u044c", n4);
            object = new AccountStore(this.parent);
            n2 = ((AccountStore)object).getNumAccounts();
            for (n = 0; n < n2; ++n) {
                Account account = ((AccountStore)object).getAccountFromIndex(n);
                if (this.parent.end) {
                    return;
                }
                this.cgAccount.append(account.name, null);
            }
            if (this.parent.end) {
                return;
            }
            this.append((Item)this.cgAccount);
            ((AccountStore)object).closeAccountStore();
            object = null;
        }
        this.cgCategory = bl2 && string.equals("") ? new ChoiceGroup("\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f", 2) : new ChoiceGroup("\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f", n4);
        object = new CategoryStore(this.parent);
        n2 = ((CategoryStore)object).getNumCategories();
        n = string.length();
        string = string.toUpperCase();
        for (int i = 0; i < n2; ++i) {
            Category category = ((CategoryStore)object).getCategoryFromIndex(i);
            if (this.parent.end) {
                return;
            }
            if (string.equals("")) {
                this.cgCategory.append(category.name, null);
                continue;
            }
            int n5 = Math.min(category.name.length(), n);
            if (!category.name.substring(0, n5).toUpperCase().equals(string)) continue;
            this.cgCategory.append(category.name, null);
        }
        if (this.parent.end) {
            return;
        }
        this.append((Item)this.cgCategory);
        ((CategoryStore)object).closeCategoryStore();
        object = null;
        this.cgCurrency = new ChoiceGroup("\u0412\u0430\u043b\u044e\u0442\u0430", n4);
        CurrencyStore currencyStore = new CurrencyStore(this.parent);
        n2 = currencyStore.getNumCurrencies();
        for (int i = 0; i < n2; ++i) {
            Currency currency = currencyStore.getCurrencyFromIndex(i);
            if (this.parent.end) {
                return;
            }
            this.cgCurrency.append(currency.code, null);
            if (!currency.code.equals(this.parent.homeCurrency)) continue;
            this.cgCurrency.setSelectedIndex(i, true);
        }
        if (this.parent.end) {
            return;
        }
        this.append((Item)this.cgCurrency);
        currencyStore.closeCurrencyStore();
        currencyStore = null;
        if (!this.parent.isAndroid) {
            this.delete(0);
        }
        this.ready = true;
    }

    void show(Transaction transaction, String string) {
        if (this.parent.isAndroid) {
            while (this.size() > 0) {
                this.delete(0);
            }
        }
        this.setTitle(string + " \u0422\u0440\u0430\u043d\u0441\u0430\u043a\u0446\u0438\u044f");
        this.append("Desc: " + transaction.description + "\n");
        String string2 = " DR";
        if (transaction.amount >= 0) {
            string2 = " CR";
        }
        this.append("\u0421\u0443\u043c\u043c\u0430: " + Utilities.numberToString(Math.abs(transaction.amount), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed) + string2 + "\n");
        this.append("Ref: " + transaction.reference + "\n");
        this.append("\u0414\u0430\u0442\u0430: " + this.showDate(transaction.longDate) + "\n");
        string2 = transaction.reconciled ? "\u0414\u0430" : "\u041d\u0435\u0442";
        this.append("\u041f\u0440\u0438\u043c\u0438\u0440\u0435\u043d\u043d\u043e: " + string2 + "\n");
        string2 = transaction.transferFlag ? "\u0414\u0430 (" + transaction.transferAccount + ")" : "\u041d\u0435\u0442";
        this.append("\u0422\u0440\u0430\u043d\u0441\u0444\u0435\u0440: " + string2 + "\n");
        this.append("\u0423\u0447. \u0437\u0430\u043f\u0438\u0441\u044c: " + transaction.account + "\n");
        if (transaction.transferFlag) {
            return;
        }
        if (transaction.splitFlag) {
            for (int i = 0; i < transaction.ss.size(); ++i) {
                Split split = transaction.ss.getSplit(i);
                this.append("\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f: " + split.category + "\n");
                string2 = " DR";
                if (split.amount >= 0) {
                    string2 = " CR";
                }
                this.append("\u0421\u0443\u043c\u043c\u0430: " + Utilities.numberToString(Math.abs(split.amount), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed) + string2 + "\n");
            }
        } else {
            this.append("\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f: " + transaction.category);
        }
    }

    void setCategories() {
        CategoryStore categoryStore = new CategoryStore(this.parent);
        int n = categoryStore.getNumCategories();
        for (int i = 0; i < n; ++i) {
            Category category = categoryStore.getCategoryFromIndex(i);
            if (this.t.splitFlag) {
                for (int j = 0; j < this.t.ss.size(); ++j) {
                    if (!category.name.equals(this.t.ss.getSplit((int)j).category)) continue;
                    this.cgCategory.setSelectedIndex(i, true);
                }
                continue;
            }
            if (!category.name.equals(this.t.category)) continue;
            this.cgCategory.setSelectedIndex(i, true);
        }
        categoryStore.closeCategoryStore();
        categoryStore = null;
    }

    void setCurrency() {
        Object object;
        String string = "";
        if (!this.t.account.equals("")) {
            object = new AccountStore(this.parent);
            Account account = ((AccountStore)object).getAccountFromName(this.t.account);
            string = account.currency;
            if (account.type.equals("\u041d\u0430\u043b\u0438\u0447\u043d\u044b\u0435")) {
                this.cgReconciled.setSelectedIndex(1, true);
            }
            ((AccountStore)object).closeAccountStore();
            object = null;
        }
        object = new CurrencyStore(this.parent);
        int n = ((CurrencyStore)object).getNumCurrencies();
        for (int i = 0; i < n; ++i) {
            Currency currency = ((CurrencyStore)object).getCurrencyFromIndex(i);
            if (this.t.amount == 0 || this.s1.equals("Matched")) {
                if (!currency.code.equals(string)) continue;
                this.cgCurrency.setSelectedIndex(i, true);
                continue;
            }
            if (!currency.code.equals(this.parent.homeCurrency)) continue;
            this.cgCurrency.setSelectedIndex(i, true);
        }
        ((CurrencyStore)object).closeCurrencyStore();
        object = null;
    }

    int checkAmount() {
        return Utilities.stringToNumber(this.tfAmount.getString(), 0, this.parent.numericEntry, this.parent.isEuropeanNumberFormat);
    }

    Transaction update() {
        Split split;
        int n;
        Object object;
        this.t.description = this.tfDescription.getString();
        this.t.amount = Utilities.stringToNumber(this.tfAmount.getString(), 0, this.parent.numericEntry, this.parent.isEuropeanNumberFormat);
        if (this.cgDRCR.getSelectedIndex() == 0) {
            this.t.amount = -this.t.amount;
        }
        this.t.reference = this.tfReference.getString();
        String string = this.cgCurrency.getString(this.cgCurrency.getSelectedIndex());
        if (!string.equals(this.parent.homeCurrency)) {
            this.t.reference = this.t.reference.equals("") ? string + " " + Utilities.numberToString(Math.abs(this.t.amount), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed) : string + " " + Utilities.numberToString(Math.abs(this.t.amount), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed) + "|" + this.t.reference;
            object = new CurrencyStore(this.parent);
            Currency currency = ((CurrencyStore)object).getCurrencyFromName(string);
            this.t.amount = Utilities.foreignToHome(this.t.amount, currency.rate);
            currency = null;
            ((CurrencyStore)object).closeCurrencyStore();
            object = null;
        }
        this.t.longDate = this.df.getDate().getTime();
        if (this.cgAccount != null) {
            this.t.account = this.cgAccount.getString(this.cgAccount.getSelectedIndex());
        }
        this.t.reconciled = this.cgReconciled.getSelectedIndex() != 0;
        this.t.transferFlag = this.cgTransfer.getSelectedIndex() != 0;
        if (this.t.transferFlag) {
            return this.t;
        }
        object = new SplitStore();
        for (n = 0; n < this.cgCategory.size(); ++n) {
            if (!this.cgCategory.isSelected(n)) continue;
            split = new Split();
            split.category = this.cgCategory.getString(n);
            ((SplitStore)object).addSplit(split);
            this.cgCategory.setSelectedIndex(n, false);
        }
        if (((Vector)object).size() == 0) {
            object = null;
            return this.t;
        }
        if (((Vector)object).size() == 1) {
            this.t.splitFlag = false;
            this.t.category = ((SplitStore)object).getSplit((int)0).category;
            object = null;
            this.t.ss = null;
        } else {
            this.t.splitFlag = true;
            if (this.t.ss != null) {
                for (n = 0; n < ((Vector)object).size(); ++n) {
                    split = ((SplitStore)object).getSplit(n);
                    for (int i = 0; i < this.t.ss.size(); ++i) {
                        if (!split.category.equals(this.t.ss.getSplit((int)i).category)) continue;
                        split.amount = this.t.ss.getSplit((int)i).amount;
                        break;
                    }
                    ((SplitStore)object).setSplit(split, n);
                }
            }
            this.t.ss = object;
        }
        return this.t;
    }

    void set(Transaction transaction, String string) {
        this.t1 = transaction;
        this.s1 = string;
        if (this.ready) {
            this.run();
        } else {
            Thread thread = new Thread(this);
            thread.start();
        }
    }

    public void run() {
        this.t = this.t1;
        this.setTitle(this.s1 + " \u0422\u0440\u0430\u043d\u0441\u0430\u043a\u0446\u0438\u044f");
        this.tfDescription.setString(this.t.description);
        String string = "";
        if (this.t.amount != 0) {
            string = Utilities.numberToString(Math.abs(this.t.amount), this.parent.numericEntry, this.parent.isEuropeanNumberFormat, false);
        }
        this.tfAmount.setString(string);
        if (this.t.amount <= 0) {
            this.cgDRCR.setSelectedIndex(0, true);
        } else {
            this.cgDRCR.setSelectedIndex(1, true);
        }
        this.tfReference.setString(this.t.reference);
        if (this.cgAccount != null) {
            AccountStore accountStore = new AccountStore(this.parent);
            int n = accountStore.getNumAccounts();
            for (int i = 0; i < n; ++i) {
                Account account = accountStore.getAccountFromIndex(i);
                if (!account.name.equals(this.parent.lastAccount)) continue;
                this.cgAccount.setSelectedIndex(i, true);
                break;
            }
            accountStore.closeAccountStore();
            accountStore = null;
        }
        this.parent.genericDate.setTime(this.t.longDate + 3600000L);
        this.df.setDate(this.parent.genericDate);
        if (!this.t.reconciled) {
            this.cgReconciled.setSelectedIndex(0, true);
        }
        if (this.t.reconciled) {
            this.cgReconciled.setSelectedIndex(1, true);
        }
        if (!this.t.transferFlag) {
            this.cgTransfer.setSelectedIndex(0, true);
        }
        if (this.t.transferFlag) {
            this.cgTransfer.setSelectedIndex(1, true);
        }
        while (!this.ready) {
        }
        if (!this.s1.equals("\u041d\u043e\u0432\u044b\u0439")) {
            this.setCategories();
        }
        this.setCurrency();
    }

    void clearCategories() {
        if (this.cgCategory == null) {
            return;
        }
        for (int i = 0; i < this.cgCategory.size(); ++i) {
            this.cgCategory.setSelectedIndex(i, false);
        }
    }

    String showDate(long l) {
        this.parent.genericDate.setTime(l + 3600000L);
        this.parent.cal.setTime(this.parent.genericDate);
        String string = "" + this.parent.cal.get(5);
        if (string.length() < 2) {
            string = "0" + string;
        }
        int n = this.parent.cal.get(2) + 1;
        String string2 = "" + n;
        if (string2.length() < 2) {
            string2 = "0" + string2;
        }
        String string3 = ("" + this.parent.cal.get(1)).substring(2, 4);
        if (this.parent.dateFormat == 0 || this.parent.dateFormat == 2) {
            return string + "/" + string2 + "/" + string3;
        }
        if (this.parent.dateFormat == 1 || this.parent.dateFormat == 3) {
            return string2 + "/" + string + "/" + string3;
        }
        return "";
    }
}

