/*
 * Decompiled with CFR 0.152.
 */
package JabpLite;

import JabpLite.JabpLite;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class PreferenceStore {
    RecordStore rs;
    JabpLite parent;

    public PreferenceStore(JabpLite jabpLite) {
        this.parent = jabpLite;
        try {
            this.rs = RecordStore.openRecordStore((String)"\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438", (boolean)true, (int)1, (boolean)true);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " ps1");
        }
    }

    void closePreferenceStore() {
        if (this.rs != null) {
            try {
                this.rs.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException) {
                System.err.println((Object)((Object)recordStoreException) + " ps2");
            }
        }
    }

    int getNumPreferences() {
        if (this.rs == null) {
            return 0;
        }
        try {
            return this.rs.getNumRecords();
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " ps3");
            return 0;
        }
    }

    byte[] toByteArray() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeUTF(this.parent.homeCurrency);
            dataOutputStream.writeBoolean(this.parent.mediumSize);
            dataOutputStream.writeInt(this.parent.fontAdjustment);
            dataOutputStream.writeInt(this.parent.widthAdjustment);
            dataOutputStream.writeInt(this.parent.colorHeading);
            dataOutputStream.writeInt(this.parent.colorCursor);
            dataOutputStream.writeInt(this.parent.colorBackground);
            dataOutputStream.writeBoolean(this.parent.passwordMode);
            dataOutputStream.writeUTF(this.parent.password);
            dataOutputStream.writeInt(this.parent.dateFormat);
            dataOutputStream.writeInt(this.parent.heightAdjustment);
            dataOutputStream.writeBoolean(this.parent.numericEntry);
            dataOutputStream.writeBoolean(this.parent.reuseForm);
            dataOutputStream.writeBoolean(this.parent.quickStart);
            dataOutputStream.writeUTF(this.parent.lastAccount);
            dataOutputStream.writeBoolean(this.parent.createFormsInBackground);
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    void fromByteArray(byte[] byArray) {
        try {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            this.parent.homeCurrency = dataInputStream.readUTF();
            this.parent.mediumSize = dataInputStream.readBoolean();
            this.parent.fontAdjustment = dataInputStream.readInt();
            this.parent.widthAdjustment = dataInputStream.readInt();
            this.parent.colorHeading = dataInputStream.readInt();
            this.parent.colorCursor = dataInputStream.readInt();
            this.parent.colorBackground = dataInputStream.readInt();
            this.parent.passwordMode = dataInputStream.readBoolean();
            this.parent.password = dataInputStream.readUTF();
            this.parent.dateFormat = dataInputStream.readInt();
            this.parent.heightAdjustment = dataInputStream.readInt();
            this.parent.numericEntry = dataInputStream.readBoolean();
            this.parent.reuseForm = dataInputStream.readBoolean();
            this.parent.quickStart = dataInputStream.readBoolean();
            this.parent.lastAccount = dataInputStream.readUTF();
            this.parent.createFormsInBackground = dataInputStream.readBoolean();
            dataInputStream.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException + " ps4a");
        }
    }

    void getPreferences() {
        try {
            if (this.rs.getNumRecords() == 0) {
                return;
            }
            byte[] byArray = this.rs.getRecord(1);
            this.fromByteArray(byArray);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " ps4");
        }
    }

    void savePreferences() {
        if (this.rs != null) {
            try {
                byte[] byArray = this.toByteArray();
                if (this.rs.getNumRecords() > 0) {
                    this.rs.setRecord(1, byArray, 0, byArray.length);
                } else {
                    this.rs.addRecord(byArray, 0, byArray.length);
                }
            }
            catch (RecordStoreException recordStoreException) {
                System.err.println((Object)((Object)recordStoreException) + " ps7");
            }
        }
    }

    int getSize() {
        try {
            return this.rs.getSize();
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " ps9");
            return 0;
        }
    }
}

