/*
 * Decompiled with CFR 0.152.
 */
package JabpLite;

import JabpLite.CategoryView;
import JabpLite.CurrencyView;
import JabpLite.DateId;
import JabpLite.InvestmentView;
import JabpLite.JabpLite;
import JabpLite.StandingOrder;
import JabpLite.StandingOrderForm;
import JabpLite.StandingOrderStore;
import JabpLite.TransferForm;
import JabpLite.Utilities;
import JabpLite.ViewForm;
import java.util.Calendar;
import java.util.Date;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.DateField;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;

public class StandingOrderView
extends Canvas
implements CommandListener,
Runnable {
    StandingOrder so;
    StandingOrder so1;
    StandingOrder oldSO;
    StandingOrder previousSO;
    StandingOrderForm sof;
    TransferForm trf;
    Form debug;
    Form f3;
    StandingOrderStore sos;
    Alert alert;
    Calendar calendar;
    DateField df;
    Display display;
    Font font;
    JabpLite parent;
    ViewForm vl;
    String msg = "";
    String oldName = "";
    int width;
    int height;
    int actionKey;
    int upKey;
    int downKey;
    int leftKey;
    int rightKey;
    int currentX;
    int currentY;
    int oldX;
    int oldY;
    int numItems;
    int numItemsPage;
    int fontHeight;
    int fontWidth;
    int currentPos;
    int oldId;
    int startPos;
    int dateWidth;
    int numberWidth;
    int descriptionWidth;
    int descriptionPosition;
    int amountPosition;
    int currencyRate;
    int runMode;

    public StandingOrderView(JabpLite jabpLite, Display display) {
        this.parent = jabpLite;
        this.display = display;
        this.addCommand(this.parent.exitCommand);
        this.addCommand(this.parent.newCommand);
        this.addCommand(this.parent.editCommand);
        this.addCommand(this.parent.deleteCommand);
        this.addCommand(this.parent.mainCommand);
        this.addCommand(this.parent.viewCommand);
        this.addCommand(this.parent.processNowCommand);
        this.addCommand(this.parent.cancelCommand);
        this.setCommandListener(this);
        this.calendar = Calendar.getInstance();
        this.alert = new Alert("");
        this.alert.setType(AlertType.CONFIRMATION);
        this.alert.setTimeout(1500);
        this.width = this.getWidth();
        this.height = this.getHeight() - this.parent.heightAdjustment;
        int n = 8;
        this.runMode = 1;
        if (this.parent.mediumSize) {
            n = 0;
        }
        this.font = Font.getFont((int)0, (int)0, (int)n);
        this.fontHeight = this.font.getHeight();
        this.dateWidth = this.font.stringWidth("99/99");
        this.numberWidth = this.font.stringWidth("999999.99");
        this.descriptionWidth = this.width - this.numberWidth - this.dateWidth - this.parent.widthAdjustment * 2 - 30;
        this.setPositions();
        this.numItemsPage = this.height / this.fontHeight - 2;
        this.actionKey = this.getKeyCode(8);
        this.upKey = this.getKeyCode(1);
        this.downKey = this.getKeyCode(6);
        this.leftKey = this.getKeyCode(2);
        this.rightKey = this.getKeyCode(5);
        this.sos = new StandingOrderStore(this.parent);
        this.numItems = this.sos.getNumStandingOrders();
        this.currentX = 0;
        this.currentY = this.fontHeight;
        this.currentPos = 0;
        this.startPos = 0;
        if (this.parent.createFormsInBackground) {
            this.runThread();
        }
    }

    void runThread() {
        Thread thread = new Thread(this);
        thread.start();
    }

    public void paint(Graphics graphics) {
        this.height = this.getHeight() - this.parent.heightAdjustment;
        this.numItemsPage = this.height / this.fontHeight - 2;
        graphics.setFont(this.font);
        this.showHeader(graphics);
        this.showPage(graphics);
        this.showFooter(graphics);
    }

    void showPage(Graphics graphics) {
        graphics.setColor(this.parent.colorBackground);
        graphics.fillRect(0, this.fontHeight, this.width, this.height - this.fontHeight * 2);
        graphics.setColor(0);
        if (this.numItems == 0) {
            return;
        }
        for (int i = 0; i < this.numItemsPage && i + this.startPos <= this.numItems - 1; ++i) {
            if (i == this.currentPos) {
                graphics.setColor(this.parent.colorCursor);
                graphics.fillRect(0, this.fontHeight * i + this.fontHeight, this.width, this.fontHeight);
                graphics.setColor(0);
            }
            this.so = this.sos.getStandingOrderFromIndex(i + this.startPos);
            this.buildLine(graphics, this.so, this.fontHeight * i + this.fontHeight);
        }
        this.so = this.sos.getStandingOrderFromIndex(this.startPos + this.currentPos);
    }

    void showHeader(Graphics graphics) {
        if (this.msg.equals("")) {
            graphics.setColor(this.parent.colorHeading);
            graphics.fillRect(0, 0, this.width, this.fontHeight);
            graphics.setColor(0);
            graphics.drawString("\u041f\u043e\u0441\u0442.\u041f\u043e\u0440\u0443\u0447\u0435\u043d\u0438\u044f", this.parent.widthAdjustment, this.parent.fontAdjustment, 20);
        } else {
            graphics.setColor(this.parent.colorRed);
            graphics.fillRect(0, 0, this.width, this.fontHeight);
            graphics.setColor(0);
            graphics.drawString(this.msg, this.parent.widthAdjustment, this.parent.fontAdjustment, 20);
        }
    }

    void showFooter(Graphics graphics) {
        graphics.setColor(this.parent.colorHeading);
        graphics.fillRect(0, this.height - this.fontHeight, this.width, this.fontHeight);
        graphics.setColor(0);
    }

    void drawUp() {
        if (this.startPos + this.currentPos > 0) {
            this.oldY = this.currentY;
            this.currentY -= this.fontHeight;
            --this.currentPos;
            this.previousSO = new StandingOrder();
            this.previousSO.clone(this.so);
            this.so = this.sos.getStandingOrderFromIndex(this.startPos + this.currentPos);
            if (this.currentY < this.fontHeight) {
                this.currentY = this.fontHeight;
                --this.startPos;
                if (this.startPos < 0) {
                    this.startPos = 0;
                }
                ++this.currentPos;
            }
            this.repaint();
            return;
        }
    }

    void drawDown() {
        if (this.startPos + this.currentPos < this.numItems - 1) {
            this.oldY = this.currentY;
            this.currentY += this.fontHeight;
            ++this.currentPos;
            this.previousSO = new StandingOrder();
            this.previousSO.clone(this.so);
            this.so = this.sos.getStandingOrderFromIndex(this.startPos + this.currentPos);
            if (this.currentY + this.fontHeight * 2 > this.height) {
                this.currentY -= this.fontHeight;
                ++this.startPos;
                --this.currentPos;
                if (this.startPos > this.numItems - 1) {
                    this.startPos = this.numItems - 1 - this.currentPos;
                }
            }
            this.repaint();
            return;
        }
    }

    String setPageDate(Date date) {
        this.calendar.setTime(date);
        String string = "" + this.calendar.get(5);
        if (string.length() < 2) {
            string = "0" + string;
        }
        int n = this.calendar.get(2) + 1;
        String string2 = "" + n;
        if (string2.length() < 2) {
            string2 = "0" + string2;
        }
        if (this.parent.dateFormat == 1) {
            return string2 + "/" + string;
        }
        return string + "/" + string2;
    }

    void buildLine(Graphics graphics, StandingOrder standingOrder, int n) {
        graphics.drawString(this.setPageDate(standingOrder.processingDate), this.parent.widthAdjustment, n + this.parent.fontAdjustment, 20);
        int n2 = standingOrder.description.length();
        for (int i = 0; i < n2; ++i) {
            int n3 = n2 - i;
            if (this.font.stringWidth(standingOrder.description.substring(0, n3)) > this.descriptionWidth) continue;
            graphics.drawString(standingOrder.description.substring(0, n3), this.descriptionPosition, n + this.parent.fontAdjustment, 20);
            break;
        }
        String string = Utilities.numberToString(standingOrder.amount, false);
        graphics.drawString(string, this.amountPosition + this.numberWidth - this.font.stringWidth(string), n + this.parent.fontAdjustment, 20);
    }

    void setPositions() {
        this.descriptionPosition = this.dateWidth + this.parent.widthAdjustment + 10;
        this.amountPosition = this.descriptionPosition + this.descriptionWidth + 10;
    }

    StandingOrder showStandingOrder() {
        this.oldSO = new StandingOrder();
        this.oldSO.clone(this.so);
        return this.so;
    }

    int newStandingOrder(StandingOrder standingOrder) {
        this.so1 = standingOrder;
        this.so1.id = this.sos.saveNewStandingOrder(this.so1);
        if (this.so == null) {
            this.so = this.so1;
        }
        ++this.numItems;
        this.repaint();
        return this.so1.id;
    }

    void editStandingOrder(StandingOrder standingOrder) {
        this.so1 = standingOrder;
        this.sos.saveExistingStandingOrder(this.so1);
        if (Utilities.calcDate(this.so1.processingDate) != Utilities.calcDate(this.oldSO.processingDate)) {
            this.sos.deleteIndex(this.startPos + this.currentPos);
            this.sos.addIndex(this.so1);
        }
        this.oldY = this.currentY;
        this.repaint();
    }

    void deleteStandingOrder(StandingOrder standingOrder) {
        this.so1 = standingOrder;
        this.sos.deleteStandingOrder(this.so1);
        this.sos.deleteIndex(this.startPos + this.currentPos);
        --this.numItems;
        if (this.numItems > 0 && this.startPos + this.currentPos > this.numItems - 1) {
            if (this.currentPos > 0) {
                this.currentY -= this.fontHeight;
                --this.currentPos;
            } else {
                --this.startPos;
            }
        }
        this.repaint();
    }

    protected void showNotify() {
        this.repaint();
    }

    protected void keyPressed(int n) {
        if (n == this.leftKey || n == -3) {
            if (this.startPos == 0) {
                this.currentPos = 0;
                this.currentY = this.fontHeight;
            } else {
                this.startPos -= this.numItemsPage;
                if (this.startPos < 0) {
                    this.startPos = 0;
                }
            }
            this.repaint();
            return;
        }
        if (n == this.rightKey || n == -4) {
            this.startPos += this.numItemsPage;
            if (this.startPos + this.currentPos > this.numItems - 1) {
                this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                this.startPos = this.numItems - 1 - this.currentPos;
                this.currentY = this.currentPos * this.fontHeight + this.fontHeight;
            }
            this.repaint();
            return;
        }
        if (n == this.actionKey) {
            // empty if block
        }
        if (n == this.upKey) {
            this.drawUp();
            return;
        }
        if (n == this.downKey) {
            this.drawDown();
            return;
        }
        if (n == 48) {
            int n2 = this.startPos + this.currentPos;
            this.debug = new Form("\u0417\u0430\u043f\u0438\u0441\u044c \u0421\u0432\u043e\u0439\u0441\u0442\u0432");
            this.debug.append("\u041f\u043e\u0437\u0438\u0446\u0438\u044f" + n2 + "\u0438\u0437" + this.numItems + "\n");
            short s = (short)n2;
            int n3 = ((DateId)this.sos.ht.get((Object)new Short((short)s))).id;
            this.debug.append("\u0417\u0430\u043f\u0438\u0441\u044c ID " + n3 + "\n");
            this.debug.append("\u0417\u0430\u043f\u0438\u0441\u044c \u0414\u043b\u0438\u043d\u044b" + this.sos.getRecordSize(n3) + "\n");
            this.debug.append("\u0420\u0430\u0437\u043c\u0435\u0440 \u0417\u0430\u043f\u0438\u0441\u0438 \u0418\u0441\u0442\u043e\u0440\u0438\u0438" + this.sos.getSize() + "\n");
            this.debug.addCommand(this.parent.okCommand);
            this.debug.setCommandListener((CommandListener)this);
            this.display.setCurrent((Displayable)this.debug);
        }
    }

    protected void pointerPressed(int n, int n2) {
        if (n2 < this.fontHeight) {
            this.keyPressed(this.leftKey);
            return;
        }
        if (n2 > this.height - this.fontHeight) {
            this.keyPressed(this.rightKey);
            return;
        }
        int n3 = (n2 - this.fontHeight) / this.fontHeight;
        while (n3 > this.currentPos) {
            this.drawDown();
        }
        while (n3 < this.currentPos) {
            this.drawUp();
        }
        this.repaint();
    }

    void removeAllCommands() {
        this.sof.removeCommand(this.parent.createCommand);
        this.sof.removeCommand(this.parent.updateCommand);
        this.sof.removeCommand(this.parent.deleteCommand);
        this.sof.removeCommand(this.parent.cancelCommand);
    }

    void checkForm() {
        if (this.parent.reuseForm) {
            return;
        }
        if (this.parent.createFormsInBackground) {
            this.runThread();
        } else {
            this.run();
        }
    }

    void show(String string) {
        this.msg = string;
        this.repaint();
        this.serviceRepaints();
    }

    public void run() {
        if (this.runMode == 1) {
            this.show("\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u0444\u043e\u0440\u043c\u044b \u0441 \u0444\u043e\u043d\u0435...");
            this.sof = new StandingOrderForm(this.parent);
            this.sof.build();
            this.sof.setCommandListener(this);
            this.show("");
        }
        if (this.runMode == 2) {
            this.sos.processStandingOrders(this.df.getDate());
            this.numItems = this.sos.getNumStandingOrders();
            this.runMode = 1;
            this.display.setCurrent((Displayable)this);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.parent.exitCommand) {
            this.parent.destroyApp(true);
            return;
        }
        if (displayable == this) {
            if (command == this.parent.newCommand) {
                if (this.sof == null) {
                    this.run();
                }
                if (!this.sof.ready) {
                    this.display.setCurrent((Displayable)this.sof);
                }
                StandingOrder standingOrder = new StandingOrder();
                this.removeAllCommands();
                this.sof.addCommand(this.parent.createCommand);
                this.sof.addCommand(this.parent.cancelCommand);
                this.sof.addCommand(this.parent.exitCommand);
                this.sof.set(standingOrder, "\u041d\u043e\u0432\u044b\u0439");
                this.display.setCurrent((Displayable)this.sof);
            }
            if (command == this.parent.editCommand) {
                if (this.numItems == 0) {
                    this.alert.setString("\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b \u041f\u043e\u0441\u0442.\u041f\u043e\u0440\u0443\u0447\u0435\u043d\u0438\u044f");
                    this.display.setCurrent(this.alert, (Displayable)this);
                    return;
                }
                if (this.sof == null) {
                    this.run();
                }
                if (!this.sof.ready) {
                    this.display.setCurrent((Displayable)this.sof);
                }
                this.removeAllCommands();
                this.sof.addCommand(this.parent.updateCommand);
                this.sof.addCommand(this.parent.cancelCommand);
                this.sof.addCommand(this.parent.exitCommand);
                this.sof.set(this.showStandingOrder(), "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
                this.display.setCurrent((Displayable)this.sof);
            }
            if (command == this.parent.deleteCommand) {
                if (this.numItems == 0) {
                    this.alert.setString("\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b \u041f\u043e\u0441\u0442.\u041f\u043e\u0440\u0443\u0447\u0435\u043d\u0438\u044f");
                    this.display.setCurrent(this.alert, (Displayable)this);
                    return;
                }
                if (this.sof == null) {
                    this.run();
                }
                if (!this.sof.ready) {
                    this.display.setCurrent((Displayable)this.sof);
                }
                this.removeAllCommands();
                this.sof.addCommand(this.parent.deleteCommand);
                this.sof.addCommand(this.parent.cancelCommand);
                this.sof.addCommand(this.parent.exitCommand);
                this.sof.set(this.showStandingOrder(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c");
                this.display.setCurrent((Displayable)this.sof);
            }
            if (command == this.parent.mainCommand) {
                this.display.setCurrent((Displayable)this.parent.av);
            }
            if (command == this.parent.viewCommand) {
                this.vl = new ViewForm();
                this.vl.addCommand(this.parent.okCommand);
                this.vl.addCommand(this.parent.cancelCommand);
                this.vl.addCommand(this.parent.exitCommand);
                this.vl.setCommandListener(this);
                this.display.setCurrent((Displayable)this.vl);
            }
            if (command == this.parent.processNowCommand) {
                this.f3 = new Form("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c \u0421\u0435\u0439\u0447\u0430\u0441");
                this.df = new DateField("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u0434\u043e \u0434\u0430\u0442\u044b", 1);
                this.df.setDate(new Date());
                this.f3.append((Item)this.df);
                this.f3.addCommand(this.parent.okCommand);
                this.f3.addCommand(this.parent.cancelCommand);
                this.f3.addCommand(this.parent.exitCommand);
                this.f3.setCommandListener((CommandListener)this);
                this.display.setCurrent((Displayable)this.f3);
            }
        }
        if (displayable == this.sof) {
            if (command == this.parent.createCommand) {
                this.so1 = this.sof.update();
                if (this.so1.description.equals("")) {
                    this.alert.setString("\u041f\u0443\u0441\u0442\u043e\u0435 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435");
                    this.display.setCurrent(this.alert, (Displayable)this.sof);
                    return;
                }
                if (this.sos.getStandingOrderFromName(this.so1.description) != null) {
                    this.alert.setString(this.so1.description + " \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442");
                    this.display.setCurrent(this.alert, (Displayable)this.sof);
                    return;
                }
                if (this.so1.transferFlag) {
                    this.trf = new TransferForm(this.parent, null, this.so1, "\u041f\u0435\u0440\u0435\u0432\u043e\u0434");
                    this.trf.addCommand(this.parent.okCommand);
                    this.trf.setCommandListener(this);
                    this.display.setCurrent((Displayable)this.trf);
                    return;
                }
                this.newStandingOrder(this.so1);
                this.checkForm();
                this.display.setCurrent((Displayable)this);
            }
            if (command == this.parent.updateCommand) {
                this.so1 = this.sof.update();
                if (this.so1.description.equals("")) {
                    this.alert.setString("\u041f\u0443\u0441\u0442\u043e\u0435 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435");
                    this.display.setCurrent(this.alert, (Displayable)this.sof);
                    return;
                }
                if (!this.so1.description.equals(this.oldSO.description) && this.sos.getStandingOrderFromName(this.so1.description) != null) {
                    this.alert.setString(this.so1.description + " \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442");
                    this.display.setCurrent(this.alert, (Displayable)this.sof);
                    return;
                }
                if (!this.oldSO.transferFlag && this.so1.transferFlag) {
                    this.alert.setString("\u041d\u0435 \u043c\u043e\u0433\u0443 \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0434\u043e \u043f\u0435\u0440\u0435\u0432\u043e\u0434\u0430 - \u0443\u0434\u0430\u043b\u0438\u0442\u0435 \u0438 \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u0441\u043d\u043e\u0432\u0430");
                    this.display.setCurrent(this.alert, (Displayable)this.sof);
                    return;
                }
                if (this.oldSO.transferFlag && !this.so1.transferFlag) {
                    this.alert.setString("\u041d\u0435 \u043c\u043e\u0433\u0443 \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u043e\u0442 \u043f\u0435\u0440\u0435\u0432\u043e\u0434\u0430 - \u0443\u0434\u0430\u043b\u0438\u0442\u0435 \u0438 \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u0441\u043d\u043e\u0432\u0430");
                    this.display.setCurrent(this.alert, (Displayable)this.sof);
                    return;
                }
                this.editStandingOrder(this.so1);
                this.checkForm();
                this.display.setCurrent((Displayable)this);
            }
            if (command == this.parent.deleteCommand) {
                this.deleteStandingOrder(this.so);
                this.checkForm();
                this.display.setCurrent((Displayable)this);
            }
            if (command == this.parent.cancelCommand) {
                this.checkForm();
                this.alert.setString("\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e");
                this.display.setCurrent(this.alert, (Displayable)this);
                return;
            }
        }
        if (displayable == this.trf && command == this.parent.okCommand) {
            this.so1 = this.trf.updateTransferSO();
            if (this.so1.account.equals(this.so1.transferAccount)) {
                this.alert.setString("\u0412\u044b\u0431\u0440\u0430\u0442\u044c \u0434\u0440\u0443\u0433\u0443\u044e \u0423\u0447.\u0417\u0430\u043f\u0438\u0441\u044c");
                this.display.setCurrent(this.alert, (Displayable)this.sof);
                return;
            }
            this.newStandingOrder(this.so1);
            this.display.setCurrent((Displayable)this);
        }
        if (displayable == this.vl) {
            if (command == this.parent.cancelCommand) {
                this.vl = null;
                this.alert.setString("\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
            if (command == this.parent.okCommand) {
                if (this.vl.update() == 0) {
                    this.display.setCurrent((Displayable)this.parent.av);
                }
                if (this.vl.update() == 1) {
                    if (this.parent.tv == null) {
                        this.alert.setString("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u0430 \u0423\u0447.\u0417\u0430\u043f\u0438\u0441\u044c");
                        this.display.setCurrent(this.alert, (Displayable)this);
                    } else {
                        this.display.setCurrent((Displayable)this.parent.tv);
                    }
                }
                if (this.vl.update() == 2) {
                    if (this.parent.cv == null) {
                        this.parent.cv = new CategoryView(this.parent, this.display);
                    }
                    this.display.setCurrent((Displayable)this.parent.cv);
                }
                if (this.vl.update() == 3) {
                    this.display.setCurrent((Displayable)this);
                }
                if (this.vl.update() == 4) {
                    if (this.parent.iv == null) {
                        this.parent.iv = new InvestmentView(this.parent, this.display);
                    }
                    this.display.setCurrent((Displayable)this.parent.iv);
                }
                if (this.vl.update() == 5) {
                    if (this.parent.ccyv == null) {
                        this.parent.ccyv = new CurrencyView(this.parent, this.display);
                    }
                    this.display.setCurrent((Displayable)this.parent.ccyv);
                }
            }
        }
        if (displayable == this.f3) {
            if (command == this.parent.okCommand) {
                this.parent.f3 = new List("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c \u0421\u0435\u0439\u0447\u0430\u0441", 3);
                this.parent.f3.setCommandListener((CommandListener)this);
                this.display.setCurrent((Displayable)this.parent.f3);
                this.runMode = 2;
                this.runThread();
            }
            if (command == this.parent.cancelCommand) {
                this.f3 = null;
                this.alert.setString("\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
        }
        if (displayable == this.debug) {
            this.debug = null;
            this.display.setCurrent((Displayable)this);
        }
    }
}

