/*
 * Decompiled with CFR 0.152.
 */
package com.bgate.ItemEgg;

import com.bgate.ItemStruct.StructBrokenEgg;
import com.bgate.utils.Source;
import com.bgate.utils.SourceImage;
import com.bgate.utils.SourceState;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;

public class ItemBrokenEgg {
    public static int[][] fBroken;
    public static Random random;
    public static StructBrokenEgg[][] structBrokenEgg;
    public static Sprite[] spriteListBroken;
    public static int nListBroken;

    public ItemBrokenEgg() {
        this.initSprite();
        this.initArray();
    }

    public void initSprite() {
        spriteListBroken = new Sprite[2 * Source.MAXM];
        for (int i = 0; i < 2 * Source.MAXM; ++i) {
            ItemBrokenEgg.spriteListBroken[i] = new Sprite(SourceImage.brokenEggs, Source.BROKEN_WIDTH, Source.BROKEN_HEIGHT);
        }
    }

    public void initArray() {
        fBroken = new int[Source.ROW_MAX][Source.COLUMN_MAX];
        structBrokenEgg = new StructBrokenEgg[Source.ROW_MAX][Source.COLUMN_MAX];
        random = new Random();
        for (int i = 0; i < Source.ROW_MAX; ++i) {
            for (int j = 0; j < Source.COLUMN_MAX; ++j) {
                ItemBrokenEgg.fBroken[i][j] = 0;
                ItemBrokenEgg.structBrokenEgg[i][j] = new StructBrokenEgg();
            }
        }
    }

    public void initLevel() {
        nListBroken = 0;
        for (int i = 0; i < Source.ROW_MAX; ++i) {
            for (int j = 0; j < Source.COLUMN_MAX; ++j) {
                ItemBrokenEgg.fBroken[i][j] = 0;
                ItemBrokenEgg.structBrokenEgg[i][j].time = 0;
                ItemBrokenEgg.structBrokenEgg[i][j].state = 0;
                ItemBrokenEgg.structBrokenEgg[i][j].rand = 0;
                ItemBrokenEgg.structBrokenEgg[i][j].X1 = 0.0;
                ItemBrokenEgg.structBrokenEgg[i][j].Y1 = 0.0;
                ItemBrokenEgg.structBrokenEgg[i][j].X2 = 0.0;
                ItemBrokenEgg.structBrokenEgg[i][j].Y2 = 0.0;
                ItemBrokenEgg.structBrokenEgg[i][j].X3 = 0.0;
                ItemBrokenEgg.structBrokenEgg[i][j].Y3 = 0.0;
                ItemBrokenEgg.structBrokenEgg[i][j].X4 = 0.0;
                ItemBrokenEgg.structBrokenEgg[i][j].Y4 = 0.0;
            }
        }
    }

    public void dispose() {
        fBroken = null;
        structBrokenEgg = null;
        random = null;
        spriteListBroken = null;
    }

    public boolean getState() {
        for (int i = 0; i < Source.ROW_MAX; ++i) {
            for (int j = 0; j < Source.COLUMN_MAX; ++j) {
                if (fBroken[i][j] <= 0) continue;
                return SourceState.STATE_EGG_BROKEN;
            }
        }
        return false;
    }

    public static void update(int i, int j) {
        double XList = 0.0;
        double YList = 0.0;
        double tempInitRow = 0.0;
        tempInitRow = i % 2 == 0 ? 0.0 : (double)(Source.SIZE_EGG / 2);
        XList = (double)(Source.INIT_ROW + j * Source.SIZE_EGG) + tempInitRow;
        YList = i * Source.SIZE_EGG + Source.INIT_ABOVE;
        if (ItemBrokenEgg.structBrokenEgg[i][j].time == 0) {
            ItemBrokenEgg.structBrokenEgg[i][j].X1 = XList + 12.0;
            ItemBrokenEgg.structBrokenEgg[i][j].Y1 = YList;
            ItemBrokenEgg.structBrokenEgg[i][j].X2 = XList + 12.0;
            ItemBrokenEgg.structBrokenEgg[i][j].Y2 = YList;
            ItemBrokenEgg.structBrokenEgg[i][j].Y3 = YList + 12.0;
            ItemBrokenEgg.structBrokenEgg[i][j].X3 = XList + 12.0;
            ItemBrokenEgg.structBrokenEgg[i][j].X4 = XList + 12.0;
            ItemBrokenEgg.structBrokenEgg[i][j].Y4 = YList + 12.0;
            ItemBrokenEgg.structBrokenEgg[i][j].time = 1;
            ItemBrokenEgg.structBrokenEgg[i][j].rand = 2 + random.nextInt(6);
        } else {
            if (ItemBrokenEgg.structBrokenEgg[i][j].Y1 >= YList - (double)Source.FALL && ItemBrokenEgg.structBrokenEgg[i][j].state == 0) {
                ItemBrokenEgg.structBrokenEgg[i][j].Y1 -= (double)Source.FALL;
                ItemBrokenEgg.structBrokenEgg[i][j].Y2 -= (double)Source.FALL;
                ItemBrokenEgg.structBrokenEgg[i][j].X1 -= Math.sqrt(Source.FALL / ItemBrokenEgg.structBrokenEgg[i][j].rand);
                ItemBrokenEgg.structBrokenEgg[i][j].X2 += Math.sqrt(Source.FALL / ItemBrokenEgg.structBrokenEgg[i][j].rand);
                if (ItemBrokenEgg.structBrokenEgg[i][j].Y1 == YList - (double)Source.FALL) {
                    ItemBrokenEgg.structBrokenEgg[i][j].state = 1;
                }
            }
            ItemBrokenEgg.structBrokenEgg[i][j].Y3 += (double)Source.FALL;
            ItemBrokenEgg.structBrokenEgg[i][j].X3 += Math.sqrt(Source.FALL / ItemBrokenEgg.structBrokenEgg[i][j].rand);
            ItemBrokenEgg.structBrokenEgg[i][j].Y4 += (double)Source.FALL;
            ItemBrokenEgg.structBrokenEgg[i][j].X4 -= Math.sqrt(Source.FALL / ItemBrokenEgg.structBrokenEgg[i][j].rand);
        }
    }

    public void updateBroken12(int i, int j) {
        if (ItemBrokenEgg.structBrokenEgg[i][j].state == 1) {
            ItemBrokenEgg.structBrokenEgg[i][j].Y1 += (double)Source.FALL;
            ItemBrokenEgg.structBrokenEgg[i][j].Y2 += (double)Source.FALL;
            ItemBrokenEgg.structBrokenEgg[i][j].X1 -= Math.sqrt(Source.FALL / ItemBrokenEgg.structBrokenEgg[i][j].rand);
            ItemBrokenEgg.structBrokenEgg[i][j].X2 += Math.sqrt(Source.FALL / ItemBrokenEgg.structBrokenEgg[i][j].rand);
        }
        if (this.checkBroken(ItemBrokenEgg.structBrokenEgg[i][j].Y1, ItemBrokenEgg.structBrokenEgg[i][j].Y2, ItemBrokenEgg.structBrokenEgg[i][j].Y3, ItemBrokenEgg.structBrokenEgg[i][j].Y4)) {
            ItemBrokenEgg.fBroken[i][j] = 0;
            ItemBrokenEgg.structBrokenEgg[i][j].state = 0;
            ItemBrokenEgg.structBrokenEgg[i][j].time = 0;
        }
    }

    public boolean checkBroken(double Y1, double Y2, double Y3, double Y4) {
        return Y1 >= (double)Source.BOARD_HEIGHT && Y2 >= (double)Source.BOARD_HEIGHT && Y3 >= (double)Source.BOARD_HEIGHT && Y4 >= (double)Source.BOARD_HEIGHT;
    }

    public static void setList() {
        if (++nListBroken >= 2 * Source.MAXM) {
            nListBroken = 0;
        }
    }

    public static void presentList(Graphics g, int index, int trans, int i, int j, double X, double Y) {
        spriteListBroken[nListBroken].setFrame(index - 1);
        spriteListBroken[nListBroken].setTransform(0);
        spriteListBroken[nListBroken].setTransform(trans);
        spriteListBroken[nListBroken].setPosition((int)X, (int)Y);
        spriteListBroken[nListBroken].paint(g);
        ItemBrokenEgg.setList();
    }

    public static void presentBroken(Graphics g, int index, int i, int j) {
        ItemBrokenEgg.presentList(g, index, 3, i, j, ItemBrokenEgg.structBrokenEgg[i][j].X1, ItemBrokenEgg.structBrokenEgg[i][j].Y1);
        ItemBrokenEgg.presentList(g, index, 6, i, j, ItemBrokenEgg.structBrokenEgg[i][j].X2, ItemBrokenEgg.structBrokenEgg[i][j].Y2);
        ItemBrokenEgg.presentList(g, index, 2, i, j, ItemBrokenEgg.structBrokenEgg[i][j].X3, ItemBrokenEgg.structBrokenEgg[i][j].Y3);
        ItemBrokenEgg.presentList(g, index, 0, i, j, ItemBrokenEgg.structBrokenEgg[i][j].X4, ItemBrokenEgg.structBrokenEgg[i][j].Y4);
    }

    public void present(Graphics g) {
        for (int i = 0; i < Source.ROW_MAX; ++i) {
            for (int j = 0; j < Source.COLUMN_MAX; ++j) {
                if (fBroken[i][j] <= 0) continue;
                ItemBrokenEgg.update(i, j);
                this.updateBroken12(i, j);
                if (fBroken[i][j] == 1) {
                    ItemBrokenEgg.presentBroken(g, 1, i, j);
                }
                if (fBroken[i][j] == 2) {
                    ItemBrokenEgg.presentBroken(g, 2, i, j);
                }
                if (fBroken[i][j] == 3) {
                    ItemBrokenEgg.presentBroken(g, 3, i, j);
                }
                if (fBroken[i][j] == 4) {
                    ItemBrokenEgg.presentBroken(g, 4, i, j);
                }
                if (fBroken[i][j] == 5) {
                    ItemBrokenEgg.presentBroken(g, 5, i, j);
                }
                if (fBroken[i][j] == 6) {
                    ItemBrokenEgg.presentBroken(g, 6, i, j);
                }
                if (fBroken[i][j] != 7) continue;
                ItemBrokenEgg.presentBroken(g, 7, i, j);
            }
        }
    }
}

