/*
 * Decompiled with CFR 0.152.
 */
package com.bgate.game;

import com.bgate.game.BaseRMS;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;

public class UserInfoRMS
extends BaseRMS {
    public int isGameActive = 0;
    public int liveEndless = 0;
    public int level = 0;
    public int money = 0;

    public UserInfoRMS(String rmsName) {
        super(rmsName);
    }

    public void loadInfo() {
        try {
            this.open();
            this.loadData();
            if (this.getRecordStore() != null) {
                this.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveGameActive(int isActive) {
        try {
            this.open();
            this.isGameActive = isActive;
            this.updateData();
            if (this.getRecordStore() != null) {
                this.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void saveGameLevel(int level) {
        try {
            this.open();
            this.level = level;
            this.updateData();
            if (this.getRecordStore() != null) {
                this.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void saveGameEndless(int level) {
        try {
            this.open();
            this.liveEndless = level;
            this.updateData();
            if (this.getRecordStore() != null) {
                this.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void saveGameMoney(int money) {
        try {
            this.open();
            this.money = money;
            this.updateData();
            if (this.getRecordStore() != null) {
                this.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void loadData() {
        try {
            byte[] record = this.getRecordStore().getRecord(1);
            DataInputStream istream = new DataInputStream(new ByteArrayInputStream(record, 0, record.length));
            this.isGameActive = istream.readInt();
            this.level = istream.readInt();
            this.money = istream.readInt();
            this.liveEndless = istream.readInt();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void createDefaultData() {
        try {
            ByteArrayOutputStream bstream = new ByteArrayOutputStream(28);
            DataOutputStream ostream = new DataOutputStream(bstream);
            ostream.writeInt(this.isGameActive);
            ostream.writeInt(this.level);
            ostream.writeInt(this.money);
            ostream.writeInt(this.liveEndless);
            ostream.flush();
            ostream.close();
            byte[] record = bstream.toByteArray();
            this.getRecordStore().addRecord(record, 0, record.length);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void updateData() {
        try {
            ByteArrayOutputStream bstream = new ByteArrayOutputStream(28);
            DataOutputStream ostream = new DataOutputStream(bstream);
            ostream.writeInt(this.isGameActive);
            ostream.writeInt(this.level);
            ostream.writeInt(this.money);
            ostream.writeInt(this.liveEndless);
            ostream.flush();
            ostream.close();
            byte[] record = bstream.toByteArray();
            this.getRecordStore().setRecord(1, record, 0, record.length);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

