/*
 * Decompiled with CFR 0.152.
 */
package com.twistfuture.main;

import com.twistfuture.app.App;
import com.twistfuture.main.Ball;
import com.twistfuture.main.Path;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class PathContainer {
    private final Vector vector_path = new Vector();
    private final Ball ball;
    private final Image img_ControlBg;
    private final Image img_Left;
    private final Image img_Right;
    private final Image img_TouchText;
    private final int mControlY;
    private int pointerX;
    public boolean isCollision = true;
    private boolean isPointerStatus;

    public PathContainer() {
        this.mControlY = 300;
        Image temp = App.createImage("path/ball.png");
        this.ball = new Ball(temp, (240 - temp.getWidth()) / 2, 250);
        this.img_ControlBg = App.createImage("strip.png");
        this.img_Left = App.createImage("left.png");
        this.img_TouchText = App.createImage("text.png");
        this.img_Right = Image.createImage((Image)this.img_Left, (int)0, (int)0, (int)this.img_Left.getWidth(), (int)this.img_Left.getHeight(), (int)3);
    }

    public void addElement(Path path) {
        if (!this.vector_path.isEmpty()) {
            Path p = (Path)this.vector_path.lastElement();
            path.setY(p.getY() - path.getHeight());
            path.getSprite().setPosition(path.getX(), path.getY());
        }
        this.vector_path.addElement(path);
    }

    public void removeFirstElement() {
        this.vector_path.removeElementAt(0);
    }

    public boolean checkCollision() {
        for (int i = 0; i < this.vector_path.size(); ++i) {
            Path p = (Path)this.vector_path.elementAt(i);
            if (!p.getSprite().collidesWith(this.ball.getImage(), this.ball.getX() + this.ball.getImage().getWidth() / 2, this.ball.getY(), true)) continue;
            return true;
        }
        return false;
    }

    public void update() {
        this.isCollision = this.checkCollision();
        for (int i = 0; i < this.vector_path.size(); ++i) {
            Path p = (Path)this.vector_path.elementAt(i);
            p.setY(p.getY() + 4);
            if (p.getY() <= 400) continue;
            this.removeFirstElement();
        }
        Path last = (Path)this.vector_path.lastElement();
        if (last.getY() > -50) {
            if (last.getPath_no() < 57) {
                Path newPath = new Path(App.createImage("path/" + last.getPath_no() + ".png"), last.getPath_no() + 1);
                this.addElement(newPath);
            } else {
                this.isCollision = false;
            }
        }
    }

    public void paint(Graphics g) {
        for (int i = 0; i < this.vector_path.size(); ++i) {
            Path p = (Path)this.vector_path.elementAt(i);
            p.paint(g);
        }
        this.ball.paint(g);
        g.drawImage(this.img_ControlBg, 0, 300, 0);
        g.drawImage(this.img_TouchText, (240 - this.img_TouchText.getWidth()) / 2, 300 + (this.img_ControlBg.getHeight() - this.img_TouchText.getHeight()) / 2, 0);
        g.drawImage(this.img_Right, 0, 300 + (this.img_ControlBg.getHeight() - this.img_Left.getHeight()) / 2, 0);
        g.drawImage(this.img_Left, 240 - this.img_Left.getWidth(), 300 + (this.img_ControlBg.getHeight() - this.img_Left.getHeight()) / 2, 0);
    }

    public boolean pointerPressed(int x, int y) {
        this.pointerX = x;
        if (y > 300 && y < 300 + this.img_ControlBg.getHeight()) {
            this.isPointerStatus = true;
            return true;
        }
        return false;
    }

    public void pointerDragged(int x, int y) {
        if (this.isPointerStatus) {
            this.ball.setX(this.ball.getX() + x - this.pointerX);
            this.pointerX = x;
        }
    }

    public void pointerReleased(int x, int y) {
        this.isPointerStatus = false;
    }
}

