/*
 * Decompiled with CFR 0.152.
 */
package com.manthanstudio.game;

import com.manthanstudio.constants.Constants;
import com.manthanstudio.game.Actor;
import com.manthanstudio.game.Hero;
import com.manthanstudio.resource.ResManager;
import com.manthanstudio.tools.ImageSet;
import com.manthanstudio.tools.MathFP;
import com.manthanstudio.tools.Sprite;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Vehicles
extends Actor {
    public static final int SPEED_INCREASE = 0;
    public static final int SPEED_DECREASE = 1;
    public static int FP_MINUS_0_02 = MathFP.toFP("-0.01");
    public static int FP_PLUS_0_02 = MathFP.toFP("0.01");
    public static int FP_0_2 = MathFP.toFP("0.1");
    private Image imgVehicles;
    private Image imgWheels;
    private Image imgHeadLight;
    private Image imgLightOnRoad;
    private Sprite wheelsSprite;
    public int speedUpFP = FP_PLUS_0_02;
    public int panPixelsToMoveFP;
    public boolean isInUse = false;
    public boolean isCrossHero = false;
    private int bonusPoints;
    public int collisionX;
    public int collisionY;
    public int collisionWidth;
    public int collisionHeight;
    public long timeSinceSpeedChange;
    public long timeSpeedChange;
    public int speedState = 0;
    public int seqNo;
    private int headLightX;
    private int headLightY;
    private int tyre1X;
    private int tyre1Y;
    private int tyre2X;
    private int tyre2Y;
    int sign = -1;

    public Vehicles(int id, int x, int y, int speedFP) {
        super(x, y);
        this.actorID = id;
        this.speedFP = speedFP;
    }

    public Vehicles(int id, int speedFP) {
        this(id, 0, 0, speedFP);
    }

    public void init() {
        this.isInUse = false;
        this.isCrossHero = false;
        this.imgWheels = ResManager.getImage(ResManager.IMAGE_VEHICALS_WHEELS);
        int wheelsWidth = this.imgWheels.getWidth() / 3;
        int wheelsHeight = this.imgWheels.getHeight();
        ImageSet imageSet = new ImageSet(1);
        imageSet.addState(this.imgWheels, new int[]{50, 50, 50}, new int[]{wheelsWidth, wheelsWidth, wheelsWidth}, new int[]{wheelsHeight, wheelsHeight, wheelsHeight}, new int[]{0, 1, 2, 1, 0});
        this.wheelsSprite = new Sprite(imageSet, 0, 0);
        if (this.wheelsSprite != null) {
            this.wheelsSprite.setOwner(this);
        }
        switch (this.actorID) {
            case 4: {
                this.imgVehicles = ResManager.getImage(ResManager.IMAGE_CAR_1);
                this.bonusPoints = 300;
                this.collisionX = 7;
                this.collisionY = 0;
                this.collisionWidth = 32;
                this.collisionHeight = 6;
                this.headLightX = 55;
                this.headLightY = 5;
                this.tyre1X = 3;
                this.tyre1Y = 16;
                this.tyre2X = 44;
                this.tyre2Y = 16;
                break;
            }
            case 6: {
                this.imgVehicles = ResManager.getImage(ResManager.IMAGE_CAR_2);
                this.bonusPoints = 300;
                this.collisionX = 7;
                this.collisionY = 0;
                this.collisionWidth = 32;
                this.collisionHeight = 6;
                this.headLightX = 55;
                this.headLightY = 5;
                this.tyre1X = 3;
                this.tyre1Y = 16;
                this.tyre2X = 44;
                this.tyre2Y = 16;
                break;
            }
            case 3: {
                this.imgVehicles = ResManager.getImage(ResManager.IMAGE_SUV);
                this.bonusPoints = 200;
                this.collisionX = 5;
                this.collisionY = 0;
                this.collisionWidth = 43;
                this.collisionHeight = 6;
                this.headLightX = 65;
                this.headLightY = 12;
                this.tyre1X = 5;
                this.tyre1Y = 19;
                this.tyre2X = 50;
                this.tyre2Y = 19;
                break;
            }
            case 5: {
                this.imgVehicles = ResManager.getImage(ResManager.IMAGE_BUS_1);
                this.bonusPoints = 150;
                this.collisionX = 4;
                this.collisionY = 0;
                this.collisionWidth = 101;
                this.collisionHeight = 6;
                this.headLightX = 110;
                this.headLightY = 21;
                this.tyre1X = 17;
                this.tyre1Y = 31;
                this.tyre2X = 78;
                this.tyre2Y = 31;
                break;
            }
            case 7: {
                this.imgVehicles = ResManager.getImage(ResManager.IMAGE_BUS_2);
                this.bonusPoints = 150;
                this.collisionX = 4;
                this.collisionY = 0;
                this.collisionWidth = 101;
                this.collisionHeight = 6;
                this.headLightX = 110;
                this.headLightY = 21;
                this.tyre1X = 17;
                this.tyre1Y = 31;
                this.tyre2X = 78;
                this.tyre2Y = 31;
                break;
            }
            case 1: {
                this.imgVehicles = ResManager.getImage(ResManager.IMAGE_TAXI);
                this.bonusPoints = 250;
                this.collisionX = 20;
                this.collisionY = 3;
                this.collisionWidth = 28;
                this.collisionHeight = 6;
                this.headLightX = 69;
                this.headLightY = 6;
                this.tyre1X = 11;
                this.tyre1Y = 18;
                this.tyre2X = 54;
                this.tyre2Y = 18;
                break;
            }
            case 0: {
                this.imgVehicles = ResManager.getImage(ResManager.IMAGE_GAME_AMBULANCE);
                this.bonusPoints = 150;
                this.collisionX = 3;
                this.collisionY = 0;
                this.collisionWidth = 54;
                this.collisionHeight = 6;
                this.headLightX = 83;
                this.headLightY = 21;
                this.tyre1X = 17;
                this.tyre1Y = 28;
                this.tyre2X = 70;
                this.tyre2Y = 28;
                break;
            }
            case 2: {
                this.imgVehicles = ResManager.getImage(ResManager.IMAGE_GAME_DOUBLE_DECKER);
                this.bonusPoints = 100;
                this.collisionX = 4;
                this.collisionY = 0;
                this.collisionWidth = 96;
                this.collisionHeight = 6;
                this.headLightX = 119;
                this.headLightY = 44;
                this.tyre1X = 23;
                this.tyre1Y = 54;
                this.tyre2X = 106;
                this.tyre2Y = 54;
            }
        }
        this.imgHeadLight = ResManager.getImage(ResManager.IMAGE_GAME_HEAD_LIGHT);
        this.imgLightOnRoad = ResManager.getImage(ResManager.IMAGE_LIGHT_ON_ROAD);
        this.setWidth(50);
        this.setHeight(25);
        if (this.imgVehicles != null) {
            this.setWidth(this.imgVehicles.getWidth());
            this.setHeight(this.imgVehicles.getHeight());
        }
        this.speedFP = Constants.SPEED_VEHICLE_PIXEL_PER_MS_FP;
        this.setSpeedState(0);
    }

    public void reInit() {
    }

    public void cycle(long deltaMS) {
        if (Hero.isHeroOnVehicale) {
            if (this.speedState == 0) {
                this.timeSinceSpeedChange = System.currentTimeMillis() - this.timeSpeedChange;
                if (this.timeSinceSpeedChange >= 1000L) {
                    this.setSpeedState(1);
                    this.speedFP = this.seqNo % 2 != 0 ? Constants.SPEED_VEHICLE_PIXEL_PER_MS_FP_1 : Constants.SPEED_VEHICLE_PIXEL_PER_MS_FP_2;
                }
            } else if (this.speedState == 1) {
                this.timeSinceSpeedChange = System.currentTimeMillis() - this.timeSpeedChange;
                if (this.timeSinceSpeedChange >= 1000L) {
                    this.setSpeedState(0);
                    this.speedFP = this.seqNo % 2 != 0 ? Constants.SPEED_VEHICLE_PIXEL_PER_MS_FP_2 : Constants.SPEED_VEHICLE_PIXEL_PER_MS_FP_1;
                }
            }
        }
        if (this.nextLinked != null && this.actorX < this.nextLinked.actorX + this.nextLinked.getWidth() + 10) {
            this.setSpeedState(0);
            this.speedFP = Constants.SPEED_VEHICLE_PIXEL_PER_MS_FP_1;
        }
        if (this.prevLinked != null && this.actorX + this.getWidth() + 10 > this.prevLinked.actorX) {
            this.setSpeedState(1);
            this.speedFP = Constants.SPEED_VEHICLE_PIXEL_PER_MS_FP_2;
        }
        this.panPixelsToMoveFP += MathFP.mul(this.speedFP, MathFP.toFP((int)deltaMS));
        int wholePixels = MathFP.toInt(this.panPixelsToMoveFP);
        if (wholePixels > 0) {
            this.setX(this.actorX + wholePixels);
            this.wheelsSprite.cycle(deltaMS);
            this.panPixelsToMoveFP = MathFP.sub(this.panPixelsToMoveFP, MathFP.toFP(wholePixels));
            if (this.actorX > this.world.currentViewX + 220 + this.getWidth()) {
                this.world.vehiclesToBeRemoved = this;
            }
        }
    }

    public void renderer(Graphics g, int offsetX, int offsetY) {
        if (this.actorX - offsetX < -(this.getWidth() + this.imgHeadLight.getWidth() + this.imgLightOnRoad.getWidth())) {
            return;
        }
        if (this.actorX - offsetX > 230) {
            return;
        }
        if (this.world.bgEnvirnmentIndex == 1 || this.world.bgEnvirnmentIndex == 2) {
            g.drawImage(this.imgHeadLight, this.actorX - offsetX + this.headLightX, this.actorY - offsetY + this.headLightY, 0);
            g.drawImage(this.imgLightOnRoad, this.actorX - offsetX + this.headLightX + 25, 162, 0);
        }
        if (this.imgVehicles != null) {
            g.drawImage(this.imgVehicles, this.actorX - offsetX, this.actorY - offsetY, 0);
        } else {
            g.fillRect(this.actorX - offsetX, this.actorY - offsetY, this.width, this.height);
        }
        this.wheelsSprite.draw(g, this.actorX - offsetX + this.tyre1X, this.actorY - offsetY + this.tyre1Y);
        this.wheelsSprite.draw(g, this.actorX - offsetX + this.tyre2X, this.actorY - offsetY + this.tyre2Y);
    }

    public int getSpeedState() {
        return this.speedState;
    }

    public void setSpeedState(int speedState) {
        this.speedState = speedState;
        this.timeSpeedChange = System.currentTimeMillis();
    }

    public void free() {
        switch (this.actorID) {
            case 4: {
                ResManager.releaseImage(ResManager.IMAGE_CAR_1);
                break;
            }
            case 6: {
                ResManager.releaseImage(ResManager.IMAGE_CAR_2);
                break;
            }
            case 3: {
                ResManager.releaseImage(ResManager.IMAGE_SUV);
                break;
            }
            case 5: {
                ResManager.releaseImage(ResManager.IMAGE_BUS_1);
                break;
            }
            case 7: {
                ResManager.releaseImage(ResManager.IMAGE_BUS_2);
                break;
            }
            case 1: {
                ResManager.releaseImage(ResManager.IMAGE_TAXI);
                break;
            }
            case 0: {
                ResManager.releaseImage(ResManager.IMAGE_GAME_AMBULANCE);
                break;
            }
            case 2: {
                ResManager.releaseImage(ResManager.IMAGE_GAME_DOUBLE_DECKER);
            }
        }
        this.imgVehicles = null;
        this.imgWheels = null;
    }

    public void destroy() {
        switch (this.actorID) {
            case 4: {
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                break;
            }
        }
    }

    public int getBonusPoints() {
        return this.bonusPoints;
    }

    public void setBonusPoints(int points) {
        this.bonusPoints = points;
    }

    public void enable() {
    }

    public void disable() {
    }

    public void pause() {
    }

    public void resume() {
    }
}

