/*
 * Decompiled with CFR 0.152.
 */
package com.manthanstudio.tools;

import com.manthanstudio.game.GameCanvas;
import com.manthanstudio.midlet.GameMIDlet;
import com.manthanstudio.resource.ResManager;
import com.nokia.mid.ui.DeviceControl;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class Tools {
    public static final int GRAPHICS_TOP_LEFT = 20;
    private static final Random randomizer = new Random();
    static Image pointerPressImg = ResManager.getImage(ResManager.IMAGE_MENU_TOUCH_IMAGE);

    public static final int getRand(int min, int max) {
        int r = Math.abs(randomizer.nextInt());
        return r % (max - min + 1) + min;
    }

    public static final boolean isIntersectingRect(int ax, int ay, int aw, int ah, int bx, int by, int bw, int bh) {
        return by + bh >= ay && by <= ay + ah && bx + bw >= ax && bx <= ax + aw;
    }

    public static final boolean isRectWithinRect(int ax, int ay, int aw, int ah, int bx, int by, int bw, int bh) {
        return Tools.isPointInRect(bx, by, ax, ay, aw, ah) && Tools.isPointInRect(bx + bw, by, ax, ay, aw, ah) && Tools.isPointInRect(bx, by + bh, ax, ay, aw, ah) && Tools.isPointInRect(bx + bw, by + bh, ax, ay, aw, ah);
    }

    public static final boolean isPointInRect(int px, int py, int x, int y, int w, int h) {
        if (px < x) {
            return false;
        }
        if (px > x + w) {
            return false;
        }
        if (py < y) {
            return false;
        }
        return py <= y + h;
    }

    public static final int[] expandArray(int[] oldArray, int expandBy) {
        int[] newArray = new int[oldArray.length + expandBy];
        System.arraycopy(oldArray, 0, newArray, 0, oldArray.length);
        return newArray;
    }

    public static final Image[][] expandArray(Image[][] oldArray, int expandBy) {
        Image[][] newArray = new Image[oldArray.length + expandBy][];
        System.arraycopy(oldArray, 0, newArray, 0, oldArray.length);
        return newArray;
    }

    public static final Image[] expandArray(Image[] oldArray, int expandBy) {
        Image[] newArray = new Image[oldArray.length + expandBy];
        System.arraycopy(oldArray, 0, newArray, 0, oldArray.length);
        return newArray;
    }

    public static final int[][] expandArray(int[][] oldArray, int expandBy) {
        int[][] newArray = new int[oldArray.length + expandBy][];
        System.arraycopy(oldArray, 0, newArray, 0, oldArray.length);
        return newArray;
    }

    public static void drawTouchImage(Graphics g, int x, int y, int w, int h) {
        w += w % 8 > 0 ? Math.abs(8 - w % 8) : 0;
        g.drawRegion(pointerPressImg, 0, 0, pointerPressImg.getWidth() / 2, pointerPressImg.getHeight(), 0, x, y, 0);
        int i = 0;
        for (i = x + pointerPressImg.getWidth() / 2; i < x + w; i += pointerPressImg.getWidth() / 2) {
            g.drawRegion(pointerPressImg, pointerPressImg.getWidth() / 2, 0, pointerPressImg.getWidth() / 2, pointerPressImg.getHeight(), 0, i, y, 0);
        }
        g.drawRegion(pointerPressImg, 0, 0, pointerPressImg.getWidth() / 2, pointerPressImg.getHeight(), 2, i, y, 0);
    }

    public static void vibrate(int strength, int time) {
        try {
            if (GameCanvas.isVibrate) {
                GameMIDlet.display.vibrate(time);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void OnBackLight() {
        DeviceControl.setLights((int)0, (int)100);
    }

    public static void OffBackLight() {
        DeviceControl.setLights((int)0, (int)1);
    }
}

