/*
 * Decompiled with CFR 0.152.
 */
package com.twistfuture.main;

import buzzcity.java.mobile.BCAdsClientBanner;
import buzzcity.java.mobile.Banner;
import com.twistfuture.main.MainMenu;
import com.twistfuture.main.Setting;
import com.twistfuture.main.TwistCanvas;
import java.io.InputStream;
import java.util.Hashtable;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import vAdEngine.VservInterface;
import vAdEngine.VservManager;

public class TwistMidlet
extends MIDlet
implements VservInterface {
    private TwistCanvas mTwistCanvas;
    private MainMenu mMainMenu;
    private Setting setting;
    private Display display;
    private String VSERV_APP_ID = this.getAppProperty("VSERV_APP_ID");
    private Displayable vservDisplayable;
    public static TwistMidlet mMidlet;
    private BCAdsClientBanner mClientBannerUp;
    private BCAdsClientBanner mClientBannerDown;
    private Banner mBannerUp;
    private Banner mBannerDown;
    public static Image mAdUpImage;
    public static Image mAdDownImage;
    public static Callback mCallBack;
    private int mDrawUpX;
    private int mDrawUpY;
    private int mDrawDX;
    private int mDrawDY;
    private int mUPWidth;
    private int mUPHeight;
    private int mDWidth;
    private int mDHeight;
    public static TwistMidlet mThis;
    private Thread mAdThread;
    private boolean mAdThreadStatus;
    private boolean mUpAdStatus;
    private boolean mDownAdStatus;
    private String BUZZ_CITY_APP_ID = this.getAppProperty("BUZZ_CITY_APP_ID");
    private int mBuzID;

    public void startApp() {
        mMidlet = this;
        Hashtable<String, String> vservConfigTableAd = new Hashtable<String, String>();
        vservConfigTableAd.put("zoneId", this.VSERV_APP_ID);
        vservConfigTableAd.put("showAt", "start");
        new VservManager(this, vservConfigTableAd);
    }

    public void constructorMainApp() {
    }

    public void resumeMainApp() {
        Display.getDisplay((MIDlet)this).setCurrent(this.vservDisplayable);
    }

    public void showMiddleAd(Displayable mAfDisplayable) {
        this.vservDisplayable = mAfDisplayable;
        Hashtable<String, String> vservConfigTableAd = new Hashtable<String, String>();
        vservConfigTableAd.put("zoneId", this.VSERV_APP_ID);
        vservConfigTableAd.put("showAt", "mid");
        new VservManager(this, vservConfigTableAd);
    }

    public void startMainApp() {
        this.registerAd();
        this.mainMenu();
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
    }

    public void exitMidlet() {
        this.destroyApp(true);
        Hashtable<String, String> vservConfigTableAd = new Hashtable<String, String>();
        vservConfigTableAd.put("zoneId", this.VSERV_APP_ID);
        vservConfigTableAd.put("showAt", "end");
        new VservManager(this, vservConfigTableAd);
    }

    public void mainCanvas() {
        if (this.mTwistCanvas == null) {
            this.mTwistCanvas = new TwistCanvas();
        }
        this.getDisplay().setCurrent((Displayable)this.mTwistCanvas);
    }

    public void mainMenu() {
        if (this.mMainMenu == null) {
            this.mMainMenu = new MainMenu();
            this.getDisplay().setCurrent((Displayable)this.mMainMenu);
        } else {
            this.showMiddleAd((Displayable)this.mMainMenu);
        }
    }

    public Display getDisplay() {
        return Display.getDisplay((MIDlet)this);
    }

    public void registerAd() {
        mThis = this;
        try {
            HttpConnection connection = (HttpConnection)Connector.open((String)this.BUZZ_CITY_APP_ID);
            InputStream mInputStream = connection.openInputStream();
            byte[] b = new byte[5];
            mInputStream.read(b);
            this.mBuzID = Integer.parseInt(new String(b).trim());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.mClientBannerUp = new BCAdsClientBanner(this.mBuzID, 4, this);
        this.mClientBannerDown = new BCAdsClientBanner(this.mBuzID, 4, this);
        this.mDrawDY = -4000;
        this.mDrawDX = -4000;
        this.mDrawUpY = -4000;
        this.mDrawUpX = -4000;
    }

    private void startAdThread() {
        this.mAdThread = new Thread(new Runnable(){

            public void run() {
                while (TwistMidlet.this.mAdThreadStatus) {
                    if (TwistMidlet.this.mUpAdStatus && TwistMidlet.this.mClientBannerUp != null) {
                        try {
                            TwistMidlet.this.mBannerUp = TwistMidlet.this.mClientBannerUp.getBanner();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (TwistMidlet.this.mBannerUp != null) {
                            try {
                                mAdUpImage = (Image)TwistMidlet.this.mBannerUp.getItem();
                                mAdUpImage = TwistMidlet.this.scaleImage(mAdUpImage, TwistMidlet.this.mUPWidth, TwistMidlet.this.mUPHeight);
                                mCallBack.callRepaint(TwistMidlet.this.mDrawUpX, TwistMidlet.this.mDrawUpY, TwistMidlet.this.mUPWidth, TwistMidlet.this.mUPHeight);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    if (TwistMidlet.this.mDownAdStatus) {
                        try {
                            TwistMidlet.this.mBannerDown = TwistMidlet.this.mClientBannerDown.getBanner();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (TwistMidlet.this.mBannerDown != null) {
                            try {
                                if (TwistMidlet.this.mBannerDown.getType().equals("image")) {
                                    try {
                                        mAdDownImage = (Image)TwistMidlet.this.mBannerDown.getItem();
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                    mAdDownImage = TwistMidlet.this.scaleImage(mAdDownImage, TwistMidlet.this.mDWidth, TwistMidlet.this.mDHeight);
                                }
                                mCallBack.callRepaint(TwistMidlet.this.mDrawDX, TwistMidlet.this.mDrawDY, TwistMidlet.this.mDWidth, TwistMidlet.this.mDHeight);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                System.out.println("Thread Dead");
            }
        });
        this.mAdThread.start();
    }

    public void unregisterAd() {
        this.mDrawUpY = -2000;
        this.mDrawUpX = -2000;
        this.mDrawDY = -2000;
        this.mDrawDX = -2000;
        this.mAdThreadStatus = false;
        this.mDownAdStatus = false;
        this.mUpAdStatus = false;
        mCallBack = null;
        try {
            this.mAdThread.interrupt();
            System.out.println("mAdthreadis dead =" + this.mAdThread.isAlive());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void paintAd(Graphics g) {
        if (mAdUpImage != null) {
            g.drawImage(mAdUpImage, this.mDrawUpX, this.mDrawUpY, 0);
        }
        if (mAdDownImage != null) {
            g.drawImage(mAdDownImage, this.mDrawDX, this.mDrawDY, 0);
        }
    }

    public void registerForUP(Callback callback) {
        if (!this.mUpAdStatus) {
            this.mUpAdStatus = true;
            mCallBack = callback;
            this.mDrawUpX = 0;
            this.mDrawUpY = 0;
            this.mUPWidth = 240;
            this.mUPHeight = 40;
            this.mAdThreadStatus = true;
            if (this.mAdThread != null) {
                if (!this.mAdThread.isAlive()) {
                    this.startAdThread();
                }
            } else {
                this.startAdThread();
            }
        }
    }

    public void registerForDown(Callback callback) {
        this.mDownAdStatus = true;
        mCallBack = callback;
        this.mDrawDX = 0;
        this.mDWidth = 240;
        this.mDHeight = 40;
        this.mDrawDY = 400 - this.mDHeight;
        this.mAdThreadStatus = true;
        if (this.mAdThread != null) {
            if (!this.mAdThread.isAlive()) {
                this.startAdThread();
            }
        } else {
            this.startAdThread();
        }
    }

    public void registerForUP(int initialX, int initialY, int width, int height, Callback callback) {
        this.mUpAdStatus = true;
        mCallBack = callback;
        this.mDrawUpX = initialX;
        this.mDrawUpY = initialY;
        this.mUPWidth = width;
        this.mUPHeight = height;
        this.mAdThreadStatus = true;
        if (this.mAdThread != null) {
            if (!this.mAdThread.isAlive()) {
                this.startAdThread();
            }
        } else {
            this.startAdThread();
        }
    }

    public void registerForDown(int initialX, int initialY, int width, int height, Callback callback) {
        mCallBack = callback;
        this.mDrawDX = initialX;
        this.mDrawDY = initialY;
        this.mDWidth = width;
        this.mDHeight = height;
        this.mDownAdStatus = true;
        this.mAdThreadStatus = true;
        if (this.mAdThread != null) {
            if (!this.mAdThread.isAlive()) {
                this.startAdThread();
            }
        } else {
            this.startAdThread();
        }
    }

    public void adClicked(int x, int y) {
        if (mAdUpImage != null && x >= this.mDrawUpX && x <= this.mDrawUpX + this.mUPWidth && y >= this.mDrawUpY && y <= this.mDrawUpY + this.mUPHeight) {
            this.adUpClicked();
        }
        if (mAdDownImage != null && x >= this.mDrawDX && x <= this.mDrawDX + this.mDWidth && y >= this.mDrawDY && y <= this.mDrawDY + this.mDHeight) {
            this.adDownClicked();
        }
    }

    public void adUpClicked() {
        this.mClientBannerUp.clickAd();
    }

    public void adDownClicked() {
        this.mClientBannerDown.clickAd();
    }

    public void unregisterUp() {
        this.mDrawUpY = -2000;
        this.mDrawUpX = -2000;
        this.mUpAdStatus = false;
    }

    public void unregisterDown() {
        this.mDrawDY = -2000;
        this.mDrawDX = -2000;
        this.mDownAdStatus = false;
    }

    public Image scaleImage(Image original, int newWidth, int newHeight) {
        int[] rawInput = new int[original.getHeight() * original.getWidth()];
        original.getRGB(rawInput, 0, original.getWidth(), 0, 0, original.getWidth(), original.getHeight());
        int[] rawOutput = new int[newWidth * newHeight];
        int YD = original.getHeight() / newHeight * original.getWidth() - original.getWidth();
        int YR = original.getHeight() % newHeight;
        int XD = original.getWidth() / newWidth;
        int XR = original.getWidth() % newWidth;
        int outOffset = 0;
        int inOffset = 0;
        int YE = 0;
        for (int y = newHeight; y > 0; --y) {
            int XE = 0;
            for (int x = newWidth; x > 0; --x) {
                rawOutput[outOffset++] = rawInput[inOffset];
                inOffset += XD;
                if ((XE += XR) < newWidth) continue;
                XE -= newWidth;
                ++inOffset;
            }
            inOffset += YD;
            if ((YE += YR) < newHeight) continue;
            YE -= newHeight;
            inOffset += original.getWidth();
        }
        return Image.createRGBImage((int[])rawOutput, (int)newWidth, (int)newHeight, (boolean)false);
    }

    public void drawAdUpRect(Graphics g) {
        int color = g.getColor();
        g.setColor(0xFF0000);
        g.drawRect(this.mDrawUpX, this.mDrawUpY, this.mUPWidth + 5, this.mUPHeight + 5);
        g.setColor(color);
    }

    public void drawAdDownRect(Graphics g) {
        int color = g.getColor();
        g.setColor(0xFF0000);
        g.drawRect(this.mDrawDX, this.mDrawDY, this.mDWidth, this.mDHeight);
        g.setColor(color);
    }

    public static interface Callback {
        public void callRepaint(int var1, int var2, int var3, int var4);
    }
}

