/*
 * Decompiled with CFR 0.152.
 */
package com.twistfuture.main;

import com.twistfuture.app.App;
import com.twistfuture.main.NewOrder;
import com.twistfuture.main.Setting;
import com.twistfuture.main.TwistMidlet;
import com.twistfuture.utill.DataStore;
import com.twistfuture.utill.PixelMixingScaler;
import java.util.Vector;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Result {
    private static final Image img_UpperStrip = App.createImage("main/strip.png");
    private static final Image img_Tip = App.createImage("main/sidebar.png");
    private static final Image img_Circle = App.createImage("main/circle.png");
    private static final Image img_Done = App.createImage("main/done.png");
    private static final Image img_OrderFailed = App.createImage("main/failed.png");
    private static final Image img_OrderUp = App.createImage("main/pass.png");
    static boolean isResult;
    private Image recipe;
    private int id;
    private int items;
    private int item_temp;
    private String name;
    static int Total_No_of_Item_Value;
    static float price;
    static int tip;
    static Vector vector;

    public Result(Image recipe, int id, int items, String name) {
        this.recipe = PixelMixingScaler.scaleImage(recipe, 25, 20);
        this.id = id;
        this.items = items;
        this.item_temp = items;
        this.name = name;
        System.out.println("Total " + (Total_No_of_Item_Value += items));
    }

    public static void drawResult(Graphics g) {
        int x = 0;
        g.drawImage(img_UpperStrip, 0, 0, 0);
        g.drawImage(img_Tip, 0, 3, 0);
        g.setFont(App.small);
        g.setColor(0xFFFFFF);
        g.drawString("  $" + price, 0, 6, 0);
        g.drawImage(img_Tip, 0, img_Tip.getHeight() + 4, 0);
        g.drawString("  " + Result.getTip() + "% tip", 0, img_Tip.getHeight() + 6, 0);
        for (int i = 0; i < vector.size(); ++i) {
            Result r = (Result)vector.elementAt(i);
            x = 60 + (r.getWidth() + 5) * i;
            g.drawImage(r.getRecipe(), x, 5, 0);
            g.drawImage(img_Circle, x, r.getHeight() + 5, 0);
            g.setFont(App.small);
            g.setColor(0xFFFFFF);
            if (r.getItems() > 0) {
                g.drawString("" + r.getItems(), x + 10, r.getHeight() + 10, 0);
                continue;
            }
            g.drawImage(img_Done, x + 5, r.getHeight() + 5, 0);
        }
        if (isResult) {
            App.THREAD_STATUS = false;
            int x1 = (240 - img_OrderFailed.getWidth()) / 2;
            int y1 = (400 - img_OrderFailed.getHeight()) / 2;
            if (Total_No_of_Item_Value <= 0) {
                System.out.println("Order Pass");
                g.drawImage(img_OrderUp, 0, 0, 0);
                g.setFont(App.medium);
                g.setColor(255);
                g.drawString("$" + Result.getString(price) + "  " + NewOrder.burger_name, 39, 110, 0);
                g.setFont(App.small);
                for (int i = 0; i < vector.size(); ++i) {
                    Result r = (Result)vector.elementAt(i);
                    float p = App.RECIPE_PRICE[r.getId()] * (float)r.item_temp;
                    int y = 145 + 24 * i;
                    g.drawString("$" + p, 39, y, 0);
                    g.drawString("- " + r.item_temp + " x " + r.getName(), 80, y, 0);
                }
                float tip_percent = price / 100.0f * (float)Result.getTip();
                g.drawString("Tip     $" + Result.getString(tip_percent), 39, 312, 0);
                g.drawString("Total   $" + Result.getString(price + tip_percent), 39, 337, 0);
            } else {
                g.drawImage(img_OrderFailed, x1, y1, 0);
            }
        }
    }

    private static String getString(float value) {
        String s = String.valueOf(value);
        if (s.length() > 5) {
            s = s.substring(0, 4);
        }
        return s;
    }

    public static void pointerPressed(int x, int y) {
        if (!App.THREAD_STATUS) {
            if (Total_No_of_Item_Value <= 0) {
                DataStore.writeData("order", String.valueOf(++NewOrder.mOrderNumber));
            }
            Result.freeElement();
            TwistMidlet.mMidlet.getDisplay().setCurrent((Displayable)new NewOrder());
        }
    }

    public static void freeElement() {
        isResult = false;
        Total_No_of_Item_Value = 0;
        price = 0.0f;
        tip = 0;
        vector.removeAllElements();
    }

    public Image getRecipe() {
        return this.recipe;
    }

    public void setRecipe(Image recipe) {
        this.recipe = recipe;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getItems() {
        return this.items;
    }

    public void setItems(int items) {
        if (items >= 0) {
            System.out.println("tota " + --Total_No_of_Item_Value);
            this.items = items;
            price += App.RECIPE_PRICE[this.id];
            Result.setTip(Result.getTip() + 1);
        }
        if (items < 0) {
            Result.setTip(Result.getTip() - 1);
            if (Setting.isViberation) {
                App.startViberation(50);
            }
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getWidth() {
        return this.recipe.getWidth();
    }

    public int getHeight() {
        return this.recipe.getHeight();
    }

    public static void setTip(int atip) {
        if (atip >= 0) {
            tip = atip;
        }
    }

    public static int getTip() {
        if (tip < 0) {
            tip = 0;
        }
        return tip;
    }

    static {
        Total_No_of_Item_Value = 0;
        price = 0.0f;
        tip = 0;
        vector = new Vector();
    }
}

