/*
 * Decompiled with CFR 0.152.
 */
package com.twistfuture.Game;

import com.twistfuture.app.GeneralFunction;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Totem {
    private static final Image[] TOTEM_IMAGES = new Image[12];
    private static Image LEFT_SMASH_IMAGE;
    private static Image RIGHT_SMASH_IMAGE;
    private Image smashImage;
    private Image imgTotem;
    private int X;
    private int Y;
    private int endX;
    public static boolean onLeftSide;
    private int characterId;
    private int smashX;

    public Totem(int characterId) {
        this.characterId = characterId;
        this.imgTotem = TOTEM_IMAGES[characterId];
        onLeftSide = true;
        this.Y = 303 - this.imgTotem.getHeight() + 30;
    }

    public void paint(Graphics g) {
        g.drawImage(this.imgTotem, this.X, this.Y, 0);
        if (this.smashImage != null) {
            g.drawImage(this.smashImage, this.smashX, this.Y + 30, 0);
        }
    }

    public void setX(int X) {
        this.X = X;
    }

    void update() {
        if (!onLeftSide) {
            this.X = 220 - this.imgTotem.getWidth();
            this.imgTotem = TOTEM_IMAGES[this.characterId + 1];
            this.smashX = 120;
            this.smashImage = RIGHT_SMASH_IMAGE;
        } else {
            this.X = 15;
            this.smashX = 0;
            this.imgTotem = TOTEM_IMAGES[this.characterId + 3];
            this.smashImage = LEFT_SMASH_IMAGE;
        }
    }

    public void reset() {
        if (!onLeftSide) {
            this.imgTotem = TOTEM_IMAGES[this.characterId];
            this.X = 240 - this.imgTotem.getWidth();
        } else {
            this.imgTotem = TOTEM_IMAGES[this.characterId + 2];
        }
        this.smashImage = null;
    }

    public int getX() {
        return this.X;
    }

    public int getEndX() {
        return this.endX;
    }

    public int getY() {
        return this.Y;
    }

    static {
        for (int i = 0; i < TOTEM_IMAGES.length; ++i) {
            Totem.TOTEM_IMAGES[i] = GeneralFunction.createImage("maincanvas/character/" + i + ".png");
        }
        LEFT_SMASH_IMAGE = GeneralFunction.createImage("maincanvas/character/smashleft.png");
        RIGHT_SMASH_IMAGE = GeneralFunction.createImage("maincanvas/character/smashright.png");
    }
}

