/*
 * Decompiled with CFR 0.152.
 */
package in.spicelabs.doodleCopter.screens;

import in.spicelabs.doodleCopter.common.Config;
import in.spicelabs.doodleCopter.common.ScaleImage;
import in.spicelabs.doodleCopter.common.YeloFocus;
import in.spicelabs.doodleCopter.midlet.MainMidlet;
import in.spicelabs.doodleCopter.screens.GameScreen;
import in.spicelabs.doodleCopter.screens.HomeScreen;
import in.spicelabs.doodleCopter.store.RMSData;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameOverScreen
extends Canvas {
    public static final Image WhiteScreenBG = ScaleImage.CreateScaledImage(Config.getFolderImage("copter", "frame_popup.png"), Config.getX(80), Config.getY(70));
    public static YeloFocus focus1 = new YeloFocus(Config.focusButton, Config.unFocusButton, 88, 25, "copter", 35, 18, "New Game", 0xFFFFFF);
    public static final Image blankScreen = ScaleImage.CreateScaledImage(Config.getImage("black_popup.png"), Config.SCREEN_WIDTH, Config.SCREEN_HEIGHT);
    int score;
    int coin;
    boolean isHighScore;
    public static int x = (Config.SCREEN_WIDTH - WhiteScreenBG.getWidth()) / 2;
    public static int y = (Config.SCREEN_HEIGHT - WhiteScreenBG.getHeight()) / 2;
    public boolean isVisible = true;

    public GameOverScreen(int score, int coin, boolean isHighScore) {
        this.setFullScreenMode(true);
        this.score = score;
        this.coin = coin;
        this.isHighScore = isHighScore;
        focus1.setFocusLeft(true);
        focus1.setFocusRight(false);
    }

    protected void paint(Graphics g) {
        if (this.isVisible) {
            g.drawImage(blankScreen, 0, 0, 0);
        }
        this.isVisible = false;
        g.setColor(0);
        focus1.drawBaseImage(g, WhiteScreenBG, x, y);
        int x1 = x + (WhiteScreenBG.getWidth() - g.getFont().stringWidth("Congratulations!!!")) / 2;
        int y1 = y + g.getFont().getHeight() / 2;
        if (this.isHighScore) {
            g.drawString("Congratulations!!!", x1, y1, 0);
        } else {
            g.drawString("You Lose!!!!", x + (WhiteScreenBG.getWidth() - g.getFont().stringWidth("You Lose!!!!")) / 2, y1, 0);
        }
        int x2 = x + (WhiteScreenBG.getWidth() - g.getFont().stringWidth("Score: " + this.score)) / 2;
        int y2 = y1 + g.getFont().getHeight();
        g.drawString("Score: " + this.score, x2, y2, 0);
        int coinx = x + (WhiteScreenBG.getWidth() - g.getFont().stringWidth("Coins: " + this.coin)) / 2;
        int coiny = y2 + g.getFont().getHeight();
        g.drawString("Coins: " + this.coin, coinx, coiny, 0);
        int totalcoinx = x + (WhiteScreenBG.getWidth() - g.getFont().stringWidth("Total: " + RMSData.getClassicGameTotalCoins())) / 2;
        int totalcoiny = coiny + g.getFont().getHeight();
        g.drawString("Total: " + RMSData.getClassicGameTotalCoins(), totalcoinx, totalcoiny, 0);
        focus1.draw(g, "Replay", "Exit", "", 0xFFFFFF, 0);
    }

    protected void pointerPressed(int x, int y) {
        if (x > focus1.getLeftX() && x < focus1.getLeftX() + focus1.getImageWidth() && y > focus1.getY() && y < focus1.getY() + focus1.getImageHeight()) {
            focus1.setFocusLeft(true);
            focus1.setFocusRight(false);
        } else if (x > focus1.getRightX() && x < focus1.getRightX() + focus1.getImageWidth() && y > focus1.getY() && y < focus1.getY() + focus1.getImageHeight()) {
            focus1.setFocusLeft(false);
            focus1.setFocusRight(true);
        }
        this.repaint();
    }

    protected void pointerReleased(int x, int y) {
        if (x > focus1.getLeftX() && x < focus1.getLeftX() + focus1.getImageWidth() && y > focus1.getY() && y < focus1.getY() + focus1.getImageHeight()) {
            MainMidlet.display.setCurrent((Displayable)GameScreen.getinstance());
        } else if (x > focus1.getRightX() && x < focus1.getRightX() + focus1.getImageWidth() && y > focus1.getY() && y < focus1.getY() + focus1.getImageHeight()) {
            MainMidlet.display.setCurrent((Displayable)new HomeScreen());
        }
    }

    protected void keyPressed(int keyCode) {
        int key;
        String key1 = this.getKeyName(keyCode);
        if (key1.equals("g")) {
            if (GameOverScreen.focus1.IsFocusLeft) {
                GameScreen.screen = null;
                MainMidlet.display.setCurrent((Displayable)GameScreen.getinstance());
            } else {
                MainMidlet.display.setCurrent((Displayable)new HomeScreen());
                GameScreen.screen = null;
            }
        }
        if ((key = this.getGameAction(keyCode)) == 5) {
            if (GameOverScreen.focus1.IsFocusLeft) {
                focus1.setFocusRight(true);
                focus1.setFocusLeft(false);
            }
        } else if (key == 2) {
            if (GameOverScreen.focus1.IsFocusRight) {
                focus1.setFocusLeft(true);
                focus1.setFocusRight(false);
            }
        } else if (key == 8) {
            if (GameOverScreen.focus1.IsFocusLeft) {
                MainMidlet.display.setCurrent((Displayable)GameScreen.getinstance());
            } else {
                MainMidlet.display.setCurrent((Displayable)new HomeScreen());
            }
        }
        this.repaint();
    }

    protected void showNotify() {
        this.isVisible = true;
    }
}

