/*
 * Decompiled with CFR 0.152.
 */
package in.spicelabs.game.objects;

import in.spicelabs.game.objects.Controller;
import in.spicelabs.game.objects.LevelGeneratorListener;
import java.util.Random;

public class LevelGenerator {
    private static final int MIN_PERIOD = 200;
    public static final int INIT_FLY_AREA = (int)(0.8 * (double)Controller.DIS_H);
    public static final int MIN_TILE_H = (int)(0.05 * (double)(Controller.DIS_H - INIT_FLY_AREA));
    public static final int MAX_TILE_H = (int)(0.5 * (double)(Controller.DIS_H - INIT_FLY_AREA));
    private static final int MIN_FLY_AREA = 5 * (INIT_FLY_AREA >> 3);
    private static final int MIN_GAP = Controller.DIS_W >> 1;
    private static final int MAX_GAP = 3 * (Controller.DIS_W >> 2);
    private static final int MIN_REAPPEAR_COUNT = 200;
    private static final int MAX_REAPPEAR_COUNT = 400;
    private static Random random = new Random();
    private static LevelGenerator gen;
    private static int updatePeriod;
    private int level;
    private int ticksCount;
    private int shieldCounter;
    private int rocketCounter;
    private int flyArea = INIT_FLY_AREA;
    private int gap = MAX_GAP;
    private LevelGeneratorListener listener;

    static {
        updatePeriod = 300;
    }

    private LevelGenerator() {
    }

    public static LevelGenerator getInstance() {
        if (gen == null) {
            gen = new LevelGenerator();
        }
        return gen;
    }

    public void setListener(LevelGeneratorListener listener) {
        this.listener = listener;
    }

    public void tick() {
        ++this.ticksCount;
        if (this.ticksCount % updatePeriod == 0) {
            this.ticksCount = 0;
            ++this.level;
            this.updateFactors();
            this.notifyListener();
            updatePeriod = 200 + random.nextInt(200);
        }
        if (this.shieldCounter > 0) {
            --this.shieldCounter;
        }
        if (this.rocketCounter > 0) {
            --this.rocketCounter;
        }
    }

    public static boolean canAddPower(int type) {
        switch (type) {
            case 2: {
                return LevelGenerator.gen.rocketCounter == 0;
            }
        }
        return LevelGenerator.gen.shieldCounter == 0;
    }

    public static void resetCounter(int type) {
        switch (type) {
            case 2: {
                LevelGenerator.gen.rocketCounter = 200 + random.nextInt(200);
                break;
            }
            default: {
                LevelGenerator.gen.shieldCounter = 200 + random.nextInt(200);
            }
        }
    }

    public static void stopCounter(int type) {
        switch (type) {
            case 2: {
                LevelGenerator.gen.rocketCounter = -1;
                break;
            }
            default: {
                LevelGenerator.gen.shieldCounter = -1;
            }
        }
    }

    public void reset() {
        this.level = 1;
        this.flyArea = INIT_FLY_AREA;
        this.shieldCounter = 200 + random.nextInt(200);
        this.rocketCounter = 200 + random.nextInt(200);
    }

    private void updateFactors() {
        this.flyArea = this.flyArea <= MIN_FLY_AREA ? (this.flyArea += random.nextInt(INIT_FLY_AREA - MIN_FLY_AREA)) : (this.flyArea >= INIT_FLY_AREA ? (this.flyArea -= random.nextInt(INIT_FLY_AREA - MIN_FLY_AREA)) : (random.nextInt(2) == 0 ? (this.flyArea -= random.nextInt(this.flyArea - MIN_FLY_AREA)) : (this.flyArea += random.nextInt(INIT_FLY_AREA - this.flyArea))));
    }

    private void notifyListener() {
        if (this.listener != null) {
            this.listener.onLevelUp();
        }
    }

    public static int getFlyArea() {
        return LevelGenerator.gen.flyArea;
    }

    public static int getAndUpdateGap() {
        int tmp = LevelGenerator.gen.gap;
        LevelGenerator.gen.gap = MIN_GAP + random.nextInt(MAX_GAP - MIN_GAP);
        return tmp;
    }

    public static int getGap() {
        return LevelGenerator.gen.gap;
    }
}

