/*
 * Decompiled with CFR 0.152.
 */
package in.spicelabs.game.objects;

import in.spicelabs.game.objects.AnimationCompleteListener;
import in.spicelabs.game.objects.AnimationSprite;
import in.spicelabs.game.objects.Sprite;
import in.spicelabs.game.objects.World;
import in.spicelabs.game.objects.XYRect;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public abstract class AnimatableSprite
extends Sprite
implements AnimationCompleteListener {
    private Vector animations = new Vector(10);

    public AnimatableSprite(XYRect rect, World world) {
        super(rect, world);
    }

    public void addAnimation(AnimationSprite anim) {
        if (anim == null) {
            return;
        }
        anim.setAnimationListener(this);
        this.animations.addElement(anim);
    }

    protected void draw(Graphics g) {
        if (this.animations.isEmpty()) {
            return;
        }
        Enumeration en = this.animations.elements();
        while (en.hasMoreElements()) {
            AnimationSprite element = (AnimationSprite)en.nextElement();
            element.draw(g);
            element.tick();
        }
    }

    public void moveAnimation(int speed) {
        Enumeration en = this.animations.elements();
        while (en.hasMoreElements()) {
            AnimationSprite element = (AnimationSprite)en.nextElement();
            element.rect.x -= speed;
        }
    }

    public void onAnimationComplete(AnimationSprite sprite) {
        if (this.animations.contains(sprite)) {
            this.animations.removeElement(sprite);
        }
    }
}

