/*
 * Decompiled with CFR 0.152.
 */
package in.spice.flappybird2048.screen;

import com.emobtech.googleanalyticsme.Event;
import com.emobtech.googleanalyticsme.Tracker;
import in.spice.flappybird2048.animationlistener.CollisionAndScoreListener;
import in.spice.flappybird2048.common.Config;
import in.spice.flappybird2048.midlet.MainMidlet;
import in.spice.flappybird2048.objects.BirdObject;
import in.spice.flappybird2048.objects.FlapBird;
import in.spice.flappybird2048.objects.LapCompletionObject;
import in.spice.flappybird2048.objects.ObstructionBoxes;
import in.spice.flappybird2048.screen.GameOverScreen;
import in.spice.flappybird2048.screen.HomeScreen;
import in.spice.flappybird2048.store.RMSData;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;

public class GameScreen
extends GameCanvas
implements CollisionAndScoreListener,
Runnable,
CommandListener {
    private FlapBird bird;
    Alert alert;
    private static final int refreshInterval = 40;
    private boolean isScheduled = true;
    private ObstructionBoxes[] arr = new ObstructionBoxes[]{new ObstructionBoxes(this, 2), new ObstructionBoxes(this, 2), new ObstructionBoxes(this, 2), new ObstructionBoxes(this, 2), new ObstructionBoxes(this, 2)};
    private int currentIndex;
    private Vector vec = new Vector(2);
    private int score = 0;
    private int durationToAddObstruction = GameScreen.getDuration() * 3;
    private int currentfirstLayer = 0;
    private int currentsecondLayer = 0;
    private int currentthirdLayer = 0;
    private int currentfourthLayer = 0;
    private int currentfifthLayer = 0;
    private int currentsixthLayer = 0;
    int correctNumberYPos = 0;
    private int firstLayer = 1;
    private int secondLayer = 2;
    private int thirdLayer = 3;
    private int fourthLayer = 4;
    private int fifthLayer = 5;
    private int sixthLayer = 6;
    int LapComplette_YPos;
    private boolean isGameOver;
    private boolean isGameStart;
    private Image bgLayer7;
    boolean isFirstGame;
    private int firstLayerHeight = Config.bgLayer1.getHeight();
    private int secondLayerHeight = Config.bgLayer2.getHeight();
    private int thirdLayerHeight = Config.bgLayer3.getHeight();
    private int fourthLayerHeight = Config.bgLayer4.getHeight();
    private int fifthLayerHeight = Config.bgLayer5.getHeight();
    private int sixthLayerHeight = Config.bgLayer6.getHeight();
    LapCompletionObject lapComplete;
    private int firstLayerWidth = Config.bgLayer1.getWidth() / 2;
    private String scoreString = "0";
    private long currentNumber;
    boolean isCollideToCorrectNumber;
    boolean isLapStarted;
    int lapNo;
    public static GameScreen screen;
    private int currentDurationCount;
    private boolean toRemoveObStruction;
    boolean isObstructionAdded;
    boolean isStart = true;
    private Command backCommand;
    Timer gameLapTimer;
    Thread runner;
    public boolean isAnimationStart;
    public int count = 0;
    Font font1 = Font.getFont((int)0, (int)1, (int)0);
    StringBuffer buffer = new StringBuffer();

    public GameScreen() {
        super(false);
        this.setFullScreenMode(true);
        this.isCollideToCorrectNumber = false;
        ++Config.gameCount;
        this.lapNo = 0;
        this.bird = new FlapBird();
        Config.reInitializeBird();
        this.isObstructionAdded = false;
        this.currentNumber = 0L;
        this.isFirstGame = true;
        this.start();
        this.backCommand = new Command("Back", 2, 1);
        this.addCommand(this.backCommand);
        this.setCommandListener(this);
        Tracker tracker = Tracker.getInstance(Config.midlet, "UA-48934997-17");
        tracker.addToQueue(new Event("Game_Play", "Play_Started", "Game_Play", null));
    }

    public static GameScreen getinstance() {
        if (screen == null) {
            screen = new GameScreen();
        }
        return screen;
    }

    public long getPowerof(int number) {
        long numb = 1L;
        int i = 0;
        while (i < number) {
            numb *= 2L;
            ++i;
        }
        return numb;
    }

    private void addObstructionObj() {
        long number;
        if ((number = this.getPowerof(++Config._obstructionCount)) < (long)Config.GAME_COMPLETION_SCORE) {
            this.arr[this.currentIndex].setParams(number);
            if (Config._obstructionCount >= this.getMovingObstruction()) {
                this.arr[this.currentIndex].setMoving(true);
            }
            this.vec.addElement(this.arr[this.currentIndex]);
            ++this.currentIndex;
            if (this.currentIndex >= this.arr.length) {
                this.currentIndex = 0;
            }
        }
    }

    public int getMovingObstruction() {
        int obstructionNo = 7;
        obstructionNo = this.score == 0 ? 7 : (this.score == 1 ? 6 : (this.score == 2 ? 5 : (this.score == 3 ? 4 : (this.score == 4 ? 3 : 1))));
        return obstructionNo;
    }

    public void start() {
        this.runner = new Thread(this);
        this.runner.start();
    }

    public void run() {
        while (this.isStart) {
            this.repaint();
            if (this.bird.isGameOver()) {
                this.isGameOver = true;
            }
            if (this.isFirstGame) {
                this.durationToAddObstruction = GameScreen.getDuration() / 8;
                this.isFirstGame = false;
            } else {
                this.durationToAddObstruction = GameScreen.getDuration() * 3 + GameScreen.getDuration() / 2;
            }
            if (this.isScheduled && !this.bird.isGameOver()) {
                if (this.isGameStart) {
                    ++this.currentDurationCount;
                    if (this.currentDurationCount >= this.durationToAddObstruction) {
                        this.currentDurationCount = 0;
                        new Timer().schedule(new TimerTask(){

                            public void run() {
                                GameScreen.this.addObstructionObj();
                            }
                        }, 0L);
                    }
                }
            } else if (this.isGameOver) {
                Tracker tracker = Tracker.getInstance(Config.midlet, "UA-48934997-17");
                tracker.addToQueue(new Event("Game_Play", "Play_End", "Game_Play", new Integer(this.score)));
                MainMidlet.display.setCurrent((Displayable)new HomeScreen());
                if ((long)this.score > RMSData.getScore()) {
                    RMSData.setScore(this.score);
                    MainMidlet.display.setCurrent((Displayable)new GameOverScreen(this.score, true, this.lapNo));
                } else {
                    MainMidlet.display.setCurrent((Displayable)new GameOverScreen(this.score, false, this.lapNo));
                }
                this.isStart = false;
                this.runner = null;
                screen = null;
            }
            try {
                Thread.sleep(40L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private Vector wrap(String text, int width) {
        Vector<String> result = new Vector<String>();
        if (text == null) {
            return result;
        }
        boolean hasMore = true;
        int current = 0;
        int lineBreak = -1;
        int nextSpace = -1;
        while (hasMore) {
            int linewidth;
            do {
                if ((lineBreak = nextSpace) == text.length() - 1) {
                    hasMore = false;
                    break;
                }
                nextSpace = text.indexOf(32, lineBreak + 1);
                if (nextSpace != -1) continue;
                nextSpace = text.length() - 1;
            } while ((linewidth = Font.getDefaultFont().substringWidth(text, current, nextSpace - current)) <= width);
            String line = text.substring(current, lineBreak + 1);
            result.addElement(line);
            current = lineBreak + 1;
        }
        return result;
    }

    public void startNextLap() {
        this.isGameStart = true;
        Config.reInitializeBird();
        this.bird.setCurrentNumber(2L);
        Image[][] frames = (Image[][])Config._birdTable.get(new Integer(1));
        BirdObject birdObj = this.bird.getBirdObject();
        birdObj.setBirdFrames(frames);
        this.bird.setBirdObject(birdObj);
        this.bird.setAnimationFlag(false);
        this.isAnimationStart = false;
        if (this.gameLapTimer != null) {
            this.gameLapTimer.cancel();
        }
        this.repaint();
        this.count = 0;
    }

    public void paint(Graphics g) {
        ++Config.layer_frequency;
        if (!this.isGameOver) {
            this.incrementLayerPos();
            Config.layer_frequency = 0;
        }
        g.drawImage(Config.gameScreenBG, 0, 0, 0);
        g.drawImage(Config.bgLayer1, -this.currentfirstLayer, Config.SCREEN_HEIGHT - this.firstLayerHeight, 0);
        g.drawImage(Config.bgLayer2, -this.currentsecondLayer, Config.SCREEN_HEIGHT - this.secondLayerHeight, 0);
        g.drawImage(Config.bgLayer3, -this.currentthirdLayer, Config.SCREEN_HEIGHT - this.thirdLayerHeight, 0);
        g.drawImage(Config.bgLayer4, -this.currentfourthLayer, Config.SCREEN_HEIGHT - this.fourthLayerHeight, 0);
        g.drawImage(Config.bgLayer5, -this.currentfifthLayer, Config.SCREEN_HEIGHT - this.fifthLayerHeight, 0);
        g.drawImage(Config.bgLayer6, -this.currentsixthLayer, Config.SCREEN_HEIGHT - this.sixthLayerHeight, 0);
        if (this.bgLayer7 != null) {
            g.drawImage(this.bgLayer7, 0, 0, 0);
        }
        if (this.isGameStart) {
            ObstructionBoxes obj;
            int i;
            if (this.toRemoveObStruction) {
                i = this.vec.size() - 1;
                while (i >= 0) {
                    obj = (ObstructionBoxes)this.vec.elementAt(i);
                    if (obj.isOutOfScreen()) {
                        this.vec.removeElementAt(i);
                    }
                    --i;
                }
                this.toRemoveObStruction = false;
            }
            i = 0;
            while (i < this.vec.size()) {
                obj = (ObstructionBoxes)this.vec.elementAt(i);
                obj.drawObstruction(g, this.bird.getXYRect(), this.isGameOver);
                ++i;
            }
        } else if (this.isAnimationStart) {
            g.setFont(this.font1);
            g.setColor(0xFFFF00);
            int fontht = g.getFont().getHeight();
            this.LapComplette_YPos = Config.SCREEN_HEIGHT / 2 - 2 * fontht;
            if (this.LapComplette_YPos > Config.SCREEN_HEIGHT - (this.bird.getXYRect().height + this.bird.getXYRect().height / 2)) {
                this.LapComplette_YPos -= 3 * fontht;
            }
            if (this.LapComplette_YPos < this.bird.getXYRect().height) {
                this.LapComplette_YPos += this.bird.getXYRect().height;
            }
            g.drawString("Great!!", this.bird.getXPos() + this.bird.getXYRect().width, this.LapComplette_YPos, 0);
            g.setColor(0xF5F5F5);
            g.drawString("Score is: " + this.score, this.bird.getXPos() + this.bird.getXYRect().width, this.LapComplette_YPos + fontht, 0);
            g.setColor(0);
            Vector instructionVec = this.wrap("Get ready for the next lap!!", Config.SCREEN_WIDTH - (this.bird.getXPos() + this.bird.getXYRect().width));
            int instructionY = this.LapComplette_YPos + 2 * fontht;
            int i = 0;
            while (i < instructionVec.size()) {
                String str = (String)instructionVec.elementAt(i);
                g.drawString(str, this.bird.getXPos() + this.bird.getXYRect().width, instructionY, 0);
                instructionY += fontht;
                ++i;
            }
        }
        ++Config.frequency;
        this.bird.drawBird(g, this.isGameStart, this.isGameOver);
        g.setColor(0);
        g.setFont(this.font1);
        g.drawString(String.valueOf(this.score), (Config.SCREEN_WIDTH - g.getFont().stringWidth(String.valueOf(this.score))) / 2, 0, 0);
    }

    private void incrementLayerPos() {
        this.currentfirstLayer += this.firstLayer;
        this.currentsecondLayer += this.secondLayer;
        this.currentthirdLayer += this.thirdLayer;
        this.currentfourthLayer += this.fourthLayer;
        this.currentfifthLayer += this.fifthLayer;
        this.currentsixthLayer += this.sixthLayer;
        if (this.currentfirstLayer >= this.firstLayerWidth) {
            this.currentfirstLayer = 0;
        }
        if (this.currentsecondLayer >= this.firstLayerWidth) {
            this.currentsecondLayer = 0;
        }
        if (this.currentthirdLayer >= this.firstLayerWidth) {
            this.currentthirdLayer = 0;
        }
        if (this.currentfourthLayer >= this.firstLayerWidth) {
            this.currentfourthLayer = 0;
        }
        if (this.currentfifthLayer >= this.firstLayerWidth) {
            this.currentfifthLayer = 0;
        }
        if (this.currentsixthLayer >= this.firstLayerWidth) {
            this.currentsixthLayer = 0;
        }
    }

    public void updateScore() {
        ++this.score;
        this.buffer.setLength(0);
        this.buffer.append(this.score);
        this.scoreString = this.buffer.toString();
        int ticks = this.score % 80;
        if (ticks < 20) {
            return;
        }
        if (ticks == 20) {
            this.bgLayer7 = null;
        } else if (ticks == 40) {
            this.bgLayer7 = Config.evening;
        } else if (ticks == 60) {
            this.bgLayer7 = Config.night;
        } else if (ticks == 0 && this.score != 0) {
            this.bgLayer7 = Config.morning;
        }
    }

    public void oneLapComplete() {
        this.vec.removeAllElements();
        this.LapComplette_YPos = Config.SCREEN_HEIGHT / 2;
        this.isGameStart = false;
        this.isAnimationStart = true;
        this.bird.setAnimationFlag(true);
        ++this.lapNo;
        this.count = 0;
        if (this.gameLapTimer != null) {
            this.gameLapTimer.cancel();
        }
        this.gameLapTimer = new Timer();
        this.gameLapTimer.schedule((TimerTask)new GameLapTimerTask(), 10L, 500L);
    }

    public static final int getDuration() {
        int finalVelocity = 0;
        int count = 0;
        int initial = -FlapBird.MAX_UP_DISTANCE;
        while (initial < Config.SCREEN_HEIGHT) {
            ++count;
            initial += (finalVelocity += FlapBird.mass * FlapBird.gravity);
        }
        return count;
    }

    public void iscollideToCorrectNumber(int correctNumberYPos, long number) {
        this.isCollideToCorrectNumber = true;
        this.correctNumberYPos = correctNumberYPos;
        this.bird.setContantSpeed(correctNumberYPos, true);
    }

    public void isObstructionCrossed(ObstructionBoxes obj) {
        this.isCollideToCorrectNumber = false;
        long _next_number = obj.getNumberToCollide() * 2L;
        this.bird.setCurrentNumber(_next_number);
        if (_next_number == (long)Config.GAME_COMPLETION_SCORE) {
            this.oneLapComplete();
        }
        int powNumber = Config.log2((int)_next_number);
        Image[][] frames = (Image[][])Config._birdTable.get(new Integer(powNumber % 6));
        BirdObject birdObj = this.bird.getBirdObject();
        birdObj.setBirdFrames(frames);
        this.bird.setBirdObject(birdObj);
        this.currentNumber = this.bird.getCuurentNumber();
        this.bird.resetInitialVelocity();
        this.updateScore();
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.backCommand) {
            this.showConfirmationYesOrNo(" ", Config.EXIT_MSG);
            this.isStart = false;
        }
    }

    public void isGameOver() {
        this.isGameOver = true;
    }

    public void isOutOfScreen(ObstructionBoxes obj) {
        this.toRemoveObStruction = true;
    }

    public void animationComplete() {
    }

    private void flyBird() {
        if (!this.isAnimationStart) {
            this.isGameStart = true;
        }
        if (!this.isGameOver) {
            this.bird.flyBird();
        }
    }

    protected void pointerPressed(int x, int y) {
        this.flyBird();
    }

    protected void keyPressed(int keyCode) {
        this.flyBird();
    }

    protected void showNotify() {
        if (!this.isScheduled && !this.isGameOver) {
            this.isScheduled = true;
            this.isStart = true;
            this.start();
        }
    }

    protected void hideNotify() {
        if (this.gameLapTimer != null) {
            this.gameLapTimer.cancel();
        }
        this.isScheduled = false;
        this.isStart = false;
    }

    protected void showConfirmationYesOrNo(String title, String text) {
        this.alert = new Alert(title, text, null, AlertType.CONFIRMATION);
        this.alert.addCommand(new Command("Yes", 4, 1));
        this.alert.addCommand(new Command("No", 3, 1));
        this.alert.setCommandListener(new CommandListener(){

            public void commandAction(Command c, Displayable d) {
                if (c.getLabel().equals("Yes")) {
                    GameScreen.this.isGameOver = true;
                    Tracker tracker = Tracker.getInstance(Config.midlet, "UA-48934997-17");
                    tracker.addToQueue(new Event("Game_Play", "Play_End", "Game_Play", new Integer(GameScreen.this.score)));
                    MainMidlet.display.setCurrent((Displayable)new HomeScreen());
                    GameScreen.this.isStart = false;
                    GameScreen.this.runner = null;
                    screen = null;
                    GameScreen.this.alert = null;
                }
                if (c.getLabel().equals("No")) {
                    MainMidlet.display.setCurrent((Displayable)GameScreen.getinstance());
                    GameScreen.this.isGameOver = false;
                    GameScreen.this.alert = null;
                }
            }
        });
        MainMidlet.display.setCurrent((Displayable)this.alert);
    }

    public class GameLapTimerTask
    extends TimerTask {
        public void run() {
            GameScreen.this.repaint();
            ++GameScreen.this.count;
            if (GameScreen.this.count == 6) {
                GameScreen.this.isGameStart = true;
                Config.reInitializeBird();
                GameScreen.this.bird.setCurrentNumber(2L);
                Image[][] frames = (Image[][])Config._birdTable.get(new Integer(1));
                BirdObject birdObj = GameScreen.this.bird.getBirdObject();
                birdObj.setBirdFrames(frames);
                GameScreen.this.bird.setBirdObject(birdObj);
                GameScreen.this.bird.setAnimationFlag(false);
                GameScreen.this.isAnimationStart = false;
                this.cancel();
                GameScreen.this.gameLapTimer.cancel();
                GameScreen.this.repaint();
                GameScreen.this.count = 0;
            }
        }
    }
}

