/*
 * Decompiled with CFR 0.152.
 */
package in.spice.flappybird2048.common;

import in.spice.flappybird2048.common.ScaleImage;
import in.spice.flappybird2048.midlet.MainMidlet;
import in.spice.flappybird2048.objects.BirdObject;
import in.spice.flappybird2048.objects.ObstructionBoxes;
import in.spice.flappybird2048.utils.ImageCache;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Config {
    public static final int BLACK = 0;
    public static int GAME_COMPLETION_SCORE = 2048;
    public static final int WHITE = 0xFFFFFF;
    public static final int YELLOW = 0xFFFF00;
    public static final int WHITESMOKE = 0xF5F5F5;
    public static final String BillBoardID = "7e26ac6f";
    public static final String BannerID = "09219cf9";
    public static final String GA_ID = "UA-48934997-17";
    public static int SCREEN_WIDTH = 0;
    public static int SCREEN_HEIGHT = 0;
    public static MainMidlet midlet;
    public static int layer_frequency;
    public static final String appName = "Flappy2048";
    public static final int TYPE_CHALLENGE = 1;
    public static final int TYPE_TIMERMODE = 2;
    public static final int TYPE_CLASSIC = 3;
    public static final String INDONESIAN = "/jewel_indonesian.txt";
    public static final String ENGLISH = "/JewelWorldStrings.txt";
    public static final String SPANISH = "/jewel_spanish.txt";
    public static final String SESSION_ID;
    public static int SPLASH_SCREEN_TIME;
    public static final String playbg = "game_bg.jpg";
    public static String play_bg;
    public static String splash;
    public static String serverUrl;
    public static String appWorldID;
    public static final String appworldUrl;
    public static String splash_screen_bitmap;
    public static Random random;
    public static String home_bg;
    public static String focusButton;
    public static String unFocusButton;
    public static String popup;
    public static String popupButtonFocus;
    public static String popupButtonNormal;
    public static String tabButton;
    public static String bubbleSelector;
    public static final String MORE_APPS_URL = "http://appworld.blackberry.com/webstore/vendor/2004/?lang=en";
    public static int gameCount;
    public static final String popupunFocusButton = "btn.png";
    public static final String review_popup_unFocus_button = "review-btn.png";
    public static final String review_popup_focus_button = "review-btn_focus.png";
    public static final int AD_MANAGER_HEIGHT = 55;
    public static final String game_name_height = "pixel_height.png";
    public static final String POPUP_BG = "popup1.png";
    public static final String SOUND_DISABLE = "sound_off.png";
    public static final String SOUND_ENABLE = "sound_on.png";
    public static final String SOUND_FOCUS_DISABLE = "sound_off_focus.png";
    public static final String SOUND_FOCUS_ENABLE = "sound_on_focus.png";
    public static final String GAME_BG = "game_bg2.jpg";
    public static final String popup_focusButton = "btn_focus.png";
    public static final int FOCUS_COLOR = 23448;
    public static final int NONFOCUS_COLOR = 0xFFFF00;
    public static final String PLAY_TEXT = "Play";
    public static final String ENABLE_NOTIF_TEXT = "Enable Notification";
    public static final String DISABLE_NOTIF_TEXT = "Disable Notification";
    public static final String REPLAY_TEXT = "Replay";
    public static final String PREVIOUS_HIGH_SCORE = "High Score: ";
    public static final String INSTRUCTION_TEXT_1 = "Tap or Press any key to";
    public static final String INSTRUCTION_TEXT_2 = "Release to ";
    public static final String NEXT_LAP_TEXT = "Get ready for the next lap!!";
    public static final String lapCompleteMsg = "You have completed";
    public static final String OBSTRUCTED_SOUND = "gameOver.mp3";
    public static final String GAME_WIN = "Win_Sound.mp3";
    public static final String GAME_LOOSE = "Laugh.mp3";
    public static final String[][] WIN_FRAME;
    public static final String[][] LOOSE_FRAME;
    public static final String SCORE_UP_MP3 = "scoreUp.mp3";
    public static final String FLY_MP3 = "fly.mp3";
    public static String YOUR_SCORE;
    public static String FEEDBACK;
    public static String PLEASE_LEAVE;
    public static String FIVE_STAR_REVIEW;
    public static String NEXT_LEVEL;
    public static String NOTIFICATION_TIME_TEXT;
    public static String ENABLE_NOTIFICATION_TEXT;
    public static String DISABLE_NOTIFICATION_TEXT;
    public static String LIKE_IT_LEAVE_REVIEW;
    public static String OK_TEXT;
    public static String LIKED_IT_TEXT;
    public static String LEAVE_5STAR_REVIEW_TEXT;
    public static String LEAVE_REVIEW_TEXT;
    public static String LATER_TEXT;
    public static String DISABLE_SOUND_TEXT;
    public static String ENABLE_SOUND_TEXT;
    public static String EXIT_MSG;
    public static String NO_TEXT;
    public static String YES_TEXT;
    public static String EXIT_TEXT;
    public static String NEW_GAME_TEXT;
    public static String GAME_OVER_TEXT;
    public static String BEST_TILE;
    public static String TILE;
    public static String CONGRATS_TEXT;
    public static String HIGH_SCORE_TEXT;
    public static int POP_UP_TEXT_COLOR;
    public static String MORE_APPS;
    public static String RESUME;
    public static String SCORE;
    public static String[] reviewMessage;
    public static String reviewLaterMessage;
    public static BirdObject birds;
    public static int FREQUENCY;
    public static final String chooserFocusBird1 = "btn_yellowbird_focus.png";
    public static final String chooserUnFocusBird1 = "btn_yellowbird.png";
    public static final String chooserFocusBird2 = "btn_redbird_focus.png";
    public static final String chooserUnFocusBird2 = "btn_redbird.png";
    public static final String GAMESCREEN = "gameScreen";
    public static Image HELP_1;
    public static Image HELP_2;
    private static Image[][] firstBird;
    private static Image[][] numberBird_0;
    private static Image[][] numberBird_1;
    private static Image[][] numberBird_2;
    private static Image[][] numberBird_3;
    private static Image[][] numberBird_4;
    private static Image[][] numberBird_5;
    private static Image[][] secondBird;
    public static final String blacktransparent = "trans_frame.png";
    public static int _obstructionCount;
    public static int frequency;
    public static Image obstructionBox;
    public static Image straightBird;
    public static Image pipe_up;
    public static Image pipe_down;
    public static Image bgLayer1;
    public static Image bgLayer2;
    public static Image bgLayer3;
    public static Image bgLayer4;
    public static Image bgLayer5;
    public static Image bgLayer6;
    public static Image night;
    public static Image morning;
    public static Image evening;
    public static Image gameScreenBG;
    public static final String CHOOOSE_BIRD = "Choose your bird";
    public static final int MAX_COINS_TO_EARN_IN_DAY = 35;
    public static int[] _2048Arr;
    public static Hashtable _birdTable;
    static float ratio;

    static {
        layer_frequency = 0;
        SESSION_ID = "" + System.currentTimeMillis();
        SPLASH_SCREEN_TIME = 2000;
        play_bg = "home1_bg.jpg";
        splash = "splash.jpg";
        serverUrl = "http://funnycutouts.spicelabs.in:8080//CommonService/log";
        appWorldID = "59933748";
        appworldUrl = "http://appworld.blackberry.com/webstore/content/reviews/" + appWorldID;
        splash_screen_bitmap = "splash.jpg";
        random = new Random();
        home_bg = "bg_home.jpg";
        focusButton = popup_focusButton;
        unFocusButton = popupunFocusButton;
        popup = "popup.png";
        popupButtonFocus = popup_focusButton;
        popupButtonNormal = popupunFocusButton;
        tabButton = "button1.png";
        bubbleSelector = "frame_focus.png";
        WIN_FRAME = new String[][]{{"win_1.png", "win_2.png"}, {"red_win_1.png", "red_win_2.png"}};
        LOOSE_FRAME = new String[][]{{"lose_1.png", "lose_2.png"}, {"red_lose_1.png", "red_lose_2.png"}};
        YOUR_SCORE = "Your Score: ";
        FEEDBACK = "Feedback";
        PLEASE_LEAVE = "Please leave ";
        FIVE_STAR_REVIEW = "5 star review.";
        NEXT_LEVEL = "Next Level";
        NOTIFICATION_TIME_TEXT = "Notification Time";
        ENABLE_NOTIFICATION_TEXT = ENABLE_NOTIF_TEXT;
        DISABLE_NOTIFICATION_TEXT = DISABLE_NOTIF_TEXT;
        LIKE_IT_LEAVE_REVIEW = "Liked It?\nPlease leave a 5 star review.";
        OK_TEXT = "Ok";
        LIKED_IT_TEXT = "Liked It!!!";
        LEAVE_5STAR_REVIEW_TEXT = "Please leave a 5 star review.";
        LEAVE_REVIEW_TEXT = "Leave Review";
        LATER_TEXT = "Later";
        DISABLE_SOUND_TEXT = "Disable Sound";
        ENABLE_SOUND_TEXT = "Enable Sound";
        EXIT_MSG = "Are you sure you want to exit?";
        NO_TEXT = "No";
        YES_TEXT = "Yes";
        EXIT_TEXT = "Exit";
        NEW_GAME_TEXT = "New Game";
        GAME_OVER_TEXT = "GAME OVER!!!";
        BEST_TILE = "Best Tile";
        TILE = "Tile";
        CONGRATS_TEXT = "CONGRATULATIONS!!!";
        HIGH_SCORE_TEXT = "You made new high score.";
        POP_UP_TEXT_COLOR = 23448;
        MORE_APPS = "More Apps";
        RESUME = "Resume";
        SCORE = "Score: ";
        reviewMessage = new String[]{"Liked it?", "Please leave a 5 star review."};
        reviewLaterMessage = "You can give review from menu";
        FREQUENCY = 2;
        _obstructionCount = 0;
        frequency = 0;
        _2048Arr = new int[]{1024, 512, 16834, 32768, 2048, 512};
        _birdTable = new Hashtable();
    }

    public static int getRandomNumber(int i) {
        return random.nextInt(i);
    }

    public static void initBird() {
        birds = new BirdObject(numberBird_0, WIN_FRAME[0], LOOSE_FRAME[0], ObstructionBoxes.gap * 50 / 100, 1, 4 * SCREEN_HEIGHT / 480, 4, Config.scaleBitmap(SCREEN_WIDTH, SCREEN_HEIGHT, Config.getFolderImage(GAMESCREEN, chooserFocusBird1)), Config.scaleBitmap(SCREEN_WIDTH, SCREEN_HEIGHT, Config.getFolderImage(GAMESCREEN, chooserUnFocusBird1)));
        Config.initializeBirdTable();
    }

    public static void reInitializeBird() {
        birds = new BirdObject(numberBird_0, WIN_FRAME[0], LOOSE_FRAME[0], ObstructionBoxes.gap * 50 / 100, 1, 4 * SCREEN_HEIGHT / 480, 4, Config.scaleBitmap(SCREEN_WIDTH, SCREEN_HEIGHT, Config.getFolderImage(GAMESCREEN, chooserFocusBird1)), Config.scaleBitmap(SCREEN_WIDTH, SCREEN_HEIGHT, Config.getFolderImage(GAMESCREEN, chooserUnFocusBird1)));
        _obstructionCount = 0;
        frequency = 0;
    }

    public static void loadBitmap() {
        HELP_1 = Config.scaleBitmap(SCREEN_WIDTH, SCREEN_HEIGHT, Config.getFolderImage(GAMESCREEN, "help_up.png"));
        HELP_2 = Config.scaleBitmap(SCREEN_WIDTH, SCREEN_HEIGHT, Config.getFolderImage(GAMESCREEN, "help_down.png"));
        numberBird_0 = new Image[][]{{ImageCache.getBirdFrame("1_straight_1.png"), ImageCache.getBirdFrame("1_straight_2.png"), ImageCache.getBirdFrame("1_straight_3.png")}, {ImageCache.getBirdFrame("1_straight_1.png"), ImageCache.getBirdFrame("1_straight_2.png"), ImageCache.getBirdFrame("1_straight_3.png")}, {ImageCache.getBirdFrame("1_straight_1.png"), ImageCache.getBirdFrame("1_straight_2.png"), ImageCache.getBirdFrame("1_straight_3.png")}};
        numberBird_1 = new Image[][]{{ImageCache.getBirdFrame("2_straight_1.png"), ImageCache.getBirdFrame("2_straight_2.png"), ImageCache.getBirdFrame("2_straight_3.png")}, {ImageCache.getBirdFrame("2_straight_1.png"), ImageCache.getBirdFrame("2_straight_2.png"), ImageCache.getBirdFrame("2_straight_3.png")}, {ImageCache.getBirdFrame("2_straight_1.png"), ImageCache.getBirdFrame("2_straight_2.png"), ImageCache.getBirdFrame("2_straight_3.png")}};
        numberBird_2 = new Image[][]{{ImageCache.getBirdFrame("3_straight_1.png"), ImageCache.getBirdFrame("3_straight_2.png"), ImageCache.getBirdFrame("3_straight_3.png")}, {ImageCache.getBirdFrame("3_straight_1.png"), ImageCache.getBirdFrame("3_straight_2.png"), ImageCache.getBirdFrame("3_straight_3.png")}, {ImageCache.getBirdFrame("3_straight_1.png"), ImageCache.getBirdFrame("3_straight_2.png"), ImageCache.getBirdFrame("3_straight_3.png")}};
        numberBird_3 = new Image[][]{{ImageCache.getBirdFrame("4_straight_1.png"), ImageCache.getBirdFrame("4_straight_2.png"), ImageCache.getBirdFrame("4_straight_3.png")}, {ImageCache.getBirdFrame("4_straight_1.png"), ImageCache.getBirdFrame("4_straight_2.png"), ImageCache.getBirdFrame("4_straight_3.png")}, {ImageCache.getBirdFrame("4_straight_1.png"), ImageCache.getBirdFrame("4_straight_2.png"), ImageCache.getBirdFrame("4_straight_3.png")}};
        numberBird_4 = new Image[][]{{ImageCache.getBirdFrame("5_straight_1.png"), ImageCache.getBirdFrame("5_straight_2.png"), ImageCache.getBirdFrame("5_straight_3.png")}, {ImageCache.getBirdFrame("5_straight_1.png"), ImageCache.getBirdFrame("5_straight_2.png"), ImageCache.getBirdFrame("5_straight_3.png")}, {ImageCache.getBirdFrame("5_straight_1.png"), ImageCache.getBirdFrame("5_straight_2.png"), ImageCache.getBirdFrame("5_straight_3.png")}};
        numberBird_5 = new Image[][]{{ImageCache.getBirdFrame("6_straight_1.png"), ImageCache.getBirdFrame("6_straight_2.png"), ImageCache.getBirdFrame("6_straight_3.png")}, {ImageCache.getBirdFrame("6_straight_1.png"), ImageCache.getBirdFrame("6_straight_2.png"), ImageCache.getBirdFrame("6_straight_3.png")}, {ImageCache.getBirdFrame("6_straight_1.png"), ImageCache.getBirdFrame("6_straight_2.png"), ImageCache.getBirdFrame("6_straight_3.png")}};
        obstructionBox = ImageCache.get("1_block.png");
        straightBird = ImageCache.getBirdFrame("1_straight_2.png");
        pipe_up = Config.scaleBitmap(SCREEN_WIDTH, SCREEN_HEIGHT, Config.getFolderImage(GAMESCREEN, "pipe_2.png"));
        pipe_down = Config.scaleBitmap(SCREEN_WIDTH, SCREEN_HEIGHT, Config.getFolderImage(GAMESCREEN, "pipe_1.png"));
        bgLayer1 = Config.scaleBitmap(SCREEN_WIDTH, SCREEN_HEIGHT, Config.getFolderImage(GAMESCREEN, "building_layer1.png"));
        bgLayer2 = Config.scaleBitmap(SCREEN_WIDTH, SCREEN_HEIGHT, Config.getFolderImage(GAMESCREEN, "building_layer2.png"));
        bgLayer3 = Config.scaleBitmap(SCREEN_WIDTH, SCREEN_HEIGHT, Config.getFolderImage(GAMESCREEN, "bush_leyer3.png"));
        bgLayer4 = Config.scaleBitmap(SCREEN_WIDTH, SCREEN_HEIGHT, Config.getFolderImage(GAMESCREEN, "bush_layer4.png"));
        bgLayer5 = Config.scaleBitmap(SCREEN_WIDTH, SCREEN_HEIGHT, Config.getFolderImage(GAMESCREEN, "bush_layer5.png"));
        bgLayer6 = Config.scaleBitmap(SCREEN_WIDTH, SCREEN_HEIGHT, Config.getFolderImage(GAMESCREEN, "grass_layer6.png"));
        night = Config.scaleBitmap(SCREEN_WIDTH, SCREEN_HEIGHT, Config.getFolderImage(GAMESCREEN, "night.png"));
        morning = Config.scaleBitmap(SCREEN_WIDTH, SCREEN_HEIGHT, Config.getFolderImage(GAMESCREEN, "morning.png"));
        evening = Config.scaleBitmap(SCREEN_WIDTH, SCREEN_HEIGHT, Config.getFolderImage(GAMESCREEN, "evening.png"));
        gameScreenBG = ScaleImage.CreateScaledImage(Config.getFolderImage(GAMESCREEN, "bg.jpg"), SCREEN_WIDTH, SCREEN_HEIGHT);
        Config.initBird();
    }

    public static void setFontHeight(Graphics graphics, int height, int width, String text) {
        int fontHt = height * 50 / 100;
        graphics.setFont(Font.getFont((int)0, (int)1, (int)8));
        int textWidth = graphics.getFont().stringWidth(text);
        if (textWidth >= width) {
            while (textWidth >= width) {
                fontHt -= height * 10 / 100;
                graphics.setFont(Font.getFont((int)0, (int)1, (int)8));
                textWidth = graphics.getFont().stringWidth(text);
            }
        }
    }

    public static void initializeBirdTable() {
        _birdTable.put(new Integer(1), numberBird_0);
        _birdTable.put(new Integer(2), numberBird_1);
        _birdTable.put(new Integer(3), numberBird_2);
        _birdTable.put(new Integer(4), numberBird_3);
        _birdTable.put(new Integer(5), numberBird_4);
        _birdTable.put(new Integer(0), numberBird_5);
    }

    public static int getColorCode(int number) {
        switch (number) {
            case 1: {
                return 0xFFFF00;
            }
            case 2: {
                return 0xFF0000;
            }
            case 3: {
                return 0xFFFF00;
            }
            case 4: {
                return 0xFF0000;
            }
            case 5: {
                return 0xFFFF00;
            }
            case 6: {
                return 0xFF0000;
            }
        }
        return 0xFF0000;
    }

    public static Image getBlockBitmap(int number) {
        switch (number) {
            case 1: {
                return ImageCache.get("1_block.png");
            }
            case 2: {
                return ImageCache.get("2_block.png");
            }
            case 3: {
                return ImageCache.get("3_block.png");
            }
            case 4: {
                return ImageCache.get("4_block.png");
            }
            case 5: {
                return ImageCache.get("5_block.png");
            }
            case 0: {
                return ImageCache.get("6_block.png");
            }
        }
        return ImageCache.get("1_block.png");
    }

    public static Image getImage(String imageName) {
        try {
            return Image.createImage((String)("/" + imageName));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Image getFolderImage(String folderName, String imageName) {
        try {
            return Image.createImage((String)("/" + folderName + "/" + imageName));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int floor(double d) {
        int b = (int)d;
        return b;
    }

    public static int getX(int x) {
        int xpos = SCREEN_WIDTH * x / 100;
        return xpos;
    }

    public static int getY(int y) {
        int ypos = SCREEN_HEIGHT * y / 100;
        return ypos;
    }

    static Vector wrap(String text, Font font, int width) {
        Vector<String> result = new Vector<String>();
        if (text == null) {
            return result;
        }
        boolean hasMore = true;
        int current = 0;
        int lineBreak = -1;
        int nextSpace = -1;
        while (hasMore) {
            int linewidth;
            do {
                if ((lineBreak = nextSpace) == text.length() - 1) {
                    hasMore = false;
                    break;
                }
                nextSpace = text.indexOf(32, lineBreak + 1);
                if (nextSpace != -1) continue;
                nextSpace = text.length() - 1;
            } while ((linewidth = font.substringWidth(text, current, nextSpace - current)) <= width);
            String line = text.substring(current, lineBreak + 1);
            result.addElement(line);
            current = lineBreak + 1;
        }
        return result;
    }

    public static int drawMultilineString(Graphics g, Font font, String str, int x, int y, int anchor, int width) {
        g.setFont(font);
        Vector lines = Config.wrap(str, font, width);
        int i = 0;
        while (i < lines.size()) {
            int liney = y + i * font.getHeight();
            g.drawString((String)lines.elementAt(i), x + (width - g.getFont().stringWidth((String)lines.elementAt(i))) / 2, liney, anchor);
            ++i;
        }
        return y + lines.size() * font.getHeight();
    }

    public static Image scaleBitmap(int targetScreenwidth, int targetScreenHeight, Image bitmap) {
        float scaleFactor = Config.calculateAspectRatioFit(targetScreenwidth, targetScreenHeight);
        int imgWidth = (int)((float)bitmap.getWidth() * scaleFactor);
        int imgHeight = (int)((float)bitmap.getHeight() * scaleFactor);
        Image bmp = ScaleImage.CreateScaledImage(bitmap, imgWidth, imgHeight);
        return bmp;
    }

    public static float calculateAspectRatioFit(int srcWidth, int srcHeight) {
        ratio = srcWidth > srcHeight ? (float)Math.min(srcWidth / 320, srcHeight / 240) : (float)Math.min(srcHeight / 320, srcWidth / 240);
        return ratio;
    }

    public static int log2(int x) {
        if (x <= 0) {
            throw new IllegalArgumentException(x + " <= 0");
        }
        int v = x;
        int y = -1;
        while (v > 0) {
            v >>= 1;
            ++y;
        }
        return y;
    }

    public static double pow(double num1, double num2) {
        double result = 1.0;
        int i = 0;
        while ((double)i < num2) {
            result *= num1;
            ++i;
        }
        return result;
    }
}

