/*
 * Decompiled with CFR 0.152.
 */
package in.spice.flappybird2048.objects;

import in.spice.flappybird2048.animationlistener.CollisionAndScoreListener;
import in.spice.flappybird2048.common.Config;
import in.spice.flappybird2048.objects.XYRect;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ObstructionBoxes {
    private CollisionAndScoreListener listener;
    private static final int startXpos = Config.SCREEN_WIDTH + Config.pipe_up.getWidth();
    private int currentXPos = startXpos;
    public static final int velocity = Config.SCREEN_HEIGHT * 8 / 480;
    private int currentYPos;
    private boolean isScoreUpdated;
    public static final int pipe_width = Config.pipe_up.getWidth();
    public static final int pipe_height = Config.pipe_up.getHeight();
    public static final int number_of_blocks = 6;
    public static final int number_block_height = Config.SCREEN_HEIGHT / 6;
    public static final int number_block_width = Config.obstructionBox.getWidth();
    public static final int gap = 2 * number_block_height;
    private int CorrectBlockNumber = 1;
    private long numberToCollide = 2L;
    boolean isTouched = false;
    boolean isCrossed = false;
    private long[] numberArr = new long[6];
    int displacement;
    boolean isMoving;
    int UP = -1;
    int DOWN;
    int DIRECTION = this.DOWN = 1;
    boolean isInvisible;

    public ObstructionBoxes(CollisionAndScoreListener listener, int numberToCollide) {
        this.listener = listener;
        this.numberToCollide = numberToCollide;
        this.displacement = 0;
        this.setParams(numberToCollide);
    }

    public void setMoving(boolean flag) {
        this.isMoving = flag;
    }

    public long getNumberToCollide() {
        return this.numberToCollide;
    }

    public void setParams() {
        this.currentXPos = startXpos;
        this.CorrectBlockNumber = Config.random.nextInt(6);
        this.currentYPos = this.CorrectBlockNumber * number_block_height;
        this.currentYPos -= number_block_height / 2;
        this.isScoreUpdated = false;
        this.isTouched = false;
        this.isCrossed = false;
    }

    public int getPower(long number) {
        return Config.log2((int)number);
    }

    public void setParams(long currentNumber) {
        this.currentXPos = startXpos;
        this.numberToCollide = currentNumber;
        this.isScoreUpdated = false;
        this.setBoxNumbers(currentNumber);
        this.displacement = 0;
        this.isTouched = false;
        this.isCrossed = false;
        this.isInvisible = false;
    }

    public Vector setBoxPowerNumber(long currentNumber) {
        int pow = this.getPower(currentNumber);
        Vector<Integer> tempVec = new Vector<Integer>();
        int i = pow;
        while (i >= 1) {
            if (tempVec.size() == 3) break;
            tempVec.addElement(new Integer(i));
            --i;
        }
        i = pow + 1;
        while (tempVec.size() < 6) {
            tempVec.addElement(new Integer(i));
            ++i;
        }
        return tempVec;
    }

    public long getPowerof(int number) {
        long numb = 1L;
        int i = 0;
        while (i < number) {
            numb *= 2L;
            ++i;
        }
        return numb;
    }

    public void setBoxNumbers(long currentNumber) {
        Vector tempVec = this.setBoxPowerNumber(currentNumber);
        Vector<Integer> randomIndexParam = new Vector<Integer>();
        while (tempVec.size() > 0) {
            int randomIndex = Config.random.nextInt(tempVec.size());
            int randomVal = (Integer)tempVec.elementAt(randomIndex);
            randomIndexParam.addElement(new Integer(randomVal));
            tempVec.removeElementAt(randomIndex);
        }
        int i = 0;
        while (i < randomIndexParam.size()) {
            int index = (Integer)randomIndexParam.elementAt(i);
            this.numberArr[i] = this.getPowerof(index);
            ++i;
        }
        this.shiftNumberToCollideFromLastIndex(currentNumber);
        i = 0;
        while (i < this.numberArr.length) {
            if (this.numberArr[i] == currentNumber) {
                this.CorrectBlockNumber = i;
                this.currentYPos = i * number_block_height;
            }
            ++i;
        }
    }

    public void shiftNumberToCollideFromLastIndex(long currentNumber) {
        if (this.numberArr[this.numberArr.length - 1] == currentNumber) {
            int randomIndex = 1 + Config.random.nextInt(this.numberArr.length - 2);
            long temp = this.numberArr[randomIndex];
            this.numberArr[randomIndex] = currentNumber;
            this.numberArr[this.numberArr.length - 1] = temp;
        }
    }

    public void tempTest(long currentnumber) {
        int tempIndex = 0;
        int i = 0;
        while (i < this.numberArr.length) {
            if (this.numberArr[i] == currentnumber) {
                tempIndex = i;
                break;
            }
            ++i;
        }
        if (currentnumber == 8L) {
            long temp = this.numberArr[this.numberArr.length - 2];
            this.numberArr[this.numberArr.length - 2] = currentnumber;
            this.numberArr[tempIndex] = temp;
        }
    }

    public void drawBoxes(Graphics graphics) {
        this.drawMovingNumber(graphics);
    }

    public void toggleDirection() {
        if (this.DIRECTION == this.UP) {
            this.DIRECTION = this.DOWN;
            this.displacement = -number_block_height;
        } else {
            this.DIRECTION = this.UP;
            this.displacement = 0;
        }
    }

    public void drawMovingNumber(Graphics graphics) {
        int text_y;
        int y;
        Image boxImg;
        int code;
        int pow;
        if (this.isMoving) {
            this.displacement += number_block_height * 10 / 100;
        }
        int i = 0;
        while (i < this.numberArr.length) {
            pow = Config.log2((int)this.numberArr[i]);
            code = pow % 6;
            boxImg = Config.getBlockBitmap(code);
            int y2 = this.DIRECTION * this.displacement + i * number_block_height;
            if (this.numberArr[i] == this.numberToCollide) {
                this.currentYPos = y2;
            }
            if (!this.isInvisible || this.numberArr[i] != this.numberToCollide) {
                graphics.drawImage(boxImg, this.currentXPos, y2, 0);
            }
            graphics.setColor(0);
            Config.setFontHeight(graphics, number_block_height, number_block_width, String.valueOf(this.numberArr[i]) + " ");
            int text_y2 = (number_block_height - graphics.getFont().getHeight()) / 2;
            if (!this.isInvisible || this.numberArr[i] != this.numberToCollide) {
                graphics.setFont(Font.getFont((int)0, (int)1, (int)8));
                graphics.drawString(String.valueOf(this.numberArr[i]), this.currentXPos + (boxImg.getWidth() - graphics.getFont().stringWidth(String.valueOf(this.numberArr[i]))) / 2, y2 + text_y2, 0);
            }
            ++i;
        }
        if (this.DIRECTION == this.UP) {
            y = this.DIRECTION * this.displacement + this.numberArr.length * number_block_height;
            pow = Config.log2((int)this.numberArr[0]);
            code = pow % 6;
            boxImg = Config.getBlockBitmap(code);
            graphics.drawImage(boxImg, this.currentXPos, y, 0);
            graphics.setColor(0);
            Config.setFontHeight(graphics, number_block_height, number_block_width, String.valueOf(this.numberArr[0]) + " ");
            text_y = (number_block_height - graphics.getFont().getHeight()) / 2;
            graphics.setFont(Font.getFont((int)0, (int)1, (int)8));
            graphics.drawString(String.valueOf(this.numberArr[0]), this.currentXPos + (number_block_width - Font.getDefaultFont().stringWidth(String.valueOf(this.numberArr[0]))) / 2, y + text_y, 0);
            if (this.isMoving) {
                if (this.displacement >= number_block_height) {
                    this.displacement = 0;
                    this.shiftArrayUp();
                }
                if (this.currentYPos <= 0) {
                    this.DIRECTION = this.DOWN;
                    this.displacement = 0;
                }
            }
        } else {
            y = this.displacement - number_block_height;
            pow = Config.log2((int)this.numberArr[this.numberArr.length - 1]);
            code = pow % 6;
            boxImg = Config.getBlockBitmap(code);
            graphics.drawImage(boxImg, this.currentXPos, y, 0);
            graphics.setColor(0);
            Config.setFontHeight(graphics, number_block_height, number_block_width, String.valueOf(this.numberArr[0]) + " ");
            text_y = (number_block_height - graphics.getFont().getHeight()) / 2;
            graphics.setFont(Font.getFont((int)0, (int)1, (int)8));
            graphics.drawString(String.valueOf(this.numberArr[this.numberArr.length - 1]), this.currentXPos + (number_block_width - Font.getDefaultFont().stringWidth(String.valueOf(this.numberArr[this.numberArr.length - 1]))) / 2, y + text_y, 0);
        }
        if (this.isMoving) {
            if (this.displacement >= number_block_height) {
                this.displacement = 0;
                this.shiftArrayDown();
            }
            if (this.currentYPos >= number_block_height * (this.numberArr.length - 2)) {
                this.DIRECTION = this.UP;
                this.displacement = 0;
            }
        }
    }

    public void shiftArrayDown() {
        long temp = this.numberArr[this.numberArr.length - 1];
        int i = this.numberArr.length - 1;
        int j = this.numberArr.length - 2;
        while (j >= 0) {
            this.numberArr[i] = this.numberArr[j];
            --i;
            --j;
        }
        this.numberArr[0] = temp;
    }

    public void shiftArrayUp() {
        long temp = this.numberArr[0];
        int i = 1;
        int j = 0;
        while (i < this.numberArr.length) {
            this.numberArr[j] = this.numberArr[i];
            ++i;
            ++j;
        }
        this.numberArr[this.numberArr.length - 1] = temp;
    }

    public void drawNumbers(Graphics graphics) {
        int i = 0;
        while (i < this.numberArr.length) {
            int pow = Config.log2((int)this.numberArr[i]);
            int code = pow % 6;
            Image boxImg = Config.getBlockBitmap(code);
            graphics.drawImage(boxImg, this.currentXPos, i * number_block_height, 0);
            graphics.setColor(0);
            Config.setFontHeight(graphics, number_block_height, number_block_width, String.valueOf(this.numberArr[i]) + " ");
            int y = (number_block_height - graphics.getFont().getHeight()) / 2;
            graphics.setFont(Font.getFont((int)0, (int)1, (int)8));
            graphics.drawString(String.valueOf(this.numberArr[i]), this.currentXPos + (number_block_width - graphics.getFont().stringWidth(String.valueOf(this.numberArr[i]))) / 2, i * number_block_height + y, 0);
            ++i;
        }
    }

    public void drawObstruction(Graphics graphics, XYRect birdRect, boolean isGameOver) {
        if (!isGameOver) {
            this.decreaseXPos(birdRect);
        }
        if (this.currentXPos - (birdRect.x + birdRect.width) <= number_block_width / 2) {
            this.isMoving = false;
        }
        this.drawBoxes(graphics);
        if (!this.isTouched && this.isTouchedToCorrectNumber(birdRect)) {
            this.listener.iscollideToCorrectNumber(this.currentYPos, this.numberToCollide);
            this.isCrossed = false;
        }
        this.isInMidway(birdRect);
        if (!this.isCrossed && this.isObstructionCrossed(birdRect)) {
            this.isCrossed = true;
            this.listener.isObstructionCrossed(this);
        }
        if (this.isOutOfScreen()) {
            this.listener.isOutOfScreen(this);
        }
        if (!this.isTouched && this.isColiding(birdRect) && !isGameOver) {
            this.isTouched = true;
            this.isCrossed = true;
            this.listener.isGameOver();
        }
    }

    private void decreaseXPos(XYRect birdRect) {
        this.currentXPos -= velocity;
        if (!this.isScoreUpdated && this.currentXPos < birdRect.x + birdRect.width / 2) {
            this.isScoreUpdated = true;
        }
    }

    private boolean isColiding(XYRect birdRect) {
        if (birdRect.x + birdRect.width < this.currentXPos || birdRect.x > this.currentXPos + number_block_width) {
            return false;
        }
        return birdRect.y + birdRect.height >= gap + this.currentYPos || birdRect.y <= this.currentYPos;
    }

    public boolean isObstructionCrossed(XYRect birdRect) {
        return birdRect.x + birdRect.x / 2 > this.currentXPos + number_block_width;
    }

    public boolean isTouchedToCorrectNumber(XYRect birdRect) {
        if (birdRect.x + birdRect.width >= this.currentXPos && birdRect.y > this.currentYPos - number_block_height / 2 && birdRect.y + birdRect.height < this.currentYPos + gap / 2 + number_block_height / 2) {
            this.isTouched = true;
            return true;
        }
        return false;
    }

    public void isInMidway(XYRect birdRect) {
        if (this.isTouched && birdRect.x + birdRect.width >= this.currentXPos + number_block_width) {
            this.isInvisible = true;
        }
    }

    public boolean isOutOfScreen() {
        return this.currentXPos < -number_block_width;
    }
}

