/*
 * Decompiled with CFR 0.152.
 */
package in.spice.flappybird2048.objects;

import in.spice.flappybird2048.common.Config;
import in.spice.flappybird2048.objects.BirdObject;
import in.spice.flappybird2048.objects.ObstructionBoxes;
import in.spice.flappybird2048.objects.XYRect;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class FlapBird {
    private int currentXPos;
    private int currentYPos;
    private int currentIndex;
    private long currentNumber;
    public static final int birdXpos = Config.SCREEN_WIDTH / 4;
    private int birdYpos = Config.SCREEN_HEIGHT / 2;
    public static int mass = 4 * Config.SCREEN_HEIGHT / 480;
    public static int gravity = 1;
    private static int velocity = 4;
    public static int MAX_UP_DISTANCE = -(ObstructionBoxes.gap * 60 / 100);
    private int birdWidth;
    private int birdHeight;
    private boolean isGameOver;
    private int minHeight;
    private XYRect rect;
    private int currentFrame;
    private BirdObject obj = Config.birds;
    private boolean isConstant;
    int currentColorCode;
    static int frequency = 0;
    boolean isAnimationOn;

    public FlapBird() {
        mass = this.obj.getMass();
        gravity = this.obj.getGravity();
        velocity = this.obj.getVelocity();
        this.currentNumber = 2L;
        MAX_UP_DISTANCE = this.obj.getMaxUpDistance();
        this.currentXPos = Config.SCREEN_WIDTH / 4;
        this.currentYPos = Config.SCREEN_HEIGHT / 2;
        this.birdWidth = this.obj.getBirdFrames()[0][0].getWidth();
        this.birdHeight = this.obj.getBirdFrames()[0][0].getHeight();
        this.minHeight = Config.SCREEN_HEIGHT - this.birdHeight / 2;
        this.rect = new XYRect(this.currentXPos, this.currentYPos, this.birdWidth, this.birdHeight);
        this.isConstant = false;
    }

    public void flyBird() {
        if (!this.isGameOver) {
            velocity = -((int)Math.sqrt(2 * mass * gravity * MAX_UP_DISTANCE));
            if (this.currentIndex != 2) {
                this.currentIndex = 2;
            }
        }
    }

    private void applyPhysics() {
        if (velocity > 0 && this.currentIndex != 1) {
            this.currentIndex = 1;
        }
        this.currentYPos += (velocity += mass * gravity);
        if (this.currentYPos < 0) {
            this.currentYPos = 0;
        }
        if (this.currentYPos >= this.minHeight) {
            this.currentYPos = this.minHeight;
        }
    }

    public void setContantSpeed(int currentYPos, boolean flag) {
        this.currentYPos = currentYPos;
        this.isConstant = flag;
    }

    public void setAnimationFlag(boolean flag) {
        this.isAnimationOn = flag;
    }

    public void drawBird(Graphics graphics, boolean isGameStart, boolean gameOver) {
        ++frequency;
        if (isGameStart || this.isGameOver) {
            if (this.isGameOver) {
                this.isConstant = false;
            }
            if (!this.isConstant && !this.isAnimationOn) {
                this.applyPhysics();
            }
            if (this.isConstant) {
                this.currentIndex = 0;
            }
        }
        if (gameOver && this.currentIndex != 1) {
            this.currentIndex = 1;
        }
        this.rect.set(this.currentXPos, this.currentYPos, this.birdWidth, this.birdHeight);
        if (this.currentFrame >= this.obj.getBirdFrames()[this.currentIndex].length) {
            this.currentFrame = 0;
        }
        graphics.drawImage(this.obj.getBirdFrames()[this.currentIndex][this.currentFrame], this.currentXPos, this.currentYPos, 0);
        if (!isGameStart && this.currentNumber == 2L) {
            Font fnt = graphics.getFont();
            graphics.setFont(fnt);
            int birdYpos = this.birdYpos - graphics.getFont().getHeight() * 4;
            graphics.setFont(Font.getFont((int)0, (int)1, (int)8));
            int xShift1 = graphics.getFont().stringWidth("Tap or Press any key to");
            int birdXpos = (Config.SCREEN_WIDTH - xShift1) / 2;
            graphics.drawString("Tap or Press any key to", birdXpos, birdYpos, 0);
            graphics.drawImage(Config.HELP_1, birdXpos + xShift1, birdYpos, 0);
            int xShift = graphics.getFont().stringWidth("Release to ");
            birdXpos = (Config.SCREEN_WIDTH - xShift) / 2;
            graphics.drawString("Release to ", birdXpos, birdYpos + graphics.getFont().getHeight(), 0);
            graphics.drawImage(Config.HELP_2, birdXpos + xShift, birdYpos + graphics.getFont().getHeight(), 0);
            graphics.setFont(fnt);
        }
        graphics.setColor(0);
        int fontHt = Config.straightBird.getHeight() * 50 / 100;
        graphics.setFont(Font.getFont((int)0, (int)1, (int)16));
        int boxWidth = Config.straightBird.getWidth();
        int fontWidth = graphics.getFont().stringWidth(String.valueOf(this.currentNumber) + "  ");
        int ypos = this.currentYPos + Config.straightBird.getHeight() * 20 / 100;
        Config.setFontHeight(graphics, Config.straightBird.getHeight(), Config.obstructionBox.getWidth(), String.valueOf(this.currentNumber) + " ");
        ypos = this.currentYPos + (Config.straightBird.getHeight() - graphics.getFont().getHeight()) / 2;
        graphics.setFont(Font.getFont((int)0, (int)1, (int)8));
        graphics.drawString(String.valueOf(this.currentNumber), this.currentXPos + Config.straightBird.getWidth() / 2 + (Config.straightBird.getWidth() * 40 / 100 - graphics.getFont().stringWidth(String.valueOf(this.currentNumber))) / 2, ypos, 0);
        if (!this.isConstant && !this.isGameOver) {
            if (frequency % 2 == 0) {
                ++this.currentFrame;
            }
        } else {
            this.currentFrame = 3;
        }
    }

    public boolean isGameOver() {
        return this.currentYPos == this.minHeight;
    }

    public XYRect getXYRect() {
        return this.rect;
    }

    public int getXPos() {
        return this.currentXPos;
    }

    public int getWidth() {
        return this.birdWidth;
    }

    public int getYPos() {
        return this.currentYPos;
    }

    public void gameOver() {
        this.isGameOver = true;
    }

    public long getCuurentNumber() {
        return this.currentNumber;
    }

    public void setCurrentNumber(long currentNumber) {
        this.currentNumber = currentNumber;
        int key = Config.log2((int)currentNumber);
        this.currentColorCode = Config.getColorCode(key);
    }

    public void resetInitialVelocity() {
        velocity = this.obj.getVelocity();
        this.currentFrame = 0;
        this.isConstant = false;
    }

    public BirdObject getBirdObject() {
        return this.obj;
    }

    public void setBirdObject(BirdObject obj) {
        this.obj = obj;
    }

    public void resetParams() {
        this.isGameOver = false;
        this.currentXPos = Config.SCREEN_WIDTH / 4;
        this.currentYPos = Config.SCREEN_HEIGHT / 2;
        this.rect = new XYRect(this.currentXPos, this.currentYPos, this.birdWidth, this.birdHeight);
        this.currentIndex = 0;
        velocity = 4;
        this.currentFrame = 0;
    }
}

