/*
 * Decompiled with CFR 0.152.
 */
package in.spicelabs.hippojump.objects;

import in.spicelabs.hippojump.objects.AnimationCompleteListener;
import in.spicelabs.hippojump.objects.Sprite;
import in.spicelabs.hippojump.objects.XYRect;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class AnimationSprite
extends Sprite {
    private final Image[] frames;
    private AnimationCompleteListener listener;
    private int frameCount;
    private int animationCount;
    private final Sprite parent;
    private boolean isStopped;
    private boolean isPaused;
    private Object cookie;

    public AnimationSprite(Image[] frames, int initialX, int initialY, Sprite parent) {
        super(new XYRect(initialX, initialY, frames[0].getWidth(), frames[0].getHeight()), null);
        this.frames = frames;
        this.parent = parent;
        this.animationCount = 1;
    }

    public void setAnimationListener(AnimationCompleteListener listener) {
        this.listener = listener;
    }

    public void setAnimationCount(int animationCount) {
        this.animationCount = animationCount;
    }

    protected void draw(Graphics g) {
        if (this.isPaused) {
            return;
        }
        if (this.animationCount != 0) {
            g.drawImage(this.frames[this.frameCount], this.parent.getAbsoluteX() + this.rect.x, this.parent.getAbsoluteY() + this.rect.y, 0);
        }
        if (this.isStopped) {
            this.notifyAnimationCompletion();
        }
    }

    public void setStopped(boolean isStopped) {
        this.isStopped = isStopped;
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    public void setCookie(Object cookie) {
        this.cookie = cookie;
    }

    public Object getCookie() {
        return this.cookie;
    }

    public void pauseAnimation(boolean pause) {
        if (pause ^ this.isPaused) {
            this.isPaused = pause;
        }
    }

    protected void tick() {
        if (this.isPaused) {
            return;
        }
        if (this.animationCount != 0) {
            ++this.frameCount;
            this.frameCount %= this.frames.length;
            if (this.frameCount == 0 && this.animationCount != -1) {
                --this.animationCount;
            }
        } else {
            this.notifyAnimationCompletion();
        }
    }

    private void notifyAnimationCompletion() {
        if (this.listener != null) {
            this.listener.onAnimationComplete(this);
        }
    }
}

