/*
 * Decompiled with CFR 0.152.
 */
package in.spicelabs.hippojump.objects;

import in.spicelabs.hippojump.common.Config;
import in.spicelabs.hippojump.objects.AnimationSprite;
import in.spicelabs.hippojump.objects.Controller;
import in.spicelabs.hippojump.objects.FallableSprite;
import in.spicelabs.hippojump.objects.World;
import in.spicelabs.hippojump.objects.XYRect;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Branch
extends FallableSprite {
    public static final int TYPE_NORMAL = 0;
    public static final int TYPE_BREAK = 1;
    public static final int TYPE_MOVING = 2;
    public static final int TYPE_SPRING = 3;
    public static final int STATE_BREAK = 8;
    private static int flickSize;
    private int speedX;
    private boolean isFlicked;
    private int type;
    private Image[] frames;
    private Image spring;

    public Branch(int x, int y, int speedX, boolean isFirst, int type, World world) {
        super(new XYRect(x, y, Config.BRANCH[0].getWidth(), Config.BRANCH[0].getHeight()), world);
        this.frames = Branch.getFrames(type);
        this.type = type;
        this.speedX = speedX;
        flickSize = this.rect.height >> 2;
        this.spring = Config.SPRING[0];
    }

    public static Image[] getFrames(int type) {
        switch (type) {
            case 1: {
                return Config.BRANCH_BREAK;
            }
        }
        return Config.BRANCH;
    }

    protected void draw(Graphics g) {
        if (this.type == 3) {
            g.drawImage(this.spring, this.rect.x + (this.rect.width - this.spring.getWidth() >> 1), this.rect.y - this.spring.getHeight(), 0);
        }
        if (!this.isInState(8)) {
            g.drawImage(this.frames[0], this.rect.x, this.rect.y, 0);
        }
        super.draw(g);
    }

    protected void tick() {
        if (this.type == 2) {
            if (this.hasGotHitWithWalls()) {
                this.speedX = -this.speedX;
            }
            this.rect.x += this.speedX;
        }
        if (this.rect.y > Controller.DIS_H) {
            this.notifyRemoval();
        }
        this.rect.x += this.speedX;
        if (this.isFlicked) {
            this.rect.y += flickSize;
            if ((flickSize = -flickSize) > 0) {
                this.isFlicked = false;
            }
        }
        super.tick();
    }

    public void startBreaking() {
        if (this.type == 1) {
            this.addAnimation(new AnimationSprite(Config.BRANCH_BREAK, 0, 0, this));
            this.setState(8);
        }
    }

    public void openSpring() {
        this.spring = Config.SPRING[1];
    }

    public void onAnimationComplete(AnimationSprite sprite) {
        super.onAnimationComplete(sprite);
        this.world.removeSprite(this);
    }

    public void setFlicked(boolean isFlicked) {
        this.isFlicked = isFlicked;
    }

    private void notifyRemoval() {
        this.world.removeSprite(this);
    }

    public boolean hasGotHitWithWalls() {
        return this.rect.x + this.rect.width >= this.world.rightBoundary || this.rect.x <= this.world.leftBoundary;
    }

    public int getSpeedX() {
        return this.speedX;
    }

    public int getType() {
        return this.type;
    }
}

