/*
 * Decompiled with CFR 0.152.
 */
package in.spicelabs.jpride.objects;

import in.spicelabs.jpride.objects.AnimatableSprite;
import in.spicelabs.jpride.objects.Controller;
import in.spicelabs.jpride.objects.Sprite;
import in.spicelabs.jpride.objects.World;
import in.spicelabs.jpride.objects.XYRect;
import javax.microedition.lcdui.Image;

public abstract class FallableSprite
extends AnimatableSprite {
    public static final int G = 2;
    public static final int STATE_NORMAL = 1;
    public static final int STATE_JUMP = 2;
    public static final int STATE_FALL = 4;
    public static final int STATE_DIE = 8;
    public static final float COEFFICIENT_OF_KF = 0.4f;
    protected int velocityY;
    protected int velocityX;
    protected int mass = 1;
    protected Sprite base;
    protected int friction;
    int previousState;
    int frameCount;
    private int state = 1;

    public FallableSprite(XYRect rect, World world) {
        super(rect, world);
    }

    protected void tick() {
        int lb = this.getLowerBound();
        if (!(this.isInState(2) || this.isInState(4) || this.rect.x <= this.base.rect.x + this.base.rect.width && this.rect.x >= this.base.rect.x && this.rect.y + this.rect.height >= lb)) {
            this.addState(4);
        }
        if (this.isInState(4)) {
            this.rect.y += this.velocityY;
            this.velocityY += this.mass * 2;
            if (this.rect.y + this.rect.height >= lb) {
                this.rect.y = lb - this.rect.height;
                this.velocityY = 0;
                this.removeState(4);
            }
        }
        if (this.isInState(2)) {
            if (this.rect.y > this.world.ceiling.rect.y + (this.world.ceiling.rect.height >> 1)) {
                this.rect.y -= this.velocityY;
                this.velocityY -= this.mass * 2;
            } else {
                this.velocityY = 0;
            }
            if (this.velocityY <= 0) {
                this.addState(4);
            }
        }
    }

    public boolean isOnTheBase() {
        int lb = this.getLowerBound();
        return this.rect.y + this.rect.height >= lb;
    }

    public int getState() {
        return this.state;
    }

    public void setBase(Sprite base) {
        this.base = base;
    }

    private int getMomentum() {
        return this.velocityX * this.mass;
    }

    private float getKineticFriction() {
        return (float)this.getMomentum() * 0.4f;
    }

    protected int getLowerBound() {
        if (this.base.rect.x <= this.rect.x + (this.rect.width >> 1) && this.rect.y + this.rect.height <= this.base.rect.y + this.base.rect.height) {
            return this.base.rect.y + (this.base.rect.height >> 1);
        }
        return Controller.DIS_H + this.rect.height;
    }

    public boolean isInState(int state) {
        return (this.state & state) == state;
    }

    public void addState(int state) {
        this.previousState = this.state;
        this.state |= state;
        this.frameCount = 0;
        switch (state) {
            case 4: {
                this.state &= 0xFFFFFFFD;
                break;
            }
            case 2: {
                this.state &= 0xFFFFFFFE;
                this.state &= 0xFFFFFFFB;
                break;
            }
            case 1: {
                this.state &= 0xFFFFFFFB;
                break;
            }
            case 8: {
                this.state &= 0xFFFFFFFE;
                this.state &= 0xFFFFFFFB;
            }
        }
    }

    public void setState(int state) {
        this.state = state;
        this.frameCount = 0;
    }

    public void removeState(int state) {
        this.state &= ~state;
        this.frameCount = 0;
    }

    void updateRect(Image frm) {
        int temp = this.rect.height;
        this.rect.width = frm.getWidth();
        this.rect.height = frm.getHeight();
        this.rect.y += temp - this.rect.height;
    }
}

