/*
 * Decompiled with CFR 0.152.
 */
package in.spicelabs.jpride.objects;

import in.spicelabs.jpride.common.Config;
import in.spicelabs.jpride.objects.AttackDirections;
import in.spicelabs.jpride.objects.AttackListener;
import in.spicelabs.jpride.objects.AttackableSprite;
import in.spicelabs.jpride.objects.ConsumableObstacle;
import in.spicelabs.jpride.objects.Controller;
import in.spicelabs.jpride.objects.Electrods;
import in.spicelabs.jpride.objects.FireBall;
import in.spicelabs.jpride.objects.Obstacles;
import in.spicelabs.jpride.objects.Platform;
import in.spicelabs.jpride.objects.RemoveSpriteListener;
import in.spicelabs.jpride.objects.Runner;
import in.spicelabs.jpride.objects.Sprite;
import in.spicelabs.jpride.objects.WorldListener;
import in.spicelabs.jpride.objects.XYRect;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class World
extends Sprite
implements AttackListener,
AttackDirections,
RemoveSpriteListener {
    private static final int[] OBS_SMALL = new int[]{1, 4, 3, 2};
    private static final int[] OBS_ALL = new int[]{1, 4, 3, 2, 5, 8, 7, 6};
    public static final int[][][] MISSILE_PATTERN;
    public static final int[][][] COIN_PATTERN;
    public static final int TOTAL_SMALL_MISSILE_PTRNS = 7;
    public static final int TOTAL_MISSILE_PTRNS;
    public static final int TOTOL_COIN_PTRNS;
    private static int min_gap;
    private static int max_gap;
    private static final int DEFAULT_SPEED;
    private Vector sprites;
    private WorldListener listener;
    private Runner ninja;
    private Random random = new Random();
    private int speed = DEFAULT_SPEED;
    private int dxLayer1;
    private int dxLayer2;
    private int dxLayer3;
    private int dxLayer4;
    Platform floor;
    Platform ceiling;
    protected Vector obstacles;
    private boolean shouldStop;
    private int missileCounter = -1;
    private int missileDodgeCount;
    private int electrodDodgeCount;

    static {
        int[][][] nArrayArray = new int[18][][];
        int[][] nArrayArray2 = new int[2][];
        int[] nArray = new int[2];
        nArray[0] = 1;
        nArrayArray2[0] = nArray;
        int[] nArray2 = new int[2];
        nArray2[1] = 1;
        nArrayArray2[1] = nArray2;
        nArrayArray[0] = nArrayArray2;
        int[][] nArrayArray3 = new int[2][];
        int[] nArray3 = new int[2];
        nArray3[1] = 1;
        nArrayArray3[0] = nArray3;
        int[] nArray4 = new int[2];
        nArray4[0] = 1;
        nArrayArray3[1] = nArray4;
        nArrayArray[1] = nArrayArray3;
        nArrayArray[2] = new int[][]{{1}, {1}};
        nArrayArray[3] = new int[][]{{1}, {1}, {1}};
        int[][] nArrayArray4 = new int[3][];
        int[] nArray5 = new int[2];
        nArray5[0] = 1;
        nArrayArray4[0] = nArray5;
        int[] nArray6 = new int[2];
        nArray6[1] = 1;
        nArrayArray4[1] = nArray6;
        int[] nArray7 = new int[2];
        nArray7[0] = 1;
        nArrayArray4[2] = nArray7;
        nArrayArray[4] = nArrayArray4;
        int[][] nArrayArray5 = new int[3][];
        int[] nArray8 = new int[2];
        nArray8[1] = 1;
        nArrayArray5[0] = nArray8;
        int[] nArray9 = new int[2];
        nArray9[0] = 1;
        nArrayArray5[1] = nArray9;
        int[] nArray10 = new int[2];
        nArray10[1] = 1;
        nArrayArray5[2] = nArray10;
        nArrayArray[5] = nArrayArray5;
        int[][] nArrayArray6 = new int[3][];
        int[] nArray11 = new int[3];
        nArray11[2] = 1;
        nArrayArray6[0] = nArray11;
        int[] nArray12 = new int[3];
        nArray12[1] = 1;
        nArrayArray6[1] = nArray12;
        int[] nArray13 = new int[3];
        nArray13[0] = 1;
        nArrayArray6[2] = nArray13;
        nArrayArray[6] = nArrayArray6;
        int[][] nArrayArray7 = new int[3][];
        int[] nArray14 = new int[3];
        nArray14[0] = 1;
        nArrayArray7[0] = nArray14;
        int[] nArray15 = new int[3];
        nArray15[1] = 1;
        nArrayArray7[1] = nArray15;
        int[] nArray16 = new int[3];
        nArray16[2] = 1;
        nArrayArray7[2] = nArray16;
        nArrayArray[7] = nArrayArray7;
        int[][] nArrayArray8 = new int[7][];
        int[] nArray17 = new int[2];
        nArray17[0] = 1;
        nArrayArray8[0] = nArray17;
        int[] nArray18 = new int[2];
        nArray18[1] = 1;
        nArrayArray8[1] = nArray18;
        nArrayArray8[2] = new int[2];
        nArrayArray8[3] = new int[2];
        nArrayArray8[4] = new int[2];
        int[] nArray19 = new int[2];
        nArray19[1] = 1;
        nArrayArray8[5] = nArray19;
        int[] nArray20 = new int[2];
        nArray20[0] = 1;
        nArrayArray8[6] = nArray20;
        nArrayArray[8] = nArrayArray8;
        nArrayArray[9] = new int[][]{{1}, {1}, new int[1], new int[1], new int[1], {1}, {1}};
        int[][] nArrayArray9 = new int[8][];
        int[] nArray21 = new int[4];
        nArray21[0] = 1;
        nArrayArray9[0] = nArray21;
        int[] nArray22 = new int[4];
        nArray22[0] = 1;
        nArrayArray9[1] = nArray22;
        nArrayArray9[2] = new int[4];
        nArrayArray9[3] = new int[4];
        nArrayArray9[4] = new int[4];
        int[] nArray23 = new int[4];
        nArray23[3] = 1;
        nArrayArray9[5] = nArray23;
        int[] nArray24 = new int[4];
        nArray24[3] = 1;
        nArrayArray9[6] = nArray24;
        int[] nArray25 = new int[4];
        nArray25[3] = 1;
        nArrayArray9[7] = nArray25;
        nArrayArray[10] = nArrayArray9;
        int[][] nArrayArray10 = new int[5][];
        int[] nArray26 = new int[5];
        nArray26[4] = 1;
        nArrayArray10[0] = nArray26;
        int[] nArray27 = new int[5];
        nArray27[3] = 1;
        nArrayArray10[1] = nArray27;
        int[] nArray28 = new int[5];
        nArray28[2] = 1;
        nArrayArray10[2] = nArray28;
        int[] nArray29 = new int[5];
        nArray29[1] = 1;
        nArrayArray10[3] = nArray29;
        int[] nArray30 = new int[5];
        nArray30[0] = 1;
        nArrayArray10[4] = nArray30;
        nArrayArray[11] = nArrayArray10;
        int[][] nArrayArray11 = new int[5][];
        int[] nArray31 = new int[5];
        nArray31[0] = 1;
        nArrayArray11[0] = nArray31;
        int[] nArray32 = new int[5];
        nArray32[1] = 1;
        nArrayArray11[1] = nArray32;
        int[] nArray33 = new int[5];
        nArray33[2] = 1;
        nArrayArray11[2] = nArray33;
        int[] nArray34 = new int[5];
        nArray34[3] = 1;
        nArrayArray11[3] = nArray34;
        int[] nArray35 = new int[5];
        nArray35[4] = 1;
        nArrayArray11[4] = nArray35;
        nArrayArray[12] = nArrayArray11;
        int[][] nArrayArray12 = new int[5][];
        int[] nArray36 = new int[3];
        nArray36[0] = 1;
        nArrayArray12[0] = nArray36;
        int[] nArray37 = new int[3];
        nArray37[1] = 1;
        nArrayArray12[1] = nArray37;
        int[] nArray38 = new int[3];
        nArray38[2] = 1;
        nArrayArray12[2] = nArray38;
        int[] nArray39 = new int[3];
        nArray39[1] = 1;
        nArrayArray12[3] = nArray39;
        int[] nArray40 = new int[3];
        nArray40[0] = 1;
        nArrayArray12[4] = nArray40;
        nArrayArray[13] = nArrayArray12;
        int[][] nArrayArray13 = new int[5][];
        int[] nArray41 = new int[3];
        nArray41[2] = 1;
        nArrayArray13[0] = nArray41;
        int[] nArray42 = new int[3];
        nArray42[1] = 1;
        nArrayArray13[1] = nArray42;
        int[] nArray43 = new int[3];
        nArray43[0] = 1;
        nArrayArray13[2] = nArray43;
        int[] nArray44 = new int[3];
        nArray44[1] = 1;
        nArrayArray13[3] = nArray44;
        int[] nArray45 = new int[3];
        nArray45[2] = 1;
        nArrayArray13[4] = nArray45;
        nArrayArray[14] = nArrayArray13;
        nArrayArray[15] = new int[][]{{1}, {1}, {1}, {1}, {1}};
        int[][] nArrayArray14 = new int[5][];
        int[] nArray46 = new int[2];
        nArray46[1] = 1;
        nArrayArray14[0] = nArray46;
        int[] nArray47 = new int[2];
        nArray47[0] = 1;
        nArrayArray14[1] = nArray47;
        int[] nArray48 = new int[2];
        nArray48[1] = 1;
        nArrayArray14[2] = nArray48;
        int[] nArray49 = new int[2];
        nArray49[0] = 1;
        nArrayArray14[3] = nArray49;
        int[] nArray50 = new int[2];
        nArray50[1] = 1;
        nArrayArray14[4] = nArray50;
        nArrayArray[16] = nArrayArray14;
        int[][] nArrayArray15 = new int[5][];
        int[] nArray51 = new int[2];
        nArray51[0] = 1;
        nArrayArray15[0] = nArray51;
        int[] nArray52 = new int[2];
        nArray52[1] = 1;
        nArrayArray15[1] = nArray52;
        int[] nArray53 = new int[2];
        nArray53[0] = 1;
        nArrayArray15[2] = nArray53;
        int[] nArray54 = new int[2];
        nArray54[1] = 1;
        nArrayArray15[3] = nArray54;
        int[] nArray55 = new int[2];
        nArray55[0] = 1;
        nArrayArray15[4] = nArray55;
        nArrayArray[17] = nArrayArray15;
        MISSILE_PATTERN = nArrayArray;
        int[][][] nArrayArray16 = new int[7][][];
        int[][] nArrayArray17 = new int[5][];
        int[] nArray56 = new int[5];
        nArray56[0] = 1;
        nArray56[1] = 1;
        nArray56[3] = 1;
        nArray56[4] = 1;
        nArrayArray17[0] = nArray56;
        int[] nArray57 = new int[6];
        nArray57[1] = 1;
        nArray57[2] = 1;
        nArray57[4] = 1;
        nArray57[5] = 1;
        nArrayArray17[1] = nArray57;
        int[] nArray58 = new int[7];
        nArray58[2] = 1;
        nArray58[3] = 1;
        nArray58[5] = 1;
        nArray58[6] = 1;
        nArrayArray17[2] = nArray58;
        int[] nArray59 = new int[6];
        nArray59[1] = 1;
        nArray59[2] = 1;
        nArray59[4] = 1;
        nArray59[5] = 1;
        nArrayArray17[3] = nArray59;
        int[] nArray60 = new int[5];
        nArray60[0] = 1;
        nArray60[1] = 1;
        nArray60[3] = 1;
        nArray60[4] = 1;
        nArrayArray17[4] = nArray60;
        nArrayArray16[0] = nArrayArray17;
        int[][] nArrayArray18 = new int[5][];
        int[] nArray61 = new int[6];
        nArray61[5] = 1;
        nArrayArray18[0] = nArray61;
        int[] nArray62 = new int[7];
        nArray62[5] = 1;
        nArray62[6] = 1;
        nArrayArray18[1] = nArray62;
        nArrayArray18[2] = new int[]{1, 1, 1, 1, 1, 1, 1, 1};
        int[] nArray63 = new int[7];
        nArray63[5] = 1;
        nArray63[6] = 1;
        nArrayArray18[3] = nArray63;
        int[] nArray64 = new int[6];
        nArray64[5] = 1;
        nArrayArray18[4] = nArray64;
        nArrayArray16[1] = nArrayArray18;
        int[][] nArrayArray19 = new int[6][];
        int[] nArray65 = new int[8];
        nArray65[5] = 1;
        nArray65[6] = 1;
        nArray65[7] = 1;
        nArrayArray19[0] = nArray65;
        int[] nArray66 = new int[8];
        nArray66[5] = 1;
        nArray66[6] = 1;
        nArray66[7] = 1;
        nArrayArray19[1] = nArray66;
        nArrayArray19[2] = new int[]{1, 1, 1, 1, 1, 1, 1, 1};
        nArrayArray19[3] = new int[]{1, 1, 1, 1, 1, 1, 1, 1};
        int[] nArray67 = new int[8];
        nArray67[5] = 1;
        nArray67[6] = 1;
        nArray67[7] = 1;
        nArrayArray19[4] = nArray67;
        int[] nArray68 = new int[8];
        nArray68[5] = 1;
        nArray68[6] = 1;
        nArray68[7] = 1;
        nArrayArray19[5] = nArray68;
        nArrayArray16[2] = nArrayArray19;
        int[][] nArrayArray20 = new int[5][];
        nArrayArray20[0] = new int[]{1, 1, 1};
        int[] nArray69 = new int[4];
        nArray69[1] = 1;
        nArray69[2] = 1;
        nArray69[3] = 1;
        nArrayArray20[1] = nArray69;
        int[] nArray70 = new int[5];
        nArray70[2] = 1;
        nArray70[3] = 1;
        nArray70[4] = 1;
        nArrayArray20[2] = nArray70;
        int[] nArray71 = new int[4];
        nArray71[1] = 1;
        nArray71[2] = 1;
        nArray71[3] = 1;
        nArrayArray20[3] = nArray71;
        nArrayArray20[4] = new int[]{1, 1, 1};
        nArrayArray16[3] = nArrayArray20;
        int[][] nArrayArray21 = new int[2][];
        int[] nArray72 = new int[40];
        nArray72[0] = 1;
        nArray72[1] = 1;
        nArray72[2] = 1;
        nArray72[3] = 1;
        nArray72[4] = 1;
        nArray72[5] = 1;
        nArray72[6] = 1;
        nArray72[7] = 1;
        nArray72[8] = 1;
        nArray72[9] = 1;
        nArray72[20] = 1;
        nArray72[21] = 1;
        nArray72[22] = 1;
        nArray72[23] = 1;
        nArray72[24] = 1;
        nArray72[25] = 1;
        nArray72[26] = 1;
        nArray72[27] = 1;
        nArray72[28] = 1;
        nArray72[29] = 1;
        nArrayArray21[0] = nArray72;
        int[] nArray73 = new int[40];
        nArray73[10] = 1;
        nArray73[11] = 1;
        nArray73[12] = 1;
        nArray73[13] = 1;
        nArray73[14] = 1;
        nArray73[15] = 1;
        nArray73[16] = 1;
        nArray73[17] = 1;
        nArray73[18] = 1;
        nArray73[19] = 1;
        nArray73[30] = 1;
        nArray73[31] = 1;
        nArray73[32] = 1;
        nArray73[33] = 1;
        nArray73[34] = 1;
        nArray73[35] = 1;
        nArray73[36] = 1;
        nArray73[37] = 1;
        nArray73[38] = 1;
        nArray73[39] = 1;
        nArrayArray21[1] = nArray73;
        nArrayArray16[4] = nArrayArray21;
        int[][] nArrayArray22 = new int[2][];
        int[] nArray74 = new int[20];
        nArray74[0] = 1;
        nArray74[1] = 1;
        nArray74[2] = 1;
        nArray74[3] = 1;
        nArray74[4] = 1;
        nArray74[10] = 1;
        nArray74[11] = 1;
        nArray74[12] = 1;
        nArray74[13] = 1;
        nArray74[14] = 1;
        nArrayArray22[0] = nArray74;
        int[] nArray75 = new int[20];
        nArray75[5] = 1;
        nArray75[6] = 1;
        nArray75[7] = 1;
        nArray75[8] = 1;
        nArray75[9] = 1;
        nArray75[15] = 1;
        nArray75[16] = 1;
        nArray75[17] = 1;
        nArray75[18] = 1;
        nArray75[19] = 1;
        nArrayArray22[1] = nArray75;
        nArrayArray16[5] = nArrayArray22;
        nArrayArray16[6] = new int[][]{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1}};
        COIN_PATTERN = nArrayArray16;
        TOTAL_MISSILE_PTRNS = MISSILE_PATTERN.length;
        TOTOL_COIN_PTRNS = COIN_PATTERN.length;
        min_gap = Controller.DIS_W;
        max_gap = 2 * Controller.DIS_W;
        DEFAULT_SPEED = Controller.DIS_W / 45;
    }

    public World(XYRect rect) {
        super(rect, null);
        this.sprites = new Vector();
        this.obstacles = new Vector(20);
    }

    public void initEnvironment() {
        this.missileCounter = 60 + this.random.nextInt(250);
        this.floor = new Platform(new XYRect(0, Controller.DIS_H - Config.FLOORING.getHeight(), Controller.DIS_W, Config.FLOORING.getHeight()), false, Config.FLOORING, this);
        this.ceiling = new Platform(new XYRect(0, 0, Controller.DIS_W, Config.CEILING.getHeight()), false, Config.CEILING, this);
        this.ninja.setBase(this.floor);
        int type = OBS_ALL[this.random.nextInt(OBS_ALL.length)];
        Electrods electrod = new Electrods(2 * max_gap, this.ceiling.rect.y + (this.ceiling.rect.height >> 1), type, this);
        int g = Controller.DIS_H - (this.ceiling.rect.height >> 1) - (this.ceiling.rect.height >> 1) - electrod.rect.height;
        electrod.rect.y = type == 2 ? (this.random.nextInt(2) == 0 ? 0 : g) : this.random.nextInt(g);
        this.obstacles.addElement(electrod);
    }

    protected void draw(Graphics g) {
        g.drawImage(Config.BG, -this.dxLayer4, this.rect.height - Config.BG.getHeight(), 0);
        g.drawImage(Config.BG, Config.SCREEN_WIDTH - this.dxLayer4, this.rect.height - Config.BG.getHeight(), 0);
        this.ceiling.draw(g);
        this.floor.draw(g);
        int j = 0;
        while (j < this.sprites.size()) {
            ((Sprite)this.sprites.elementAt(j)).draw(g);
            ++j;
        }
        Enumeration en = this.obstacles.elements();
        while (en.hasMoreElements()) {
            Obstacles type = (Obstacles)en.nextElement();
            type.tick();
            type.draw(g);
        }
    }

    protected void tick() {
        if (this.shouldStop && this.speed > 0) {
            --this.speed;
            if (this.speed < 0) {
                this.speed = 0;
            }
        }
        this.shootMissile();
        this.updateScene();
        if (this.isAllMissileDestroyed() || this.missileCounter <= 30) {
            this.updateObstacleQueue();
        }
        this.floor.tick();
        this.ceiling.tick();
        this.moveWithSpeed(this.speed);
        this.detectCollisionAmongAttacableSprites();
        int j = 0;
        while (j < this.sprites.size()) {
            ((Sprite)this.sprites.elementAt(j)).tick();
            ++j;
        }
        if ((this.ninja.hasFallen() || !this.ninja.isAlive) && this.listener != null) {
            this.listener.gameOver(this.ninja.isAlive ? 1 : 0);
        }
    }

    private void shootMissile() {
        if (this.missileCounter > 0) {
            --this.missileCounter;
            return;
        }
        int ptrnIndex = this.random.nextInt(Controller.getController().getScore() < 2000 ? 7 : TOTAL_MISSILE_PTRNS);
        int h = MISSILE_PATTERN[ptrnIndex].length * Config.ROCKET[0].getHeight();
        int y = this.adjustedPatternPosition(h);
        this.insertObjects(2 * Controller.DIS_W, y, MISSILE_PATTERN[ptrnIndex], 9);
        this.missileCounter = 60 + this.random.nextInt(150);
    }

    private int adjustedPatternPosition(int ptrnHeight) {
        int y = this.ninja.rect.y + (this.ninja.rect.height - ptrnHeight >> 1);
        if (y + ptrnHeight > Controller.DIS_H - (this.floor.rect.height >> 1)) {
            y -= y + ptrnHeight - (Controller.DIS_H - (this.floor.rect.height >> 1));
        } else if (y < this.ceiling.rect.height >> 1) {
            y = this.ceiling.rect.height >> 1;
        }
        System.out.println("World.adjustedPatternPosition()........................y: " + y + "..............................pattern height: " + ptrnHeight);
        return y;
    }

    private void insertObjects(int x, int y, int[][] ptrn, int objType) {
        int i = 0;
        while (i < ptrn.length) {
            int j = 0;
            int x1 = x;
            while (j < ptrn[i].length) {
                if (ptrn[i][j] == 1) {
                    switch (objType) {
                        case 9: {
                            this.attack(x1, y, 1, 0, this.floor);
                            break;
                        }
                        case 10: {
                            ConsumableObstacle cobs = new ConsumableObstacle(x1, y, Config.COIN, 10, true, this);
                            this.obstacles.addElement(cobs);
                        }
                    }
                }
                switch (objType) {
                    case 9: {
                        x1 += Config.ROCKET[0].getWidth();
                        break;
                    }
                    case 10: {
                        x1 += Config.COIN[0].getWidth();
                    }
                }
                ++j;
            }
            switch (objType) {
                case 9: {
                    y += Config.ROCKET[0].getHeight();
                    break;
                }
                case 10: {
                    y += Config.COIN[0].getHeight();
                }
            }
            ++i;
        }
    }

    public void setShouldStop(boolean shouldStop) {
        this.shouldStop = shouldStop;
        this.speed = shouldStop ? 0 : DEFAULT_SPEED;
    }

    private void moveWithSpeed(int speed) {
        this.rect.x -= speed;
        Enumeration e = this.obstacles.elements();
        while (e.hasMoreElements()) {
            Obstacles obs = (Obstacles)e.nextElement();
            obs.moveWithSpeed(speed);
            obs.tick();
        }
    }

    private void updateScene() {
        this.dxLayer4 += this.speed;
        this.dxLayer4 %= Config.BG.getWidth();
    }

    public void setNinja(Runner sprite) {
        this.ninja = sprite;
        this.sprites.addElement(sprite);
    }

    public void addSprite(Sprite sprite) {
        if (sprite != null && !this.sprites.contains(sprite)) {
            this.sprites.addElement(sprite);
        }
    }

    public int getSpeed() {
        return this.speed;
    }

    public void addListener(WorldListener listener) {
        if (listener != null) {
            this.listener = listener;
        }
    }

    private boolean isAllMissileDestroyed() {
        int i = this.sprites.size() - 1;
        while (i >= 0) {
            if (this.sprites.elementAt(i) instanceof FireBall) {
                return false;
            }
            --i;
        }
        return true;
    }

    private void updateObstacleQueue() {
        Obstacles last = (Obstacles)this.obstacles.lastElement();
        int toss = this.random.nextInt(2);
        int gap = min_gap + this.random.nextInt(max_gap - min_gap);
        if (last.rect.x + last.rect.width < Controller.DIS_W) {
            switch (toss) {
                case 1: {
                    int ptrnIndex = this.random.nextInt(TOTOL_COIN_PTRNS);
                    int h = COIN_PATTERN[ptrnIndex].length * Config.COIN[0].getHeight();
                    int y = this.adjustedPatternPosition(h);
                    this.insertObjects(last.rect.x + gap, y, COIN_PATTERN[ptrnIndex], 10);
                    break;
                }
                default: {
                    int type = OBS_ALL[this.random.nextInt(OBS_ALL.length)];
                    Electrods electrod = new Electrods(last.rect.x + gap, this.ceiling.rect.y + (this.ceiling.rect.height >> 1), type, this);
                    electrod.rect.y = this.adjustedPatternPosition(electrod.rect.height);
                    if (type == 6) {
                        electrod.rect.y = this.random.nextInt(2) == 0 ? this.ceiling.rect.height >> 1 : Controller.DIS_H - (this.floor.rect.height >> 1);
                    }
                    this.obstacles.addElement(electrod);
                }
            }
        }
    }

    private void detectCollisionAmongAttacableSprites() {
        int j = 0;
        while (j < this.sprites.size()) {
            Sprite missile = (Sprite)this.sprites.elementAt(j);
            if (missile instanceof FireBall) {
                int i = 0;
                while (i < this.sprites.size()) {
                    Sprite s = (Sprite)this.sprites.elementAt(i);
                    if (!s.equals(missile) && s instanceof AttackableSprite && s.intersectWith(((FireBall)missile).getCollisionRect()) && ((AttackableSprite)((Object)s)).beingAttacked(missile)) {
                        ((AttackableSprite)((Object)missile)).beingAttacked(s);
                    }
                    ++i;
                }
            }
            ++j;
        }
    }

    public void attack(int x, int y, int inDirection, int weaponType, Sprite base) {
        FireBall fireBall = new FireBall(x, y, inDirection, weaponType, this);
        fireBall.setBase(base);
        this.sprites.addElement(fireBall);
    }

    public void removeSprite(Sprite sprite) {
        if (sprite != null) {
            if (sprite instanceof FireBall) {
                ++this.missileDodgeCount;
            } else if (sprite instanceof Electrods) {
                ++this.electrodDodgeCount;
            }
            this.sprites.removeElement(sprite);
        }
    }

    public Runner getNinja() {
        return this.ninja;
    }

    public int getShieldCollected() {
        return 0;
    }

    public int getMissileDodgeCount() {
        return this.missileDodgeCount;
    }

    public int getElectrodDodgeCount() {
        return this.electrodDodgeCount;
    }
}

