/*
 * Decompiled with CFR 0.152.
 */
package in.spicelabs.jpride.objects;

import in.spicelabs.jpride.common.Config;
import in.spicelabs.jpride.objects.PowerSprite;
import in.spicelabs.jpride.objects.Runner;
import in.spicelabs.jpride.objects.Sprite;
import in.spicelabs.jpride.objects.World;
import in.spicelabs.jpride.objects.WorldListener;
import in.spicelabs.jpride.objects.XYRect;
import javax.microedition.lcdui.Graphics;

public class Controller
implements WorldListener {
    public static int DIS_W = Config.SCREEN_WIDTH;
    public static int DIS_H = Config.SCREEN_HEIGHT;
    public static int MIN_JUMP_H = (int)((double)DIS_H * 0.04);
    public static int MAX_JUMP_H = (int)((double)DIS_H * 0.09);
    private static int BEGIN_CYCLE_RATE = 60;
    private static int SCORE_BONUS_FOR_ENEMY_DEFEAT = 1000;
    private static Controller controller;
    private Runner ninja;
    private World world;
    private boolean isGameOver;
    private int cycleRate = BEGIN_CYCLE_RATE;
    private int cycleCounter;
    private int score;
    private int duration;
    private boolean isPaused;
    private PowerSprite coin;
    private StringBuffer strHighScore = new StringBuffer("High Score: ");
    private int gameOverType;
    public boolean isKeepPropelling;

    private Controller() {
        int gap;
        int y = gap = 2;
        this.coin = new PowerSprite(Config.COIN, gap, y);
    }

    public void draw(Graphics g) {
        if (!this.isPaused) {
            ++this.score;
            this.duration += this.cycleRate;
            this.world.tick();
        }
        if (this.isKeepPropelling) {
            this.jump();
        }
        this.world.draw(g);
        this.coin.draw(g, " " + this.ninja.getCoins());
        g.setColor(0xFFFFFF);
        g.drawString(this.strHighScore.toString(), DIS_W - g.getFont().stringWidth(this.strHighScore.toString()), 0, 0);
        g.drawString("" + this.score, DIS_W - g.getFont().stringWidth("" + this.score), g.getFont().getHeight(), 0);
    }

    public static Controller getController() {
        if (controller == null) {
            controller = new Controller();
        }
        return controller;
    }

    public static int getWorldSpeed() {
        return Controller.controller.world.getSpeed();
    }

    public static int getDurationInSeconds() {
        return Controller.controller.duration / 1000;
    }

    public void startNewGame() {
        this.isGameOver = false;
        this.isPaused = false;
        this.score = 0;
        this.duration = 0;
        this.cycleRate = BEGIN_CYCLE_RATE;
        int x = DIS_W / 7;
        this.world = new World(new XYRect(0, 0, DIS_W, DIS_H));
        this.world.addListener(this);
        this.ninja = new Runner(x, 0, Config.NINJA_FRAMES, this.world);
        this.ninja.setCanConsume(true);
        this.world.setNinja(this.ninja);
        this.world.initEnvironment();
    }

    public void resumeGame() {
        this.ninja.resume();
        this.world.setShouldStop(false);
        this.isGameOver = false;
    }

    public void setPaused(boolean isPaused) {
        this.isPaused = isPaused;
    }

    public boolean isPaused() {
        return this.isPaused;
    }

    public int getScore() {
        return this.score;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setKeepPropelling(boolean isKeepPropelling) {
        this.isKeepPropelling = isKeepPropelling;
    }

    public void jump() {
        if (!this.isGameOver) {
            this.ninja.jumpWithVelocity(0, MIN_JUMP_H);
        }
    }

    public boolean isGameOver() {
        return this.isGameOver;
    }

    public void gameOver(int type) {
        this.gameOverType = type;
        this.isGameOver = true;
    }

    public void taskAchieved(int taskType) {
        if (taskType == 1001) {
            this.score += SCORE_BONUS_FOR_ENEMY_DEFEAT;
        }
    }

    public static boolean isOutOfWorld(Sprite sprite) {
        return !Controller.controller.world.intersectWith(sprite.rect);
    }

    public static int getCycleRate() {
        return Controller.controller.cycleRate;
    }

    public static void setCycleRate(int cycleRate) {
        Controller.controller.cycleRate = cycleRate;
    }

    public int getCoins() {
        return this.ninja.getCoins();
    }

    public void setCoins(int coins) {
        this.ninja.setCoins(coins);
    }

    public void setHighscore(long highscore) {
        this.strHighScore = new StringBuffer("Best: ");
        this.strHighScore.append(highscore);
    }

    public int getGameOverType() {
        return this.gameOverType;
    }
}

