/*
 * Decompiled with CFR 0.152.
 */
package com.twistfuture.general;

import com.twistfuture.Apps.TwistMidlet;
import com.twistfuture.Game.MainCanvas;
import com.twistfuture.app.GeneralFunction;
import com.twistfuture.general.AboutOrHelp;
import com.twistfuture.general.FBLikeCanvas;
import com.twistfuture.general.PrivacyPolicyForm;
import com.twistfuture.utility.Button;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MainMenu
extends Canvas
implements Button.ButtonCallback {
    private final Image mBackgroundImage;
    private final String[] menuString = new String[]{"play", "about", "help", "privacy", "more", "exit"};
    private final String[] gameString = new String[]{"normal", "double", "hell"};
    private final Button[] gameButton = new Button[this.gameString.length];
    private final Button[] menuButton = new Button[this.menuString.length];
    private final Button back;
    private final int menuBtnLength;
    private AboutOrHelp mAboutORHelp;
    private int mCurrentButtonSelected = 1;
    private boolean playPressed;
    private Image ninjaMode;
    private boolean btnPressedstatus;

    public MainMenu() {
        this.setFullScreenMode(true);
        Runtime.getRuntime().gc();
        this.mBackgroundImage = GeneralFunction.createImage("mainmenu/bg.png");
        this.ninjaMode = GeneralFunction.createImage("mainmenu/ninja mode.png");
        this.menuBtnLength = this.menuString.length;
        this.back = new Button(GeneralFunction.createImage("mainmenu/back.png"), GeneralFunction.createImage("mainmenu/back.png"), this.getWidth() - 50, this.getHeight() - 45, 9, this);
        this.back.SetCordinate(this.getWidth() - this.back.getWidth(), this.getHeight() - this.back.getHeight());
    }

    private void loadImage() {
        int YCordi;
        int XCordi;
        int i;
        for (i = 0; i < this.gameString.length; ++i) {
            this.gameButton[i] = new Button(GeneralFunction.createImage("mainmenu/" + this.gameString[i] + ".png"), 10, 10, i + this.menuString.length, this);
            XCordi = (this.getWidth() - this.gameButton[i].getWidth()) / 2;
            YCordi = (this.getHeight() - 260) / 3 * i + ((this.getHeight() - 260) / 3 - this.gameButton[i].getHeight()) / 2;
            this.gameButton[i].SetCordinate(XCordi, YCordi + 130);
        }
        for (i = 0; i < this.menuBtnLength; ++i) {
            this.menuButton[i] = new Button(GeneralFunction.createImage("mainmenu/" + this.menuString[i] + ".png"), 10, 10, i, this);
            XCordi = (this.getWidth() - this.menuButton[i].getWidth()) / 2;
            YCordi = (this.getHeight() - 120) / this.menuBtnLength * i + ((this.getHeight() - 120) / this.menuBtnLength - this.menuButton[i].getHeight()) / 2;
            this.menuButton[i].SetCordinate(XCordi, YCordi + 65);
        }
    }

    protected void showNotify() {
        super.showNotify();
        this.loadImage();
        TwistMidlet.mMidlet.unregisterDown();
        TwistMidlet.mMidlet.registerForUP(new TwistMidlet.Callback(){

            public void callRepaint(int x, int y, int width, int height) {
                MainMenu.this.repaint();
            }
        });
    }

    protected void hideNotify() {
        super.hideNotify();
        Runtime.getRuntime().gc();
    }

    protected void paint(Graphics g) {
        g.drawImage(this.mBackgroundImage, 0, 0, 0);
        TwistMidlet.mMidlet.paintAd(g);
        if (!this.playPressed) {
            for (int i = 0; i < this.menuBtnLength; ++i) {
                this.menuButton[i].paint(g);
            }
        } else {
            g.drawImage(this.ninjaMode, (this.getWidth() - this.ninjaMode.getWidth()) / 2, 90, 0);
            for (int i = 0; i < this.gameButton.length; ++i) {
                this.gameButton[i].paint(g);
            }
            this.back.paint(g);
        }
    }

    protected void pointerPressed(int x, int y) {
        if (!this.playPressed) {
            for (int i = 0; i < this.menuBtnLength; ++i) {
                this.menuButton[i].pointerPressed(x, y);
            }
        } else {
            if (!this.btnPressedstatus) {
                for (int i = 0; i < this.gameButton.length; ++i) {
                    if (!this.gameButton[i].pointerPressed(x, y)) continue;
                    this.btnPressedstatus = true;
                }
            }
            this.back.pointerPressed(x, y);
        }
        if (x < this.back.getX()) {
            TwistMidlet.mMidlet.adClicked(x, y);
        }
    }

    public void areaToRepaint(int xcordi, int ycordi, int width, int height) {
        this.repaint();
    }

    public void buttonClicked(int aButtonId) {
        Runtime.getRuntime().gc();
        switch (aButtonId) {
            case 0: {
                this.playPressed = true;
                this.btnPressedstatus = false;
                break;
            }
            case 1: {
                this.mAboutORHelp = new AboutOrHelp(AboutOrHelp.About);
                TwistMidlet.mDisplay.setCurrent((Displayable)this.mAboutORHelp);
                break;
            }
            case 2: {
                this.mAboutORHelp = new AboutOrHelp(AboutOrHelp.Help);
                TwistMidlet.mDisplay.setCurrent((Displayable)this.mAboutORHelp);
                break;
            }
            case 3: {
                new PrivacyPolicyForm().displayPrivacyPolicyForm();
                break;
            }
            case 4: {
                try {
                    TwistMidlet.mMidlet.platformRequest("http://store.ovi.com/publisher/Thinkink");
                }
                catch (ConnectionNotFoundException ex) {
                    ex.printStackTrace();
                }
                break;
            }
            case 5: {
                TwistMidlet.mDisplay.setCurrent((Displayable)new FBLikeCanvas());
                break;
            }
            case 6: {
                this.btnPressedstatus = true;
                TwistMidlet.mDisplay.setCurrent((Displayable)new MainCanvas(0));
                break;
            }
            case 7: {
                this.btnPressedstatus = true;
                TwistMidlet.mDisplay.setCurrent((Displayable)new MainCanvas(1));
                break;
            }
            case 8: {
                this.btnPressedstatus = true;
                TwistMidlet.mDisplay.setCurrent((Displayable)new MainCanvas(2));
                break;
            }
            case 9: {
                this.playPressed = false;
            }
        }
    }

    public void callRepaint(Image mCurrentAdImage) {
        this.repaint();
    }

    public void callRepaint(int xcordi, int ycordi, int width, int height) {
        this.repaint();
    }

    public void callRepaint() {
        this.repaint();
    }
}

