/*
 * Decompiled with CFR 0.152.
 */
package com.twistfuture.utility;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Button {
    private Image mImageUnpressed;
    private Image mImagePressed;
    private Image mImageTemp;
    private int mButtonId;
    private ButtonCallback mCallBack;
    private int mButtonXCordi;
    private int mButtonYCordi;

    public Button(Image pressImage, int xCordi, int ycordi, int buttonId, ButtonCallback callback) {
        this.mImagePressed = pressImage;
        this.mButtonXCordi = xCordi;
        this.mButtonYCordi = ycordi;
        this.mButtonId = buttonId;
        this.mCallBack = callback;
        this.mImageTemp = pressImage;
    }

    public Button(Image pressImage, Image unpressImage, int xCordi, int ycordi, int buttonId, ButtonCallback callback) {
        this.mImagePressed = pressImage;
        this.mImageUnpressed = unpressImage;
        this.mButtonXCordi = xCordi;
        this.mButtonYCordi = ycordi;
        this.mButtonId = buttonId;
        this.mCallBack = callback;
        this.mImageTemp = pressImage;
    }

    public boolean pointerPressed(int xCordi, int yCordi) {
        if (xCordi > this.mButtonXCordi && xCordi < this.mButtonXCordi + this.mImageTemp.getWidth() && yCordi > this.mButtonYCordi && yCordi < this.mButtonYCordi + this.mImageTemp.getHeight()) {
            if (this.mImageUnpressed == null) {
                this.mButtonXCordi += 5;
            } else {
                this.mImageTemp = this.mImageUnpressed;
            }
            this.mCallBack.callRepaint(this.mButtonXCordi, this.mButtonYCordi, this.mImageTemp.getWidth() + 5, this.mImageTemp.getHeight());
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(100L);
                        if (Button.this.mImageUnpressed == null) {
                            Button.this.mButtonXCordi = Button.this.mButtonXCordi - 5;
                        } else {
                            Button.this.mImageTemp = Button.this.mImagePressed;
                        }
                        Button.this.mCallBack.callRepaint(Button.this.mButtonXCordi, Button.this.mButtonYCordi, Button.this.mImageTemp.getWidth() + 5, Button.this.mImageTemp.getHeight());
                        Button.this.mCallBack.buttonClicked(Button.this.mButtonId);
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                }
            }).start();
            return true;
        }
        return false;
    }

    public void paint(Graphics g) {
        g.drawImage(this.mImageTemp, this.mButtonXCordi, this.mButtonYCordi, 0);
    }

    public void SetCordinate(int aXCordi, int aYCordi) {
        this.mButtonXCordi = aXCordi;
        this.mButtonYCordi = aYCordi;
    }

    public void setImage(Image image) {
        this.mImageTemp = image;
        this.mImagePressed = image;
    }

    public int getWidth() {
        return this.mImagePressed.getWidth();
    }

    public int getHeight() {
        return this.mImagePressed.getHeight();
    }

    public int getX() {
        return this.mButtonXCordi;
    }

    public int getY() {
        return this.mButtonYCordi;
    }

    public static interface ButtonCallback {
        public void callRepaint(int var1, int var2, int var3, int var4);

        public void buttonClicked(int var1);
    }
}

