/*
 * Decompiled with CFR 0.152.
 */
package com.twistfuture.Game;

import com.twistfuture.Apps.TwistMidlet;
import com.twistfuture.Game.DualGameManger;
import com.twistfuture.Game.ObstacleManger;
import com.twistfuture.Game.ScoreCanvas;
import com.twistfuture.Game.TripleGameManager;
import com.twistfuture.app.GeneralFunction;
import com.twistfuture.app.GeneralInfo;
import com.twistfuture.general.SoundManger;
import com.twistfuture.utility.Button;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class MainCanvas
extends Canvas
implements TwistMidlet.Callback,
Button.ButtonCallback {
    private int gameMode;
    private ObstacleManger obstacleManger;
    private TripleGameManager tripleManager;
    private DualGameManger manger;
    private final Button back;
    private long startTime;
    private float score;
    private Font font = Font.getFont((int)32, (int)0, (int)0);
    private static int adcount;
    private boolean backpressed;
    public static boolean threadStatus;

    public MainCanvas(int gameMode) {
        this.setFullScreenMode(true);
        this.gameMode = gameMode;
        if (gameMode == 0) {
            this.obstacleManger = new ObstacleManger(0, this.getHeight(), GeneralFunction.createImage("maincanvas/bg.png"), GeneralFunction.createImage("maincanvas/floor.png"), gameMode);
        } else if (gameMode == 1) {
            this.manger = new DualGameManger();
        } else {
            this.tripleManager = new TripleGameManager();
        }
        if (!GeneralInfo.ASHA501) {
            this.back = new Button(GeneralFunction.createImage("mainmenu/back.png"), GeneralFunction.createImage("mainmenu/back.png"), this.getWidth() - 30, this.getHeight() - 20, 0, this);
            this.back.SetCordinate(this.getWidth() - this.back.getWidth(), this.getHeight() - this.back.getHeight());
        } else {
            this.back = null;
            this.addCommand(new Command("back", 2, 0));
            this.setCommandListener(new CommandListener(){

                public void commandAction(Command c, Displayable d) {
                    MainCanvas.this.buttonClicked(0);
                }
            });
        }
    }

    protected void showNotify() {
        TwistMidlet.mMidlet.registerForUP(this);
        TwistMidlet.mMidlet.registerForDown(this);
    }

    public void paint(Graphics g) {
        if (this.gameMode == 0) {
            this.obstacleManger.paint(g);
        } else if (this.gameMode == 1) {
            this.manger.paint(g);
        } else {
            this.tripleManager.paint(g);
        }
        this.setScoreString(g);
        if (!GeneralInfo.ASHA501) {
            this.back.paint(g);
        }
    }

    private void setScoreString(Graphics g) {
        int index;
        String scoreString;
        String minuteStr = "00";
        String secondStr = "00";
        String milliSec = "000";
        g.setFont(this.font);
        g.setColor(0);
        if (this.score / 59.0f > 0.0f) {
            int minute = (int)this.score / 59;
            minuteStr = minute < 10 ? "0" + minute : "" + minute;
            int second = (int)this.score - minute * 60;
            secondStr = second < 10 ? "0" + second : "" + second;
        }
        if ((milliSec = (scoreString = "" + this.score).substring((index = scoreString.indexOf(46)) + 1, scoreString.length())).length() == 2) {
            milliSec = milliSec + "1";
        } else if (milliSec.length() == 1) {
            milliSec = milliSec + "10";
        } else if (milliSec.length() == 0) {
            milliSec = milliSec + "101";
        }
        String timsStr = minuteStr + "." + secondStr + "." + milliSec;
        g.drawString(timsStr, this.getWidth() - this.font.stringWidth(timsStr) - 10, 10, 0);
    }

    protected void pointerPressed(int x, int y) {
        if (!threadStatus) {
            this.startTime = System.currentTimeMillis();
            threadStatus = true;
            this.startThread();
        }
        if (this.gameMode == 0) {
            this.obstacleManger.pointerPressed(x, y);
        } else if (this.gameMode == 1) {
            this.manger.pointerPressed(x, y);
        } else {
            this.tripleManager.pointerPressed(x, y);
        }
        if (x < 200) {
            TwistMidlet.mMidlet.adClicked(x, y);
        }
        if (!GeneralInfo.ASHA501) {
            this.back.pointerPressed(x, y);
        }
    }

    protected void pointerDragged(int x, int y) {
        if (this.gameMode == 0) {
            this.obstacleManger.pointerDragged(x, y);
        }
    }

    public void buttonClicked(int buttonId) {
        if (buttonId == 0) {
            this.backpressed = true;
            TwistMidlet.mMidlet.startMainMenu();
        }
    }

    public void callRepaint(int x, int y, int width, int height) {
    }

    private void startThread() {
        new Thread(new Runnable(){

            public void run() {
                while (threadStatus) {
                    MainCanvas.this.calculateTime();
                    if (MainCanvas.this.gameMode == 0) {
                        MainCanvas.this.updateSingleMode();
                    } else if (MainCanvas.this.gameMode == 1) {
                        MainCanvas.this.updateDoubleMode();
                    } else {
                        MainCanvas.this.updateTripleMode();
                    }
                    GeneralFunction.sleepThread(50);
                    MainCanvas.this.repaint();
                }
                for (int count = 0; count < 10; ++count) {
                    if (MainCanvas.this.gameMode == 0) {
                        MainCanvas.this.obstacleManger.gameOver(count);
                    } else if (MainCanvas.this.gameMode == 1) {
                        if (MainCanvas.this.manger.getLowerGameManager().isCollisionStatus()) {
                            MainCanvas.this.manger.getLowerGameManager().gameOver(count);
                        }
                        if (MainCanvas.this.manger.getUpperGameManger().isCollisionStatus()) {
                            MainCanvas.this.manger.getUpperGameManger().gameOver(count);
                        }
                    } else {
                        if (MainCanvas.this.tripleManager.getFirstManger().isCollisionStatus()) {
                            MainCanvas.this.tripleManager.getFirstManger().gameOver(count);
                        }
                        if (MainCanvas.this.tripleManager.getSecondManger().isCollisionStatus()) {
                            MainCanvas.this.tripleManager.getSecondManger().gameOver(count);
                        }
                        if (MainCanvas.this.tripleManager.getThirdManger().isCollisionStatus()) {
                            MainCanvas.this.tripleManager.getThirdManger().gameOver(count);
                        }
                    }
                    MainCanvas.this.repaint();
                    GeneralFunction.sleepThread(60);
                }
                if (!MainCanvas.this.backpressed) {
                    SoundManger.playAudioSound.PlaySample("sounds/b3.mp3", false, 1, "audio/mpeg");
                    adcount++;
                    if (adcount % 3 == 0) {
                        TwistMidlet.mMidlet.showMiddleAd((Displayable)new ScoreCanvas(MainCanvas.this.score, MainCanvas.this.gameMode));
                    } else {
                        TwistMidlet.mDisplay.setCurrent((Displayable)new ScoreCanvas(MainCanvas.this.score, MainCanvas.this.gameMode));
                    }
                }
                ObstacleManger.initialpressed = 0;
            }
        }).start();
    }

    private void updateSingleMode() {
        this.obstacleManger.updateFloor();
        this.obstacleManger.updateFloor();
        this.obstacleManger.update();
    }

    private void updateDoubleMode() {
        this.manger.getUpperGameManger().updateFloor();
        this.manger.getLowerGameManager().updateFloor();
        this.manger.getLowerGameManager().update();
        this.manger.getUpperGameManger().update();
    }

    private void updateTripleMode() {
        this.tripleManager.getFirstManger().updateFloor();
        this.tripleManager.getSecondManger().updateFloor();
        this.tripleManager.getThirdManger().updateFloor();
        this.tripleManager.getFirstManger().update();
        this.tripleManager.getSecondManger().update();
        this.tripleManager.getThirdManger().update();
    }

    private void calculateTime() {
        long currentTime = System.currentTimeMillis();
        this.score = (float)(currentTime - this.startTime) / 1000.0f;
    }
}

