/*
 * Decompiled with CFR 0.152.
 */
package com.twistfuture.utility;

import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;

public class PlayAudioSound
implements PlayerListener {
    public static final String Format_Type_MP3 = "audio/mpeg";
    private int mAudio_File_Id;
    private String mFile_Resource_Path;
    private final CallBack mCallBack;
    private Player mPlayer = null;

    public PlayAudioSound(CallBack callback) {
        this.mCallBack = callback;
    }

    public void playerUpdate(Player player, String event, Object eventData) {
        if (event.equals("endOfMedia") && this.mCallBack != null) {
            this.mCallBack.FileEndReachOfMedia(this.mAudio_File_Id);
        }
    }

    public void PlaySample(String filename, boolean aIsLoopingOn, int PlayerNumber, String fileformat) {
        boolean execute = true;
        if (this.mFile_Resource_Path != null) {
            execute = this.mFile_Resource_Path.compareTo(filename) != 0;
        }
        if (execute) {
            this.stopAll();
            this.mFile_Resource_Path = filename;
            this.mAudio_File_Id = PlayerNumber;
            InputStream stream = this.getClass().getResourceAsStream("/" + filename);
            try {
                this.mPlayer = Manager.createPlayer((InputStream)stream, (String)Format_Type_MP3);
                if (aIsLoopingOn) {
                    this.mPlayer.setLoopCount(100);
                }
                this.mPlayer.realize();
                this.mPlayer.addPlayerListener((PlayerListener)this);
                this.mPlayer.start();
            }
            catch (Exception ex) {}
        } else if (this.mPlayer != null) {
            try {
                this.mPlayer.setMediaTime(0L);
                this.mPlayer.start();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    private static synchronized void stop(Player player) {
        if (player.getState() == 400) {
            try {
                player.stop();
            }
            catch (MediaException mediaException) {
                // empty catch block
            }
        }
        player.deallocate();
        player.close();
        player = null;
    }

    public void stopAll() {
        if (this.mPlayer != null) {
            PlayAudioSound.stop(this.mPlayer);
            this.mPlayer = null;
            this.mFile_Resource_Path = null;
        }
    }

    public static interface CallBack {
        public void FileEndReachOfMedia(int var1);
    }
}

