/*
 * Decompiled with CFR 0.152.
 */
package STH2P1_S40P1;

import STH2P1_S40P1.Constants;
import STH2P1_S40P1.Debug;
import STH2P1_S40P1.Device;
import STH2P1_S40P1.DeviceImage;
import STH2P1_S40P1.DeviceSound;
import STH2P1_S40P1.FontMgr;
import STH2P1_S40P1.GameWorld;
import STH2P1_S40P1.GluGMGDemo;
import STH2P1_S40P1.InputString;
import STH2P1_S40P1.Menu;
import STH2P1_S40P1.ResourceMaster;
import STH2P1_S40P1.STH2P1_S40P1;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;

public class Engine
extends Device
implements Debug,
Runnable,
CommandListener {
    private static boolean resumeSound;
    public static boolean handleEvent;
    public static boolean running;
    public static boolean hideNotify;
    public static long lastTick;
    public static final int EVENT_NONE = 0;
    public static final int EVENT_FORCE_SOUND = 1;
    public static final int EVENT_SHOW_PAUSE_SCREEN = 2;
    public static int lastSound;
    public static boolean vibrateOn;
    public static int soundOn;
    private GameWorld gameWorld;
    public static Display display;
    public static STH2P1_S40P1 parent;
    public static Engine instance;
    public static Random random;
    public static int tick;
    private int logicCounter;
    public static Command commandSoft1;
    public static Command commandSoft2;
    public static final int GS_UNUSED = -1;
    public static final int GS_INIT_APP = 0;
    public static final int GS_LANGUAGE = 1;
    public static final int GS_SPLASH = 2;
    public static final int GS_LOADING = 3;
    public static final int GS_PAUSE = 4;
    public static final int GS_BRAND = 5;
    public static final int GS_DEMO_OVER = 6;
    public static final int GS_MENU = 10;
    public static final int GS_COMMUNICATING = 11;
    public static final int GS_INPUT = 20;
    public static final int GS_AUDIO = 50;
    public static final int GS_INGAME = 100;
    public static int state;
    public static int pauseState;
    private static boolean isPainting;
    private static final int[][] TEXT_BRANDS;
    private static final int NUM_BRANDS;
    private static final int UP_ARROW_Y_SHIFT = 0;
    private static final int optionsYShift = 0;
    private static final int DOWN_ARROW_Y_SHIFT = 0;
    private static final int UP_DOWN_ARROW_X_SHIFT = 0;
    private static final int D_MENU_GAP_HEIGHT = 0;
    private int debugTick;
    private int debugPaint;
    private long debugStartFPSTime;
    private int debugFramesRendered;
    private int debugAvgFPS;
    private static final int FPS_RECALC = 6;
    private static int garbageCollectCounter;
    private static boolean debugStepByStep_stopped;
    private static boolean debugStepByStep_stopOnNextFrame;
    static String trace2;
    public static int soundOld;
    public static boolean changeSound;
    public static boolean ingamemenu;
    private DeviceImage imgBrand;
    private static final int BRAND_DELAY = 2000;
    private static boolean baseResourcesSectionLoaded;
    public int menuCursor;
    private int arrowHighlight;
    private static final int FRAME_ARROW_L = 0;
    private static final int FRAME_ARROW_R = 2;
    private static final int FLAG_ENGLISH = 0;
    private static final int FLAG_FRENCH = 1;
    private static final int FLAG_GERMAN = 2;
    private static final int FLAG_ITALIAN = 3;
    private static final int FLAG_SPANISH = 4;
    private static final int NUMBER_OF_LANGUAGES = 2;
    private static int langSelected;
    public static boolean reverseTooltips;
    private static final int TOOLTIP_BACK = 1;
    private static final int TOOLTIP_OK = 2;
    private static final int TOOLTIP_EXIT = 4;
    private static final int TOOLTIP_YES = 8;
    private static final int TOOLTIP_NO = 16;
    private static final int TOOLTIP_START = 32;
    private static final int TOOLTIP_GETIT = 64;
    private static final int TOOLTIP_MENU = 128;
    private static final int IMG_OK = 0;
    private static final int IMG_BACK = 1;
    private static final int IMG_ARROW_DOWN = 2;
    private static final int IMG_ARROW_UP = 3;
    private static final int IMG_PRESS = 6;
    private static final int IMG_DELETE = 7;
    private static final int IMG_TRASH = 8;
    private static int menuItemHeight;
    private static DeviceImage img_title;
    private static DeviceImage[][] img_uiArrows;
    public static DeviceImage img_backicon;
    static Menu menuCurrent;
    static Menu menuMain;
    static Menu menuIngame;
    static Menu menuInGameSettings;
    static Menu menuSettings;
    static Menu menuExit;
    static Menu menuScores;
    static Menu menuBackToMenuConfirmation;
    private Menu menuStageSelect;
    private Menu menuHowToPlay;
    private int menuId;
    private int menuOptions;
    private int menuHeight;
    private int menuDrawStart;
    private int menuDrawEnd;
    public static final int MENU_MAX_OPTIONS = 1;
    private static int runCount;
    public static final String RMS_NAME = "SONIC";
    public static final int RMS_SETTINGS = 0;
    public static String[] text;
    final String[] _mloading = new String[]{"NACITA SE", "\u0417\u0410\u0413\u0420\u0423\u0417\u041a\u0410", "CARICA...", "LADEN", "CARGANDO"};
    private boolean displayDebugInfo;
    public static String trace;
    private static int debugMsgTop;
    private static String[] debugMsgs;
    private static int keysPressed;
    public static int keyLatch;
    public static int keyUnmapped;
    public static long gameSuspendedTimeMillis;

    public Engine(STH2P1_S40P1 sTH2P1_S40P1) {
        parent = sTH2P1_S40P1;
        instance = this;
        display = Display.getDisplay((MIDlet)sTH2P1_S40P1);
        display.setCurrent((Displayable)this);
        Thread thread = new Thread(this);
        thread.start();
    }

    public void setCommandSoftkey(int n, String string) {
        if (n == 0) {
            if (commandSoft1 != null) {
                this.removeCommand(commandSoft1);
            }
            commandSoft1 = null;
            commandSoft1 = new Command(string, 1, 0);
            this.addCommand(commandSoft1);
        } else {
            if (commandSoft2 != null) {
                this.removeCommand(commandSoft2);
            }
            commandSoft2 = null;
            commandSoft2 = new Command(string, 1, 0);
            this.addCommand(commandSoft2);
        }
    }

    public void run() {
        running = true;
        state = 0;
        while (running) {
            long l = System.currentTimeMillis();
            try {
                long l2;
                if (handleEvent) {
                    Engine.handleEvent();
                }
                if (!hideNotify) {
                    Device.deviceTick();
                    this.tick();
                    Engine.doRepaint();
                }
                if ((l2 = System.currentTimeMillis() - l) < 10L) {
                    Thread.sleep(60L - l2);
                    continue;
                }
                Thread.sleep(50L);
            }
            catch (Exception exception) {}
        }
        Engine.soundFunction(1);
        parent.destroyApp(true);
        parent.notifyDestroyed();
    }

    private void tick() {
        try {
            DeviceSound.update();
            switch (state) {
                case 100: {
                    GameWorld.tick();
                    break;
                }
                case 5: {
                    this.tickBrand(false);
                    break;
                }
                case 10: {
                    this.tickMenu();
                    break;
                }
                case 50: {
                    this.tickAudioSelect();
                    break;
                }
                case 1: {
                    this.tickLanguageSelect();
                    break;
                }
                case 0: {
                    this.initApp();
                    break;
                }
                case 2: {
                    this.tickSplash();
                    break;
                }
                case 6: {
                    this.tickDemoOver();
                    if (GluGMGDemo.mDemo != 1) break;
                    this.tickMenu(false);
                    break;
                }
                case 4: {
                    if (!Engine.hasAnyKeyPressed()) break;
                    state = pauseState;
                    Engine.debugWrite("setting state to " + state);
                    if (state != 100) break;
                    Engine.debugWrite("resuming gameworld" + System.currentTimeMillis() / 1000L);
                    long l = System.currentTimeMillis() - gameSuspendedTimeMillis;
                    GameWorld.resume(l);
                    break;
                }
            }
            ++tick;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void paint(Graphics graphics) {
        try {
            switch (state) {
                case 100: {
                    GameWorld.paint(graphics);
                    break;
                }
                case 5: {
                    this.paintBrand(graphics);
                    break;
                }
                case 10: {
                    this.paintMenu(graphics);
                    break;
                }
                case 50: {
                    this.paintAudioSelect(graphics);
                    break;
                }
                case 1: {
                    this.paintLanguageSelect(graphics);
                    break;
                }
                case 2: {
                    this.paintSplash(graphics);
                    break;
                }
                case 6: {
                    Engine.cls(graphics, -15204230);
                    Engine.fillStatusArea(graphics, 0, 0, 128, 25);
                    Engine.fillStatusArea(graphics, 0, 135, 128, 25);
                    this.paintTooltips(graphics, (GluGMGDemo.mDemo == 2 ? 64 : 0) | (GluGMGDemo.demoQuit ? 4 : 128));
                    if (GluGMGDemo.mDemo == 1) {
                        this.paintMenu(graphics, false);
                        break;
                    }
                    GluGMGDemo.paintDemoOver(graphics);
                    break;
                }
                case 20: {
                    Engine.cls(graphics, 0);
                    InputString.paintInputString(graphics, 2, 160 - FontMgr.lineHeight[1] >> 1);
                    break;
                }
                case 3: {
                    Engine.cls(graphics, 0);
                    FontMgr.drawString(0, graphics, text == null ? this._mloading[langSelected] : text[20], 64, 160 - FontMgr.lineHeight[0] >> 1, 17);
                    break;
                }
                case 4: {
                    Engine.cls(graphics, 0);
                    FontMgr.drawString(0, graphics, text[21], 64, 160 - FontMgr.lineHeight[0] >> 1, 17);
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initApp() throws Exception {
        this.setBackLight(true);
        trace2 = "fonts";
        FontMgr.realise(0);
        FontMgr.realise(1);
        trace2 = "loadScn";
        this.paintLoading();
        trace2 = "tips";
        Engine.loadMenuResources();
        trace2 = "snd";
        Engine.soundFunction(0);
        trace2 = "jadPrm";
        String string = Engine.getJadValue("ms-skPos");
        if (string != null) {
            reverseTooltips = string.equals("1");
        }
        GluGMGDemo.init();
        trace2 = "rms";
        this.loadRMS(0);
        ++runCount;
        this.setLanguageSelect();
    }

    public void initGameWorld(int n, int n2) {
        Engine.soundFunction(1);
        this.paintLoading();
        this.unloadMenuResources();
        this.imgBrand = null;
        System.gc();
        try {
            GameWorld.abandonCurrentGame();
            GameWorld.loadLevel(n, n2, GameWorld.levelLoadState);
            if (!hideNotify) {
                GameWorld.tick();
            }
        }
        catch (Exception exception) {
            Engine.debugWrite("ex in loadLevel: " + exception.toString(), false);
        }
        Engine.resetKeyBuffers();
        state = 100;
    }

    private static void loadMenuResources() {
        try {
            img_title = new DeviceImage(0, "title");
            if (img_backicon == null) {
                img_backicon = new DeviceImage(1, "backicon");
            }
            img_uiArrows = Engine.loadSprite(5, 6, 7, -1);
        }
        catch (Exception exception) {
            Engine.debugWrite("Engine.returnFromGameWorld: " + exception.toString(), false);
            exception.printStackTrace();
        }
    }

    private void unloadMenuResources() {
        img_title = null;
        img_uiArrows = null;
    }

    public void returnFromGameWorld(boolean bl) {
        if (!ingamemenu) {
            // empty if block
        }
        Engine.resetKeyBuffers();
        if (bl) {
            this.setMenu(menuIngame);
            ingamemenu = true;
        } else {
            GameWorld.unloadResources(0);
            Engine.loadMenuResources();
            if (GluGMGDemo.mDemo > 0) {
                this.setDemoOver();
            } else {
                this.setMenu(menuMain);
                ingamemenu = false;
            }
        }
        Engine.menuCurrent.cursor = 0;
        this.menuCursor = 0;
        this.menuStageSelect.cursor = 0;
        Engine.soundFunction(1);
        DeviceSound.curSoundIndex = 0;
        if (!bl && !ingamemenu && soundOn != 0) {
            Engine.soundFunction(3, 0);
        }
    }

    private void returnToGameWorld() {
        this.unloadMenuResources();
        Engine.resetKeyBuffers();
        keysPressed = 0;
        long l = System.currentTimeMillis() - gameSuspendedTimeMillis;
        GameWorld.resume(l);
        GameWorld.repaintHud();
        state = 100;
        GameWorld.setZoneMusic();
        ingamemenu = false;
    }

    private void setBrand() {
        this.menuCursor = 0;
        Engine.resetKeyBuffers();
        state = 5;
        this.tickBrand(true);
    }

    private void closeBrand() {
        Engine.soundFunction(3, 0);
        if (soundOn == 0) {
            Engine.soundFunction(1);
        }
        this.imgBrand = null;
    }

    private void tickBrand(boolean bl) {
        boolean bl2 = false;
        if ((int)System.currentTimeMillis() - this.logicCounter > 2000 || bl) {
            try {
                this.imgBrand = null;
                String[] stringArray = new String[]{"/sega_splash.png", "/rockpool_splash.png", ""};
                byte[] byArray = ResourceMaster.getResourceFromJar(stringArray[this.menuCursor]);
                if (byArray != null) {
                    this.imgBrand = new DeviceImage(byArray, "brand");
                }
                if (++this.menuCursor == NUM_BRANDS + 1) {
                    bl2 = true;
                }
                if (GluGMGDemo.mDevCreditDisable && this.menuCursor == 2 && ++this.menuCursor == NUM_BRANDS + 1) {
                    bl2 = true;
                }
                this.logicCounter = (int)System.currentTimeMillis();
            }
            catch (Exception exception) {
                bl2 = true;
            }
        }
        if (bl2) {
            Engine.resetKeyBuffers();
            this.closeBrand();
            this.setMenu(menuMain);
        }
    }

    private void paintBrand(Graphics graphics) {
        int n = this.menuCursor - 1;
        Engine.cls(graphics, 0);
        graphics.setColor(Constants.COLORS_BRAND_BG[n]);
        graphics.fillRect(0, 0, 128, 160);
        if (n != 2) {
            if (this.imgBrand != null) {
                this.imgBrand.drawImageClipStack(graphics, 128 - this.imgBrand.width >> 1, 160 - this.imgBrand.height >> 1);
            }
        } else {
            int[] nArray = TEXT_BRANDS[n];
            int n2 = nArray.length;
            int n3 = 80 - (8 + (n2 - 1) * 12 >> 1);
            int n4 = 0;
            int n5 = n3;
            while (n4 < n2) {
                Engine.paintBorderedString(graphics, text[nArray[n4]], 64, n5, 17, Constants.COLORS_BRAND_TEXT[n], Constants.COLORS_BRAND_BORDER[n]);
                ++n4;
                n5 += 12;
            }
        }
    }

    public static void cls(Graphics graphics, int n) {
        graphics.setColor(n);
        graphics.fillRect(0, 0, 128, 160);
    }

    private void setDemoOver() {
        if (GluGMGDemo.mDemo == 1) {
            this.setMenu(Engine.createForm(GluGMGDemo.getText((byte)6), GluGMGDemo.STRING_DEMO_OVER_MSG[GluGMGDemo._LOCALE], null, menuMain));
        }
        this.menuCursor = 0;
        state = 6;
        Engine.resetKeyBuffers();
    }

    private void tickDemoOver() {
        if (Engine.key(64) && GluGMGDemo.mDemo == 2) {
            GluGMGDemo.platRequest(GluGMGDemo.mDemoURL);
            this.exit();
        }
        if ((keyLatch & 0x80) != 0) {
            if (GluGMGDemo.demoQuit) {
                this.exit();
            } else {
                this.setMenu(menuMain);
            }
        }
    }

    private void setSoundEnable() {
        state = 50;
    }

    private void setSplash() {
        Engine.soundFunction(3, 0);
        if (soundOn == 0) {
            Engine.soundFunction(1);
        }
        Engine.resetKeyBuffers();
        state = 2;
    }

    private void tickSplash() {
        if (Engine.hasAnyKeyPressed()) {
            this.closeSplash();
            this.setMenu(menuMain);
        }
    }

    private void paintSplash(Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(0, 0, 128, 160);
        FontMgr.drawString(0, graphics, "PUT SPLASH HERE", 64, 0, 17);
        if ((tick & 4) != 0) {
            FontMgr.drawString(0, graphics, text[21], 64, 160 - (FontMgr.lineHeight[0] << 1), 17);
        }
    }

    private void closeSplash() {
    }

    private void setLanguageSelect() {
        this.paintLoading();
        this.menuCursor = 0;
        state = 1;
    }

    private void paintAudioSelect(Graphics graphics) {
        String[] stringArray = new String[]{"Povolit zvuk?", "\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0437\u0432\u0443\u043a?", "Attivare Audio?", "Erlauben Sie Ton?", "\u00bfPermitir Sonido?"};
        String[] stringArray2 = new String[]{"Ano", "\u0414\u0430", "S\u00ec", "Ja", "S\u00ed"};
        String[] stringArray3 = new String[]{"Ne", "\u041d\u0435\u0442", "No", "Nein", "No"};
        Font font = Font.getFont((int)64, (int)0, (int)8);
        int n = font.getHeight();
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, 128, 160);
        int n2 = 32;
        int n3 = 32;
        graphics.setColor(0x505050);
        graphics.fillRoundRect(n2 - 1, n3 - 1, 66, 66, 16, 16);
        graphics.setColor(0xFFFFFF);
        graphics.fillRoundRect(n2, n3, 64, 64, 16, 16);
        graphics.setColor(22708);
        graphics.fillRoundRect(n2 + 2, n3 + 2, 60, 60, 16, 16);
        graphics.setColor(0x505050);
        graphics.fillArc(n2 + 12, (n3 += 2) + 36, 16, 16, 0, 360);
        graphics.fillArc(n2 + 36, n3 + 32, 16, 16, 0, 360);
        graphics.fillRect(n2 + 24, n3 + 12, 4, 34);
        graphics.fillRect(n2 + 24, n3 + 12, 24, 4);
        graphics.fillRect(n2 + 48, n3 + 12, 4, 26);
        graphics.setColor(0xFFFFFF);
        graphics.fillArc((n2 -= 2) + 12, (n3 -= 2) + 36, 16, 16, 0, 360);
        graphics.fillArc(n2 + 36, n3 + 32, 16, 16, 0, 360);
        graphics.fillRect(n2 + 24, n3 + 12, 4, 34);
        graphics.fillRect(n2 + 24, n3 + 12, 24, 4);
        graphics.fillRect(n2 + 48, n3 + 12, 4, 26);
        graphics.setFont(font);
        graphics.setColor(0);
        int n4 = graphics.getFont().stringWidth(stringArray[langSelected]);
        graphics.drawString(stringArray[langSelected], 128 - n4 >> 1, n3 += 72, 0);
        n3 = 160 - n - 3;
        graphics.setColor(0);
        if (reverseTooltips) {
            graphics.drawString(stringArray3[langSelected], 4, n3, 0);
            graphics.drawString(stringArray2[langSelected], 128 - graphics.getFont().stringWidth(text[17]) - 4, n3, 0);
        } else {
            graphics.drawString(stringArray2[langSelected], 4, n3, 0);
            graphics.drawString(stringArray3[langSelected], 128 - graphics.getFont().stringWidth(text[18]) - 4, n3, 0);
        }
    }

    private void paintLanguageSelect(Graphics graphics) {
        int n;
        String[] stringArray = new String[]{"\u010cesk\u00fd", "\u0420\u0443\u0441\u0441\u043a\u0438\u0439", "Italiano", "Deutsch", "Espa\u00f1ol"};
        String[] stringArray2 = new String[]{"Vybrat", "\u0412\u044b\u0431\u0440\u0430\u0442\u044c", "Seleziona", "W\u00e4hlen", "Selec."};
        String[] stringArray3 = new String[]{"Ukoncit", "\u0412\u044b\u0445\u043e\u0434", "Esci", "Ende", "Salir"};
        Font font = Font.getFont((int)64, (int)0, (int)8);
        int n2 = font.getHeight();
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, 128, 160);
        int n3 = 8;
        int n4 = 128 - (n3 + n3);
        int n5 = n = 40;
        graphics.setFont(font);
        int n6 = 0;
        int n7 = 1;
        for (int i = n6; i <= n7; ++i) {
            String string = stringArray[i];
            int n8 = graphics.getFont().stringWidth(string);
            if (this.menuCursor == i) {
                graphics.setColor(0);
                n5 = n - 3;
                graphics.setColor(0x505050);
                graphics.fillRoundRect(n3, n5, n4, n2 + 6, 16, 16);
                graphics.setColor(0xFFFFFF);
                graphics.fillRoundRect(n3 + 1, n5 + 1, n4 - 2, n2 + 4, 16, 16);
                graphics.setColor(22708);
                graphics.fillRoundRect(n3 + 2, n5 + 2, n4 - 4, n2 + 2, 16, 16);
                graphics.setColor(0xFFFF00);
            } else {
                graphics.setColor(0);
            }
            int n9 = 0;
            graphics.drawString(string, 128 - n8 >> 1, n + n9, 0);
            n += n2 + 4;
        }
        n = 160 - n2 - 3;
        graphics.setColor(0);
        if (reverseTooltips) {
            graphics.drawString(stringArray3[this.menuCursor], 4, n, 0);
            graphics.drawString(stringArray2[this.menuCursor], 128 - graphics.getFont().stringWidth(stringArray2[this.menuCursor]) - 4, n, 0);
        } else {
            graphics.drawString(stringArray2[this.menuCursor], 4, n, 0);
            graphics.drawString(stringArray3[this.menuCursor], 128 - graphics.getFont().stringWidth(stringArray3[this.menuCursor]) - 4, n, 0);
        }
    }

    private void tickAudioSelect() {
        if (Engine.key(16) || Engine.key(64)) {
            if (soundOn == 0) {
                soundOn = 2;
            }
            this.initSettingsMenu();
            this.setBrand();
        } else if (Engine.key(128)) {
            soundOn = 0;
            this.initSettingsMenu();
            this.setBrand();
        }
    }

    private void tickLanguageSelect() {
        if (this.arrowHighlight > 0) {
            --this.arrowHighlight;
        } else if (this.arrowHighlight < 0) {
            ++this.arrowHighlight;
        }
        if (Engine.key(1)) {
            this.menuCursor = (this.menuCursor + 1) % 2;
            this.arrowHighlight = 2;
        } else if (Engine.key(2)) {
            this.menuCursor = (this.menuCursor + 1) % 2;
            this.arrowHighlight = -2;
        } else if (Engine.key(128)) {
            this.exit();
        } else if (Engine.key(16) || Engine.key(64)) {
            langSelected = this.menuCursor;
            GluGMGDemo._LOCALE = (byte)langSelected;
            this.initLanguage(this.menuCursor == 0 ? "lang_en.dat" : "lang_fr.dat");
            this.setSoundEnable();
        }
    }

    private void initLanguage(String string) {
        this.paintLoading();
        trace2 = "initlang_txt";
        Engine.initText("/" + string);
        try {
            Engine.deviceFunction(1, text[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        trace2 = "initlang_hs";
        trace2 = "initlang_menus";
        this.initMenus();
    }

    private void paintTooltips(Graphics graphics, int n) {
        int n2 = 2;
        int n3 = 126;
        int n4 = 158;
        if (reverseTooltips) {
            if ((n & 1) != 0) {
                Engine.paintBorderedString(graphics, 22, n2, n4, 36);
            }
            if ((n & 4) != 0) {
                Engine.paintBorderedString(graphics, 9, n2, n4, 36);
            }
            if ((n & 2) != 0) {
                Engine.paintBorderedString(graphics, 19, n3, n4, 40);
            }
            if ((n & 8) != 0) {
                Engine.paintBorderedString(graphics, 17, n3, n4, 40);
            }
            if ((n & 0x10) != 0) {
                Engine.paintBorderedString(graphics, 18, n2, n4, 36);
            }
            if ((n & 0x20) != 0) {
                Engine.paintBorderedString(graphics, GluGMGDemo.getText((byte)2), n3, n4, 40);
            }
            if ((n & 0x40) != 0) {
                Engine.paintBorderedString(graphics, GluGMGDemo.getText((byte)3), n3, n4, 40);
            }
            if ((n & 0x80) != 0) {
                Engine.paintBorderedString(graphics, GluGMGDemo.getText((byte)4), n2, n4, 36);
            }
        } else {
            if ((n & 1) != 0) {
                Engine.paintBorderedString(graphics, 22, n3, n4, 40);
            }
            if ((n & 4) != 0) {
                Engine.paintBorderedString(graphics, 9, n3, n4, 40);
            }
            if ((n & 2) != 0) {
                Engine.paintBorderedString(graphics, 19, n2, n4, 36);
            }
            if ((n & 8) != 0) {
                Engine.paintBorderedString(graphics, 17, n2, n4, 36);
            }
            if ((n & 0x10) != 0) {
                Engine.paintBorderedString(graphics, 18, n3, n4, 40);
            }
            if ((n & 0x20) != 0) {
                Engine.paintBorderedString(graphics, GluGMGDemo.getText((byte)2), n2, n4, 36);
            }
            if ((n & 0x40) != 0) {
                Engine.paintBorderedString(graphics, GluGMGDemo.getText((byte)3), n2, n4, 36);
            }
            if ((n & 0x80) != 0) {
                Engine.paintBorderedString(graphics, GluGMGDemo.getText((byte)4), n3, n4, 40);
            }
        }
    }

    private void paintLoading() {
        int n = state;
        state = 3;
        Engine.doRepaint();
    }

    private void initMenus() {
        menuItemHeight = FontMgr.lineHeight[1];
        String[] stringArray = new String[]{text[17], text[18]};
        String[] stringArray2 = new String[]{text[18], text[17]};
        String[] stringArray3 = GluGMGDemo.mDemo > 0 || GluGMGDemo.mUpsell > 0 ? GluGMGDemo.getMainMenu() : new String[]{text[5], text[6], text[7], text[8]};
        if (GluGMGDemo.mDemo > 0) {
            GluGMGDemo.setExitDemoText();
        }
        String[] stringArray4 = new String[]{text[23], text[7], text[24]};
        menuMain = new Menu(null, stringArray3, 0);
        menuExit = langSelected == 4 ? new Menu("\u00bf" + text[9] + "?", stringArray2, 1) : new Menu(text[9] + "?", stringArray2, 1);
        this.menuStageSelect = new Menu(text[5], null, 3);
        menuIngame = new Menu(null, stringArray4, 1);
        menuBackToMenuConfirmation = langSelected == 4 ? new Menu("\u00bf" + text[24] + "?", stringArray2, 1) : new Menu(text[24] + "?", stringArray2, 1);
        this.menuHowToPlay = Engine.createForm(text[6], text[36], menuMain, null);
        this.initSettingsMenu();
    }

    private void initSettingsMenu() {
        String[] stringArray = null;
        stringArray = new String[]{text[10 + soundOn], text[vibrateOn ? 14 : 15]};
        menuSettings = new Menu(text[7], stringArray, 1);
        menuInGameSettings = new Menu(text[7], stringArray, 1);
    }

    private void setMenu(Menu menu) {
        if (menu == null) {
            return;
        }
        if (menu.type != 0 && menuCurrent != null && menu != Engine.menuCurrent.previous) {
            menu.previous = menuCurrent;
        }
        menuCurrent = menu;
        if (menu.type == 2 || menu.type == 1) {
            this.menuOptions = Math.min(menuCurrent.length(), 3);
            int n = Engine.menuCurrent.title == null ? 0 : 1;
            this.menuHeight = (this.menuOptions - n) * (FontMgr.lineHeight[1] + 2) - 2;
        } else {
            this.menuOptions = Math.min(menuCurrent.length(), 1);
            this.menuHeight = this.menuOptions * (menuItemHeight + 2) - 2;
        }
        this.menuCursor = Engine.menuCurrent.cursor;
        this.updateMenuDrawPoints();
        Engine.resetKeyBuffers();
        state = 10;
    }

    private void paintMenu(Graphics graphics) {
        this.paintMenu(graphics, true);
    }

    private void paintMenu(Graphics graphics, boolean bl) {
        int n;
        if (bl) {
            Engine.cls(graphics, -15204230);
            Engine.fillStatusArea(graphics, 0, 0, 128, 25);
            Engine.fillStatusArea(graphics, 0, 135, 128, 25);
            n = 0;
            if (GluGMGDemo.mDemo > 0 && menuCurrent == this.menuStageSelect) {
                this.paintTooltips(graphics, 33);
            } else {
                if (Engine.menuCurrent.previous != null) {
                    n |= 1;
                }
                if (Engine.menuCurrent.next != null || Engine.menuCurrent.type != 2) {
                    n |= 2;
                }
                if (menuCurrent == menuMain) {
                    n |= 4;
                    if (GluGMGDemo.mDemo > 0) {
                        Engine.paintBorderedString(graphics, GluGMGDemo.getText((byte)5), 64, 2, 17);
                    }
                }
                this.paintTooltips(graphics, n);
            }
        }
        graphics.translate(0, 25);
        graphics.setClip(0, 0, 128, 110);
        if (Engine.menuCurrent.type == 0) {
            img_title.drawImageNoClipping(graphics, 128 - Engine.img_title.width >> 1, 110 - FontMgr.lineHeight[0] - Engine.img_title.height >> 1);
            n = 110 - FontMgr.lineHeight[0];
            if (Engine.menuCurrent.text[Engine.menuCurrent.cursor] == GluGMGDemo.getText((byte)13)) {
                Engine.paintBorderedString(graphics, Engine.menuCurrent.text[Engine.menuCurrent.cursor], 64, n - 2 - 0, 17, 16751723, -15597228);
            } else {
                Engine.paintBorderedString(graphics, Engine.menuCurrent.text[Engine.menuCurrent.cursor], 64, n - 2 - 0, 17);
            }
            img_uiArrows[0][0].drawImageClipStack(graphics, 3, n + 1 - 0);
            img_uiArrows[1][0].drawImageClipStack(graphics, 118 - Engine.img_uiArrows[1][0].width + 7, n + 1 - 0);
        } else if (Engine.menuCurrent.type == 3) {
            if (GluGMGDemo.mDemo > 0) {
                GluGMGDemo.paintDemoStart(graphics);
            } else {
                Engine.paintZoneScreen(graphics, Engine.menuCurrent.cursor / 2, Engine.menuCurrent.cursor % 2 + 1, true);
            }
        } else if (Engine.menuCurrent.type == 1 || Engine.menuCurrent.type == 2) {
            graphics.setColor(0);
            graphics.fillRect(0, 0, 128, 110);
            if (Engine.menuCurrent.title != null) {
                Engine.paintDropString(graphics, Engine.menuCurrent.title, 64, 5, 17, -1118482, -15378944);
            }
            n = 0;
            int n2 = (110 - this.menuHeight >> 1) - n;
            if (this.menuDrawStart > 0) {
                img_uiArrows[3][0].drawImageAndRestoreClip(graphics, 64, n2 - 4 - 0 - Engine.img_uiArrows[3][0].height);
            }
            for (int i = this.menuDrawStart; i < this.menuDrawEnd; ++i) {
                if (Engine.menuCurrent.type == 2 || i != Engine.menuCurrent.cursor) {
                    graphics.setColor(0x5A5A5A);
                    FontMgr.drawString(1, graphics, Engine.menuCurrent.text[i], 64, n2, 17);
                } else {
                    graphics.setColor(0xFFFFFF);
                    FontMgr.drawString(1, graphics, Engine.menuCurrent.text[i], 64, n2, 17);
                }
                n2 += menuItemHeight + 2 - 0;
            }
            if (this.menuDrawEnd < menuCurrent.length()) {
                img_uiArrows[2][0].drawImageAndRestoreClip(graphics, 64, n2 + 0);
            }
        }
        graphics.translate(0, -25);
    }

    public static void paintZoneScreen(Graphics graphics, int n, int n2, boolean bl) {
        if (bl) {
            graphics.setColor(0);
            graphics.fillRect(0, 0, 128, 110);
        } else {
            graphics.setColor(0);
            graphics.fillRect(0, 0, 128, 160);
        }
        int n3 = 55;
        int n4 = bl ? 10 + Engine.img_uiArrows[0][0].width + 10 : 20;
        Engine.paintDropString(graphics, text[31 + n], n4, n3 - 16, 20, -1118482, -15378944);
        Engine.paintDropString(graphics, text[34], 64, n3, 17, -1118482, -15378944);
        if (bl) {
            img_uiArrows[0][0].drawImageClipStack(graphics, 10, n3);
            img_uiArrows[1][0].drawImageClipStack(graphics, 118 - Engine.img_uiArrows[1][0].width, n3);
        }
        Engine.paintDropString(graphics, text[35] + " " + n2, 128 - n4, n3 += 16, 24, -1118482, -15378944);
    }

    public static void fillStatusArea(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = n4;
        int n6 = 0;
        while (--n5 >= 0) {
            graphics.setColor(Constants.COLOR_STATUSBAR[n6]);
            graphics.fillRect(n, n2 + n5, n3, 1);
            n6 = 1 - n6;
        }
    }

    private void tickMenu() {
        this.tickMenu(true);
    }

    private void tickMenu(boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (Engine.menuCurrent.type == 0 || Engine.menuCurrent.type == 3 && GluGMGDemo.mDemo == 0) {
            if (Engine.key(4)) {
                bl3 = true;
            }
        } else if (Engine.menuCurrent.type == 1) {
            if (Engine.key(1)) {
                bl3 = true;
            }
        } else if (Engine.menuCurrent.type == 2 && Engine.isPressed(1)) {
            bl3 = true;
        }
        if (Engine.menuCurrent.type == 0 || Engine.menuCurrent.type == 3 && GluGMGDemo.mDemo == 0) {
            if (Engine.key(8)) {
                bl4 = true;
            }
        } else if (Engine.menuCurrent.type == 1) {
            if (Engine.key(2)) {
                bl4 = true;
            }
        } else if (Engine.menuCurrent.type == 2 && Engine.isPressed(2)) {
            bl4 = true;
        }
        if (bl3) {
            if (--Engine.menuCurrent.cursor < 0) {
                if (Engine.menuCurrent.type == 2) {
                    Engine.menuCurrent.cursor = 0;
                } else {
                    Engine.releaseKey(1);
                    Engine.menuCurrent.cursor = menuCurrent.length() - 1;
                    bl2 = true;
                }
            } else {
                bl2 = true;
            }
        }
        if (bl4) {
            int n = menuCurrent.length();
            if (Engine.menuCurrent.type == 2) {
                if (++Engine.menuCurrent.cursor >= (n -= 2)) {
                    Engine.menuCurrent.cursor = n - 1;
                } else {
                    bl2 = true;
                }
            } else {
                Engine.releaseKey(2);
                if (++Engine.menuCurrent.cursor >= n) {
                    Engine.menuCurrent.cursor = 0;
                }
                bl2 = true;
            }
        } else if ((Engine.key(16) || Engine.key(64)) && bl) {
            if (Engine.menuCurrent.next != null) {
                Engine.menuCurrent.next.cursor = 0;
                this.setMenu(Engine.menuCurrent.next);
            } else {
                this.doMenuAction(menuCurrent, Engine.menuCurrent.cursor);
            }
        } else if (Engine.key(128) && bl) {
            if (menuCurrent == menuMain) {
                this.setMenu(menuExit);
                return;
            }
            if (menuCurrent == menuIngame) {
                this.returnToGameWorld();
                return;
            }
            if (Engine.menuCurrent.previous != null) {
                Engine.menuCurrent.cursor = 0;
                this.setMenu(Engine.menuCurrent.previous);
            }
        }
        if (bl2) {
            this.updateMenuDrawPoints();
        }
    }

    private void updateMenuDrawPoints() {
        if (Engine.menuCurrent.type == 2) {
            this.menuDrawStart = Engine.menuCurrent.cursor;
            this.menuDrawEnd = Math.min(this.menuDrawStart + 3, menuCurrent.length());
        } else {
            this.menuDrawStart = Math.max(0, Engine.menuCurrent.cursor - (this.menuOptions >> 1));
            this.menuDrawEnd = this.menuDrawStart + this.menuOptions;
            if (this.menuDrawEnd >= menuCurrent.length()) {
                this.menuDrawEnd = menuCurrent.length();
                this.menuDrawStart = Math.max(0, this.menuDrawEnd - this.menuOptions);
            }
        }
    }

    private void doMenuAction(Menu menu, int n) {
        String string = null;
        if (menu.type != 3) {
            string = menu.text[n];
        }
        if (menu == menuMain) {
            if (string == text[5]) {
                this.setMenu(this.menuStageSelect);
            } else if (string == GluGMGDemo.getText((byte)1)) {
                this.setMenu(this.menuStageSelect);
            } else if (string == GluGMGDemo.getText((byte)0)) {
                GluGMGDemo.platRequest(GluGMGDemo.mDemoURL);
                this.exit();
            } else if (string == GluGMGDemo.getText((byte)13)) {
                if (GluGMGDemo.mUpsell == 2) {
                    GluGMGDemo.platRequest(GluGMGDemo.mUpsellURL);
                    this.exit();
                } else {
                    this.setMenu(Engine.createForm(GluGMGDemo.getText((byte)13), GluGMGDemo.STRING_GMG_NOBROWSE_MSG[GluGMGDemo._LOCALE], menuCurrent, null));
                }
            } else if (string == text[6]) {
                this.setMenu(this.menuHowToPlay);
            } else if (string == text[7]) {
                this.setMenu(menuSettings);
            } else if (string == text[8]) {
                String string2;
                String string3 = Engine.getJadValue("MIDlet-Version");
                if (string3 == null) {
                    string3 = "?";
                }
                if ((string2 = Engine.getJadValue("MIDlet-Name")) == null) {
                    string2 = "?";
                }
                this.setMenu(Engine.createForm(text[8], Engine.getText(37, new String[]{string2, string3}), menu, null));
            }
        } else if (menu == this.menuStageSelect) {
            int n2 = Engine.menuCurrent.cursor;
            if (GluGMGDemo.mDemo > 0) {
                n2 = 0;
                GluGMGDemo.demoQuit = false;
            }
            this.initGameWorld(n2 / 2, n2 % 2);
        } else if (menu == menuSettings || menu == menuIngame || menu == menuInGameSettings) {
            if (string == text[10 + soundOn]) {
                if (++soundOn > 3) {
                    soundOn = 0;
                }
                DeviceSound.volumeChanged();
                menu.updateItem(text[10 + soundOn]);
            } else if (string == text[15]) {
                vibrateOn = true;
                menu.updateItem(text[14]);
                if (menu != menuInGameSettings) {
                    Engine.vibrate(250);
                }
            } else if (string == text[14]) {
                vibrateOn = false;
                menu.updateItem(text[15]);
            } else if (string == text[24]) {
                this.setMenu(menuBackToMenuConfirmation);
                this.menuCursor = 0;
                Engine.menuCurrent.cursor = 0;
            } else if (string == text[7]) {
                this.setMenu(menuInGameSettings);
            } else if (string == text[23]) {
                this.returnToGameWorld();
                return;
            }
        } else if (menu == menuBackToMenuConfirmation) {
            if (string == text[17]) {
                GameWorld.abandonCurrentGame();
                GameWorld.unloadResources(0);
                Engine.loadMenuResources();
                if (GluGMGDemo.mDemo > 0) {
                    GluGMGDemo.demoQuit = true;
                    Engine.text[9] = GluGMGDemo.getText((byte)11);
                    this.setDemoOver();
                } else {
                    this.setMenu(menuMain);
                }
                ingamemenu = false;
                Engine.soundFunction(3, 0);
                if (soundOn == 0) {
                    Engine.soundFunction(1);
                }
            } else {
                this.setMenu(menuIngame);
            }
        } else if (menu == menuExit) {
            if (string == text[17]) {
                this.exit();
            } else if (string == text[18]) {
                this.setMenu(menuMain);
            }
        }
    }

    private static Menu createForm(String string, String string2, Menu menu, Menu menu2) {
        Menu menu3 = new Menu(string, Engine.getStrings(string2, 124, 1), 2);
        menu3.previous = menu;
        menu3.next = menu2;
        return menu3;
    }

    public void commandAction(Command command, Displayable displayable) {
    }

    public void loadRMS(int n) {
        String string = RMS_NAME;
        int n2 = n;
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
            if (recordStore.getNumRecords() > n) {
                byte[] byArray = recordStore.getRecord(n + 1);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                if (n2 == 0) {
                    runCount = dataInputStream.readInt();
                    soundOn = dataInputStream.readInt();
                    vibrateOn = dataInputStream.readBoolean();
                }
                dataInputStream.close();
                byteArrayInputStream.close();
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean saveRMS(int n) {
        String string = RMS_NAME;
        int n2 = n;
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            if (n2 == 0) {
                dataOutputStream.writeInt(runCount);
                dataOutputStream.writeInt(soundOn);
                dataOutputStream.writeBoolean(vibrateOn);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            dataOutputStream.close();
            byteArrayOutputStream.close();
            if (recordStore.getNumRecords() <= n) {
                recordStore.addRecord(byArray, 0, byArray.length);
            } else {
                recordStore.setRecord(n + 1, byArray, 0, byArray.length);
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private static void deleteRMS(String string) {
        try {
            RecordStore.deleteRecordStore((String)string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void initText(String string) {
        try {
            InputStream inputStream = null;
            DataInputStream dataInputStream = null;
            inputStream = instance.getClass().getResourceAsStream(string);
            dataInputStream = new DataInputStream(inputStream);
            text = new String[dataInputStream.readInt()];
            for (int i = 0; i < text.length; ++i) {
                Engine.text[i] = dataInputStream.readUTF();
            }
        }
        catch (Exception exception) {
            trace2 = "initText[" + string + " : " + exception.toString() + "]";
            Engine.debugWrite(trace2, false);
        }
    }

    public static String getText(int n) {
        if (n < text.length) {
            return text[n];
        }
        return "No text: " + n;
    }

    public static String getText(int n, String[] stringArray) {
        String string = new String(Engine.getText(n));
        if (stringArray.length == 1) {
            string = Engine.replaceText(string, "%U", stringArray[0]);
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                string = Engine.replaceText(string, "%U", stringArray[i]);
            }
        }
        return string;
    }

    public static String replaceText(String string, String string2, String string3) {
        String string4 = "";
        int n = 0;
        n = string.indexOf(string2);
        string4 = n != -1 ? string.substring(0, n) + string3 + string.substring(n + string2.length()) : string;
        return string4;
    }

    public static String[] getStrings(String string, int n, int n2) {
        int n3;
        Vector<String> vector = new Vector<String>();
        int n4 = 0;
        boolean bl = false;
        int n5 = string.length();
        String string2 = null;
        do {
            n3 = n4;
            int n6 = string.indexOf(124, n3);
            block1: do {
                int n7 = n3;
                String string3 = string2;
                n3 = Engine.getWordIndex(string, n3);
                if (n6 > -1 && n6 < n3) {
                    n3 = n6;
                }
                if (FontMgr.stringWidth(n2, string2 = string.substring(n4, n3).trim()) <= n) continue;
                if (n7 == n4) {
                    for (int i = string2.length() - 1; i > 0; --i) {
                        String string4 = string2.substring(0, i);
                        if (FontMgr.stringWidth(n2, string4) > n) continue;
                        n3 = n7 + i;
                        string2 = string4;
                        break block1;
                    }
                    break;
                }
                n3 = n7;
                string2 = string3;
                break;
            } while (n3 != n6 && n3 < n5);
            vector.addElement(string2);
        } while ((n4 = ++n3) < n5);
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private static int getWordIndex(String string, int n) {
        int n2;
        char c = string.charAt(n);
        if (Engine.charIsWord(c)) {
            return n + 1;
        }
        int n3 = 0;
        while ((n2 = string.indexOf(32, n)) == 0) {
            ++n;
        }
        n3 = n2;
        n3 = n3 == -1 ? string.length() : ++n3;
        for (n2 = n + 1; n2 < n3; ++n2) {
            if (!Engine.charIsWord(string.charAt(n2))) continue;
            return n2;
        }
        return n3;
    }

    private static boolean charIsWord(int n) {
        return n >= 11904 && n < 44032 || n >= 63744 && n < 64256 || n >= 65280 && n < 65504;
    }

    public static String getJadValue(String string) {
        String string2 = parent.getAppProperty(string);
        return string2 != null ? string2.trim() : null;
    }

    public static int rnd(int n) {
        return random.nextInt() % n;
    }

    public static int rndPositive(int n) {
        return Math.abs(random.nextInt() % n);
    }

    public static void paintString(String string, Graphics graphics, int n, int n2, int n3) {
    }

    public static void paintString(String string, Graphics graphics, int n, int n2, int n3, int n4) {
    }

    public static void paintString(Graphics graphics, String string, int n, int n2, int n3, int n4, boolean bl) {
        if (bl) {
            graphics.setFont(FONT);
            n2 += 0;
        }
        graphics.setColor(n4);
        graphics.drawString(string, n, n2, n3);
    }

    public static void paintString(Graphics graphics, String string, int n, int n2, int n3, int n4) {
        Engine.paintString(graphics, string, n, n2, n3, n4, true);
    }

    public static void paintBorderedString(Graphics graphics, int n, int n2, int n3, int n4) {
        Engine.paintBorderedString(graphics, text[n], n2, n3, n4, -1118482, -15597228);
    }

    public static void paintBorderedString(Graphics graphics, String string, int n, int n2, int n3) {
        Engine.paintBorderedString(graphics, string, n, n2, n3, -1118482, -15597228);
    }

    public static void paintBorderedString(Graphics graphics, String string, int n, int n2, int n3, int n4, int n5) {
        Engine.paintString(graphics, string, n - 1, n2, n3, n5);
        Engine.paintString(graphics, string, n + 1, n2, n3, n5);
        Engine.paintString(graphics, string, n, n2 - 1, n3, n5);
        Engine.paintString(graphics, string, n, n2 + 1, n3, n5);
        Engine.paintString(graphics, string, n, n2, n3, n4);
    }

    public static void paintDropString(Graphics graphics, String string, int n, int n2, int n3, int n4, int n5) {
        if (langSelected == 4 && menuCurrent == menuBackToMenuConfirmation) {
            graphics.setFont(FONT_NB);
            Engine.paintString(graphics, string, n + 2, n2 + 2, n3, n5, false);
            Engine.paintString(graphics, string, n + 1, n2 + 1, n3, -16777216, false);
            Engine.paintString(graphics, string, n, n2, n3, n4, false);
            graphics.setFont(FONT);
        } else {
            Engine.paintString(graphics, string, n + 2, n2 + 2, n3, n5);
            Engine.paintString(graphics, string, n + 1, n2 + 1, n3, -16777216);
            Engine.paintString(graphics, string, n, n2, n3, n4);
        }
    }

    public static void paintDebug(Graphics graphics) {
    }

    public static void debugWrite(String string, boolean bl) {
    }

    public static void debugWrite(String string) {
    }

    public static void clearDebug() {
    }

    private void paintDebugPanel(Graphics graphics) {
        int n = 4;
        int n2 = 0;
        int n3 = FontMgr.lineHeight[1];
        graphics.setClip(0, 0, 128, 160);
        graphics.setColor(13947080);
        graphics.fillRect(0, 0, 128, n * n3);
        graphics.setColor(0);
        FontMgr.drawString(1, graphics, "AVG FPS: " + this.debugAvgFPS, 0, n2, 20);
        FontMgr.drawString(1, graphics, "TICK: " + this.debugTick, 0, n2 += n3, 20);
        FontMgr.drawString(1, graphics, "PAINT: " + this.debugPaint, 0, n2 += n3, 20);
        FontMgr.drawString(1, graphics, "MEM: " + Engine.getFreeMemory(), 0, n2 += n3, 20);
    }

    public static String getFreeMemory() {
        System.gc();
        return (Runtime.getRuntime().freeMemory() >> 10) + " K";
    }

    public static String getTotalMemory() {
        return (Runtime.getRuntime().totalMemory() >> 10) + " K";
    }

    public static void clipRect(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = graphics.getClipX();
        int n6 = graphics.getClipY();
        int n7 = graphics.getClipWidth();
        int n8 = graphics.getClipHeight();
        int n9 = Math.max(n, n5);
        int n10 = Math.max(n2, n6);
        graphics.setClip(n9, n10, Math.min(n + n3, n5 + n7) - n9, Math.min(n2 + n4, n6 + n8) - n10);
    }

    public static boolean isPressed(int n) {
        return (keysPressed & n) != 0;
    }

    public static boolean key(int n) {
        if ((keyLatch & n) != 0) {
            keyLatch = 0;
            return true;
        }
        return false;
    }

    public static void releaseKey(int n) {
        keyLatch &= ~n;
    }

    public static boolean hasAnyKeyPressed() {
        if (keyLatch != 0) {
            keyLatch = 0;
            return true;
        }
        return false;
    }

    public static void resetKeyBuffers() {
        keyUnmapped = 0;
        keyLatch = 0;
    }

    public synchronized void keyPressed(int n) {
        try {
            int n2 = this.getKeyMap(n);
            keysPressed |= n2;
            keyLatch |= n2;
            keyUnmapped = n;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void keyReleased(int n) {
        try {
            int n2 = this.getKeyMap(n);
            keysPressed &= ~n2;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void doRepaint() {
        instance.repaint();
        instance.serviceRepaints();
    }

    public static void handleEvent() {
        handleEvent = false;
        Engine.resetKeyBuffers();
        keysPressed = 0;
        if (!ingamemenu) {
            // empty if block
        }
        if (state != 4) {
            Engine.soundFunction(1);
            if (text != null) {
                pauseState = state;
                state = 4;
            }
        }
    }

    public static byte[] insertPLTE(byte[] byArray, byte[] byArray2) {
        int n;
        int n2 = 37;
        for (n = 0; n < byArray.length - 4; ++n) {
            if (byArray[n] != 80 || byArray[n + 1] != 76 || byArray[n + 2] != 84 || byArray[n + 3] != 69) continue;
            n2 = n;
            break;
        }
        n = n2 - 4;
        int n3 = ((byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF) & 0xFFFFFFFF;
        byte[] byArray3 = new byte[byArray.length - (n3 += 12) + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, n);
        System.arraycopy(byArray2, 0, byArray3, n, byArray2.length);
        System.arraycopy(byArray, n + n3, byArray3, n + byArray2.length, byArray.length - (n + n3));
        return byArray3;
    }

    public static DeviceImage[] loadNonAnimatedSprite(int n, int n2, int n3, int n4) throws Exception {
        return (DeviceImage[])Engine.loadSprite(n, n2, n3, n4, false);
    }

    public static DeviceImage[] loadNonAnimatedSprite(int n, int n2, int n3, int n4, int n5) throws Exception {
        return (DeviceImage[])Engine.loadSprite(n, n2, n3, n4, n5, false);
    }

    public static DeviceImage[][] loadSprite(int n, int n2, int n3, int n4) throws Exception {
        return (DeviceImage[][])Engine.loadSprite(n, n2, n3, n4, true);
    }

    public static Object loadSprite(int n, int n2, int n3, int n4, boolean bl) throws Exception {
        return Engine.loadSprite(n, n2, n3, n4, -1, bl);
    }

    public static Object loadSprite(int n, int n2, int n3, int n4, int n5, boolean bl) throws Exception {
        DeviceImage[][] deviceImageArrayArray = null;
        try {
            byte by;
            byte by2;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            byte[] byArray = ResourceMaster.getResourceAsBytes(n);
            byte[] byArray2 = ResourceMaster.getResourceAsBytes(n2);
            int n12 = 0;
            int n13 = byArray[n12++] & 0xFF;
            byte by3 = byArray[n12++];
            byte by4 = byArray[n12++];
            DeviceImage[] deviceImageArray = new DeviceImage[n13];
            if (n3 != -1) {
                DeviceImage deviceImage = new DeviceImage(n3, n5, "unsplit image for SpriteID " + n);
                n11 = 0;
                for (n10 = 0; n10 < n13; ++n10) {
                    n9 = byArray[n12++] & 0xFF;
                    n8 = byArray[n12++] & 0xFF;
                    n7 = byArray[n12++] & 0xFF;
                    n6 = byArray[n12++] & 0xFF;
                    by2 = byArray[n12++];
                    by = byArray[n12++];
                    DeviceImage deviceImage2 = new DeviceImage(deviceImage, n9, n8, n7, n6, true);
                    deviceImage2.offset_x = by2;
                    deviceImage2.offset_y = by;
                    deviceImage2.frameWidth = by3;
                    deviceImage2.frameHeight = by4;
                    deviceImageArray[n11++] = deviceImage2;
                }
            } else {
                int n14 = 0;
                for (n11 = 0; n11 < n13; ++n11) {
                    n12 += 4;
                    n10 = byArray[n12++];
                    n9 = byArray[n12++];
                    DeviceImage deviceImage = new DeviceImage(n4 + n11, n5, "split image " + n11 + " for SpriteID " + n);
                    deviceImage.offset_x = n10;
                    deviceImage.offset_y = (byte)n9;
                    deviceImage.frameWidth = by3;
                    deviceImage.frameHeight = by4;
                    deviceImageArray[n14++] = deviceImage;
                }
            }
            n12 = 0;
            byte by5 = byArray2[n12++];
            byte[][] byArrayArray = new byte[by5][];
            for (n10 = 0; n10 < by5; ++n10) {
                n9 = byArray2[n12++];
                if ((n8 = byArray2[n12++]) != 1 && !bl) {
                    throw new Exception("\"frameCount != 1 && !multipleFrames\" in Engine.loadSprite frames file (" + n2 + ")");
                }
                byArrayArray[n9] = new byte[n8 << 1];
                for (n7 = 0; n7 < n8; ++n7) {
                    n6 = byArray2[n12++];
                    by2 = byArray2[n12++];
                    byArrayArray[n9][n7 << 1] = n6;
                    byArrayArray[n9][(n7 << 1) + 1] = by2;
                }
            }
            if (bl) {
                DeviceImage[][] deviceImageArrayArray2 = new DeviceImage[by5][];
                for (n9 = 0; n9 < by5; ++n9) {
                    n8 = byArrayArray[n9].length >> 1;
                    deviceImageArrayArray2[n9] = new DeviceImage[n8];
                    n7 = 0;
                    for (n6 = 0; n6 < n8; ++n6) {
                        by2 = byArrayArray[n9][n7++];
                        deviceImageArrayArray2[n9][n6] = (by = byArrayArray[n9][n7++]) == 0 ? deviceImageArray[by2] : new DeviceImage(deviceImageArray[by2], (int)by);
                    }
                }
                deviceImageArrayArray = deviceImageArrayArray2;
            } else {
                DeviceImage[] deviceImageArray2 = new DeviceImage[by5];
                for (n9 = 0; n9 < by5; ++n9) {
                    n8 = 0;
                    n7 = byArrayArray[n9][n8++];
                    deviceImageArray2[n9] = (n6 = byArrayArray[n9][n8++]) == 0 ? deviceImageArray[n7] : new DeviceImage(deviceImageArray[n7], n6);
                }
                deviceImageArrayArray = deviceImageArray2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return deviceImageArrayArray;
    }

    public void exit() {
        running = false;
    }

    static {
        lastSound = -1;
        vibrateOn = true;
        random = new Random();
        state = -1;
        TEXT_BRANDS = new int[][]{{1}, {2}, {3, 4}};
        NUM_BRANDS = TEXT_BRANDS.length;
        changeSound = false;
        ingamemenu = false;
    }
}

