/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.mp.game;

import com.barteo.emulator.device.DeviceFactory;
import com.siemens.mp.game.ExtendedImage;
import com.siemens.mp.game.GraphicObject;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TiledBackground
extends GraphicObject {
    Image[] pixels;
    byte[] map;
    int widthInTiles;
    int heightInTiles;
    int posx;
    int posy;

    public TiledBackground(byte[] tilePixels, byte[] tileMask, byte[] map, int widthInTiles, int heightInTiles) {
        this(com.siemens.mp.ui.Image.createImageFromBitmap(tilePixels, 8, tilePixels.length), com.siemens.mp.ui.Image.createImageFromBitmap(tileMask, 8, tilePixels.length), map, widthInTiles, heightInTiles);
    }

    public TiledBackground(ExtendedImage tilePixels, ExtendedImage tileMask, byte[] map, int widthInTiles, int heightInTiles) {
        this(tilePixels.getImage(), tileMask.getImage(), map, widthInTiles, heightInTiles);
    }

    public TiledBackground(Image tilePixels, Image tileMask, byte[] map, int widthInTiles, int heightInTiles) {
        System.out.println("public TiledBackground(Image tilePixels, Image tileMask, byte[] map, int " + widthInTiles + ", int " + heightInTiles + ")");
        this.map = map;
        this.heightInTiles = heightInTiles;
        this.widthInTiles = widthInTiles;
        this.pixels = new Image[tilePixels.getHeight() / 8 + 3];
        this.pixels[0] = Image.createImage((int)8, (int)8);
        this.pixels[1] = Image.createImage((int)8, (int)8);
        this.pixels[2] = Image.createImage((int)8, (int)8);
        this.pixels[2].getGraphics().fillRect(0, 0, 8, 8);
        for (int i2 = 0; i2 < this.pixels.length - 3; ++i2) {
            Image img = Image.createImage((int)8, (int)8);
            img.getGraphics().drawImage(tilePixels, 0, -i2 * 8, 0);
            this.pixels[i2 + 3] = img;
        }
    }

    public void setPositionInMap(int x2, int y2) {
        this.posx = x2;
        this.posy = y2;
    }

    protected void paint(Graphics g2) {
        for (int y2 = this.posy / 8; y2 < this.heightInTiles; ++y2) {
            for (int x2 = this.posx / 8; x2 < this.widthInTiles && -this.posx + x2 * 8 <= DeviceFactory.getDevice().getDeviceDisplay().getWidth(); ++x2) {
                g2.drawImage(this.pixels[this.map[y2 * this.widthInTiles + x2]], -this.posx + x2 * 8, -this.posy + y2 * 8, 0);
            }
            if (-this.posy + y2 * 8 > DeviceFactory.getDevice().getDeviceDisplay().getHeight()) break;
        }
    }
}

