/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.kxml2.io.KXmlParser;

public abstract class Parser {
    private static String getEncoding(byte[] array) {
        try {
            int size = array.length - 8;
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < size; ++i) {
                if (array[i] != 101 || array[i + 1] != 110 || array[i + 2] != 99 || array[i + 3] != 111 || array[i + 4] != 100 || array[i + 5] != 105 || array[i + 6] != 110 || array[i + 7] != 103) continue;
                int flag = 0;
                for (int index = i; index < size; ++index) {
                    if (array[index] == 34) {
                        ++index;
                        ++flag;
                    }
                    if (flag == 2) {
                        return buf.toString().toLowerCase();
                    }
                    if (flag <= 0) continue;
                    buf.append((char)array[index]);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "unknown";
    }

    protected static KXmlParser getParser(byte[] data) {
        KXmlParser xmlParser;
        try {
            InputStreamReader iStreamReader;
            xmlParser = new KXmlParser();
            String encoding = Parser.getEncoding(data);
            if (encoding.equals("unknown")) {
                try {
                    iStreamReader = new InputStreamReader((InputStream)new ByteArrayInputStream(data), "windows-1251");
                }
                catch (UnsupportedEncodingException e2) {
                    try {
                        iStreamReader = new InputStreamReader((InputStream)new ByteArrayInputStream(data), "UTF-8");
                    }
                    catch (Exception e3) {
                        return null;
                    }
                }
            } else {
                if (encoding.equals("windows-1251")) {
                    data = Unicode.convCp1251ToUnicode(data).getBytes("UTF-8");
                }
                iStreamReader = new InputStreamReader((InputStream)new ByteArrayInputStream(data), "UTF-8");
            }
            xmlParser.setInput(iStreamReader);
        }
        catch (Exception e) {
            return null;
        }
        return xmlParser;
    }

    private static int nextParserNode(KXmlParser xmlParser) {
        int iParserEvent = -1;
        try {
            iParserEvent = xmlParser.next();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return iParserEvent;
    }

    protected static String getNextSubNode(String node, KXmlParser xmlParser) {
        int iParserEvent = Parser.nextParserNode(xmlParser);
        while (iParserEvent != 1) {
            if (iParserEvent == 2) {
                return xmlParser.getName();
            }
            if (iParserEvent == 3 && node != null && xmlParser.getName().compareTo(node) == 0) {
                return null;
            }
            iParserEvent = Parser.nextParserNode(xmlParser);
        }
        return null;
    }

    protected static String getNextNode(KXmlParser xmlParser) {
        int iParserEvent = Parser.nextParserNode(xmlParser);
        while (iParserEvent != 1) {
            if (iParserEvent == 2) {
                return xmlParser.getName();
            }
            iParserEvent = Parser.nextParserNode(xmlParser);
        }
        return null;
    }

    protected static String getNextText(KXmlParser xmlParser) {
        int iParserEvent = Parser.nextParserNode(xmlParser);
        while (iParserEvent != 1) {
            if (iParserEvent == 4) {
                return xmlParser.getText();
            }
            if (iParserEvent == 3) {
                return "";
            }
            iParserEvent = Parser.nextParserNode(xmlParser);
        }
        return null;
    }

    protected static String getXmlContent(byte[] data) {
        if (data == null) {
            return "";
        }
        String strData = new String(data);
        int xmlTagIdx = strData.indexOf("<?xml");
        if (xmlTagIdx < 0) {
            return strData;
        }
        return strData.substring(xmlTagIdx);
    }
}

