/*
 * Decompiled with CFR 0.152.
 */
package gps;

import gps.Debug;
import gps.MessageListener;
import gps.ReceiveAndSendMessages;
import gps.SaveAndLoad;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.lcdui.List;
import javax.microedition.rms.RecordStoreException;

class BluetoothConnectionToGPS
implements DiscoveryListener,
Runnable {
    private ReceiveAndSendMessages bluetoothToGPS;
    private SaveAndLoad saveLoad = new SaveAndLoad("bluetoothToGPS");
    private DiscoveryAgent mDiscoveryAgent = null;
    private RemoteDevice remoteDevice;
    private Vector devices = new Vector();
    private List lastDevice = new List("last Device", 1);
    private List listFindDevice = new List("Devices find", 1);
    private static String url = "";
    private String lastdeviceAdress = new String();
    private int idService = 0;
    private int timeSearchDevice = 20;
    private int timeSearchService = 10;
    private UUID[] uuidSet = new UUID[]{new UUID(4353L)};
    private boolean searchDevice = false;
    private boolean searchService = false;
    private boolean isConnected = false;
    private boolean connectLastDevice = false;
    private boolean deviceFind = false;
    private boolean serviceNotConnected = false;
    private boolean endNow = false;
    private MessageListener listener;

    public BluetoothConnectionToGPS(MessageListener listener) {
        this.listener = listener;
    }

    public void connectLastDevice() {
        url = null;
        this.idService = 0;
        this.serviceNotConnected = false;
        this.isConnected = false;
        this.deviceFind = false;
        this.endNow = false;
        if (this.isLastDevice()) {
            this.connectLastDevice = true;
            Thread thread = new Thread(this);
            thread.start();
        } else {
            this.serviceNotConnected = true;
        }
    }

    public void newSearchDevices() {
        this.isConnected = false;
        this.deviceFind = false;
        this.connectLastDevice = false;
        this.serviceNotConnected = false;
        this.endNow = false;
        url = null;
        this.devices.removeAllElements();
        this.listFindDevice.deleteAll();
        this.listFindDevice = new List("Devices find", 1);
        this.lastDevice.deleteAll();
        this.idService = 0;
        Thread thread = new Thread(this);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectDevice(int i) {
        if (this.searchDevice) {
            this.mDiscoveryAgent.cancelInquiry((DiscoveryListener)this);
        }
        this.remoteDevice = (RemoteDevice)this.devices.elementAt(i);
        BluetoothConnectionToGPS bluetoothConnectionToGPS = this;
        synchronized (bluetoothConnectionToGPS) {
            this.notify();
        }
    }

    private void readContent() {
        Thread thread = new Thread(this);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopGPS() {
        this.endNow = true;
        url = null;
        if (this.searchDevice) {
            this.mDiscoveryAgent.cancelInquiry((DiscoveryListener)this);
        }
        if (this.searchService) {
            this.mDiscoveryAgent.cancelServiceSearch(this.idService);
        }
        this.isConnected = false;
        BluetoothConnectionToGPS bluetoothConnectionToGPS = this;
        synchronized (bluetoothConnectionToGPS) {
            this.notify();
        }
        if (this.bluetoothToGPS != null) {
            this.bluetoothToGPS.stop();
        }
    }

    public void sendNMEAMessage(String NMEAMessage) {
        this.bluetoothToGPS.sendNMEAMessage(NMEAMessage);
    }

    public void sendSirfMessage(int[] SIRFmessage) {
        this.bluetoothToGPS.sendSirfMessage(SIRFmessage);
    }

    public boolean isLastDevice() {
        try {
            this.lastDevice = this.saveLoad.showListRecordStore();
        }
        catch (RecordStoreException e) {
            e.printStackTrace();
        }
        boolean lastDevice1 = this.lastDevice.size() != 0;
        return lastDevice1;
    }

    public void setSearchDeviceTime(int time) {
        this.timeSearchDevice = time;
    }

    public void setSearchServiceTime(int time) {
        this.timeSearchService = time;
    }

    public boolean isDeviceFound() {
        return this.deviceFind;
    }

    public boolean isServiceConnected() {
        return this.isConnected;
    }

    public boolean isServiceDefinitelyNotConnected() {
        return this.serviceNotConnected;
    }

    public List getDevicesList() {
        return this.listFindDevice;
    }

    public String getDeviceUrl() {
        return url;
    }

    public void deviceDiscovered(RemoteDevice rd, DeviceClass deviceClass) {
        if (this.connectLastDevice) {
            try {
                this.lastdeviceAdress = this.saveLoad.loadRecordStore(0).toString();
            }
            catch (RecordStoreException e) {
                e.printStackTrace();
            }
            if (rd.getBluetoothAddress().toString().equals(this.lastdeviceAdress)) {
                try {
                    this.deviceFind = true;
                    this.searchService = true;
                    this.remoteDevice = rd;
                    this.idService = this.mDiscoveryAgent.searchServices(null, this.uuidSet, rd, (DiscoveryListener)this);
                }
                catch (BluetoothStateException e) {
                    e.printStackTrace();
                }
            }
        } else if (!this.connectLastDevice) {
            try {
                this.listFindDevice.append(rd.getFriendlyName(false).toString(), null);
                this.devices.addElement(rd);
                this.deviceFind = true;
                Debug.setDebug("Device found : " + rd.getFriendlyName(false).toString(), 2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void inquiryCompleted(int i) {
        this.searchDevice = false;
        switch (i) {
            case 0: {
                Debug.setDebug("Device search completed", 1);
                break;
            }
            case 7: {
                Debug.setDebug("Error: Device search stopped", 1);
                this.serviceNotConnected = true;
                break;
            }
            case 5: {
                Debug.setDebug("Device search aborted", 1);
                this.serviceNotConnected = true;
            }
        }
    }

    public void servicesDiscovered(int i, ServiceRecord[] serviceRecords) {
        Debug.setDebug("Service discovered : " + serviceRecords[0], 2);
        url = serviceRecords[0].getConnectionURL(0, true);
    }

    public void serviceSearchCompleted(int i, int i1) {
        this.searchService = false;
        if (url != null) {
            Debug.setDebug("Connection to : " + url, 1);
            this.bluetoothToGPS = new ReceiveAndSendMessages(url, this.listener);
            long time = System.currentTimeMillis() / 1000L;
            boolean stop = false;
            while (!this.isConnected && !stop) {
                this.isConnected = this.bluetoothToGPS.isConnected();
                if (System.currentTimeMillis() / 1000L - time <= (long)this.timeSearchService) continue;
                this.serviceNotConnected = true;
                stop = true;
            }
        } else {
            this.serviceNotConnected = true;
        }
        switch (i1) {
            case 1: {
                Debug.setDebug("Service search completed", 1);
                try {
                    this.saveLoad.deleteAndSaveRecordStore(this.remoteDevice.getBluetoothAddress().toString(), "bluetoothToGPS device");
                }
                catch (RecordStoreException e) {
                    e.printStackTrace();
                }
                this.readContent();
                break;
            }
            case 6: {
                Debug.setDebug("Service not reachable", 1);
                this.serviceNotConnected = true;
                break;
            }
            case 3: {
                Debug.setDebug("Error in the device search", 1);
                this.serviceNotConnected = true;
                break;
            }
            case 4: {
                Debug.setDebug("Service search: no records", 1);
                this.serviceNotConnected = true;
                break;
            }
            case 2: {
                Debug.setDebug("Service search aborted", 1);
                this.serviceNotConnected = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block15: {
            while (this.searchDevice || this.searchService) {
                Thread.yield();
            }
            if (url == null) {
                try {
                    LocalDevice localDevice = LocalDevice.getLocalDevice();
                    this.mDiscoveryAgent = localDevice.getDiscoveryAgent();
                    this.searchDevice = true;
                    this.mDiscoveryAgent.startInquiry(10390323, (DiscoveryListener)this);
                    Debug.setDebug("Devices search started", 1);
                    long time = System.currentTimeMillis() / 1000L;
                    boolean stop = false;
                    while (!this.deviceFind && !stop) {
                        if (System.currentTimeMillis() / 1000L - time <= (long)this.timeSearchDevice) continue;
                        this.serviceNotConnected = true;
                        stop = true;
                    }
                    if (stop) break block15;
                    BluetoothConnectionToGPS bluetoothConnectionToGPS = this;
                    synchronized (bluetoothConnectionToGPS) {
                        try {
                            this.wait();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (!this.endNow) {
                        this.searchService = true;
                        Debug.setDebug("Services search started", 1);
                        this.idService = this.mDiscoveryAgent.searchServices(null, this.uuidSet, this.remoteDevice, (DiscoveryListener)this);
                    }
                }
                catch (Exception exception) {}
            } else if (!this.endNow) {
                while (this.isConnected) {
                    this.isConnected = this.bluetoothToGPS.isConnected();
                }
            } else {
                this.bluetoothToGPS.stop();
            }
        }
    }
}

