/*
 * Decompiled with CFR 0.152.
 */
package Mail;

import java.util.Calendar;
import java.util.Random;
import java.util.TimeZone;
import java.util.Vector;

public class Message {
    Vector lines = new Vector();
    int headerSize = 0;
    public String size = "0 \u043a\u0431";

    public String getHeaderLine(int n) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n >= this.headerSize) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return (String)this.lines.elementAt(n);
    }

    public String getHeaderName(int n) throws ArrayIndexOutOfBoundsException {
        return Message.getStringName(this.getHeaderLine(n));
    }

    public String getHeaderValue(int n) throws ArrayIndexOutOfBoundsException {
        return Message.getStringValue(this.getHeaderLine(n));
    }

    public int getHeaderIndex(String string, int n) {
        String string2 = string.toLowerCase();
        int n2 = n;
        while (n2 < this.headerSize) {
            String string3 = this.getHeaderName(n2);
            if (string3 != null && string3.toLowerCase().equals(string2)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int getHeaderIndex(String string) {
        return this.getHeaderIndex(string, 0);
    }

    public String getHeaderValue(String string) {
        return this.getHeaderValue(string, null);
    }

    public String getHeaderValue(String string, String string2) {
        int n = this.getHeaderIndex(string);
        if (n == -1) {
            return string2;
        }
        return this.getHeaderValue(n);
    }

    public String[] getAllHeaderValues(String string) {
        Vector<String> vector = new Vector<String>();
        int n = this.getHeaderIndex(string);
        while (n != -1) {
            vector.addElement(this.getHeaderValue(n));
            n = this.getHeaderIndex(string, n + 1);
        }
        String[] stringArray = new String[vector.size()];
        int n2 = 0;
        while (n2 < vector.size()) {
            stringArray[n2] = (String)vector.elementAt(n2);
            ++n2;
        }
        return stringArray;
    }

    public void setHeaderLine(int n, String string) {
        if (n < 0 || n >= this.headerSize) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        this.lines.setElementAt(string, n);
    }

    public int getHeaderLineCount() {
        return this.headerSize;
    }

    public int addHeaderLine(String string) {
        this.lines.insertElementAt(string, this.headerSize);
        return this.headerSize++;
    }

    public void insertHeaderLine(int n, String string) {
        if (n < 0 || n > this.headerSize) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        this.lines.insertElementAt(string, n);
        ++this.headerSize;
    }

    public void removeHeaderLine(int n) {
        if (n < 0 || n >= this.headerSize) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        this.lines.removeElementAt(n);
        --this.headerSize;
    }

    public void setHeaderValue(String string, String string2) {
        int n = this.getHeaderIndex(string);
        if (n == -1) {
            if (string2 != null) {
                this.addHeaderLine(String.valueOf(string).concat(": ").concat(String.valueOf(string2)));
            }
        } else if (string2 != null) {
            this.setHeaderLine(n, String.valueOf(string).concat(": ").concat(String.valueOf(string2)));
        } else {
            this.removeHeaderLine(n);
        }
    }

    public String getBodyLine(int n) {
        if (n < 0 || n >= this.getBodyLineCount()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return (String)this.lines.elementAt(this.headerSize + n + 1);
    }

    public void setBodyLine(int n, String string) {
        if (n < 0 || n >= this.getBodyLineCount()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        this.lines.setElementAt(string, this.headerSize + n + 1);
    }

    public int getBodyLineCount() {
        return this.lines.size() - this.headerSize - 1;
    }

    public int addBodyLine(String string) {
        this.lines.addElement(string);
        return this.getBodyLineCount() - 1;
    }

    public void insertBodyLine(int n, String string) {
        if (n < 0 || n > this.getBodyLineCount()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        this.lines.insertElementAt(string, this.headerSize + n + 1);
    }

    public void removeBodyLine(int n) {
        if (n < 0 || n >= this.getBodyLineCount()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        this.lines.removeElementAt(this.headerSize + n + 1);
    }

    public static String getMachineAddress(String string) {
        int n = string.indexOf(60);
        int n2 = string.indexOf(62, n + 1);
        if (n != -1 && n2 != -1) {
            return string.substring(n + 1, n2);
        }
        n = string.indexOf(40);
        n2 = string.indexOf(41, n + 1);
        if (n != -1 && n2 != -1) {
            return string.substring(0, n).trim();
        }
        n = string.indexOf(34);
        n2 = string.indexOf(34, n + 1);
        if (n != -1 && n2 != -1) {
            return string.substring(0, n).trim();
        }
        return string;
    }

    public static String getDisplayAddress(String string) {
        int n = string.indexOf(34);
        int n2 = string.indexOf(34, n + 1);
        if (n != -1 && n2 != -1) {
            return string.substring(n + 1, n2);
        }
        n = string.indexOf(40);
        n2 = string.indexOf(41, n + 1);
        if (n != -1 && n2 != -1) {
            return string.substring(n + 1, n2);
        }
        n = string.indexOf(60);
        n2 = string.indexOf(62, n + 1);
        if (n != -1 && n2 != -1) {
            return string.substring(0, n).trim();
        }
        return "";
    }

    static String intToStr(int n, int n2) {
        String string = Integer.toString(n);
        string = String.valueOf("0000".substring(string.length(), n2)).concat(String.valueOf(string));
        return string;
    }

    public static String getCanonicalDate(Calendar calendar, TimeZone timeZone) {
        String string = "JanFebMarAprMayJunJulAugSepOctNovDec";
        String string2 = "SunMonTueWedThuFriSatSun";
        int n = calendar.get(1);
        int n2 = calendar.get(2);
        int n3 = calendar.get(5);
        int n4 = calendar.get(7) - 1;
        int n5 = calendar.get(11);
        int n6 = calendar.get(12);
        int n7 = calendar.get(13);
        String string3 = String.valueOf(string2.substring(3 * n4, 3 * n4 + 3)) + ", " + String.valueOf(Message.intToStr(n3, 2)) + " " + String.valueOf(string.substring(3 * n2, 3 * n2 + 3)) + " " + String.valueOf(Message.intToStr(n, 4)) + " " + String.valueOf(Message.intToStr(n5, 2)) + ":" + String.valueOf(Message.intToStr(n6, 2)) + ":" + String.valueOf(Message.intToStr(n7, 2));
        if (timeZone != null) {
            String string4;
            int n8 = timeZone.getRawOffset() / 1000;
            if (timeZone.useDaylightTime()) {
                n8 += 3600;
            }
            if (n8 >= 0) {
                string4 = " GMT+";
            } else {
                string4 = " GMT-";
                n8 = -n8;
            }
            string3 = String.valueOf(string3) + String.valueOf(string4) + String.valueOf(Message.intToStr(n8 / 3600, 2)) + String.valueOf(Message.intToStr(n8 % 3600, 2));
        }
        return string3;
    }

    public static String[] getStringElements(String string, char c) {
        int n;
        Vector<String> vector = new Vector<String>();
        string = String.valueOf(string).concat(String.valueOf(c));
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n3;
            n = 0;
            while (n4 < n2 && (string.charAt(n4) != c || n != 0)) {
                if (string.charAt(n4) == '\"') {
                    n = n != 0 ? 0 : 1;
                }
                ++n4;
            }
            String string2 = string.substring(n3, n4).trim();
            if (string2.length() != 0) {
                vector.addElement(string2);
            }
            n3 = n4 + 1;
        }
        String[] stringArray = new String[vector.size()];
        n = 0;
        while (n < vector.size()) {
            stringArray[n] = (String)vector.elementAt(n);
            ++n;
        }
        return stringArray;
    }

    public static String getStringName(String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            return null;
        }
        return string.substring(0, n);
    }

    public static String getStringValue(String string) {
        int n = string.indexOf(58);
        String string2 = n == -1 ? string : string.substring(n + 1);
        if ((string2 = string2.trim()).length() > 1 && string2.charAt(0) == '\"' && string2.charAt(string2.length() - 1) == '\"') {
            string2 = string2.substring(1, string2.length() - 1);
        }
        return string2;
    }

    public static String getRandomString() {
        return String.valueOf(Long.toString(System.currentTimeMillis(), 36)).concat(".").concat(String.valueOf(Integer.toString(Math.abs(new Random().nextInt()), 36)));
    }

    Vector getLines() {
        return this.lines;
    }

    public Message() {
        this.lines.addElement("");
    }

    public Message(String string, String string2, String string3) {
        this.lines.addElement("");
        if (string != null) {
            this.addHeaderLine("From: ".concat(String.valueOf(string)));
            String string4 = Message.getMachineAddress(string);
            this.addHeaderLine("Message-ID: <" + String.valueOf(Message.getRandomString()) + "." + String.valueOf(string4) + ">");
        } else {
            this.addHeaderLine("Message-ID: <".concat(String.valueOf(Message.getRandomString())).concat(">"));
        }
        if (string2 != null) {
            this.addHeaderLine("To: ".concat(String.valueOf(string2)));
        }
        if (string3 != null) {
            this.addHeaderLine("Subject: ".concat(String.valueOf(string3)));
        }
        this.addHeaderLine("Date: ".concat(String.valueOf(Message.getCanonicalDate(Calendar.getInstance(), TimeZone.getDefault()))));
    }
}

