/*
 * Decompiled with CFR 0.152.
 */
package fs;

import fs.File;
import fs.FileAttrs;
import fs.Ftp;
import fs.IRemoteFile;
import fs.RemoteFile;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class FTPClient
implements File {
    public Ftp ftp;
    private String location;
    private FileAttrs file;
    private Hashtable list = new Hashtable();

    public boolean close() {
        boolean result = true;
        try {
            this.ftp.close();
        }
        catch (Exception exception) {
            System.err.println("Close connection failed: " + exception.getMessage());
            result = false;
        }
        return result;
    }

    public FTPClient(String host, int port, String user, String password) {
        boolean result = true;
        try {
            this.ftp = new Ftp(host, port, user, password);
        }
        catch (Exception exception) {
            result = false;
        }
    }

    public boolean open(String filename) {
        return this.open(filename, 0);
    }

    public boolean open(String filename, int mode) {
        boolean result = true;
        this.location = filename;
        String s = (String)this.list.get(filename);
        IRemoteFile f = RemoteFile.parse(s);
        this.file = f.getAttrs();
        return result;
    }

    public String[] list(String mask, boolean hidden) {
        try {
            this.list.clear();
        }
        catch (Exception e) {
            // empty catch block
        }
        Object[] as = new String[]{};
        Vector<String> vector = new Vector<String>();
        try {
            if (!this.isDirectory()) {
                return null;
            }
            this.ftp.cwd(this.location);
            Enumeration enF = this.ftp.list();
            Enumeration en = this.ftp.nlst();
            while (en.hasMoreElements()) {
                String t = (String)en.nextElement();
                vector.addElement(t);
                this.list.put(t, (String)enF.nextElement());
            }
        }
        catch (Exception e) {
            System.err.println("Can't list the directory: " + e.getMessage());
        }
        as = new String[vector.size()];
        vector.copyInto(as);
        vector.removeAllElements();
        return as;
    }

    public String[] listRoots() {
        try {
            this.list.clear();
        }
        catch (Exception e) {
            // empty catch block
        }
        Vector<String> vector = new Vector<String>();
        try {
            this.ftp.cdup();
            Enumeration enF = this.ftp.list();
            Enumeration en = this.ftp.nlst();
            while (en.hasMoreElements()) {
                String t = (String)en.nextElement();
                vector.addElement(t);
                this.list.put(t, (String)enF.nextElement());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object[] array = new String[vector.size()];
        vector.copyInto(array);
        vector.removeAllElements();
        return array;
    }

    public boolean isDirectory() {
        return this.file.isDir();
    }

    public InputStream openInputStream() {
        InputStream inputstream = null;
        try {
            this.ftp.mode('S');
            inputstream = this.ftp.retr(this.location);
        }
        catch (Exception exception) {
            inputstream = null;
            System.out.println("openInputStream from '" + this.location + "' failed: " + exception.getMessage());
        }
        return inputstream;
    }

    public OutputStream openOutputStream() {
        OutputStream outputstream = null;
        try {
            this.ftp.mode('S');
            outputstream = this.ftp.stou(this.location);
        }
        catch (Exception exception) {
            outputstream = null;
            System.out.println("openOutputStream from '" + this.location + "' failed: " + exception.getMessage());
        }
        return outputstream;
    }

    public DataInputStream openDataInputStream() {
        DataInputStream inputstream = null;
        try {
            inputstream = new DataInputStream(this.openInputStream());
        }
        catch (Exception exception) {
            inputstream = null;
            System.out.println("openInputStream from '" + this.location + "' failed: " + exception.getMessage());
        }
        return inputstream;
    }

    public DataOutputStream openDataOutputStream() {
        DataOutputStream dataoutputstream = null;
        try {
            dataoutputstream = new DataOutputStream(this.openOutputStream());
        }
        catch (Exception exception) {
            dataoutputstream = null;
            System.out.println("openOutputStream from '" + this.location + "' failed: " + exception.getMessage());
        }
        return dataoutputstream;
    }

    public boolean create() throws Exception {
        boolean flag = true;
        return flag;
    }

    public boolean mkdir() throws Exception {
        boolean flag = true;
        this.ftp.mkd(this.location);
        return flag;
    }

    public boolean delete() throws Exception {
        boolean flag = true;
        if (this.isDirectory()) {
            this.ftp.rmd(this.location);
        } else {
            this.ftp.dele(this.location);
        }
        return flag;
    }

    public boolean exists() throws Exception {
        return this.list.containsKey(this.location);
    }

    public long fileSize() throws Exception {
        long l = -1L;
        l = this.file.getSize();
        return l;
    }

    public long usedSize() throws Exception {
        long l = -1L;
        return l;
    }

    public long availableSize() throws Exception {
        long l = -1L;
        return l;
    }

    public long totalSize() throws Exception {
        long l = -1L;
        return l;
    }

    public long directorySize(boolean flag) throws Exception {
        long l = -1L;
        l = this.file.getSize();
        return l;
    }

    public long lastModified() throws Exception {
        long l = -1L;
        return l;
    }

    public boolean canRead() throws Exception {
        boolean l = false;
        return l;
    }

    public boolean canWrite() throws Exception {
        boolean l = false;
        return l;
    }

    public boolean isHidden() throws Exception {
        boolean l = false;
        return l;
    }

    public boolean setReadable(boolean mode) throws Exception {
        boolean result = true;
        return result;
    }

    public boolean setWritable(boolean mode) throws Exception {
        boolean result = true;
        return result;
    }

    public boolean setHidden(boolean mode) throws Exception {
        boolean result = true;
        return result;
    }

    public boolean rename(String newName) throws Exception {
        boolean result = true;
        this.ftp.rnfr(this.location);
        this.ftp.rnto(newName);
        return result;
    }
}

