/*
 * Decompiled with CFR 0.152.
 */
package gps;

import gps.BluetoothConnection;
import gps.Coordinates;
import gps.MessageListener;
import gps.NMEAMessages;
import gps.NMEAObject;
import gps.SIRFMessages;
import gps.Satellite;

public class GPS
implements MessageListener {
    private static final double KnotsToMiles = 1.15078;
    private NMEAObject message = null;
    private BluetoothConnection bt = null;
    private NMEAObject GSVSentence1;
    private NMEAObject GSVSentence2;
    private NMEAObject GSVSentence3;
    private String time = "";
    private float speedKmh = 0.0f;
    private float speedKnot = 0.0f;
    private String fixQuality = "";
    private int satellitesNumber = 0;
    private float HDOP = 0.0f;
    private float DOP = 0.0f;
    private float VDOP = 0.0f;
    private float altitudeDifference = 0.0f;
    private String fixType = "";
    private char fixSelectionType = (char)78;
    private int[] satellitesForFix = new int[12];
    private static Satellite[] satellitesInView = new Satellite[12];
    private static Satellite[] satellitesTemp = new Satellite[12];
    private char status = (char)78;
    private float azimuth = 0.0f;
    private float magneticAzimuth = 0.0f;
    private String date = "";
    private String magneticVariation = "";
    private int numberOfSatellitesInView = 0;
    private char validityOfData = (char)78;
    private String waypointLatitude = "";
    private String waypointLongitude = "";
    private String waypointName = "";
    private int residualsMode = -1;
    private boolean hasFix = false;
    private Coordinates point = new Coordinates(0.0, 0.0f);
    private SIRFMessages sirfMessages = null;
    private NMEAMessages nmeaMessages = null;

    public GPS(BluetoothConnection bluetoothManager) {
        this.bt = bluetoothManager;
        this.bt.setMessageListener(this);
        this.sirfMessages = new SIRFMessages(this.bt);
        this.nmeaMessages = new NMEAMessages(this.bt);
    }

    public void setBluetooth(BluetoothConnection bluetoothConnection) {
        this.bt = bluetoothConnection;
        this.bt.setMessageListener(this);
    }

    public BluetoothConnection getBluetooth() {
        return this.bt;
    }

    public Coordinates getCoordinates() {
        return this.point;
    }

    public float getAltitudeDifference() {
        return this.altitudeDifference;
    }

    public String getTime() {
        return this.makeTimeAndDate(this.time);
    }

    public float getSpeedKmh() {
        return this.speedKmh;
    }

    public float getSpeedMph() {
        return (float)((double)this.speedKnot * 1.15078);
    }

    public float getSpeedMS() {
        return (float)((double)this.speedKmh / 3.6);
    }

    public float getSpeedKnot() {
        return this.speedKnot;
    }

    public String getNMEAMessage() {
        return this.message.toNMEASentence();
    }

    public int getResidualsMode() {
        return this.residualsMode;
    }

    public boolean hasFix() {
        return this.hasFix;
    }

    public String getMagneticVariation() {
        return this.magneticVariation;
    }

    public char getValidityOfData() {
        return this.validityOfData;
    }

    public String getFixType() {
        return this.fixType;
    }

    public char getFixSelectionType() {
        return this.fixSelectionType;
    }

    public int getSatellitesNumber() {
        return this.satellitesNumber;
    }

    public int[] getSatellitesForFix() {
        return this.satellitesForFix;
    }

    public float getHorizontalDilution() {
        return this.HDOP;
    }

    public float getVerticalDilution() {
        return this.VDOP;
    }

    public float getDilution() {
        return this.DOP;
    }

    public String getFixQuality() {
        return this.fixQuality;
    }

    public float getAzimuth() {
        return this.azimuth;
    }

    public float getMagneticAzimuth() {
        return this.magneticAzimuth;
    }

    public String getDate() {
        return this.date;
    }

    public char getStatus() {
        return this.status;
    }

    public int getNumberOfSatellitesInView() {
        return this.numberOfSatellitesInView;
    }

    public Satellite[] getSatellitesInView() {
        return satellitesInView;
    }

    public void switchToNMEAProtocol() {
        this.sirfMessages.sendSIRFMessageToNMEAProtocol();
    }

    public void switchToNMEAProtocol(int GGARate, int GLLRate, int GSARate, int GSVRate, int MSSRate, int RMCRate, int VTGRate, int baud) throws NumberFormatException {
        if (GGARate < 0 || GGARate > 255) {
            throw new NumberFormatException("Rate must be between 0 and 255.");
        }
        if (GLLRate < 0 || GLLRate > 255) {
            throw new NumberFormatException("Rate must be between 0 and 255.");
        }
        if (GSARate < 0 || GSARate > 255) {
            throw new NumberFormatException("Rate must be between 0 and 255.");
        }
        if (GSVRate < 0 || GSVRate > 255) {
            throw new NumberFormatException("Rate must be between 0 and 255.");
        }
        if (MSSRate < 0 || MSSRate > 255) {
            throw new NumberFormatException("Rate must be between 0 and 255.");
        }
        if (RMCRate < 0 || RMCRate > 255) {
            throw new NumberFormatException("Rate must be between 0 and 255.");
        }
        if (VTGRate < 0 || VTGRate > 255) {
            throw new NumberFormatException("Rate must be between 0 and 255.");
        }
        if (baud != 1200 && baud != 2400 && baud != 4800 && baud != 9600 && baud != 19200 && baud != 38400 && baud != 57600) {
            throw new NumberFormatException("Invalid Baud number");
        }
        this.sirfMessages.sendSIRFMessageToNMEAProtocol(GGARate, GLLRate, GSARate, GSVRate, MSSRate, RMCRate, VTGRate, baud);
    }

    public void switchToSIRFProtocol() {
        this.nmeaMessages.setSIRFProtocol(9600);
    }

    public void switchToSIRFProtocol(int baud) throws NumberFormatException {
        if (baud != 4800 && baud != 9600 && baud != 19200 && baud != 38400) {
            throw new NumberFormatException("Invalid Baud number");
        }
        this.nmeaMessages.setSIRFProtocol(baud);
    }

    public void setDGPSPort() {
        this.nmeaMessages.setDGPSPort(9600);
    }

    public void setDGPSPort(int baud) throws NumberFormatException {
        if (baud != 4800 && baud != 9600 && baud != 19200 && baud != 38400) {
            throw new NumberFormatException("Invalid Baud number");
        }
        this.nmeaMessages.setDGPSPort(baud);
    }

    public void setGGARate(int rate) throws NumberFormatException {
        if (rate > 255 || rate < 0) {
            throw new NumberFormatException(" Rate value must be between 0 and 255");
        }
        this.nmeaMessages.setGGARate(rate);
    }

    public void setGLLRate(int rate) throws NumberFormatException {
        if (rate > 255 || rate < 0) {
            throw new NumberFormatException(" Rate value must be between 0 and 255");
        }
        this.nmeaMessages.setGLLRate(rate);
    }

    public void setGSARate(int rate) throws NumberFormatException {
        if (rate > 255 || rate < 0) {
            throw new NumberFormatException(" Rate value must be between 0 and 255");
        }
        this.nmeaMessages.setGSARate(rate);
    }

    public void setGSVRate(int rate) throws NumberFormatException {
        if (rate > 255 || rate < 0) {
            throw new NumberFormatException(" Rate value must be between 0 and 255");
        }
        this.nmeaMessages.setGSVRate(rate);
    }

    public void setRMCRate(int rate) throws NumberFormatException {
        if (rate > 255 || rate < 0) {
            throw new NumberFormatException(" Rate value must be between 0 and 255");
        }
        this.nmeaMessages.setRMCRate(rate);
    }

    public void setVTGRate(int rate) throws NumberFormatException {
        if (rate > 255 || rate < 0) {
            throw new NumberFormatException(" Rate value must be between 0 and 255");
        }
        this.nmeaMessages.setVTGRate(rate);
    }

    public void setSBAS(boolean on) {
        this.nmeaMessages.setSbas(on);
    }

    private void process() {
        if (this.message.getType().equals("GPGGA")) {
            this.time = this.message.getData(1);
            this.point.setTime(this.makeTimeAndDate(this.time));
            try {
                this.hasFix = !this.message.getData(2).equals("") && this.bt.isServiceConnected();
                this.point.setLatitude(this.degreesMinToDegrees(this.message.getData(2) + this.message.getData(3)));
                this.point.setLongitude(this.degreesMinToDegrees(this.message.getData(4) + this.message.getData(5)));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (this.message.getData(6) != "") {
                try {
                    switch (Integer.parseInt(this.message.getData(6))) {
                        case 0: {
                            this.fixQuality = "invalid";
                            break;
                        }
                        case 1: {
                            this.fixQuality = "gps fix";
                            break;
                        }
                        case 2: {
                            this.fixQuality = "DGPS fix";
                            break;
                        }
                        case 3: {
                            this.fixQuality = "PPS fix";
                            break;
                        }
                        case 4: {
                            this.fixQuality = "Real Time Kinematic";
                            break;
                        }
                        case 5: {
                            this.fixQuality = "Float Real Time Kinematic";
                            break;
                        }
                        case 6: {
                            this.fixQuality = "estimated";
                            break;
                        }
                        case 7: {
                            this.fixQuality = "Manual input mode";
                            break;
                        }
                        case 8: {
                            this.fixQuality = "Simulation mode";
                        }
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                this.satellitesNumber = Integer.parseInt(this.message.getData(7));
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.HDOP = Float.parseFloat(this.message.getData(8));
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.point.setAltitude(Float.parseFloat(this.message.getData(9)));
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.altitudeDifference = Float.parseFloat(this.message.getData(11));
            }
            catch (Exception e) {}
        } else if (this.message.getType().equals("GPGSA")) {
            if (this.message.getData(1) == "A") {
                this.fixSelectionType = (char)65;
            } else if (this.message.getData(1) == "M") {
                this.fixSelectionType = (char)77;
            }
            try {
                switch (Integer.parseInt(this.message.getData(2))) {
                    case 1: {
                        this.fixType = "no fix";
                        this.hasFix = false;
                        break;
                    }
                    case 2: {
                        this.fixType = "2D fix";
                        if (this.bt.isServiceConnected()) {
                            this.hasFix = true;
                            break;
                        }
                        this.hasFix = false;
                        break;
                    }
                    case 3: {
                        this.fixType = "3D fix";
                        this.hasFix = this.bt.isServiceConnected();
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            for (int i = 0; i <= 11; ++i) {
                try {
                    this.satellitesForFix[i] = Integer.parseInt(this.message.getData(i + 3));
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                this.DOP = Float.parseFloat(this.message.getData(15));
                this.HDOP = Float.parseFloat(this.message.getData(16));
                this.VDOP = Float.parseFloat(this.message.getData(17));
            }
            catch (Exception e) {}
        } else if (!this.message.getType().equals("GPGST")) {
            if (this.message.getType().equals("GPGSV")) {
                switch (Integer.parseInt(this.message.getData(2))) {
                    case 1: {
                        this.GSVSentence1 = this.message;
                        break;
                    }
                    case 2: {
                        this.GSVSentence2 = this.message;
                        break;
                    }
                    case 3: {
                        this.GSVSentence3 = this.message;
                        this.processGSV(this.GSVSentence1);
                        this.processGSV(this.GSVSentence2);
                        this.processGSV(this.GSVSentence3);
                    }
                }
            } else if (this.message.getType().equals("GPRMC")) {
                this.time = this.message.getData(1);
                this.point.setTime(this.makeTimeAndDate(this.time));
                if (this.message.getData(2) == "A") {
                    this.status = (char)65;
                } else if (this.message.getData(2) == "M") {
                    this.status = (char)77;
                }
                try {
                    this.hasFix = !this.message.getData(3).equals("") && this.bt.isServiceConnected();
                    this.point.setLatitude(this.degreesMinToDegrees(this.message.getData(3) + this.message.getData(4)));
                    this.point.setLongitude(this.degreesMinToDegrees(this.message.getData(5) + this.message.getData(6)));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                try {
                    this.speedKnot = Float.parseFloat(this.message.getData(7));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    this.azimuth = Float.parseFloat(this.message.getData(8));
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.date = this.makeTimeAndDate(this.message.getData(9));
                this.magneticVariation = this.message.getData(10) + this.message.getData(11);
            } else if (this.message.getType().equals("GPGLL")) {
                try {
                    if (this.message.getData(1) == "") {
                        this.hasFix = false;
                    }
                    this.point.setLatitude(this.degreesMinToDegrees(this.message.getData(1) + this.message.getData(2)));
                    this.point.setLongitude(this.degreesMinToDegrees(this.message.getData(3) + this.message.getData(4)));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                this.time = this.message.getData(5);
                if (this.message.getData(6) == "A") {
                    this.validityOfData = (char)65;
                }
            } else if (this.message.getType().equals("GPVTG")) {
                try {
                    this.azimuth = Float.parseFloat(this.message.getData(1));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    this.magneticAzimuth = Float.parseFloat(this.message.getData(3));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    this.speedKnot = Float.parseFloat(this.message.getData(5));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    this.hasFix = !this.message.getData(7).equals("") && this.bt.isServiceConnected();
                    this.speedKmh = Float.parseFloat(this.message.getData(7));
                }
                catch (Exception e) {}
            } else if (this.message.getType().equals("GPWPL")) {
                this.waypointLatitude = this.message.getData(1) + this.message.getData(2);
                this.waypointLongitude = this.message.getData(3) + this.message.getData(4);
                this.waypointName = this.message.getData(5);
            } else if (!(this.message.getType().equals("GPAAM") || this.message.getType().equals("GPAPB") || this.message.getType().equals("GPBOD") || this.message.getType().equals("GPBWC") || this.message.getType().equals("GPRTE") || this.message.getType().equals("GPXTE") || this.message.getType().equals("GPALM") || this.message.getType().equals("GPZDA") || this.message.getType().equals("GPMSK") || this.message.getType().equals("GPMSS"))) {
                if (this.message.getType().equals("GPGRS")) {
                    try {
                        this.residualsMode = Integer.parseInt(this.message.getData(2));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    for (int i = 1; i <= 12; ++i) {
                        try {
                            satellitesInView[i].setResidual(Float.parseFloat(this.message.getData(i + 2)));
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                } else if (this.message.getType().equals("GPROO") || this.message.getType().equals("GPRMA") || this.message.getType().equals("GPRMB") || this.message.getType().equals("GPTRF") || this.message.getType().equals("GPSTN") || this.message.getType().equals("GPVBW")) {
                    // empty if block
                }
            }
        }
    }

    private String makeTimeAndDate(String time) {
        StringBuffer result = new StringBuffer();
        try {
            result.append(time.charAt(0));
            result.append(time.charAt(1));
            result.append(':');
            result.append(time.charAt(2));
            result.append(time.charAt(3));
            result.append(':');
            result.append(time.charAt(4));
            result.append(time.charAt(5));
        }
        catch (StringIndexOutOfBoundsException e) {
            return "00:00:00";
        }
        return result.toString();
    }

    private double degreesMinToDegrees(String position) throws NumberFormatException {
        try {
            double result;
            if (position.charAt(position.length() - 1) == 'W' || position.charAt(position.length() - 1) == 'E') {
                result = Double.parseDouble(position.substring(6, 10)) / 10000.0;
                result = (Double.parseDouble(position.substring(3, 5)) + result) / 60.0;
                result += Double.parseDouble(position.substring(0, 3));
            } else {
                result = Double.parseDouble(position.substring(5, 9)) / 10000.0;
                result = (Double.parseDouble(position.substring(2, 4)) + result) / 60.0;
                result += Double.parseDouble(position.substring(0, 2));
            }
            if (position.charAt(position.length() - 1) == 'W' || position.charAt(position.length() - 1) == 'S') {
                return -result;
            }
            return result;
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new NumberFormatException("The format is not valid");
        }
    }

    public void messageReceived(String NMEAMessage) {
        this.message = new NMEAObject();
        this.message.setData(NMEAMessage);
        this.process();
    }

    private void processGSV(NMEAObject message) {
        int sentenceNumber = 0;
        int sentenceTotal = 0;
        int i = 0;
        try {
            sentenceNumber = Integer.parseInt(message.getData(2));
            sentenceTotal = Integer.parseInt(message.getData(1));
        }
        catch (Exception e) {
            // empty catch block
        }
        if (sentenceNumber == 1 && Integer.parseInt(message.getData(3)) != this.numberOfSatellitesInView) {
            this.numberOfSatellitesInView = Integer.parseInt(message.getData(3));
            satellitesInView = new Satellite[this.numberOfSatellitesInView];
            satellitesTemp = new Satellite[this.numberOfSatellitesInView];
        }
        Satellite sat = new Satellite();
        try {
            for (i = 1; i <= 4; ++i) {
                sat = new Satellite();
                sat.setPRN(Integer.parseInt(message.getData(i * 4)));
                sat.setElevation(Integer.parseInt(message.getData(i * 4 + 1)));
                sat.setAzimuth(Integer.parseInt(message.getData(i * 4 + 2)));
                sat.setSNR(Integer.parseInt(message.getData(i * 4 + 3)));
                GPS.satellitesTemp[i - 1 + (sentenceNumber - 1) * 4] = sat;
            }
        }
        catch (Exception e) {
            GPS.satellitesTemp[i - 1 + (sentenceNumber - 1) * 4] = sat;
        }
        if (sentenceNumber == sentenceTotal) {
            satellitesInView = satellitesTemp;
        }
    }
}

