/*
 * Decompiled with CFR 0.152.
 */
package gps.utilities;

import gps.utilities.Float11;

class LambertConformalConicProjection {
    private static double firstEllipsoidalSemiMajor;
    private static double firstEllipsoidalSemiMinor;
    private static double secondEllipsoidalSemiMajor;
    private static double secondEllipsoidalSemiMinor;
    private static double firstStandardParallel;
    private static double secondStandardParallel;
    private static double latitudeFalseOrigin;
    private static double longitudeFalseOrigin;
    private static double eastingFalseOrigin;
    private static double northingFalseOrigin;
    private static double latitude;
    private static double longitude;
    private static double easting;
    private static double northing;
    private static double height;
    private static double deltaX;
    private static double deltaY;
    private static double deltaZ;
    private static double deltaA;
    private static double deltaF;

    LambertConformalConicProjection() {
    }

    public static double[] WGS84toBD72(double lat, double lon) {
        double[] temp1 = new double[3];
        double[] temp2 = new double[2];
        double[] result = new double[2];
        temp1 = LambertConformalConicProjection.WGS84toBD72(lat, lon, 0.0);
        temp2[0] = temp1[0];
        temp2[1] = temp1[1];
        result = temp2;
        return result;
    }

    public static double[] WGS84toBD72(double lat, double lon, double h) {
        double[] result = new double[3];
        firstEllipsoidalSemiMajor = 6378137.0;
        firstEllipsoidalSemiMinor = 6356752.31414;
        secondEllipsoidalSemiMajor = 6378388.0;
        secondEllipsoidalSemiMinor = 6356911.946128;
        firstStandardParallel = Math.toRadians(51.166666667);
        secondStandardParallel = Math.toRadians(49.83333333);
        eastingFalseOrigin = 150000.0;
        northingFalseOrigin = 165373.0;
        latitudeFalseOrigin = Math.toRadians(50.79936);
        longitudeFalseOrigin = Math.toRadians(4.36749);
        deltaX = Math.toRadians(-125.8);
        deltaY = Math.toRadians(79.9);
        deltaZ = Math.toRadians(-100.5);
        deltaA = Math.toRadians(-251.0);
        deltaF = Math.toRadians(-1.4192702E-5);
        latitude = Math.toRadians(lat);
        longitude = Math.toRadians(lon);
        height = h;
        LambertConformalConicProjection.Molodensky();
        latitude = Math.toDegrees(latitude);
        longitude = Math.toDegrees(longitude);
        result[0] = latitude;
        result[1] = longitude;
        result[2] = height;
        return result;
    }

    public static double[] BD72toWGS84(double lat, double lon) {
        double[] temp1 = new double[3];
        double[] temp2 = new double[2];
        double[] result = new double[2];
        temp1 = LambertConformalConicProjection.BD72toWGS84(lat, lon, 0.0);
        temp2[0] = temp1[0];
        temp2[1] = temp1[1];
        result = temp2;
        return result;
    }

    public static double[] BD72toWGS84(double lat, double lon, double h) {
        double[] result = new double[3];
        firstEllipsoidalSemiMajor = 6378137.0;
        firstEllipsoidalSemiMinor = 6356752.31414;
        secondEllipsoidalSemiMajor = 6378388.0;
        secondEllipsoidalSemiMinor = 6356911.946128;
        firstStandardParallel = Math.toRadians(51.166666667);
        secondStandardParallel = Math.toRadians(49.83333333);
        eastingFalseOrigin = 150000.0;
        northingFalseOrigin = 165373.0;
        latitudeFalseOrigin = Math.toRadians(50.79936);
        longitudeFalseOrigin = Math.toRadians(4.36749);
        deltaX = Math.toRadians(125.8);
        deltaY = Math.toRadians(-79.9);
        deltaZ = Math.toRadians(100.5);
        deltaA = Math.toRadians(251.0);
        deltaF = Math.toRadians(1.4192702E-5);
        latitude = Math.toRadians(lat);
        longitude = Math.toRadians(lon);
        height = h;
        LambertConformalConicProjection.Molodensky();
        latitude = Math.toDegrees(latitude);
        longitude = Math.toDegrees(longitude);
        result[0] = latitude;
        result[1] = longitude;
        result[2] = height;
        return result;
    }

    public static double[] WGS84toLambert72(double lat, double lon) {
        double[] temp1 = new double[3];
        double[] temp2 = new double[2];
        double[] result = new double[2];
        temp1 = LambertConformalConicProjection.WGS84toLambert72(lat, lon, 0.0);
        temp2[0] = temp1[0];
        temp2[1] = temp1[1];
        result = temp2;
        return result;
    }

    public static double[] WGS84toLambert72(double lat, double lon, double h) {
        double[] result = new double[3];
        firstEllipsoidalSemiMajor = 6378137.0;
        firstEllipsoidalSemiMinor = 6356752.31414;
        secondEllipsoidalSemiMajor = 6378388.0;
        secondEllipsoidalSemiMinor = 6356911.946128;
        firstStandardParallel = Math.toRadians(51.166666667);
        secondStandardParallel = Math.toRadians(49.83333333);
        eastingFalseOrigin = 150000.0;
        northingFalseOrigin = 165373.0;
        latitudeFalseOrigin = Math.toRadians(50.79936);
        longitudeFalseOrigin = Math.toRadians(4.36749);
        deltaX = Math.toRadians(-125.8);
        deltaY = Math.toRadians(79.9);
        deltaZ = Math.toRadians(-100.5);
        deltaA = Math.toRadians(-251.0);
        deltaF = Math.toRadians(-1.4192702E-5);
        latitude = Math.toRadians(lat);
        longitude = Math.toRadians(lon);
        height = h;
        LambertConformalConicProjection.Molodensky();
        result[0] = LambertConformalConicProjection.Northing();
        result[1] = LambertConformalConicProjection.Easting();
        result[2] = height;
        return result;
    }

    public static double[] lambert72toWGS84(double north, double east) {
        double[] temp1 = new double[3];
        double[] temp2 = new double[2];
        double[] result = new double[2];
        temp1 = LambertConformalConicProjection.lambert72toWGS84(north, east, 0.0);
        temp2[0] = temp1[0];
        temp2[1] = temp1[1];
        result = temp2;
        return result;
    }

    public static double[] lambert72toWGS84(double north, double east, double h) {
        double[] result = new double[3];
        firstEllipsoidalSemiMajor = 6378137.0;
        firstEllipsoidalSemiMinor = 6356752.31414;
        secondEllipsoidalSemiMajor = 6378388.0;
        secondEllipsoidalSemiMinor = 6356911.946128;
        firstStandardParallel = Math.toRadians(51.166666667);
        secondStandardParallel = Math.toRadians(49.83333333);
        eastingFalseOrigin = 150000.0;
        northingFalseOrigin = 165373.0;
        latitudeFalseOrigin = Math.toRadians(50.79936);
        longitudeFalseOrigin = Math.toRadians(4.36749);
        deltaX = Math.toRadians(125.8);
        deltaY = Math.toRadians(-79.9);
        deltaZ = Math.toRadians(100.5);
        deltaA = Math.toRadians(251.0);
        deltaF = Math.toRadians(1.4192702E-5);
        northing = north;
        easting = east;
        height = h;
        latitude = LambertConformalConicProjection.latitude();
        longitude = LambertConformalConicProjection.longitude();
        LambertConformalConicProjection.Molodensky();
        latitude = Math.toDegrees(latitude);
        longitude = Math.toDegrees(longitude);
        result[0] = latitude;
        result[1] = longitude;
        result[2] = height;
        return result;
    }

    public static double[] WGS84toNTF(double lat, double lon) {
        double[] temp1 = new double[3];
        double[] temp2 = new double[2];
        double[] result = new double[2];
        temp1 = LambertConformalConicProjection.WGS84toNTF(lat, lon, 0.0);
        temp2[0] = temp1[0];
        temp2[1] = temp1[1];
        result = temp2;
        return result;
    }

    public static double[] WGS84toNTF(double lat, double lon, double h) {
        double[] result = new double[3];
        firstEllipsoidalSemiMajor = 6378137.0;
        firstEllipsoidalSemiMinor = 6356752.31414;
        secondEllipsoidalSemiMajor = 6378249.2;
        secondEllipsoidalSemiMinor = 6356515.0;
        firstStandardParallel = Math.toRadians(48.59852);
        secondStandardParallel = Math.toRadians(50.39591);
        eastingFalseOrigin = 600000.0;
        northingFalseOrigin = 1200000.0;
        latitudeFalseOrigin = Math.toRadians(49.5);
        longitudeFalseOrigin = Math.toRadians(2.33723);
        deltaX = Math.toRadians(-168.0);
        deltaY = Math.toRadians(-60.0);
        deltaZ = Math.toRadians(320.0);
        deltaA = Math.toRadians(-112.14);
        deltaF = Math.toRadians(-5.4750714E-5);
        latitude = Math.toRadians(lat);
        longitude = Math.toRadians(lon);
        height = h;
        LambertConformalConicProjection.Molodensky();
        latitude = Math.toDegrees(latitude);
        longitude = Math.toDegrees(longitude);
        result[0] = latitude;
        result[1] = longitude;
        result[2] = height;
        return result;
    }

    public static double[] NTFtoWGS84(double lat, double lon) {
        double[] temp1 = new double[3];
        double[] temp2 = new double[2];
        double[] result = new double[2];
        temp1 = LambertConformalConicProjection.NTFtoWGS84(lat, lon, 0.0);
        temp2[0] = temp1[0];
        temp2[1] = temp1[1];
        result = temp2;
        return result;
    }

    public static double[] NTFtoWGS84(double lat, double lon, double h) {
        double[] result = new double[3];
        firstEllipsoidalSemiMajor = 6378137.0;
        firstEllipsoidalSemiMinor = 6356752.31414;
        secondEllipsoidalSemiMajor = 6378249.2;
        secondEllipsoidalSemiMinor = 6356515.0;
        firstStandardParallel = Math.toRadians(48.59852);
        secondStandardParallel = Math.toRadians(50.39591);
        eastingFalseOrigin = 600000.0;
        northingFalseOrigin = 1200000.0;
        latitudeFalseOrigin = Math.toRadians(49.5);
        longitudeFalseOrigin = Math.toRadians(2.33723);
        deltaX = Math.toRadians(168.0);
        deltaY = Math.toRadians(60.0);
        deltaZ = Math.toRadians(-320.0);
        deltaA = Math.toRadians(112.14);
        deltaF = Math.toRadians(5.4750714E-5);
        latitude = Math.toRadians(lat);
        longitude = Math.toRadians(lon);
        height = h;
        LambertConformalConicProjection.Molodensky();
        latitude = Math.toDegrees(latitude);
        longitude = Math.toDegrees(longitude);
        result[0] = latitude;
        result[1] = longitude;
        result[2] = height;
        return result;
    }

    public static double[] WGS84toLambertI(double lat, double lon) {
        double[] temp1 = new double[3];
        double[] temp2 = new double[2];
        double[] result = new double[2];
        temp1 = LambertConformalConicProjection.WGS84toLambertI(lat, lon, 0.0);
        temp2[0] = temp1[0];
        temp2[1] = temp1[1];
        result = temp2;
        return result;
    }

    public static double[] WGS84toLambertI(double lat, double lon, double h) {
        double[] result = new double[3];
        firstEllipsoidalSemiMajor = 6378137.0;
        firstEllipsoidalSemiMinor = 6356752.31414;
        secondEllipsoidalSemiMajor = 6378249.2;
        secondEllipsoidalSemiMinor = 6356515.0;
        firstStandardParallel = Math.toRadians(48.59852);
        secondStandardParallel = Math.toRadians(50.39591);
        eastingFalseOrigin = 600000.0;
        northingFalseOrigin = 1200000.0;
        latitudeFalseOrigin = Math.toRadians(49.5);
        longitudeFalseOrigin = Math.toRadians(2.33723);
        deltaX = Math.toRadians(-168.0);
        deltaY = Math.toRadians(-60.0);
        deltaZ = Math.toRadians(320.0);
        deltaA = Math.toRadians(-112.14);
        deltaF = Math.toRadians(-5.4750714E-5);
        latitude = Math.toRadians(lat);
        longitude = Math.toRadians(lon);
        height = h;
        LambertConformalConicProjection.Molodensky();
        result[0] = LambertConformalConicProjection.Northing();
        result[1] = LambertConformalConicProjection.Easting();
        result[2] = height;
        return result;
    }

    public static double[] lambertItoWGS84(double north, double east) {
        double[] temp1 = new double[3];
        double[] temp2 = new double[2];
        double[] result = new double[2];
        temp1 = LambertConformalConicProjection.lambertItoWGS84(north, east, 0.0);
        temp2[0] = temp1[0];
        temp2[1] = temp1[1];
        result = temp2;
        return result;
    }

    public static double[] lambertItoWGS84(double north, double east, double h) {
        double[] result = new double[3];
        firstEllipsoidalSemiMajor = 6378137.0;
        firstEllipsoidalSemiMinor = 6356752.31414;
        secondEllipsoidalSemiMajor = 6378249.2;
        secondEllipsoidalSemiMinor = 6356515.0;
        firstStandardParallel = Math.toRadians(48.59852);
        secondStandardParallel = Math.toRadians(50.39591);
        eastingFalseOrigin = 600000.0;
        northingFalseOrigin = 1200000.0;
        latitudeFalseOrigin = Math.toRadians(49.5);
        longitudeFalseOrigin = Math.toRadians(2.33723);
        deltaX = Math.toRadians(168.0);
        deltaY = Math.toRadians(60.0);
        deltaZ = Math.toRadians(-320.0);
        deltaA = Math.toRadians(112.14);
        deltaF = Math.toRadians(5.4750714E-5);
        northing = north;
        easting = east;
        height = h;
        latitude = LambertConformalConicProjection.latitude();
        longitude = LambertConformalConicProjection.longitude();
        LambertConformalConicProjection.Molodensky();
        latitude = Math.toDegrees(latitude);
        longitude = Math.toDegrees(longitude);
        result[0] = latitude;
        result[1] = longitude;
        result[2] = height;
        return result;
    }

    public static double[] WGS84toLambertII(double lat, double lon) {
        double[] temp1 = new double[3];
        double[] temp2 = new double[2];
        double[] result = new double[2];
        temp1 = LambertConformalConicProjection.WGS84toLambertII(lat, lon, 0.0);
        temp2[0] = temp1[0];
        temp2[1] = temp1[1];
        result = temp2;
        return result;
    }

    public static double[] WGS84toLambertII(double lat, double lon, double h) {
        double[] result = new double[3];
        firstEllipsoidalSemiMajor = 6378137.0;
        firstEllipsoidalSemiMinor = 6356752.31414;
        secondEllipsoidalSemiMajor = 6378249.2;
        secondEllipsoidalSemiMinor = 6356515.0;
        firstStandardParallel = Math.toRadians(45.89892);
        secondStandardParallel = Math.toRadians(47.69601);
        eastingFalseOrigin = 600000.0;
        northingFalseOrigin = 2200000.0;
        latitudeFalseOrigin = Math.toRadians(46.8);
        longitudeFalseOrigin = Math.toRadians(2.33723);
        deltaX = Math.toRadians(-168.0);
        deltaY = Math.toRadians(-60.0);
        deltaZ = Math.toRadians(320.0);
        deltaA = Math.toRadians(-112.14);
        deltaF = Math.toRadians(-5.4750714E-5);
        latitude = Math.toRadians(lat);
        longitude = Math.toRadians(lon);
        height = h;
        LambertConformalConicProjection.Molodensky();
        result[0] = LambertConformalConicProjection.Northing();
        result[1] = LambertConformalConicProjection.Easting();
        result[2] = height;
        return result;
    }

    public static double[] lambertIItoWGS84(double north, double east) {
        double[] temp1 = new double[3];
        double[] temp2 = new double[2];
        double[] result = new double[2];
        temp1 = LambertConformalConicProjection.lambertIItoWGS84(north, east, 0.0);
        temp2[0] = temp1[0];
        temp2[1] = temp1[1];
        result = temp2;
        return result;
    }

    public static double[] lambertIItoWGS84(double north, double east, double h) {
        double[] result = new double[3];
        firstEllipsoidalSemiMajor = 6378137.0;
        firstEllipsoidalSemiMinor = 6356752.31414;
        secondEllipsoidalSemiMajor = 6378249.2;
        secondEllipsoidalSemiMinor = 6356515.0;
        firstStandardParallel = Math.toRadians(45.89892);
        secondStandardParallel = Math.toRadians(47.69601);
        eastingFalseOrigin = 600000.0;
        northingFalseOrigin = 2200000.0;
        latitudeFalseOrigin = Math.toRadians(46.8);
        longitudeFalseOrigin = Math.toRadians(2.33723);
        deltaX = Math.toRadians(168.0);
        deltaY = Math.toRadians(60.0);
        deltaZ = Math.toRadians(-320.0);
        deltaA = Math.toRadians(112.14);
        deltaF = Math.toRadians(5.4750714E-5);
        northing = north;
        easting = east;
        height = h;
        latitude = LambertConformalConicProjection.latitude();
        longitude = LambertConformalConicProjection.longitude();
        LambertConformalConicProjection.Molodensky();
        latitude = Math.toDegrees(latitude);
        longitude = Math.toDegrees(longitude);
        result[0] = latitude;
        result[1] = longitude;
        result[2] = height;
        return result;
    }

    public static double[] WGS84toLambertIIEtendu(double lat, double lon) {
        double[] temp1 = new double[3];
        double[] temp2 = new double[2];
        double[] result = new double[2];
        temp1 = LambertConformalConicProjection.WGS84toLambertIIEtendu(lat, lon, 0.0);
        temp2[0] = temp1[0];
        temp2[1] = temp1[1];
        result = temp2;
        return result;
    }

    public static double[] WGS84toLambertIIEtendu(double lat, double lon, double h) {
        double[] result = new double[3];
        firstEllipsoidalSemiMajor = 6378137.0;
        firstEllipsoidalSemiMinor = 6356752.31414;
        secondEllipsoidalSemiMajor = 6378249.2;
        secondEllipsoidalSemiMinor = 6356515.0;
        firstStandardParallel = Math.toRadians(45.89892);
        secondStandardParallel = Math.toRadians(47.69601);
        eastingFalseOrigin = 600000.0;
        northingFalseOrigin = 2200000.0;
        latitudeFalseOrigin = Math.toRadians(46.8);
        longitudeFalseOrigin = Math.toRadians(2.33723);
        deltaX = Math.toRadians(-168.0);
        deltaY = Math.toRadians(-60.0);
        deltaZ = Math.toRadians(320.0);
        deltaA = Math.toRadians(-112.14);
        deltaF = Math.toRadians(-5.4750714E-5);
        latitude = Math.toRadians(lat);
        longitude = Math.toRadians(lon);
        height = h;
        LambertConformalConicProjection.Molodensky();
        result[0] = LambertConformalConicProjection.Northing();
        result[1] = LambertConformalConicProjection.Easting();
        result[2] = height;
        return result;
    }

    public static double[] lambertIIEtendutoWGS84(double north, double east) {
        double[] temp1 = new double[3];
        double[] temp2 = new double[2];
        double[] result = new double[2];
        temp1 = LambertConformalConicProjection.lambertIIEtendutoWGS84(north, east, 0.0);
        temp2[0] = temp1[0];
        temp2[1] = temp1[1];
        result = temp2;
        return result;
    }

    public static double[] lambertIIEtendutoWGS84(double north, double east, double h) {
        double[] result = new double[3];
        firstEllipsoidalSemiMajor = 6378137.0;
        firstEllipsoidalSemiMinor = 6356752.31414;
        secondEllipsoidalSemiMajor = 6378249.2;
        secondEllipsoidalSemiMinor = 6356515.0;
        firstStandardParallel = Math.toRadians(45.89892);
        secondStandardParallel = Math.toRadians(47.69601);
        eastingFalseOrigin = 600000.0;
        northingFalseOrigin = 2200000.0;
        latitudeFalseOrigin = Math.toRadians(46.8);
        longitudeFalseOrigin = Math.toRadians(2.33723);
        deltaX = Math.toRadians(168.0);
        deltaY = Math.toRadians(60.0);
        deltaZ = Math.toRadians(-320.0);
        deltaA = Math.toRadians(112.14);
        deltaF = Math.toRadians(5.4750714E-5);
        northing = north;
        easting = east;
        height = h;
        latitude = LambertConformalConicProjection.latitude();
        longitude = LambertConformalConicProjection.longitude();
        LambertConformalConicProjection.Molodensky();
        latitude = Math.toDegrees(latitude);
        longitude = Math.toDegrees(longitude);
        result[0] = latitude;
        result[1] = longitude;
        result[2] = height;
        return result;
    }

    public static double[] WGS84toLambertIII(double lat, double lon) {
        double[] temp1 = new double[3];
        double[] temp2 = new double[2];
        double[] result = new double[2];
        temp1 = LambertConformalConicProjection.WGS84toLambertIII(lat, lon, 0.0);
        temp2[0] = temp1[0];
        temp2[1] = temp1[1];
        result = temp2;
        return result;
    }

    public static double[] WGS84toLambertIII(double lat, double lon, double h) {
        double[] result = new double[3];
        firstEllipsoidalSemiMajor = 6378137.0;
        firstEllipsoidalSemiMinor = 6356752.31414;
        secondEllipsoidalSemiMajor = 6378249.2;
        secondEllipsoidalSemiMinor = 6356515.0;
        firstStandardParallel = Math.toRadians(43.19929);
        secondStandardParallel = Math.toRadians(44.99609);
        eastingFalseOrigin = 600000.0;
        northingFalseOrigin = 3200000.0;
        latitudeFalseOrigin = Math.toRadians(44.1);
        longitudeFalseOrigin = Math.toRadians(2.33723);
        deltaX = Math.toRadians(-168.0);
        deltaY = Math.toRadians(-60.0);
        deltaZ = Math.toRadians(320.0);
        deltaA = Math.toRadians(-112.14);
        deltaF = Math.toRadians(-5.4750714E-5);
        latitude = Math.toRadians(lat);
        longitude = Math.toRadians(lon);
        height = h;
        LambertConformalConicProjection.Molodensky();
        result[0] = LambertConformalConicProjection.Northing();
        result[1] = LambertConformalConicProjection.Easting();
        result[2] = height;
        return result;
    }

    public static double[] lambertIIItoWGS84(double north, double east) {
        double[] temp1 = new double[3];
        double[] temp2 = new double[2];
        double[] result = new double[2];
        temp1 = LambertConformalConicProjection.lambertIIItoWGS84(north, east, 0.0);
        temp2[0] = temp1[0];
        temp2[1] = temp1[1];
        result = temp2;
        return result;
    }

    public static double[] lambertIIItoWGS84(double north, double east, double h) {
        double[] result = new double[3];
        firstEllipsoidalSemiMajor = 6378137.0;
        firstEllipsoidalSemiMinor = 6356752.31414;
        secondEllipsoidalSemiMajor = 6378249.2;
        secondEllipsoidalSemiMinor = 6356515.0;
        firstStandardParallel = Math.toRadians(43.19929);
        secondStandardParallel = Math.toRadians(44.99609);
        eastingFalseOrigin = 600000.0;
        northingFalseOrigin = 3200000.0;
        latitudeFalseOrigin = Math.toRadians(44.1);
        longitudeFalseOrigin = Math.toRadians(2.33723);
        deltaX = Math.toRadians(168.0);
        deltaY = Math.toRadians(60.0);
        deltaZ = Math.toRadians(-320.0);
        deltaA = Math.toRadians(112.14);
        deltaF = Math.toRadians(5.4750714E-5);
        northing = north;
        easting = east;
        height = h;
        latitude = LambertConformalConicProjection.latitude();
        longitude = LambertConformalConicProjection.longitude();
        LambertConformalConicProjection.Molodensky();
        latitude = Math.toDegrees(latitude);
        longitude = Math.toDegrees(longitude);
        result[0] = latitude;
        result[1] = longitude;
        result[2] = height;
        return result;
    }

    public static double[] WGS84toLambertIV(double lat, double lon) {
        double[] temp1 = new double[3];
        double[] temp2 = new double[2];
        double[] result = new double[2];
        temp1 = LambertConformalConicProjection.WGS84toLambertIV(lat, lon, 0.0);
        temp2[0] = temp1[0];
        temp2[1] = temp1[1];
        result = temp2;
        return result;
    }

    public static double[] WGS84toLambertIV(double lat, double lon, double h) {
        double[] result = new double[3];
        firstEllipsoidalSemiMajor = 6378137.0;
        firstEllipsoidalSemiMinor = 6356752.31414;
        secondEllipsoidalSemiMajor = 6378249.2;
        secondEllipsoidalSemiMinor = 6356515.0;
        firstStandardParallel = Math.toRadians(41.56039);
        secondStandardParallel = Math.toRadians(42.76766);
        eastingFalseOrigin = 234.358;
        northingFalseOrigin = 4185861.369;
        latitudeFalseOrigin = Math.toRadians(42.165);
        longitudeFalseOrigin = Math.toRadians(2.33723);
        deltaX = Math.toRadians(-168.0);
        deltaY = Math.toRadians(-60.0);
        deltaZ = Math.toRadians(320.0);
        deltaA = Math.toRadians(-112.14);
        deltaF = Math.toRadians(-5.4750714E-5);
        latitude = Math.toRadians(lat);
        longitude = Math.toRadians(lon);
        height = h;
        LambertConformalConicProjection.Molodensky();
        result[0] = LambertConformalConicProjection.Northing();
        result[1] = LambertConformalConicProjection.Easting();
        result[2] = height;
        return result;
    }

    public static double[] lambertIVtoWGS84(double north, double east) {
        double[] temp1 = new double[3];
        double[] temp2 = new double[2];
        double[] result = new double[2];
        temp1 = LambertConformalConicProjection.lambertIVtoWGS84(north, east, 0.0);
        temp2[0] = temp1[0];
        temp2[1] = temp1[1];
        result = temp2;
        return result;
    }

    public static double[] lambertIVtoWGS84(double north, double east, double h) {
        double[] result = new double[3];
        firstEllipsoidalSemiMajor = 6378137.0;
        firstEllipsoidalSemiMinor = 6356752.31414;
        secondEllipsoidalSemiMajor = 6378249.2;
        secondEllipsoidalSemiMinor = 6356515.0;
        firstStandardParallel = Math.toRadians(41.56039);
        secondStandardParallel = Math.toRadians(42.76766);
        eastingFalseOrigin = 234.358;
        northingFalseOrigin = 4185861.369;
        latitudeFalseOrigin = Math.toRadians(42.165);
        longitudeFalseOrigin = Math.toRadians(2.33723);
        deltaX = Math.toRadians(168.0);
        deltaY = Math.toRadians(60.0);
        deltaZ = Math.toRadians(-320.0);
        deltaA = Math.toRadians(112.14);
        deltaF = Math.toRadians(5.4750714E-5);
        northing = north;
        easting = east;
        height = h;
        latitude = LambertConformalConicProjection.latitude();
        longitude = LambertConformalConicProjection.longitude();
        LambertConformalConicProjection.Molodensky();
        latitude = Math.toDegrees(latitude);
        longitude = Math.toDegrees(longitude);
        result[0] = latitude;
        result[1] = longitude;
        result[2] = height;
        return result;
    }

    public static double[] WGS84toLambert93(double lat, double lon) {
        double[] temp1 = new double[3];
        double[] temp2 = new double[2];
        double[] result = new double[2];
        temp1 = LambertConformalConicProjection.WGS84toLambert93(lat, lon, 0.0);
        temp2[0] = temp1[0];
        temp2[1] = temp1[1];
        result = temp2;
        return result;
    }

    public static double[] WGS84toLambert93(double lat, double lon, double h) {
        double[] result = new double[3];
        firstEllipsoidalSemiMajor = 6378137.0;
        firstEllipsoidalSemiMinor = 6356752.31414;
        secondEllipsoidalSemiMajor = 6378137.0;
        secondEllipsoidalSemiMinor = 6356752.31414;
        firstStandardParallel = Math.toRadians(44.0);
        secondStandardParallel = Math.toRadians(49.0);
        eastingFalseOrigin = 700000.0;
        northingFalseOrigin = 6600000.0;
        latitudeFalseOrigin = Math.toRadians(46.5);
        longitudeFalseOrigin = Math.toRadians(3.0);
        deltaX = Math.toRadians(0.0);
        deltaY = Math.toRadians(0.0);
        deltaZ = Math.toRadians(0.0);
        deltaA = Math.toRadians(0.0);
        deltaF = Math.toRadians(-1.6E-11);
        latitude = Math.toRadians(lat);
        longitude = Math.toRadians(lon);
        height = h;
        LambertConformalConicProjection.Molodensky();
        result[0] = LambertConformalConicProjection.Northing();
        result[1] = LambertConformalConicProjection.Easting();
        result[2] = height;
        return result;
    }

    public static double[] lambert93toWGS84(double north, double east) {
        double[] temp1 = new double[3];
        double[] temp2 = new double[2];
        double[] result = new double[2];
        temp1 = LambertConformalConicProjection.lambert93toWGS84(north, east, 0.0);
        temp2[0] = temp1[0];
        temp2[1] = temp1[1];
        result = temp2;
        return result;
    }

    public static double[] lambert93toWGS84(double north, double east, double h) {
        double[] result = new double[3];
        firstEllipsoidalSemiMajor = 6378137.0;
        firstEllipsoidalSemiMinor = 6356752.31414;
        secondEllipsoidalSemiMajor = 6378137.0;
        secondEllipsoidalSemiMinor = 6356752.31414;
        firstStandardParallel = Math.toRadians(44.0);
        secondStandardParallel = Math.toRadians(49.0);
        eastingFalseOrigin = 700000.0;
        northingFalseOrigin = 6600000.0;
        latitudeFalseOrigin = Math.toRadians(46.5);
        longitudeFalseOrigin = Math.toRadians(3.0);
        deltaX = Math.toRadians(0.0);
        deltaY = Math.toRadians(0.0);
        deltaZ = Math.toRadians(0.0);
        deltaA = Math.toRadians(0.0);
        deltaF = Math.toRadians(1.6E-11);
        northing = north;
        easting = east;
        height = h;
        latitude = LambertConformalConicProjection.latitude();
        longitude = LambertConformalConicProjection.longitude();
        LambertConformalConicProjection.Molodensky();
        latitude = Math.toDegrees(latitude);
        longitude = Math.toDegrees(longitude);
        result[0] = latitude;
        result[1] = longitude;
        result[2] = height;
        return result;
    }

    private static double M() {
        return firstEllipsoidalSemiMajor * (1.0 - LambertConformalConicProjection.e2()) / Math.sqrt(Float11.pow(1.0 - LambertConformalConicProjection.e2() * Float11.pow(Math.sin(latitude), 2.0), 3.0));
    }

    private static double N() {
        return firstEllipsoidalSemiMajor / Math.sqrt(1.0 - LambertConformalConicProjection.e2() * Float11.pow(Math.sin(latitude), 2.0));
    }

    public static void Molodensky() {
        double deltaLatitude = (-1.0 * Math.sin(latitude) * Math.cos(longitude) * deltaX - Math.sin(latitude) * Math.sin(longitude) * deltaY + Math.cos(latitude) * deltaZ + LambertConformalConicProjection.N() * LambertConformalConicProjection.e2() * Math.sin(latitude) * Math.cos(latitude) / firstEllipsoidalSemiMajor * deltaA + (LambertConformalConicProjection.M() * (firstEllipsoidalSemiMajor / firstEllipsoidalSemiMinor) + LambertConformalConicProjection.N() * (firstEllipsoidalSemiMinor / firstEllipsoidalSemiMajor)) * deltaF * Math.sin(latitude) * Math.cos(latitude)) / LambertConformalConicProjection.M();
        double deltaLongitude = (-1.0 * Math.sin(longitude) * deltaX + Math.cos(longitude) * deltaY) / (LambertConformalConicProjection.N() * Math.cos(latitude));
        double deltaHeight = Math.cos(latitude) * Math.cos(longitude) * deltaX + Math.cos(latitude) * Math.sin(longitude) * deltaY + Math.sin(latitude) * deltaZ - firstEllipsoidalSemiMajor / LambertConformalConicProjection.N() * deltaA + firstEllipsoidalSemiMinor / firstEllipsoidalSemiMajor * deltaF * LambertConformalConicProjection.N() * Float11.pow(Math.sin(latitude), 2.0);
        latitude -= Math.toDegrees(deltaLatitude);
        longitude -= Math.toDegrees(deltaLongitude);
        height -= deltaHeight;
    }

    private static double fInverse() {
        return secondEllipsoidalSemiMajor / (secondEllipsoidalSemiMajor - secondEllipsoidalSemiMinor);
    }

    private static double e2() {
        return 2.0 * (1.0 / LambertConformalConicProjection.fInverse()) - Float11.pow(1.0 / LambertConformalConicProjection.fInverse(), 2.0);
    }

    private static double e() {
        return Math.sqrt(LambertConformalConicProjection.e2());
    }

    private static double m(double x, double y) {
        return Math.cos(x) / Float11.pow(1.0 - y * Float11.pow(Math.sin(x), 2.0), 0.5);
    }

    private static double t(double x, double y) {
        return Math.tan(0.7853981633974483 - 0.5 * x) / Float11.pow((1.0 - y * Math.sin(x)) / (1.0 + y * Math.sin(x)), 0.5 * y);
    }

    private static double n() {
        return (Float11.log(LambertConformalConicProjection.m(firstStandardParallel, LambertConformalConicProjection.e2())) - Float11.log(LambertConformalConicProjection.m(secondStandardParallel, LambertConformalConicProjection.e2()))) / (Float11.log(LambertConformalConicProjection.t(firstStandardParallel, LambertConformalConicProjection.e())) - Float11.log(LambertConformalConicProjection.t(secondStandardParallel, LambertConformalConicProjection.e())));
    }

    private static double f() {
        return LambertConformalConicProjection.m(firstStandardParallel, LambertConformalConicProjection.e2()) / (LambertConformalConicProjection.n() * Float11.pow(LambertConformalConicProjection.t(firstStandardParallel, LambertConformalConicProjection.e()), LambertConformalConicProjection.n()));
    }

    private static double r(double x) {
        return secondEllipsoidalSemiMajor * LambertConformalConicProjection.f() * Float11.pow(LambertConformalConicProjection.t(x, LambertConformalConicProjection.e()), LambertConformalConicProjection.n());
    }

    private static double phi() {
        return LambertConformalConicProjection.n() * (longitude - longitudeFalseOrigin);
    }

    private static double Easting() {
        return eastingFalseOrigin + LambertConformalConicProjection.r(latitude) * Math.sin(LambertConformalConicProjection.phi());
    }

    private static double Northing() {
        return northingFalseOrigin + LambertConformalConicProjection.r(latitudeFalseOrigin) - LambertConformalConicProjection.r(latitude) * Math.cos(LambertConformalConicProjection.phi());
    }

    private static double rInverse() {
        if (LambertConformalConicProjection.n() >= 0.0) {
            return Math.sqrt(Float11.pow(easting - eastingFalseOrigin, 2.0) + Float11.pow(LambertConformalConicProjection.r(latitudeFalseOrigin) - (northing - northingFalseOrigin), 2.0));
        }
        return -1.0 * Math.sqrt(Float11.pow(easting - eastingFalseOrigin, 2.0) + Float11.pow(LambertConformalConicProjection.r(latitudeFalseOrigin) - (northing - northingFalseOrigin), 2.0));
    }

    private static double tInverse() {
        return Float11.pow(LambertConformalConicProjection.rInverse() / (secondEllipsoidalSemiMajor * LambertConformalConicProjection.f()), 1.0 / LambertConformalConicProjection.n());
    }

    private static double phiInverse() {
        return Float11.atan((easting - eastingFalseOrigin) / (LambertConformalConicProjection.r(latitudeFalseOrigin) - (northing - northingFalseOrigin)));
    }

    private static double latitude() {
        double ecart = 1.0;
        double latitude0 = latitude = 0.0;
        while (ecart > 1.0E-10) {
            latitude = latitude0;
            latitude0 = 1.5707963267948966 - 2.0 * Float11.atan(LambertConformalConicProjection.tInverse() * Float11.pow((1.0 - LambertConformalConicProjection.e() * Math.sin(latitude)) / (1.0 + LambertConformalConicProjection.e() * Math.sin(latitude)), LambertConformalConicProjection.e() / 2.0));
            ecart = Math.abs(latitude - latitude0);
        }
        return latitude;
    }

    private static double longitude() {
        return LambertConformalConicProjection.phiInverse() / LambertConformalConicProjection.n() + longitudeFalseOrigin;
    }
}

