/*
 * Decompiled with CFR 0.152.
 */
package gps.utilities;

import gps.utilities.CH1903;
import gps.utilities.Float11;
import gps.utilities.LambertConformalConicProjection;

public abstract class Utilities {
    public static final int LATITUDE = 0;
    public static final int LONGITUDE = 1;
    private static final double metersToFeet = 3.28084;
    private static final double KnotsToKm = 1.852;
    private static final double KnotsToMiles = 1.15078;
    private static final double KMToMiles = 0.62137;
    private static final double yardsToFeet = 3.0;

    public static double[] toDatum(double latitude, double longitude, double altitude, int datum) throws NumberFormatException {
        double[] result = new double[3];
        switch (datum) {
            case 2: {
                result = CH1903.WGS84ToCH1903(latitude, longitude, altitude);
                break;
            }
            case 3: {
                result = Utilities.WGS84ToNTF(latitude, longitude, altitude);
                break;
            }
            case 4: {
                result = Utilities.WGS84ToLambert1(latitude, longitude, altitude);
                break;
            }
            case 5: {
                result = Utilities.WGS84ToLambert2(latitude, longitude, altitude);
                break;
            }
            case 6: {
                result = Utilities.WGS84ToLambert2E(latitude, longitude, altitude);
                break;
            }
            case 7: {
                result = Utilities.WGS84ToLambert3(latitude, longitude, altitude);
                break;
            }
            case 8: {
                result = Utilities.WGS84ToLambert4(latitude, longitude, altitude);
                break;
            }
            case 9: {
                result = Utilities.WGS84ToLambert93(latitude, longitude, altitude);
                break;
            }
            case 10: {
                result = Utilities.WGS84ToBD72(latitude, longitude, altitude);
                break;
            }
            case 11: {
                result = Utilities.WGS84ToLambert72(latitude, longitude, altitude);
                break;
            }
            default: {
                throw new NumberFormatException("The CoordinatesFormat is not valid, must be a valid datum");
            }
        }
        return result;
    }

    public static double[] toDatum(double latitude, double longitude, int datum) throws NumberFormatException {
        double[] result = new double[2];
        switch (datum) {
            case 2: {
                result = CH1903.WGS84ToCH1903(latitude, longitude);
                break;
            }
            case 3: {
                result = Utilities.WGS84ToNTF(latitude, longitude);
                break;
            }
            case 4: {
                result = Utilities.WGS84ToLambert1(latitude, longitude);
                break;
            }
            case 5: {
                result = Utilities.WGS84ToLambert2(latitude, longitude);
                break;
            }
            case 6: {
                result = Utilities.WGS84ToLambert2E(latitude, longitude);
                break;
            }
            case 7: {
                result = Utilities.WGS84ToLambert3(latitude, longitude);
                break;
            }
            case 8: {
                result = Utilities.WGS84ToLambert4(latitude, longitude);
                break;
            }
            case 9: {
                result = Utilities.WGS84ToLambert93(latitude, longitude);
                break;
            }
            case 10: {
                result = Utilities.WGS84ToBD72(latitude, longitude);
                break;
            }
            case 11: {
                result = Utilities.WGS84ToLambert72(latitude, longitude);
                break;
            }
            default: {
                throw new NumberFormatException("The CoordinatesFormat is not valid, must be a valid datum");
            }
        }
        return result;
    }

    public static double[] toWGS84(double y, double x, double altitude, int datum) throws NumberFormatException {
        double[] result = new double[3];
        switch (datum) {
            case 2: {
                result = CH1903.CH1903ToWGS84(y, x, altitude);
                break;
            }
            case 3: {
                result = Utilities.NTFToWGS84(y, x, altitude);
                break;
            }
            case 4: {
                result = Utilities.lambert1ToWGS84(y, x, altitude);
                break;
            }
            case 5: {
                result = Utilities.lambert2ToWGS84(y, x, altitude);
                break;
            }
            case 6: {
                result = Utilities.lambert2EToWGS84(y, x, altitude);
                break;
            }
            case 7: {
                result = Utilities.lambert3ToWGS84(y, x, altitude);
                break;
            }
            case 8: {
                result = Utilities.lambert4ToWGS84(y, x, altitude);
                break;
            }
            case 9: {
                result = Utilities.lambert93ToWGS84(y, x, altitude);
                break;
            }
            case 10: {
                result = Utilities.BD72ToWGS84(y, x, altitude);
                break;
            }
            case 11: {
                result = Utilities.lambert72ToWGS84(y, x, altitude);
                break;
            }
            default: {
                throw new NumberFormatException("The CoordinatesFormat is not valid, must be the code of a country");
            }
        }
        return result;
    }

    public static double[] toWGS84(double y, double x, int datum) throws NumberFormatException {
        double[] result = new double[2];
        switch (datum) {
            case 2: {
                result = CH1903.CH1903ToWGS84(y, x);
                break;
            }
            case 3: {
                result = Utilities.NTFToWGS84(y, x);
                break;
            }
            case 4: {
                result = Utilities.lambert1ToWGS84(y, x);
                break;
            }
            case 5: {
                result = Utilities.lambert2ToWGS84(y, x);
                break;
            }
            case 6: {
                result = Utilities.lambert2EToWGS84(y, x);
                break;
            }
            case 7: {
                result = Utilities.lambert3ToWGS84(y, x);
                break;
            }
            case 8: {
                result = Utilities.lambert4ToWGS84(y, x);
                break;
            }
            case 9: {
                result = Utilities.lambert93ToWGS84(y, x);
                break;
            }
            case 10: {
                result = Utilities.BD72ToWGS84(y, x);
                break;
            }
            case 11: {
                result = Utilities.lambert72ToWGS84(y, x);
                break;
            }
            default: {
                throw new NumberFormatException("The CoordinatesFormat is not valid, must be the code of a country");
            }
        }
        return result;
    }

    private static double[] WGS84ToNTF(double latitude, double longitude, double altitude) {
        double[] result = new double[3];
        result = LambertConformalConicProjection.WGS84toNTF(latitude, longitude, altitude);
        return result;
    }

    private static double[] WGS84ToNTF(double latitude, double longitude) {
        double[] result = new double[2];
        result = LambertConformalConicProjection.WGS84toNTF(latitude, longitude);
        return result;
    }

    private static double[] NTFToWGS84(double latitude, double longitude, double altitude) {
        double[] result = new double[3];
        result = LambertConformalConicProjection.NTFtoWGS84(latitude, longitude, altitude);
        return result;
    }

    private static double[] NTFToWGS84(double latitude, double longitude) {
        double[] result = new double[2];
        result = LambertConformalConicProjection.NTFtoWGS84(latitude, longitude);
        return result;
    }

    private static double[] WGS84ToLambert1(double latitude, double longitude, double altitude) {
        double[] result = new double[3];
        result = LambertConformalConicProjection.WGS84toLambertI(latitude, longitude, altitude);
        return result;
    }

    private static double[] WGS84ToLambert1(double latitude, double longitude) {
        double[] result = new double[2];
        result = LambertConformalConicProjection.WGS84toLambertI(latitude, longitude);
        return result;
    }

    private static double[] lambert1ToWGS84(double northing, double easting, double altitude) {
        double[] result = new double[3];
        result = LambertConformalConicProjection.lambertItoWGS84(northing, easting, altitude);
        return result;
    }

    private static double[] lambert1ToWGS84(double northing, double easting) {
        double[] result = new double[2];
        result = LambertConformalConicProjection.lambertItoWGS84(northing, easting);
        return result;
    }

    private static double[] WGS84ToLambert2(double latitude, double longitude, double altitude) {
        double[] result = new double[3];
        result = LambertConformalConicProjection.WGS84toLambertII(latitude, longitude, altitude);
        return result;
    }

    private static double[] WGS84ToLambert2(double latitude, double longitude) {
        double[] result = new double[2];
        result = LambertConformalConicProjection.WGS84toLambertII(latitude, longitude);
        return result;
    }

    private static double[] lambert2ToWGS84(double northing, double easting, double altitude) {
        double[] result = new double[3];
        result = LambertConformalConicProjection.lambertIItoWGS84(northing, easting, altitude);
        return result;
    }

    private static double[] lambert2ToWGS84(double northing, double easting) {
        double[] result = new double[2];
        result = LambertConformalConicProjection.lambertIItoWGS84(northing, easting);
        return result;
    }

    private static double[] WGS84ToLambert2E(double latitude, double longitude, double altitude) {
        double[] result = new double[3];
        result = LambertConformalConicProjection.WGS84toLambertIIEtendu(latitude, longitude, altitude);
        return result;
    }

    private static double[] WGS84ToLambert2E(double latitude, double longitude) {
        double[] result = new double[2];
        result = LambertConformalConicProjection.WGS84toLambertIIEtendu(latitude, longitude);
        return result;
    }

    private static double[] lambert2EToWGS84(double northing, double easting, double altitude) {
        double[] result = new double[3];
        result = LambertConformalConicProjection.lambertIIEtendutoWGS84(northing, easting, altitude);
        return result;
    }

    private static double[] lambert2EToWGS84(double northing, double easting) {
        double[] result = new double[2];
        result = LambertConformalConicProjection.lambertIIEtendutoWGS84(northing, easting);
        return result;
    }

    private static double[] WGS84ToLambert3(double latitude, double longitude, double altitude) {
        double[] result = new double[3];
        result = LambertConformalConicProjection.WGS84toLambertIII(latitude, longitude, altitude);
        return result;
    }

    private static double[] WGS84ToLambert3(double latitude, double longitude) {
        double[] result = new double[2];
        result = LambertConformalConicProjection.WGS84toLambertIII(latitude, longitude);
        return result;
    }

    private static double[] lambert3ToWGS84(double northing, double easting, double altitude) {
        double[] result = new double[3];
        result = LambertConformalConicProjection.lambertIIItoWGS84(northing, easting, altitude);
        return result;
    }

    private static double[] lambert3ToWGS84(double northing, double easting) {
        double[] result = new double[2];
        result = LambertConformalConicProjection.lambertIIItoWGS84(northing, easting);
        return result;
    }

    private static double[] WGS84ToLambert4(double latitude, double longitude, double altitude) {
        double[] result = new double[3];
        result = LambertConformalConicProjection.WGS84toLambertIV(latitude, longitude, altitude);
        return result;
    }

    private static double[] WGS84ToLambert4(double latitude, double longitude) {
        double[] result = new double[2];
        result = LambertConformalConicProjection.WGS84toLambertIV(latitude, longitude);
        return result;
    }

    private static double[] lambert4ToWGS84(double northing, double easting, double altitude) {
        double[] result = new double[3];
        result = LambertConformalConicProjection.lambertIVtoWGS84(northing, easting, altitude);
        return result;
    }

    private static double[] lambert4ToWGS84(double northing, double easting) {
        double[] result = new double[2];
        result = LambertConformalConicProjection.lambertIVtoWGS84(northing, easting);
        return result;
    }

    private static double[] WGS84ToLambert93(double latitude, double longitude, double altitude) {
        double[] result = new double[3];
        result = LambertConformalConicProjection.WGS84toLambert93(latitude, longitude, altitude);
        return result;
    }

    private static double[] WGS84ToLambert93(double latitude, double longitude) {
        double[] result = new double[2];
        result = LambertConformalConicProjection.WGS84toLambert93(latitude, longitude);
        return result;
    }

    private static double[] lambert93ToWGS84(double northing, double easting, double altitude) {
        double[] result = new double[3];
        result = LambertConformalConicProjection.lambert93toWGS84(northing, easting, altitude);
        return result;
    }

    private static double[] lambert93ToWGS84(double northing, double easting) {
        double[] result = new double[2];
        result = LambertConformalConicProjection.lambert93toWGS84(northing, easting);
        return result;
    }

    private static double[] WGS84ToBD72(double latitude, double longitude, double altitude) {
        double[] result = new double[3];
        result = LambertConformalConicProjection.WGS84toBD72(latitude, longitude, altitude);
        return result;
    }

    private static double[] WGS84ToBD72(double latitude, double longitude) {
        double[] result = new double[2];
        result = LambertConformalConicProjection.WGS84toBD72(latitude, longitude);
        return result;
    }

    private static double[] BD72ToWGS84(double latitude, double longitude, double altitude) {
        double[] result = new double[3];
        result = LambertConformalConicProjection.BD72toWGS84(latitude, longitude, altitude);
        return result;
    }

    private static double[] BD72ToWGS84(double latitude, double longitude) {
        double[] result = new double[2];
        result = LambertConformalConicProjection.BD72toWGS84(latitude, longitude);
        return result;
    }

    private static double[] WGS84ToLambert72(double latitude, double longitude, double altitude) {
        double[] result = new double[3];
        result = LambertConformalConicProjection.WGS84toLambert72(latitude, longitude, altitude);
        return result;
    }

    private static double[] WGS84ToLambert72(double latitude, double longitude) {
        double[] result = new double[2];
        result = LambertConformalConicProjection.WGS84toLambert72(latitude, longitude);
        return result;
    }

    private static double[] lambert72ToWGS84(double northing, double easting, double altitude) {
        double[] result = new double[3];
        result = LambertConformalConicProjection.lambert72toWGS84(northing, easting, altitude);
        return result;
    }

    private static double[] lambert72ToWGS84(double northing, double easting) {
        double[] result = new double[2];
        result = LambertConformalConicProjection.lambert72toWGS84(northing, easting);
        return result;
    }

    public static double degreesMinSecToDegrees(String position) throws StringIndexOutOfBoundsException {
        try {
            double result;
            if (position.charAt(position.length() - 1) == 'W' || position.charAt(position.length() - 1) == 'E') {
                result = Double.parseDouble(position.substring(7, 12)) / 60.0;
                result = (Double.parseDouble(position.substring(4, 6)) + result) / 60.0;
                result += Double.parseDouble(position.substring(0, 3));
            } else {
                result = Double.parseDouble(position.substring(6, 11)) / 60.0;
                result = (Double.parseDouble(position.substring(3, 5)) + result) / 60.0;
                result += Double.parseDouble(position.substring(0, 2));
            }
            if (position.charAt(position.length() - 1) == 'W' || position.charAt(position.length() - 1) == 'S') {
                return -result;
            }
            return result;
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new StringIndexOutOfBoundsException("Bad entry format");
        }
    }

    public static String degreesToDegreesMinSec(double position, int i) throws NumberFormatException {
        String result = "";
        boolean isNegative = position < 0.0;
        position = Math.abs(position);
        if (i == 0) {
            if (position < 10.0) {
                result = result + '0';
            }
            result = result + Integer.toString((int)Math.floor(position)) + '\u00b0';
            if ((position = (position - Math.floor(position)) * 60.0) < 10.0) {
                result = result + '0';
            }
            result = result + Integer.toString((int)Math.floor(position)) + "'";
            position = (position - Math.floor(position)) * 60.0;
            if ((position = Math.floor(position * 100.0) / 100.0) < 10.0) {
                result = result + '0';
            }
            if ((result = result + Double.toString(position)).length() != 11) {
                result = result + '0';
            }
            result = result + "''";
            result = isNegative ? result + 'S' : result + 'N';
        } else if (i == 1) {
            if (position < 10.0) {
                result = result + "00";
            } else if (position < 100.0) {
                result = result + '0';
            }
            result = result + Integer.toString((int)Math.floor(position)) + '\u00b0';
            position = (position - Math.floor(position)) * 60.0;
            if (position < 10.0) {
                result = result + '0';
            }
            result = result + Integer.toString((int)Math.floor(position)) + "'";
            position = (position - Math.floor(position)) * 60.0;
            if ((position = Math.floor(position * 100.0) / 100.0) < 10.0) {
                result = result + '0';
            }
            if ((result = result + Double.toString(position)).length() != 12) {
                result = result + '0';
            }
            result = result + "''";
            result = isNegative ? result + 'W' : result + 'E';
        } else {
            throw new NumberFormatException("Bad argument i");
        }
        return result;
    }

    public static double distanceBetween(double lat1, double lon1, double lat2, double lon2) {
        try {
            double lat1Rad = Math.toRadians(lat1);
            double lon1Rad = Math.toRadians(lon1);
            double lat2Rad = Math.toRadians(lat2);
            double lon2Rad = Math.toRadians(lon2);
            double dlat = lat2Rad - lat1Rad;
            double dlon = lon2Rad - lon1Rad;
            double a = Math.sin(dlat / 2.0) * Math.sin(dlat / 2.0) + Math.cos(lat1Rad) * Math.cos(lat2Rad) * Math.sin(dlon / 2.0) * Math.sin(dlon / 2.0);
            double c = 2.0 * Float11.asin(Math.min(1.0, Math.sqrt(a)));
            return 6367000.0 * c;
        }
        catch (Exception e) {
            return Double.NEGATIVE_INFINITY;
        }
    }

    public static float KilometersToMiles(int kilometers) {
        return (float)((double)kilometers * 0.62137);
    }

    public static float KilometersToMiles(float kilometers) {
        return (float)((double)kilometers * 0.62137);
    }

    public static long KilometersToMiles(long kilometers) {
        return (long)((double)kilometers * 0.62137);
    }

    public static double KilometersToMiles(double kilometers) {
        return kilometers * 0.62137;
    }

    public static float milesToKilometers(int miles) {
        return (float)((double)miles / 0.62137);
    }

    public static float milesToKilometers(float miles) {
        return (float)((double)miles / 0.62137);
    }

    public static long milesToKilometers(long miles) {
        return (long)((double)miles / 0.62137);
    }

    public static double milesToKilometers(double miles) {
        return miles / 0.62137;
    }

    public static float msToKmh(int ms) {
        return (float)((double)ms * 3.6);
    }

    public static float msToKmh(float ms) {
        return (float)((double)ms * 3.6);
    }

    public static long msToKmh(long ms) {
        return (long)((double)ms * 3.6);
    }

    public static double msToKmh(double ms) {
        return ms * 3.6;
    }

    public static float kmhToMs(int kmh) {
        return (float)((double)kmh / 3.6);
    }

    public float kmhToMs(float kmh) {
        return (float)((double)kmh / 3.6);
    }

    public static long kmhToMs(long kmh) {
        return (long)((double)kmh / 3.6);
    }

    public static double kmhToMs(double kmh) {
        return kmh / 3.6;
    }

    public static float metersToYards(int meters) {
        return (float)((double)meters * 3.28084 / 3.0);
    }

    public static float metersToYards(float meters) {
        return (float)((double)meters * 3.28084 / 3.0);
    }

    public static long metersToYards(long meters) {
        return (long)((double)meters * 3.28084 / 3.0);
    }

    public static double metersToYards(double meters) {
        return meters * 3.28084 / 3.0;
    }

    public static float yardsToMeters(int yards) {
        return (float)((double)yards * 3.0 / 3.28084);
    }

    public static float yardsToMeters(float yards) {
        return (float)((double)yards * 3.0 / 3.28084);
    }

    public static long yardsToMeters(long yards) {
        return (long)((double)yards * 3.0 / 3.28084);
    }

    public static double yardsToMeters(double yards) {
        return yards * 3.0 / 3.28084;
    }

    public static float metersToFeet(int meters) {
        return (float)((double)meters * 3.28084);
    }

    public static float metersToFeet(float meters) {
        return (float)((double)meters * 3.28084);
    }

    public static long metersToFeet(long meters) {
        return (long)((double)meters * 3.28084);
    }

    public static double metersToFeet(double meters) {
        return meters * 3.28084;
    }

    public static float feetToMeters(int feet) {
        return (float)((double)feet / 3.28084);
    }

    public static float feetToMeters(float feet) {
        return (float)((double)feet / 3.28084);
    }

    public static long feetToMeters(long feet) {
        return (long)((double)feet / 3.28084);
    }

    public static double feetToMeters(double feet) {
        return feet / 3.28084;
    }

    public static float knotsToKm(int knots) {
        return (float)((double)knots * 1.852);
    }

    public static float knotsToKm(float knots) {
        return (float)((double)knots * 1.852);
    }

    public static long knotsToKm(long knots) {
        return (long)((double)knots * 1.852);
    }

    public static double knotsToKm(double knots) {
        return knots * 1.852;
    }

    public static float kmToKnots(int km) {
        return (float)((double)km / 1.852);
    }

    public static float kmToKnots(float km) {
        return (float)((double)km / 1.852);
    }

    public static long kmToKnots(long km) {
        return (long)((double)km / 1.852);
    }

    public static double kmToKnots(double km) {
        return km / 1.852;
    }

    public static float milesToKnots(int miles) {
        return (float)((double)miles / 1.15078);
    }

    public static float milesToKnots(float miles) {
        return (float)((double)miles / 1.15078);
    }

    public static long milesToKnots(long miles) {
        return (long)((double)miles / 1.15078);
    }

    public static double milesToKnots(double miles) {
        return miles / 1.15078;
    }

    public static float knotsToMiles(int knots) {
        return (float)((double)knots * 1.15078);
    }

    public static float knotsToMiles(float knots) {
        return (float)((double)knots * 1.15078);
    }

    public static long knotsToMiles(long knots) {
        return (long)((double)knots * 1.15078);
    }

    public static double knotsToMiles(double knots) {
        return knots * 1.15078;
    }
}

