/*
 * Decompiled with CFR 0.152.
 */
package menu;

import containers.Localizaton;
import framework.MainGameCanvas;
import framework.graphics.TextRenderer;
import framework.menu.IMenuFormListener;
import framework.menu.MenuForm;
import javax.microedition.lcdui.Graphics;
import menu.GoolMenu;
import root.GoolGlobals;

public class QuickMenu
extends GoolMenu
implements IMenuFormListener {
    MenuForm menu;
    public static MenuForm qMenu;
    public static MenuForm nextMenu;
    private int menuOffset;
    private String nextState;
    private int continue2ID;
    private int music2ID;
    private int exit2ID;
    private StringBuffer sensitivityBuff = new StringBuffer("1");
    private int maxSensitivity = 5;
    private int minTime = 1;
    private int maxTime = 5;

    public QuickMenu(String stateName, MainGameCanvas mainGameCanvas) {
        super(stateName, mainGameCanvas);
    }

    public void update(int deltaTime) {
        this.menu.update(deltaTime);
        super.update(deltaTime);
        if (this.enter) {
            this.enter(deltaTime);
        } else if (out) {
            this.out(deltaTime);
        }
    }

    public void keyPressed(int keyCode) {
        if (this.enter || out) {
            return;
        }
    }

    public void render(Graphics g) {
        super.render(g);
        this.menu.drawMenu(g);
    }

    private void createQuickMenu() {
        int fontSize = TextRenderer.getInstance().getStringHeight(1);
        int[] cols = new int[]{GoolGlobals.MAINMENU_MARGIN, GoolGlobals.menuBackground.getWidth() - GoolGlobals.MAINMENU_MARGIN, -1};
        int[] rows = new int[]{GoolGlobals.MAINMENU_BG_Y, GoolGlobals.menuBackground.getHeight() / 2 - 2 * fontSize, 2 * fontSize, 2 * fontSize, GoolGlobals.menuBackground.getHeight() / 2 - 2 * fontSize, -1};
        this.menu = MenuForm.createMenuForm(4, rows, cols, 240, 320, (byte)1, (byte)0);
        this.menu.listener = this;
        this.continue2ID = this.menu.createControl(4, 0, 2, 1, null, Localizaton.MENU_CONTINUE);
        this.exit2ID = this.menu.createControl(4, 1, 3, 1, null, Localizaton.EXIT);
        int tempID = this.menu.createControl(2, GoolGlobals.button.frameWidth, GoolGlobals.button.frameHeight, -1, 5, 0, 33, 18, GoolGlobals.button, Localizaton.SELECT, 0, 0);
        this.menu.setRendererFonts(tempID, "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED");
        tempID = this.menu.createControl(2, GoolGlobals.button.frameWidth, GoolGlobals.button.frameHeight, -1, 5, 2, 36, 18, GoolGlobals.button, Localizaton.BACK, 0, 0);
        this.menu.setRendererFonts(tempID, "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED");
        qMenu = this.menu;
    }

    public boolean initialize(Object param) {
        super.initialize(param);
        if (this.menu == null) {
            this.createQuickMenu();
        }
        this.menuOffset = GoolGlobals.background.getWidth();
        if (QuickMenu.qMenu.absoluteX >= 0) {
            this.changeMenuOffset(this.menuOffset, qMenu);
        }
        if (this.bgOffset >= 0) {
            this.changeBgOffset(this.menuOffset);
        }
        this.enter = true;
        this.nextState = null;
        nextMenu = null;
        return true;
    }

    public void notifyKeypressed(int formID, int controlID) {
    }

    public void changeMusic() {
        GoolGlobals.playMusic = !GoolGlobals.playMusic;
        this.menu.getControlByID((int)this.music2ID).text = GoolGlobals.playMusic ? new StringBuffer().append((Object)Localizaton.OPTIONS_MUSIC).append(" ").append((Object)Localizaton.ON) : new StringBuffer().append((Object)Localizaton.OPTIONS_MUSIC).append(" ").append((Object)Localizaton.OFF);
    }

    public void handleInput() {
        this.menu.handleInput(this.mainGameCanvas.getKeyStates());
    }

    public void enter(int deltaTime) {
        if (this.moveStart == 0L) {
            this.moveStart = this.currentTime;
        } else if (this.currentTime - this.moveStart > this.moveSpeed) {
            if (this.menuOffset > 0) {
                this.menuOffset -= GoolGlobals.MENU_OFFSET;
                this.changeMenuOffset(-GoolGlobals.MENU_OFFSET, this.menu);
                this.changeBgOffset(-GoolGlobals.MENU_OFFSET);
            } else {
                this.enter = false;
                this.moveStart = 0L;
            }
        }
    }

    public void out(int deltaTime) {
        if (this.moveStart == 0L) {
            this.moveStart = this.currentTime;
        } else if (this.currentTime - this.moveStart > this.moveSpeed) {
            if (this.menuOffset < GoolGlobals.background.getWidth()) {
                this.menuOffset += 8;
                this.changeMenuOffset(8, this.menu);
                this.changeBgOffset(8);
            } else {
                out = false;
                this.moveStart = 0L;
                if (this.nextState != null) {
                    this.mainGameCanvas.requestAppStateChange(this.nextState);
                } else if (nextMenu != null) {
                    this.menu = nextMenu;
                    this.enter = true;
                }
            }
        }
    }

    public void deinitialize() {
        this.nextState = null;
        nextMenu = null;
    }

    public void changeMenuOffset(int offset, MenuForm menu) {
        for (int i = 0; i < menu.controls.length - 2; ++i) {
            menu.controls[i].textPozX -= offset;
            menu.controls[i].pozX -= offset;
        }
        menu.absoluteX -= offset;
        menu.controls[menu.controls.length - 2].textPozY += offset;
        menu.controls[menu.controls.length - 1].textPozY += offset;
        menu.controls[menu.controls.length - 2].pozY += offset;
        menu.controls[menu.controls.length - 1].pozY += offset;
    }

    public void changeBgOffset(int offset) {
        this.bgOffset -= offset;
    }
}

