/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.asn1.x509.X509NameEntryConverter;
import org.bouncycastle.util.Strings;

public class X509DefaultEntryConverter
extends X509NameEntryConverter {
    public final ASN1Primitive a(ASN1ObjectIdentifier aSN1ObjectIdentifier, String string) {
        if (string.length() != 0 && string.charAt(0) == '#') {
            try {
                string = Strings.b(string);
                byte[] byArray = new byte[(string.length() - 1) / 2];
                for (int i2 = 0; i2 != byArray.length; ++i2) {
                    char c2 = string.charAt((i2 << 1) + 1);
                    char c3 = string.charAt((i2 << 1) + 1 + 1);
                    byArray[i2] = c2 < 'a' ? (byte)(c2 - 48 << 4) : (byte)(c2 - 97 + 10 << 4);
                    if (c3 < 'a') {
                        int n2 = i2;
                        byArray[n2] = (byte)(byArray[n2] | (byte)(c3 - 48));
                        continue;
                    }
                    int n3 = i2;
                    byArray[n3] = (byte)(byArray[n3] | (byte)(c3 - 97 + 10));
                }
                return new ASN1InputStream(byArray).b();
            }
            catch (IOException iOException) {
                throw new RuntimeException("can't recode value for oid " + aSN1ObjectIdentifier.c());
            }
        }
        if (string.length() != 0 && string.charAt(0) == '\\') {
            string = string.substring(1);
        }
        if (aSN1ObjectIdentifier.equals(X509Name.f) || aSN1ObjectIdentifier.equals(X509Name.g)) {
            return new DERIA5String(string);
        }
        if (aSN1ObjectIdentifier.equals(X509Name.d)) {
            return new DERGeneralizedTime(string);
        }
        if (aSN1ObjectIdentifier.equals(X509Name.a) || aSN1ObjectIdentifier.equals(X509Name.b) || aSN1ObjectIdentifier.equals(X509Name.c) || aSN1ObjectIdentifier.equals(X509Name.e)) {
            return new DERPrintableString(string);
        }
        return new DERUTF8String(string);
    }
}

