/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.DDDebug;
import com.ea.game.DDMath;
import com.ea.game.MainFrame;

class DDTextEntry {
    private static final int INPUT_DELAY_MS = 1000;
    private static final int INPUTMODE_OFF = -1;
    public static final int INPUTMODE_ALPHANUMERIC = 0;
    public static final int INPUTMODE_NUMERIC = 1;
    private static int m_inputMode = -1;
    private static boolean m_capsLock = true;
    private static char[] m_inputString;
    private static int m_currentInputChar;
    private static int m_lastKeycode;
    private static int m_keycodeCharId;
    private static int m_keycodeCharCycleIndex;
    private static int m_lastKeypressTime;
    private static String[] m_keyInputChars;
    private static String[] m_qwertyKeyInputChars;

    DDTextEntry() {
    }

    public static boolean isTextInputActive() {
        return m_inputMode != -1;
    }

    public static void deactivateTextInput() {
        if (m_inputMode != -1) {
            if (m_keycodeCharId >= 0) {
                m_currentInputChar = DDMath.min(m_currentInputChar + 1, m_inputString.length - 1);
                m_keycodeCharId = -1;
                m_keycodeCharCycleIndex = 0;
                m_lastKeycode = -1;
            }
            m_inputMode = -1;
        }
    }

    public static void initTextEntry(int n2, int n3, byte[] byArray, int n4) {
        m_inputMode = n2;
        m_inputString = new char[n3 + 1];
        if (byArray == null) {
            m_currentInputChar = 0;
        } else {
            for (int i2 = 0; i2 < n4 && i2 < n3; ++i2) {
                DDTextEntry.m_inputString[i2] = (char)byArray[i2];
            }
            m_currentInputChar = n4;
        }
        if (m_currentInputChar <= n3) {
            DDTextEntry.m_inputString[DDTextEntry.m_currentInputChar] = 45;
        }
        m_lastKeycode = -1;
        m_keycodeCharId = -1;
        m_keycodeCharCycleIndex = 0;
    }

    public static void update() {
        if (DDTextEntry.isTextInputActive()) {
            int n2 = (int)MainFrame.m_canvas.getAppTime() - m_lastKeypressTime;
            if (m_keycodeCharId >= 0 && n2 > 1000) {
                DDTextEntry.setInputChar(m_keyInputChars[m_keycodeCharId].charAt(m_keycodeCharCycleIndex), true);
                DDTextEntry.m_inputString[DDTextEntry.m_currentInputChar] = 45;
            }
        }
    }

    public static int getInputStringLength() {
        return m_currentInputChar;
    }

    public static int getInputStringBytes(byte[] byArray, int n2) {
        for (int i2 = 0; i2 < m_inputString.length; ++i2) {
            byArray[n2 + i2] = (byte)m_inputString[i2];
        }
        return DDTextEntry.getInputStringLength();
    }

    public static void handleLetterPress(int n2) {
        if (n2 >= 97 && n2 <= 122) {
            n2 -= 32;
        }
        if (n2 >= 65 && n2 <= 90 || n2 == 46) {
            DDTextEntry.setInputChar((char)n2, true);
        } else {
            DDTextEntry.setInputChar(' ', true);
        }
    }

    public static int handleKeyPress(int n2) {
        int n3 = 0;
        int n4 = 0;
        if ((n2 & 0x20000) != 0) {
            n3 = 42;
        }
        if ((n2 & 0x80) != 0) {
            n3 = 48;
        }
        if ((n2 & 0x100) != 0) {
            n3 = 49;
        }
        if ((n2 & 0x200) != 0) {
            n3 = 50;
        }
        if ((n2 & 0x400) != 0) {
            n3 = 51;
        }
        if ((n2 & 0x800) != 0) {
            n3 = 52;
        }
        if ((n2 & 0x1000) != 0) {
            n3 = 53;
        }
        if ((n2 & 0x2000) != 0) {
            n3 = 54;
        }
        if ((n2 & 0x4000) != 0) {
            n3 = 55;
        }
        if ((n2 & 0x8000) != 0) {
            n3 = 56;
        }
        if ((n2 & 0x10000) != 0) {
            n3 = 57;
        }
        if ((n2 & 1) != 0) {
            n4 = 4;
        }
        if ((n2 & 2) != 0) {
            n4 = 8;
        }
        if ((n2 & 4) != 0) {
            n4 = 1;
        }
        if ((n2 & 8) != 0) {
            n4 = 2;
        }
        if ((n2 & 0x10) != 0) {
            n4 = 16;
        }
        if ((n2 & 0x20) != 0) {
            n4 = 64;
        }
        if ((n2 & 0x800000) != 0) {
            n4 = 1024;
        }
        if ((n2 & 0x80000) != 0) {
            n4 = 512;
        }
        if (m_inputMode != -1) {
            DDDebug.msg("TEXT ENTRY: Key input. keycode=" + n3 + ", joystick=" + n2);
            int n5 = 57;
            if (n3 >= 48 && n3 <= n5) {
                m_lastKeypressTime = (int)MainFrame.m_canvas.getAppTime();
                if (m_inputMode == 1) {
                    DDTextEntry.setInputChar((char)n3, true);
                } else {
                    if (m_lastKeycode != n3) {
                        if (m_keycodeCharId >= 0) {
                            DDTextEntry.setInputChar(m_keyInputChars[m_keycodeCharId].charAt(m_keycodeCharCycleIndex), true);
                        }
                        m_keycodeCharId = n3 - 48;
                        m_keycodeCharCycleIndex = 0;
                    } else if (m_keyInputChars[m_keycodeCharId].charAt(++m_keycodeCharCycleIndex) == '$') {
                        m_keycodeCharCycleIndex = 0;
                    }
                    DDTextEntry.setInputChar(m_keyInputChars[m_keycodeCharId].charAt(m_keycodeCharCycleIndex), false);
                    m_lastKeycode = n3;
                }
                n2 = 0;
            } else {
                if (n4 == 16) {
                    n2 = 32;
                }
                if (n3 == 42) {
                    DDTextEntry.setInputChar('-', true);
                    n2 = 0;
                }
                if ((n4 & 0x200) != 0) {
                    n2 = 64;
                }
                if ((n4 & 0x400) != 0 && m_currentInputChar > 0) {
                    DDTextEntry.deleteChar();
                    n2 = 0;
                } else if (n2 == 1 && m_currentInputChar == 0) {
                    DDTextEntry.m_inputString[DDTextEntry.m_currentInputChar] = 45;
                    m_lastKeycode = -1;
                    m_keycodeCharId = -1;
                    m_keycodeCharCycleIndex = 0;
                    n2 = 0;
                }
            }
        }
        return n2;
    }

    public static void setInputChar(char c2, boolean bl) {
        if (m_currentInputChar >= m_inputString.length - 1) {
            return;
        }
        if (m_capsLock && c2 >= 'a' && c2 <= 'z') {
            c2 = (char)(c2 & 0xFFFFFFDF);
        }
        DDTextEntry.m_inputString[DDTextEntry.m_currentInputChar] = c2;
        if (bl) {
            m_currentInputChar = DDMath.min(m_currentInputChar + 1, m_inputString.length - 1);
            m_keycodeCharId = -1;
            m_keycodeCharCycleIndex = 0;
            m_lastKeycode = -1;
        }
    }

    public static void deleteChar() {
        if (m_currentInputChar > 0) {
            if (m_inputString[m_currentInputChar] == '\u0000' || m_inputString[m_currentInputChar] == '-') {
                --m_currentInputChar;
            }
            DDTextEntry.m_inputString[DDTextEntry.m_currentInputChar] = 45;
            DDTextEntry.m_inputString[DDTextEntry.m_currentInputChar + 1] = '\u0000';
            m_lastKeycode = -1;
            m_keycodeCharId = -1;
            m_keycodeCharCycleIndex = 0;
        }
    }

    static {
        m_keyInputChars = new String[]{" 0$", ".-1$", "abc2$", "def3$", "ghi4$", "jkl5$", "mno6$", "pqrs7$", "tuv8$", "wxyz9$"};
        m_qwertyKeyInputChars = new String[]{"m0$", "r1$", "t2$", "y3$", "f4$", "g5$", "h6$", "v7$", "b8$", "n9$", "u$", "j$"};
    }
}

