/*
 * Decompiled with CFR 0.152.
 */
package com.appon.knighttestgame.ui;

import com.appon.gtantra.GFont;
import com.appon.knighttestgame.adapter.GameEventListener;
import com.appon.util.Util;
import com.indiagames.arjunprince.Constant;
import com.indiagames.arjunprince.KnightTestCanvas;
import javax.microedition.lcdui.Graphics;

public abstract class CustomCanvas {
    public GFont gfont;
    public String lsk;
    public String title;
    public String rsk;
    public GameEventListener listener;
    public int gameState;
    public static int rskWidth;
    public static int rskHeight;

    public CustomCanvas(GFont gfont, String lsk, String rsk, String title) {
        this.gfont = gfont;
        this.lsk = lsk;
        this.title = title;
        this.rsk = rsk;
    }

    public void init() {
        Constant.LSK_X = 1;
        if (this.rsk != null) {
            Constant.RSK_X = Constant.SCREEN_WIDTH - Constant.SMALLFONT.getStringWidth(this.rsk);
        }
        Constant.SOFT_KEY_Y = Constant.SCREEN_HEIGHT - (Constant.SMALLFONT.getFontHeight() + Constant.HERO_POS);
    }

    protected abstract void paint(Graphics var1);

    protected abstract void keyPressed(int var1);

    public final void paintUi(Graphics g) {
        Constant.SMALLFONT.setColor(1);
        this.paint(g);
        this.paintSoftKey(g);
    }

    public void unload() {
    }

    public void paintSoftKey(Graphics g) {
        Constant.SMALLFONT.setColor(0);
        if (this.lsk != null) {
            // empty if block
        }
        if (this.rsk != null && !Util.equalsIgnoreCase(this.rsk, "Pause") || this.rsk == null || Util.equalsIgnoreCase(this.rsk, "Pause")) {
            // empty if block
        }
    }

    public int getSoftKeyHeight() {
        return Constant.SCREEN_HEIGHT - (Constant.SMALLFONT.getFontHeight() + 2);
    }

    public void pointerDragged(int x, int y) {
    }

    public void pointerReleased(int x, int y) {
    }

    public void keyRelease(int keyCode, int gameKey) {
    }

    public void callKeyPress(int keyCode, int gameKey) {
        if (this.listener != null) {
            if (this.lsk != null && Util.isLeftSoftkeyPressed(keyCode)) {
                this.listener.listenSoftKeys(0);
            } else if (this.rsk != null && Util.isRightSoftkeyPressed(keyCode)) {
                this.listener.listenSoftKeys(1);
            }
        }
        this.keyPressed(gameKey);
    }

    public int getWidth() {
        return KnightTestCanvas.getInstance().getWidth();
    }

    public int getHeight() {
        return KnightTestCanvas.getInstance().getHeight();
    }

    public void setListener(GameEventListener listener) {
        this.listener = listener;
    }

    public boolean handlePointerPressed(int x, int y) {
        if (this.lsk != null && Util.isInRect(Constant.LSK_X, Constant.SCREEN_HEIGHT - Constant.IMAGE_PAUSE_BUTTON.getHeight(), Constant.IMAGE_PAUSE_BUTTON.getWidth(), Constant.IMAGE_PAUSE_BUTTON.getHeight(), x, y) && this.listener != null) {
            this.listener.listenSoftKeys(0);
            return true;
        }
        if (this.rsk != null && Util.isInRect(Constant.SCREEN_WIDTH - Constant.IMAGE_PAUSE_BUTTON.getWidth(), Constant.SCREEN_HEIGHT - Constant.IMAGE_PAUSE_BUTTON.getHeight(), Constant.IMAGE_PAUSE_BUTTON.getWidth(), Constant.IMAGE_PAUSE_BUTTON.getHeight(), x, y) && this.listener != null) {
            this.listener.listenSoftKeys(1);
            return true;
        }
        return false;
    }

    public void update() {
    }

    public void callPointerDragged(int x, int y) {
    }

    public void handlePointerDragged(int x, int y) {
    }

    public void hideNotify() {
    }
}

