/*
 * Decompiled with CFR 0.152.
 */
package com.appon.knighttestgame.helper;

import com.appon.knighttestgame.helper.MathUtility;
import java.util.Random;

public class Utility {
    private static Random random = new Random();

    public static int getRandom(int min, int max) {
        return min + Math.abs(random.nextInt()) % (max - min - 1);
    }

    public static int getRandomFoodItems() {
        return 1 + Math.abs(random.nextInt()) % 3;
    }

    public static void threadWaitTime(int waitTime) {
        try {
            Thread.sleep(waitTime);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int sqrt(int nRoot) {
        int nSqrt = 0;
        for (int i = 0x10000000; i != 0; i >>= 2) {
            int nTemp = nSqrt + i;
            nSqrt >>= 1;
            if (nTemp > nRoot) continue;
            nRoot -= nTemp;
            nSqrt += i;
        }
        return nSqrt;
    }

    public static int approx_distance(int dx, int dy) {
        int max;
        int min;
        if (dx < 0) {
            dx = -dx;
        }
        if (dy < 0) {
            dy = -dy;
        }
        if (dx < dy) {
            min = dx;
            max = dy;
        } else {
            min = dy;
            max = dx;
        }
        return (max << 8) + (max << 3) - (max << 4) - (max << 1) + (min << 7) - (min << 5) + (min << 3) - (min << 1) >> 8;
    }

    public static boolean checkCollision(int x, int y, int width, int height, int pointX, int pointY) {
        return pointX >= x && pointX <= x + width && pointY >= y && pointY <= y + height;
    }

    public static int sin(int p_angle) {
        if (p_angle > 360) {
            p_angle -= 360 * (p_angle / 360);
        }
        p_angle &= MathUtility.kMath_BinAnglePrecision - 1;
        if (p_angle < MathUtility.kMath_BinAngle90) {
            return MathUtility.Table_Sin_Cos[p_angle];
        }
        if (p_angle < MathUtility.kMath_BinAngle180) {
            return MathUtility.Table_Sin_Cos[MathUtility.kMath_BinAngle180 - p_angle];
        }
        if (p_angle < MathUtility.kMath_BinAngle270) {
            return -MathUtility.Table_Sin_Cos[p_angle - MathUtility.kMath_BinAngle180];
        }
        return -MathUtility.Table_Sin_Cos[MathUtility.kMath_BinAngle360 - p_angle];
    }

    public static int cos(int p_angle) {
        if (p_angle > 360) {
            p_angle -= 360 * (p_angle / 360);
        }
        p_angle &= MathUtility.kMath_BinAnglePrecision - 1;
        if (p_angle < MathUtility.kMath_BinAngle90) {
            return MathUtility.Table_Sin_Cos[MathUtility.kMath_BinAngle90 - p_angle];
        }
        if (p_angle < MathUtility.kMath_BinAngle180) {
            return -MathUtility.Table_Sin_Cos[p_angle - MathUtility.kMath_BinAngle90];
        }
        if (p_angle < MathUtility.kMath_BinAngle270) {
            return -MathUtility.Table_Sin_Cos[MathUtility.kMath_BinAngle270 - p_angle];
        }
        return MathUtility.Table_Sin_Cos[p_angle - MathUtility.kMath_BinAngle270];
    }

    public static int collisionRectTORect(int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2) {
        if (Utility.checkCollision(x1, y1, w1, h1, x2, y2) || Utility.checkCollision(x1, y1, w1, h1, x2, y2 + (h2 >> 1)) || Utility.checkCollision(x1, y1, w1, h1, x2, y2 + h2)) {
            return 1;
        }
        if (Utility.checkCollision(x1, y1, w1, h1, x2 + (w2 >> 1), y2) || Utility.checkCollision(x1, y1, w1, h1, x2 + (w2 >> 1), y2 + (h2 >> 1)) || Utility.checkCollision(x1, y1, w1, h1, x2 + (w2 >> 1), y2 + h2)) {
            return 1;
        }
        if (Utility.checkCollision(x1, y1, w1, h1, x2 + w2, y2) || Utility.checkCollision(x1, y1, w1, h1, x2 + w2, y2 + (h2 >> 1)) || Utility.checkCollision(x1, y1, w1, h1, x2 + w2, y2 + h2)) {
            return 1;
        }
        return 2;
    }
}

