/*
 * Decompiled with CFR 0.152.
 */
package com.appon.knighttestgame.customShapes;

import com.appon.gtantra.GAnim;
import com.appon.knighttestgame.helper.LineWalker;
import com.appon.knighttestgame.helper.ProjectileMotion;
import com.appon.runner.RunnerManager;
import com.appon.runner.model.AddedShape;
import com.appon.runner.model.CustomShape;
import com.appon.util.Util;
import com.indiagames.arjunprince.Constant;
import com.indiagames.arjunprince.KnightTestEngine;
import javax.microedition.lcdui.Graphics;

public class Axe
extends CustomShape {
    GAnim axeAnim;
    private int ctr = 0;
    int x1;
    int y1;
    private static int Radius = 145;
    private int[] angle = new int[]{0, 15, 41, 66, 90, 114, 139};
    private int[] frameCollision = new int[4];
    private boolean isAxeDrop = false;
    private LineWalker lineCordinate = new LineWalker();

    public Axe() {
        Radius = Constant.AXE_RADIUS;
        this.axeAnim = new GAnim(Constant.axeTantra, 0);
    }

    public void PAINT(Graphics g, int x, int y) {
        ++this.ctr;
        if (!this.axeAnim.isAnimationOver() && this.isAxeDrop) {
            while (!this.lineCordinate.isOver()) {
                g.drawImage(Constant.IMG_ROPE.getImage(), this.lineCordinate.getX() - 5, this.lineCordinate.getY() - 5 - Constant.camera.getCamY(), 0);
                this.lineCordinate.update(Constant.IMG_ROPE.getHeight());
            }
            this.axeAnim.render(g, this.x1, this.y1 - Constant.camera.getCamY(), 0, false);
            Constant.axeTantra.getCollisionRect(this.axeAnim.getCurrentFrame(), this.frameCollision, 0);
        }
        if (KnightTestEngine.hero.getHeroX() < x - Constant.MAX_HEIGHT && this.ctr % 2 == 0) {
            g.drawImage(Constant.IMG_HURDLE_ALERT.getImage(), x - Constant.MAX_HEIGHT, y + Constant.MAX_HEIGHT, 0);
        }
    }

    public int getHeight() {
        return this.y1 + this.frameCollision[3];
    }

    private int getMinX() {
        return this.x1 + this.axeAnim.getCurrentFrameMinimumX();
    }

    private int getMinY() {
        return this.y1 + this.axeAnim.getCurrentFrameMinimumY();
    }

    public int getWidth() {
        return this.axeAnim.getCurrentFrameWidth();
    }

    public void reset() {
        this.axeAnim.reset();
        this.isAxeDrop = false;
        Radius = Constant.AXE_RADIUS;
    }

    public void update(AddedShape addedShape) {
        if (addedShape.getY() < KnightTestEngine.hero.getHeroY() && addedShape.getX() - RunnerManager.getManager().getCurrentCamX() < Constant.SCREEN_WIDTH >> 1 && !this.isAxeDrop) {
            this.isAxeDrop = true;
        }
        if (this.axeAnim.isAnimationOver()) {
            RunnerManager.getManager().removeAddedShape(addedShape);
        }
        if (this.isAxeDrop && !this.axeAnim.isAnimationOver()) {
            if (!this.axeAnim.isAnimationOver()) {
                this.x1 = addedShape.getX() - RunnerManager.getManager().getCurrentCamX() + (Radius * ProjectileMotion.cos(this.angle[this.axeAnim.getAnimationCurrentCycle() + 1]) >> 14);
                this.y1 = addedShape.getY() + (Radius * ProjectileMotion.sin(this.angle[this.axeAnim.getAnimationCurrentCycle() + 1]) >> 14);
            }
            this.lineCordinate.init(addedShape.getX() - RunnerManager.getManager().getCurrentCamX(), addedShape.getY(), this.x1, this.y1);
        } else {
            this.x1 = addedShape.getX() - RunnerManager.getManager().getCurrentCamX() + (Radius * ProjectileMotion.cos(0) >> 14);
            this.y1 = addedShape.getY() + (Radius * ProjectileMotion.sin(0) >> 14);
        }
    }

    public AddedShape checkCollision(int rectX, int rectY, int rectWidth, int rectHeight, AddedShape addedShape) {
        if ((Util.isRectCollision(this.getMinX(), this.getMinY(), this.axeAnim.getCurrentFrameWidth(), this.axeAnim.getCurrentFrameHeight(), rectX, rectY, rectWidth, rectHeight) || com.appon.runner.util.Util.lineToRectangle(addedShape.getX(), addedShape.getY(), this.x1, this.y1, rectX, rectY, rectWidth, rectHeight)) && addedShape.getY() < KnightTestEngine.hero.getHeroY()) {
            return addedShape;
        }
        return null;
    }
}

