/*
 * Decompiled with CFR 0.152.
 */
package com.appon.knighttestgame.customShapes;

import com.appon.camera.CameraLockable;
import com.appon.gtantra.GAnim;
import com.appon.runner.RunnerManager;
import com.appon.runner.model.AddedShape;
import com.appon.runner.model.CustomShape;
import com.appon.runner.util.Util;
import com.appon.util.BoxUtil;
import com.indiagames.arjunprince.Constant;
import com.indiagames.arjunprince.Hero;
import com.indiagames.arjunprince.KnightTestEngine;
import javax.microedition.lcdui.Graphics;

public class Pig
extends CustomShape
implements CameraLockable {
    private GAnim pigRunAnim = new GAnim(Constant.enemy, 0);
    private int animX;
    private int animY;
    private boolean pigAttacked = false;
    private boolean fallDown = false;
    public static byte isHeroCollide = (byte)-1;

    public void PAINT(Graphics g, int x, int y) {
        if (!this.pigAttacked) {
            this.pigRunAnim.render(g, x, y, 0, true);
        } else if (this.pigAttacked) {
            // empty if block
        }
    }

    public int getHeight() {
        return this.pigRunAnim.getCurrentFrameHeight();
    }

    public void update(AddedShape addedShape) {
        if (!this.fallDown) {
            addedShape.setX(addedShape.getX() - (Constant.MIN_GAME_SPEED >> 1));
            if (!this.pigAttacked && Util.isRectCollision(addedShape.getX() + this.pigRunAnim.getCurrentFrameMinimumX(), addedShape.getY() + addedShape.getAdditionalY(), this.getWidth(), this.getHeight(), KnightTestEngine.hero.getHeroX() + Hero.batCollision[0], KnightTestEngine.hero.getHeroY() + Hero.batCollision[1], Hero.batCollision[2], Hero.batCollision[3]) && Hero.getHeroState() == 9) {
                this.pigAttacked(addedShape);
            }
            if (!this.pigAttacked && Util.isRectCollision(addedShape.getX() + this.pigRunAnim.getCurrentFrameMinimumX(), addedShape.getY() + addedShape.getAdditionalY(), this.getWidth(), this.getHeight(), KnightTestEngine.hero.getHeroX() + KnightTestEngine.hero.collideRect[0], KnightTestEngine.hero.getHeroY() + KnightTestEngine.hero.collideRect[1], KnightTestEngine.hero.collideRect[2], KnightTestEngine.hero.collideRect[3]) && (Hero.getHeroInstance().motion.isOnHalf() && Hero.getHeroState() == 1 || Hero.getHeroState() == 3)) {
                this.pigAttacked(addedShape);
            }
            if (this.pigAttacked) {
                RunnerManager.getManager().removeAddedShape(addedShape);
                if (KnightTestEngine.hero.isIsPigAhead()) {
                    KnightTestEngine.hero.setIsPigAhead(false);
                }
            }
        }
        if (addedShape != null && RunnerManager.getManager().CollideToRect(addedShape) && !this.fallDown) {
            this.fallDown = true;
            this.setIsCollidable(false);
        }
        if (this.fallDown) {
            addedShape.setX(addedShape.getX() + 3);
            addedShape.setY(addedShape.getY() + Constant.MIN_GAME_SPEED);
            if (addedShape.getY() - Constant.camera.getCamY() > Constant.SCREEN_HEIGHT + (Constant.SCREEN_HEIGHT >> 1)) {
                RunnerManager.getManager().removeAddedShape(addedShape);
            }
            if (BoxUtil.isCollisionAtBottom(addedShape.getX() - RunnerManager.getManager().getCurrentCamX(), addedShape.getY() + this.getHeight(), this)) {
                this.animX = addedShape.getX() - RunnerManager.getManager().getCurrentCamX();
                this.animY = addedShape.getY() + this.pigRunAnim.getAnimationFrameY(this.pigRunAnim.getAnimationCurrentCycle()) + addedShape.getAdditionalY();
                this.setIsCollidable(false);
                this.pigAttacked = true;
            }
        }
    }

    public void pigAttacked(AddedShape addedShape) {
        KnightTestEngine.score += 200;
        this.animX = addedShape.getX() - RunnerManager.getManager().getCurrentCamX();
        this.animY = addedShape.getY() + this.pigRunAnim.getAnimationFrameY(this.pigRunAnim.getAnimationCurrentCycle()) + addedShape.getAdditionalY();
        this.setIsCollidable(false);
        this.pigAttacked = true;
    }

    public int getWidth() {
        return this.pigRunAnim.getCurrentFrameWidth();
    }

    public void reset() {
        this.pigRunAnim.reset();
    }

    public AddedShape checkCollision(int rectX, int rectY, int rectWidth, int rectHeight, AddedShape addedShape) {
        if (Util.isRectCollision(addedShape.getX() + this.pigRunAnim.getCurrentFrameMinimumX(), addedShape.getY() + this.pigRunAnim.getCurrentFrameMinimumY(), this.getWidth(), this.getHeight(), rectX, rectY, rectWidth, rectHeight) && Hero.getHeroState() != 1) {
            isHeroCollide = 1;
            return addedShape;
        }
        if (Util.isRectCollision(addedShape.getX() + this.pigRunAnim.getCurrentFrameMinimumX(), addedShape.getY() + this.pigRunAnim.getCurrentFrameMinimumY(), this.getWidth(), this.getHeight(), KnightTestEngine.hero.getHeroX(), KnightTestEngine.hero.getHeroY() - KnightTestEngine.hero.getHeroHeight(), KnightTestEngine.hero.getHeroWidth(), KnightTestEngine.hero.getHeroHeight()) && Hero.getHeroState() != 1) {
            isHeroCollide = 0;
            return addedShape;
        }
        return null;
    }

    public int getX() {
        return 0;
    }

    public int getY() {
        return 0;
    }

    public int getAllignment() {
        return -1;
    }

    public int lockedObjectIsOf() {
        return 4;
    }
}

