/*
 * Decompiled with CFR 0.152.
 */
package com.appon.effectengine;

import com.appon.effectengine.EShape;
import com.appon.effectengine.Effect;
import com.appon.effectengine.EffectLayer;
import com.appon.effectengine.EffectUtil;
import com.appon.effectengine.Point;
import com.appon.effectengine.TimeFrame;
import com.appon.miniframework.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.microedition.lcdui.Graphics;

public class ETimeFrameShape
extends EShape {
    private int timeFrameIndex = -1;
    private int layerIndex = -1;
    private int theta;
    private int zoom;
    private int anchorX;
    private int anchorY;

    public ETimeFrameShape(int id) {
        super(id);
    }

    public EShape clone() {
        ETimeFrameShape arc = new ETimeFrameShape(-1);
        this.copyProperties(arc);
        arc.setTimeFrameIndex(this.getTimeFrameIndex());
        arc.setLayerIndex(this.getLayerIndex());
        arc.setTheta(this.getTheta());
        arc.setZoom(this.getZoom());
        arc.setAnchorX(this.getAnchorX());
        arc.setAnchorY(this.getAnchorY());
        return arc;
    }

    public int getLayerIndex() {
        return this.layerIndex;
    }

    public void setLayerIndex(int layerIndex) {
        this.layerIndex = layerIndex;
    }

    public int getTheta() {
        return this.theta;
    }

    public void setTheta(int theta) {
        this.theta = theta;
    }

    public int getTimeFrameIndex() {
        return this.timeFrameIndex;
    }

    public void setTimeFrameIndex(int timeFrameIndex) {
        this.timeFrameIndex = timeFrameIndex;
    }

    public int getZoom() {
        return this.zoom;
    }

    public void setZoom(int zoom) {
        this.zoom = zoom;
    }

    public void PAINT(Graphics g, int _x, int _y, int theta, int zoom, int anchorX, int anchorY, Effect parent) {
        EffectLayer layer;
        TimeFrame frame;
        Point p = EffectUtil.pointToRotate;
        p.setPoints(this.getX(), this.getY());
        EffectUtil.rotatePoint(p, anchorX, anchorY, theta, zoom, this);
        if (parent != null && this.layerIndex < parent.getEffectLayers().size() && this.layerIndex >= 0 && this.timeFrameIndex >= 0 && (frame = (layer = (EffectLayer)parent.getEffectLayers().elementAt(this.layerIndex)).getTimeFrame(this.timeFrameIndex)) != null) {
            frame.PAINT(g, _x + p.getX(), _y + p.getY(), true, this.getTheta() + theta, this.getZoom() + zoom, this.getAnchorX() + anchorX, this.getAnchorY() + anchorY, parent, true);
        }
    }

    public void setAnchorY(int anchorY) {
        this.anchorY = anchorY;
    }

    public void setAnchorX(int anchorX) {
        this.anchorX = anchorX;
    }

    public int getAnchorY() {
        return this.anchorY;
    }

    public int getAnchorX() {
        return this.anchorX;
    }

    public String toString() {
        return "TimeFrame: " + this.getId();
    }

    public byte[] serialize() throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(super.serialize());
        Util.writeSignedInt(bos, this.getTimeFrameIndex(), 1);
        Util.writeSignedInt(bos, this.getLayerIndex(), 1);
        Util.writeSignedInt(bos, this.getTheta(), 2);
        Util.writeSignedInt(bos, this.getZoom(), 2);
        Util.writeSignedInt(bos, this.getAnchorX(), 2);
        Util.writeSignedInt(bos, this.getAnchorY(), 2);
        bos.flush();
        byte[] data = bos.toByteArray();
        bos.close();
        bos = null;
        return data;
    }

    public ByteArrayInputStream deserialize(ByteArrayInputStream bis) throws Exception {
        super.deserialize(bis);
        this.timeFrameIndex = Util.readSignedInt(bis, 1);
        this.layerIndex = Util.readSignedInt(bis, 1);
        this.theta = Util.readSignedInt(bis, 2);
        this.zoom = Util.readSignedInt(bis, 2);
        this.anchorX = Util.readSignedInt(bis, 2);
        this.anchorY = Util.readSignedInt(bis, 2);
        bis.close();
        return null;
    }

    public int getClassCode() {
        return 2020;
    }
}

