/*
 * Decompiled with CFR 0.152.
 */
package com.appon.effectengine;

import com.appon.effectengine.EShape;
import com.appon.effectengine.Effect;
import com.appon.effectengine.EffectUtil;
import com.appon.effectengine.Point;
import com.appon.gtantra.GTantra;
import com.appon.miniframework.ResourceManager;
import com.appon.miniframework.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.microedition.lcdui.Graphics;

public class EGFrame
extends EShape {
    private int gTrantraId = -1;
    private GTantra gtantra;
    private int frameId = -1;
    private int flipX;
    private int flipY;

    public EGFrame(int id) {
        super(id);
    }

    public EShape clone() {
        EGFrame arc = new EGFrame(-1);
        this.copyProperties(arc);
        arc.setgTrantraId(this.getgTrantraId());
        arc.setGtantra(this.getGtantra());
        arc.setFrameId(this.getFrameId());
        arc.setFlipX(this.getFlipX());
        arc.setFlipY(this.getFlipY());
        return arc;
    }

    public int getFlipY() {
        return this.flipY;
    }

    public int getFlipX() {
        return this.flipX;
    }

    public void setFlipY(int flipY) {
        this.flipY = flipY;
    }

    public void setFlipX(int flipX) {
        this.flipX = flipX;
    }

    public int getgTrantraId() {
        return this.gTrantraId;
    }

    public void setgTrantraId(int gTrantraId) {
        this.gTrantraId = gTrantraId;
    }

    public GTantra getGtantra() {
        return this.gtantra;
    }

    public void setGtantra(GTantra gtantra) {
        this.gtantra = gtantra;
    }

    public int getFrameId() {
        return this.frameId;
    }

    public void setFrameId(int moduleId) {
        this.frameId = moduleId;
    }

    public int getOnlyMinX() {
        if (this.gtantra == null) {
            return 0;
        }
        return this.gtantra.getFrameMinimumX(this.frameId);
    }

    public int getOnlyMinY() {
        if (this.gtantra == null) {
            return 0;
        }
        return this.gtantra.getFrameMinimumY(this.frameId);
    }

    public int getMinX() {
        if (this.gtantra == null) {
            return this.getX();
        }
        return this.getX() + this.gtantra.getFrameMinimumX(this.frameId);
    }

    public int getMinY() {
        if (this.gtantra == null) {
            return this.getY();
        }
        return this.getY() + this.gtantra.getFrameMinimumY(this.frameId);
    }

    public int getWidth() {
        if (this.gtantra == null) {
            return 50;
        }
        return this.gtantra.getFrameWidth(this.frameId);
    }

    public int getHeight() {
        if (this.gtantra == null) {
            return 50;
        }
        return this.gtantra.getFrameHeight(this.frameId);
    }

    public void PAINT(Graphics g, int _x, int _y, int theta, int zoom, int anchorX, int anchorY, Effect parent) {
        if (this.gtantra == null) {
            return;
        }
        Point p = EffectUtil.pointToRotate;
        p.setPoints(this.getX(), this.getY());
        EffectUtil.rotatePoint(p, anchorX, anchorY, theta, zoom, this);
        this.gtantra.DrawFrame(g, this.frameId, _x + p.getX(), _y + p.getY(), this.flipX | this.flipY);
    }

    public String toString() {
        return "GFrame: " + this.getId();
    }

    public byte[] serialize() throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(super.serialize());
        Util.writeSignedInt(bos, this.gTrantraId, 1);
        Util.writeInt(bos, this.frameId, 1);
        Util.writeInt(bos, this.flipX, 1);
        Util.writeInt(bos, this.flipY, 1);
        bos.flush();
        byte[] data = bos.toByteArray();
        bos.close();
        bos = null;
        return data;
    }

    public ByteArrayInputStream deserialize(ByteArrayInputStream bis) throws Exception {
        super.deserialize(bis);
        this.gTrantraId = Util.readSignedInt(bis, 1);
        this.setGtantra(ResourceManager.getInstance().getGTantraResource(this.gTrantraId));
        this.frameId = Util.readInt(bis, 1);
        this.flipX = Util.readInt(bis, 1);
        this.flipY = Util.readInt(bis, 1);
        bis.close();
        return null;
    }

    public int getClassCode() {
        return 2013;
    }
}

