/*
 * Decompiled with CFR 0.152.
 */
package com.appon.effectengine;

import com.appon.effectengine.EShape;
import com.appon.effectengine.Effect;
import com.appon.effectengine.EffectUtil;
import com.appon.effectengine.EffectsSerilize;
import com.appon.miniframework.Util;
import com.appon.util.Serilizable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class TimeFrame
implements Serilizable {
    private int timeFrameId;
    private Vector shapes = new Vector();
    private boolean visibility = true;

    public TimeFrame clone() {
        TimeFrame tf = new TimeFrame();
        tf.setTimeFrameId(this.getTimeFrameId());
        for (int i = 0; i < this.shapes.size(); ++i) {
            Object object = this.shapes.elementAt(i);
            tf.getShapes().addElement(((EShape)object).clone());
        }
        tf.setVisibility(this.isVisibility());
        return tf;
    }

    public void setBgColor(int color) {
        for (int i = 0; i < this.shapes.size(); ++i) {
            EShape object = (EShape)this.shapes.elementAt(i);
            object.setBgColor(color);
        }
    }

    public void setVisibility(boolean visibility) {
        this.visibility = visibility;
    }

    public boolean isVisibility() {
        return this.visibility;
    }

    public void PAINT(Graphics g, int x, int y, boolean considerVisability, Effect parent, boolean calldedFromETF) {
        if (considerVisability && !this.isVisibility() && !calldedFromETF) {
            return;
        }
        for (int i = 0; i < this.shapes.size(); ++i) {
            EShape object = (EShape)this.shapes.elementAt(i);
            if ((!considerVisability || !object.isVisible()) && considerVisability && !calldedFromETF) continue;
            object.PAINT(g, x, y, 0, 0, 0, 0, parent);
        }
    }

    public void PAINT(Graphics g, int x, int y, boolean considerVisability, int theta, int zoom, int anchorX, int anchorY, Effect parent, boolean calldedFromETF) {
        if (considerVisability && !this.isVisibility() && !calldedFromETF) {
            return;
        }
        for (int i = 0; i < this.shapes.size(); ++i) {
            EShape object = (EShape)this.shapes.elementAt(i);
            if ((!considerVisability || !object.isVisible()) && considerVisability && !calldedFromETF) continue;
            object.PAINT(g, x, y, theta, zoom, anchorX, anchorY, parent);
        }
    }

    public int getTimeFrameId() {
        return this.timeFrameId;
    }

    public void setTimeFrameId(int timeFrameId) {
        this.timeFrameId = timeFrameId;
    }

    public Vector getShapes() {
        return this.shapes;
    }

    public byte[] serialize() throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Util.writeSignedInt(bos, this.timeFrameId, 2);
        EffectsSerilize.serialize(this.shapes, bos);
        EffectsSerilize.serialize(new Boolean(this.isVisibility()), bos);
        bos.flush();
        byte[] data = bos.toByteArray();
        bos.close();
        bos = null;
        return data;
    }

    public ByteArrayInputStream deserialize(ByteArrayInputStream bis) throws Exception {
        this.timeFrameId = Util.readInt(bis, 2);
        this.shapes = (Vector)EffectsSerilize.deserialize(bis, EffectsSerilize.getInstance());
        if (EffectUtil.LOADING_VERSION > 0) {
            this.setVisibility((Boolean)EffectsSerilize.deserialize(bis, EffectsSerilize.getInstance()));
        }
        bis.close();
        return null;
    }

    public int getClassCode() {
        return 2002;
    }
}

