/*
 * Decompiled with CFR 0.152.
 */
package com.appon.miniframework.controls;

import com.appon.gtantra.GraphicsUtil;
import com.appon.miniframework.Control;
import com.appon.miniframework.ResourceManager;
import com.appon.miniframework.Util;
import java.io.ByteArrayInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GradualUpdate
extends Control {
    private Image leftFilled;
    private Image leftEmpty;
    private Image centerFilled;
    private Image centerEmpty;
    private int currentUpgrade;
    private int maxUpgrade;
    private int leftFilledImageId;
    private int leftEmptyImageId;
    private int centerFilledImageId;
    private int centerEmptyImageId;

    public GradualUpdate(int id) {
        super(id);
    }

    public void PAINT(Graphics g) {
        if (this.leftFilled == null || this.leftEmpty == null || this.centerFilled == null || this.centerEmpty == null) {
            return;
        }
        int _x = this.getLeftInBound();
        int _y = this.getTopInBound();
        if (this.currentUpgrade > 0) {
            Util.drawImage(g, this.leftFilled, _x, _y);
        } else {
            Util.drawImage(g, this.leftEmpty, _x, _y);
        }
        int count = this.maxUpgrade - 2;
        _x += Util.getImageWidth(this.leftFilled);
        int value = 1;
        for (int i = 0; i < count && count > 0; ++i) {
            if (value >= this.currentUpgrade) {
                Util.drawImage(g, this.centerEmpty, _x, _y);
            } else {
                Util.drawImage(g, this.centerFilled, _x, _y);
            }
            ++value;
            _x += Util.getImageWidth(this.centerFilled);
        }
        if (this.maxUpgrade > this.currentUpgrade) {
            GraphicsUtil.drawRegion(g, this.leftEmpty, _x, _y, 8, 0);
        } else {
            GraphicsUtil.drawRegion(g, this.leftFilled, _x, _y, 8, 0);
        }
    }

    public int getPreferredWidth() {
        int _w = this.getLeftInBound() + this.getRightInBound();
        if (this.leftEmpty != null) {
            _w += Util.getImageWidth(this.leftEmpty) * 2;
        }
        if (this.centerEmpty != null && this.maxUpgrade > 2) {
            _w += Util.getImageWidth(this.centerEmpty) * (this.maxUpgrade - 2);
        }
        return _w;
    }

    public int getPreferredHeight() {
        int _w = this.getTopInBound() + this.getBottomInBound();
        if (this.leftEmpty != null) {
            _w += Util.getImageHeight(this.leftEmpty);
        }
        return _w;
    }

    public int getClassCode() {
        return 1015;
    }

    public byte[] serialize() throws Exception {
        return null;
    }

    public ByteArrayInputStream deserialize(ByteArrayInputStream bis) throws Exception {
        super.deserialize(bis);
        this.setLeftFilledImageId(Util.readSignedInt(bis, 2));
        this.setLeftFilled(ResourceManager.getInstance().getImageResource(this.getLeftFilledImageId()));
        this.setLeftEmptyImageId(Util.readSignedInt(bis, 2));
        this.setLeftEmpty(ResourceManager.getInstance().getImageResource(this.getLeftEmptyImageId()));
        this.setCenterEmptyImageId(Util.readSignedInt(bis, 2));
        this.setCenterEmpty(ResourceManager.getInstance().getImageResource(this.getCenterEmptyImageId()));
        this.setCenterFilledImageId(Util.readSignedInt(bis, 2));
        this.setCenterFilled(ResourceManager.getInstance().getImageResource(this.getCenterFilledImageId()));
        this.setMaxUpgrade(Util.readInt(bis, 1));
        this.setCurrentUpgrade(Util.readInt(bis, 1));
        bis.close();
        return null;
    }

    public int getCurrentUpgrade() {
        return this.currentUpgrade;
    }

    public void setCurrentUpgrade(int currentUpgrade) {
        this.currentUpgrade = currentUpgrade;
    }

    public int getMaxUpgrade() {
        return this.maxUpgrade;
    }

    public void setMaxUpgrade(int maxUpgrade) {
        this.maxUpgrade = maxUpgrade;
    }

    public int getCenterEmptyImageId() {
        return this.centerEmptyImageId;
    }

    public void setCenterEmptyImageId(int centerEmptyImageId) {
        this.centerEmptyImageId = centerEmptyImageId;
    }

    public int getCenterFilledImageId() {
        return this.centerFilledImageId;
    }

    public void setCenterFilledImageId(int centerFilledImageId) {
        this.centerFilledImageId = centerFilledImageId;
    }

    public int getLeftEmptyImageId() {
        return this.leftEmptyImageId;
    }

    public void setLeftEmptyImageId(int leftEmptyImageId) {
        this.leftEmptyImageId = leftEmptyImageId;
    }

    public int getLeftFilledImageId() {
        return this.leftFilledImageId;
    }

    public void setLeftFilledImageId(int leftFilledImageId) {
        this.leftFilledImageId = leftFilledImageId;
    }

    public String toString() {
        return "GradualUpdate-" + this.getId();
    }

    public Image getLeftFilled() {
        return this.leftFilled;
    }

    public Image getCenterEmpty() {
        return this.centerEmpty;
    }

    public Image getCenterFilled() {
        return this.centerFilled;
    }

    public Image getLeftEmpty() {
        return this.leftEmpty;
    }

    public void setLeftEmpty(Image leftEmpty) {
        this.leftEmpty = leftEmpty;
    }

    public void setCenterEmpty(Image centerEmpty) {
        this.centerEmpty = centerEmpty;
    }

    public void setCenterFilled(Image centerFilled) {
        this.centerFilled = centerFilled;
    }

    public void setLeftFilled(Image leftFilled) {
        this.leftFilled = leftFilled;
    }
}

