/*
 * Decompiled with CFR 0.152.
 */
package com.appon.miniframework.controls;

import com.appon.gtantra.GFont;
import com.appon.miniframework.Control;
import com.appon.miniframework.EventQueue;
import com.appon.miniframework.ResourceManager;
import com.appon.miniframework.Util;
import java.io.ByteArrayInputStream;
import javax.microedition.lcdui.Graphics;

public class MultilineTextControl
extends Control {
    private GFont font;
    private GFont selectionFont;
    private String text = "";
    public static final int LEFT_ALLIGN = 0;
    public static final int CENTER_ALLIGN = 1;
    public static final int RIGHT_ALLIGN = 2;
    public static final int TOP_ALLIGN = 0;
    public static final int BOTTOM_ALLIGN = 2;
    private int xAllign = 0;
    private int yAllign = 0;
    private int pallate;
    private int selectionPallate = 0;
    private String[] parsed;
    private int calculatedWidth;
    private int calculatedHeight;
    private int fontResourceId = -1;
    private int selectionFontResourceId = -1;
    private int localTextId = -1;

    public MultilineTextControl() {
        super(-1);
    }

    public MultilineTextControl(int id) {
        super(id);
    }

    public void setLocalTextId(int localTextId) {
        this.localTextId = localTextId;
    }

    public void checkResize() {
        if (this.getWidth() > 0 && this.getHeight() > 0 && this.getFont() != null && this.getText() != null) {
            this.parsed = this.getFont().getBoxString(this.text, this.getBoundWidth(), this.getBoundHeight());
            this.calculatedWidth = this.getBoundWidth();
            if (this.calculatedWidth == 0) {
                this.calculatedWidth = 100;
            }
            this.calculatedHeight = this.getFont().getFontHeight() * this.parsed.length;
        }
    }

    public void setSelectionFontResourceId(int selectionFontResourceId) {
        this.selectionFontResourceId = selectionFontResourceId;
    }

    public void setFontResourceId(int fontResourceId) {
        this.fontResourceId = fontResourceId;
    }

    public int getFontResourceId() {
        return this.fontResourceId;
    }

    public int getSelectionFontResourceId() {
        return this.selectionFontResourceId;
    }

    public GFont getSelectionFont() {
        return this.selectionFont;
    }

    public int getXAllign() {
        return this.xAllign;
    }

    public int getYAllign() {
        return this.yAllign;
    }

    public void setWidth(int width) {
        super.setWidth(width);
        this.checkResize();
    }

    public void setHeight(int height) {
        super.setHeight(height);
        this.checkResize();
    }

    public void setSelectionFont(GFont selectionFont) {
        if (selectionFont != null) {
            this.selectionFont = selectionFont;
        }
    }

    public int getSelectionPallate() {
        return this.selectionPallate;
    }

    public int getPallate() {
        return this.pallate;
    }

    public void setSelectionPallate(int selectionPallate) {
        this.selectionPallate = selectionPallate;
    }

    public void setPallate(int pallate) {
        this.pallate = pallate;
        if (this.getSelectionPallate() == -1) {
            this.setSelectionPallate(pallate);
        }
    }

    public int getPreferredHeight() {
        if (this.getCurrentFont() == null) {
            return 20;
        }
        return this.calculatedHeight;
    }

    public int getPreferredWidth() {
        if (this.getCurrentFont() == null) {
            return 50;
        }
        return this.calculatedWidth;
    }

    public void setXAllign(int xAllign) {
        this.xAllign = xAllign;
    }

    public void setYAllign(int yAllign) {
        this.yAllign = yAllign;
    }

    public void setFont(GFont font) {
        this.font = font;
        if (this.getSelectionFont() == null) {
            this.setSelectionFont(font);
        }
        this.checkResize();
    }

    public GFont getFont() {
        return this.font;
    }

    public String getText() {
        return this.text;
    }

    private GFont getCurrentFont() {
        GFont font = null;
        if (!this.isSelected()) {
            font = this.font;
            if (this.pallate == -1) {
                this.pallate = 0;
            }
            if (font != null) {
                font.setColor(this.pallate);
            }
        } else {
            font = this.selectionFont;
            if (this.selectionPallate == -1) {
                this.selectionPallate = 0;
            }
            if (font != null) {
                font.setColor(this.selectionPallate);
            }
        }
        return font;
    }

    public void PAINT(Graphics g) {
        GFont font = this.getCurrentFont();
        if (font == null || this.parsed == null) {
            return;
        }
        int allignFlag = 4;
        if (this.xAllign == 2) {
            allignFlag = 8;
        } else if (this.xAllign == 1) {
            allignFlag = 1;
        }
        if (this.yAllign == 2) {
            allignFlag |= 0x20;
        } else if (this.yAllign == 1) {
            allignFlag |= 0x40;
        } else if (this.yAllign == 0) {
            allignFlag |= 0x10;
        }
        font.drawPage(g, this.parsed, 0, 0, this.getBoundWidth(), this.getBoundHeight(), allignFlag);
    }

    public void setText(String text) {
        this.text = text;
        this.checkResize();
    }

    public String toString() {
        return "MultilineTextControl-" + this.getId();
    }

    public int getClassCode() {
        return 1002;
    }

    public byte[] serialize() throws Exception {
        return null;
    }

    public ByteArrayInputStream deserialize(ByteArrayInputStream bis) throws Exception {
        super.deserialize(bis);
        this.setText(Util.readString(bis));
        this.setFontResourceId(Util.readInt(bis, 1));
        this.setFont(ResourceManager.getInstance().getFontResource(this.getFontResourceId()));
        this.setSelectionFontResourceId(Util.readInt(bis, 1));
        this.setSelectionFont(ResourceManager.getInstance().getFontResource(this.getSelectionFontResourceId()));
        this.setPallate(Util.readInt(bis, 1));
        this.setSelectionPallate(Util.readInt(bis, 1));
        this.setXAllign(Util.readInt(bis, 1));
        this.setYAllign(Util.readInt(bis, 1));
        bis.close();
        return null;
    }

    public void cleanup() {
        super.cleanup();
        this.selectionFont = null;
        this.font = null;
        this.text = null;
        this.parsed = null;
    }

    public void showNotify() {
        if (EventQueue.getInstance().getLocalText(this.localTextId) != null) {
            this.setText(EventQueue.getInstance().getLocalText(this.localTextId));
        }
        super.showNotify();
    }
}

