/*
 * Decompiled with CFR 0.152.
 */
package com.appon.knighttestgame.helper;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;

public class SoundServer
implements Runnable,
PlayerListener {
    public static Object syncObject = new Object();
    private Vector soundsList = new Vector();
    public static final int SOUND_BGMUSIC = 0;
    public static final int SOUND_GAME_WON = 1;
    public static final int SOUND_GAME_LOSE = 2;
    private int currentIndex;
    private boolean soundOff = false;
    private Player player = null;
    private boolean isPlaying = false;
    private static SoundServer instance;
    private static long timeTaken;
    private boolean init = false;

    private SoundServer() {
        instance = this;
    }

    public void soundSwitchToggle() {
        this.setSoundOff(!this.isSoundOff());
        if (this.isSoundOff()) {
            this.stopMedia();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object = syncObject;
        synchronized (object) {
            while (true) {
                SoundFile file;
                if (this.soundsList.size() != 0 && (file = (SoundFile)this.soundsList.elementAt(this.currentIndex)).isSoundEnable()) {
                    InputStream is = null;
                    try {
                        this.stopMedia();
                        is = file.isCache() ? new ByteArrayInputStream(file.getData()) : this.getClass().getResourceAsStream("/" + file.getName());
                        this.player = file.getName().endsWith("wav") ? Manager.createPlayer((InputStream)is, (String)"audio/x-wav") : (file.getName().endsWith("amr") ? Manager.createPlayer((InputStream)is, (String)"audio/amr") : Manager.createPlayer((InputStream)is, (String)"audio/x-midi"));
                        this.player.addPlayerListener((PlayerListener)this);
                        if (file.isInLoop) {
                            this.player.setLoopCount(-1);
                        }
                        this.player.realize();
                        this.player.start();
                    }
                    catch (Exception e) {
                        try {
                            this.player.deallocate();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    catch (Error e) {
                        try {
                            this.player.deallocate();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        System.gc();
                    }
                    finally {
                        try {
                            is.close();
                        }
                        catch (Exception e) {}
                    }
                }
                try {
                    syncObject.wait();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void checkAmrSupproted() {
        int i;
        boolean amrSupported = false;
        String[] conetents = Manager.getSupportedContentTypes(null);
        if (conetents != null && conetents.length > 0) {
            for (i = 0; i < conetents.length; ++i) {
                if (conetents[i].toLowerCase().indexOf("amr") == 0) continue;
                amrSupported = true;
            }
        }
        for (i = 0; i < this.soundsList.size(); ++i) {
            SoundFile file = (SoundFile)this.soundsList.elementAt(i);
            if (!file.getName().endsWith("both")) continue;
            String name = file.getName();
            name = name.substring(0, name.length() - 4);
            name = amrSupported ? name + "amr" : name + "mid";
            file.setName(name);
        }
    }

    public void init() {
        try {
            this.soundsList.addElement(new SoundFile("bgsound.wav", false));
            this.soundsList.addElement(new SoundFile("win.mid", false));
            this.soundsList.addElement(new SoundFile("lose.mid", false));
            this.setSoundLoop(0, true);
            this.setSoundPriority(0, 1);
            this.setSoundPriority(1, 5);
            this.setSoundPriority(2, 4);
            this.checkAmrSupproted();
            for (int i = 0; i < this.soundsList.size(); ++i) {
                Object object = this.soundsList.elementAt(i);
                ((SoundFile)object).load();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setSoundLoop(int id, boolean loop) {
        ((SoundFile)this.soundsList.elementAt(id)).setIsInLoop(loop);
    }

    public void setSoundPriority(int id, int priority) {
        ((SoundFile)this.soundsList.elementAt(id)).setPriority(priority);
    }

    public int getSoundPriority(int id) {
        return ((SoundFile)this.soundsList.elementAt(id)).getPriority();
    }

    public void setSoundEnable(int id, boolean enable) {
        ((SoundFile)this.soundsList.elementAt(id)).setSoundEnable(enable);
    }

    public static synchronized SoundServer getInstance() {
        if (instance == null) {
            instance = new SoundServer();
            timeTaken = -1L;
        }
        return instance;
    }

    public boolean isSoundOff() {
        return this.soundOff;
    }

    public void setSoundOff(boolean soundOff) {
        this.soundOff = soundOff;
    }

    public void stopMedia() {
        if (this.player != null && this.player.getState() != 0) {
            try {
                this.player.stop();
                this.player.close();
            }
            catch (Exception exception) {
            }
            finally {
                this.isPlaying = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playSound(int id) {
        if (System.currentTimeMillis() - timeTaken < 900L && this.getSoundPriority(this.currentIndex) > this.getSoundPriority(id)) {
            return;
        }
        timeTaken = System.currentTimeMillis();
        Object object = syncObject;
        synchronized (object) {
            if (this.isSoundOff()) {
                return;
            }
            if (this.isPlaying && this.getSoundPriority(this.currentIndex) >= this.getSoundPriority(id)) {
                return;
            }
            this.currentIndex = id;
            syncObject.notifyAll();
            if (!this.init) {
                this.init = true;
                new Thread(instance).start();
            }
        }
    }

    public void playerUpdate(Player player, String event, Object eventData) {
        if (event == "started") {
            this.isPlaying = true;
        }
        if (event == "stopped" || event == "endOfMedia" || event == "error") {
            this.isPlaying = false;
        }
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    class SoundFile {
        String name;
        int priority = 1;
        private boolean cache = false;
        private boolean soundEnable = true;
        private byte[] data;
        private boolean isInLoop = false;

        public void setName(String name) {
            this.name = name;
        }

        public SoundFile(String name, boolean cache) {
            this.name = name;
            this.cache = cache;
        }

        public SoundFile(String name, boolean cache, boolean enable) {
            this.name = name;
            this.cache = cache;
            this.soundEnable = enable;
        }

        public boolean isInLoop() {
            return this.isInLoop;
        }

        public void setIsInLoop(boolean isInLoop) {
            this.isInLoop = isInLoop;
        }

        public void load() throws Exception {
            if (this.cache && this.soundEnable) {
                InputStream is = "".getClass().getResourceAsStream("/" + this.name);
                this.data = new byte[is.available()];
                is.read(this.data);
                is.close();
            }
        }

        public void setPriority(int priority) {
            this.priority = priority;
        }

        public int getPriority() {
            return this.priority;
        }

        public void setSoundEnable(boolean soundEnable) {
            this.soundEnable = soundEnable;
        }

        public boolean isSoundEnable() {
            return this.soundEnable;
        }

        public byte[] getData() {
            return this.data;
        }

        public String getName() {
            return this.name;
        }

        public boolean isCache() {
            return this.cache;
        }
    }
}

